-------------------------------------------------------------------------------
-- Copyright (c) 1995/2006 Xilinx, Inc.
-- All Right Reserved.
-------------------------------------------------------------------------------
--   ____  ____
--  /   /\/   /
-- /___/  \  /    Vendor      : Xilinx
-- \   \   \/     Version : 11.1
--  \   \         Description : Xilinx Timing Simulation Library Component
--  /   /                       Tri-Mode Ethernet MAC
-- /___/   /\     Filename    : x_temac.vhd
-- \   \  /  \    Timestamp   : Thu Dec 8 2005
--  \___\/\___\
--
-- Revision:
--    12/08/05 - Initial version.
--    01/09/06 - Added architecture
--    02/06/06 - pinTime updates
--    02/23/06 - Updated Header
--    03/10/06 - CR#226740. Changed generic type of some of the generics from
--    string to boolean
--    03/29/06 - CR#228056 - Fixed input and ouput connectivity.
--    03/27/06 - Updated TEMAC smartmodel to version number 00.002 for following changes
--			CR#224695 - 
--				1. TEMAC smartmodel 16 bit client interface problem.
--				2. Compiled smartmodel with `delay_mode_zero directive
--			CR#226083 - 
--				1. Loopback attributes don't work in Verilog TEMAC smartmodel.
--			CR#224695 - 
--				1 . Added 50 ps input delay to all inputs(except clocks) going into temac swift model
--    04/11/06 - CR#228624 - Added missing timing check to timing block.
--    04/11/06 - CR#228762 - Added some missing path delays to timing block.
--    04/27/06 - CR#230105 - Fixed connectivity for CLK
--    05/23/06 - CR#231962 - Add buffers for connectivity
--    08/04/06 - CR#234555 - Recovery/Removal checks added
--    09/15/06 - CR#423162 - Timing updates
--    10/26/06 -           - replaced ZERO_DELAY with CLK_DELAY to be consistent with writers (PPC440 update)
--    06/08/07 - CR#440717 - Add constant EMAC0MIITXCLK_DELAY & EMAC1MIITXCLK_DELAY
--    08/28/07 - CR#447575 - Path Delay updates due to pinDev/pinTime updates
--    04/09/08 - CR#444072 - Add clock port to tisd in declaration & Vitalsetuphold section
--    05/13/08 - CR#444072 - Support input port sensitive to multiple clock ports, update if-section
--    07/01/08 - CR#475984 - Timing simulation fix for PHYEMAC1RXLOSSOFSYNC
--    09/24/08 - CR#490332 - Removed _dly which is not being used
--    09/30/08 - CR#490869 - TEMAC VHDL timing bugs due to multiple clk fixed
-- End Revision

----- CELL X_TEMAC -----

library IEEE;
use IEEE.STD_LOGIC_1164.all;

library IEEE;
use IEEE.VITAL_Timing.all;

library simprim;
use simprim.VCOMPONENTS.all; 

library secureip; 
use secureip.all; 

entity X_TEMAC is
generic (
	TimingChecksOn : boolean := TRUE;
	InstancePath   : string  := "*";
	Xon            : boolean := TRUE;
	MsgOn          : boolean := FALSE;

	LOC             : string  := "UNPLACED";

	EMAC0_1000BASEX_ENABLE : boolean := FALSE;
	EMAC0_ADDRFILTER_ENABLE : boolean := FALSE;
	EMAC0_BYTEPHY : boolean := FALSE;
	EMAC0_CONFIGVEC_79 : boolean := FALSE;
	EMAC0_DCRBASEADDR : bit_vector := X"00";
	EMAC0_GTLOOPBACK : boolean := FALSE;
	EMAC0_HOST_ENABLE : boolean := FALSE;
	EMAC0_LINKTIMERVAL : bit_vector := X"000";
	EMAC0_LTCHECK_DISABLE : boolean := FALSE;
	EMAC0_MDIO_ENABLE : boolean := FALSE;
	EMAC0_PAUSEADDR : bit_vector := X"000000000000";
	EMAC0_PHYINITAUTONEG_ENABLE : boolean := FALSE;
	EMAC0_PHYISOLATE : boolean := FALSE;
	EMAC0_PHYLOOPBACKMSB : boolean := FALSE;
	EMAC0_PHYPOWERDOWN : boolean := FALSE;
	EMAC0_PHYRESET : boolean := FALSE;
	EMAC0_RGMII_ENABLE : boolean := FALSE;
	EMAC0_RX16BITCLIENT_ENABLE : boolean := FALSE;
	EMAC0_RXFLOWCTRL_ENABLE : boolean := FALSE;
	EMAC0_RXHALFDUPLEX : boolean := FALSE;
	EMAC0_RXINBANDFCS_ENABLE : boolean := FALSE;
	EMAC0_RXJUMBOFRAME_ENABLE : boolean := FALSE;
	EMAC0_RXRESET : boolean := FALSE;
	EMAC0_RXVLAN_ENABLE : boolean := FALSE;
	EMAC0_RX_ENABLE : boolean := FALSE;
	EMAC0_SGMII_ENABLE : boolean := FALSE;
	EMAC0_SPEED_LSB : boolean := FALSE;
	EMAC0_SPEED_MSB : boolean := FALSE;
	EMAC0_TX16BITCLIENT_ENABLE : boolean := FALSE;
	EMAC0_TXFLOWCTRL_ENABLE : boolean := FALSE;
	EMAC0_TXHALFDUPLEX : boolean := FALSE;
	EMAC0_TXIFGADJUST_ENABLE : boolean := FALSE;
	EMAC0_TXINBANDFCS_ENABLE : boolean := FALSE;
	EMAC0_TXJUMBOFRAME_ENABLE : boolean := FALSE;
	EMAC0_TXRESET : boolean := FALSE;
	EMAC0_TXVLAN_ENABLE : boolean := FALSE;
	EMAC0_TX_ENABLE : boolean := FALSE;
	EMAC0_UNICASTADDR : bit_vector := X"000000000000";
	EMAC0_UNIDIRECTION_ENABLE : boolean := FALSE;
	EMAC0_USECLKEN : boolean := FALSE;
	EMAC1_1000BASEX_ENABLE : boolean := FALSE;
	EMAC1_ADDRFILTER_ENABLE : boolean := FALSE;
	EMAC1_BYTEPHY : boolean := FALSE;
	EMAC1_CONFIGVEC_79 : boolean := FALSE;
	EMAC1_DCRBASEADDR : bit_vector := X"00";
	EMAC1_GTLOOPBACK : boolean := FALSE;
	EMAC1_HOST_ENABLE : boolean := FALSE;
	EMAC1_LINKTIMERVAL : bit_vector := X"000";
	EMAC1_LTCHECK_DISABLE : boolean := FALSE;
	EMAC1_MDIO_ENABLE : boolean := FALSE;
	EMAC1_PAUSEADDR : bit_vector := X"000000000000";
	EMAC1_PHYINITAUTONEG_ENABLE : boolean := FALSE;
	EMAC1_PHYISOLATE : boolean := FALSE;
	EMAC1_PHYLOOPBACKMSB : boolean := FALSE;
	EMAC1_PHYPOWERDOWN : boolean := FALSE;
	EMAC1_PHYRESET : boolean := FALSE;
	EMAC1_RGMII_ENABLE : boolean := FALSE;
	EMAC1_RX16BITCLIENT_ENABLE : boolean := FALSE;
	EMAC1_RXFLOWCTRL_ENABLE : boolean := FALSE;
	EMAC1_RXHALFDUPLEX : boolean := FALSE;
	EMAC1_RXINBANDFCS_ENABLE : boolean := FALSE;
	EMAC1_RXJUMBOFRAME_ENABLE : boolean := FALSE;
	EMAC1_RXRESET : boolean := FALSE;
	EMAC1_RXVLAN_ENABLE : boolean := FALSE;
	EMAC1_RX_ENABLE : boolean := FALSE;
	EMAC1_SGMII_ENABLE : boolean := FALSE;
	EMAC1_SPEED_LSB : boolean := FALSE;
	EMAC1_SPEED_MSB : boolean := FALSE;
	EMAC1_TX16BITCLIENT_ENABLE : boolean := FALSE;
	EMAC1_TXFLOWCTRL_ENABLE : boolean := FALSE;
	EMAC1_TXHALFDUPLEX : boolean := FALSE;
	EMAC1_TXIFGADJUST_ENABLE : boolean := FALSE;
	EMAC1_TXINBANDFCS_ENABLE : boolean := FALSE;
	EMAC1_TXJUMBOFRAME_ENABLE : boolean := FALSE;
	EMAC1_TXRESET : boolean := FALSE;
	EMAC1_TXVLAN_ENABLE : boolean := FALSE;
	EMAC1_TX_ENABLE : boolean := FALSE;
	EMAC1_UNICASTADDR : bit_vector := X"000000000000";
	EMAC1_UNIDIRECTION_ENABLE : boolean := FALSE;
	EMAC1_USECLKEN : boolean := FALSE;

       	tipd_CLIENTEMAC0DCMLOCKED : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_CLIENTEMAC0PAUSEREQ : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_CLIENTEMAC0PAUSEVAL : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
	tipd_CLIENTEMAC0RXCLIENTCLKIN : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_CLIENTEMAC0TXCLIENTCLKIN : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_CLIENTEMAC0TXD : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
	tipd_CLIENTEMAC0TXDVLD : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_CLIENTEMAC0TXDVLDMSW : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_CLIENTEMAC0TXFIRSTBYTE : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_CLIENTEMAC0TXIFGDELAY : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
	tipd_CLIENTEMAC0TXUNDERRUN : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_CLIENTEMAC1DCMLOCKED : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_CLIENTEMAC1PAUSEREQ : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_CLIENTEMAC1PAUSEVAL : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
	tipd_CLIENTEMAC1RXCLIENTCLKIN : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_CLIENTEMAC1TXCLIENTCLKIN : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_CLIENTEMAC1TXD : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
	tipd_CLIENTEMAC1TXDVLD : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_CLIENTEMAC1TXDVLDMSW : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_CLIENTEMAC1TXFIRSTBYTE : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_CLIENTEMAC1TXIFGDELAY : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
	tipd_CLIENTEMAC1TXUNDERRUN : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_DCREMACABUS : VitalDelayArrayType01 (0 to 9) := (others => (0 ps, 0 ps));
	tipd_DCREMACCLK : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_DCREMACDBUS : VitalDelayArrayType01 (0 to 31) := (others => (0 ps, 0 ps));
	tipd_DCREMACENABLE : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_DCREMACREAD : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_DCREMACWRITE : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_HOSTADDR : VitalDelayArrayType01 (9 downto 0) := (others => (0 ps, 0 ps));
	tipd_HOSTCLK : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_HOSTEMAC1SEL : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_HOSTMIIMSEL : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_HOSTOPCODE : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
	tipd_HOSTREQ : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_HOSTWRDATA : VitalDelayArrayType01 (31 downto 0) := (others => (0 ps, 0 ps));
	tipd_PHYEMAC0COL : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PHYEMAC0CRS : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PHYEMAC0GTXCLK : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PHYEMAC0MCLKIN : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PHYEMAC0MDIN : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PHYEMAC0MIITXCLK : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PHYEMAC0PHYAD : VitalDelayArrayType01 (4 downto 0) := (others => (0 ps, 0 ps));
	tipd_PHYEMAC0RXBUFERR : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PHYEMAC0RXBUFSTATUS : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
	tipd_PHYEMAC0RXCHARISCOMMA : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PHYEMAC0RXCHARISK : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PHYEMAC0RXCHECKINGCRC : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PHYEMAC0RXCLK : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PHYEMAC0RXCLKCORCNT : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
	tipd_PHYEMAC0RXCOMMADET : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PHYEMAC0RXD : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
	tipd_PHYEMAC0RXDISPERR : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PHYEMAC0RXDV : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PHYEMAC0RXER : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PHYEMAC0RXLOSSOFSYNC : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
	tipd_PHYEMAC0RXNOTINTABLE : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PHYEMAC0RXRUNDISP : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PHYEMAC0SIGNALDET : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PHYEMAC0TXBUFERR : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PHYEMAC0TXGMIIMIICLKIN : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PHYEMAC1COL : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PHYEMAC1CRS : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PHYEMAC1GTXCLK : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PHYEMAC1MCLKIN : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PHYEMAC1MDIN : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PHYEMAC1MIITXCLK : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PHYEMAC1PHYAD : VitalDelayArrayType01 (4 downto 0) := (others => (0 ps, 0 ps));
	tipd_PHYEMAC1RXBUFERR : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PHYEMAC1RXBUFSTATUS : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
	tipd_PHYEMAC1RXCHARISCOMMA : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PHYEMAC1RXCHARISK : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PHYEMAC1RXCHECKINGCRC : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PHYEMAC1RXCLK : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PHYEMAC1RXCLKCORCNT : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
	tipd_PHYEMAC1RXCOMMADET : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PHYEMAC1RXD : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
	tipd_PHYEMAC1RXDISPERR : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PHYEMAC1RXDV : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PHYEMAC1RXER : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PHYEMAC1RXLOSSOFSYNC : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
	tipd_PHYEMAC1RXNOTINTABLE : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PHYEMAC1RXRUNDISP : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PHYEMAC1SIGNALDET : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PHYEMAC1TXBUFERR : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PHYEMAC1TXGMIIMIICLKIN : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_RESET : VitalDelayType01 :=  (0 ps, 0 ps);
	tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXBADFRAME : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXCLIENTCLKOUT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXD : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
	tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXDVLD : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXDVLDMSW : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXFRAMEDROP : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXGOODFRAME : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXSTATS : VitalDelayArrayType01(6 downto 0) := (others => (0 ps, 0 ps));
	tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXSTATSBYTEVLD : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXSTATSVLD : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CLIENTEMAC0TXCLIENTCLKIN_EMAC0CLIENTTXACK : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CLIENTEMAC0TXCLIENTCLKIN_EMAC0CLIENTTXCOLLISION : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CLIENTEMAC0TXCLIENTCLKIN_EMAC0CLIENTTXRETRANSMIT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CLIENTEMAC0TXCLIENTCLKIN_EMAC0CLIENTTXSTATS : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CLIENTEMAC0TXCLIENTCLKIN_EMAC0CLIENTTXSTATSBYTEVLD : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CLIENTEMAC0TXCLIENTCLKIN_EMAC0CLIENTTXSTATSVLD : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXBADFRAME : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXCLIENTCLKOUT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXD : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
	tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXDVLD : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXDVLDMSW : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXFRAMEDROP : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXGOODFRAME : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXSTATS : VitalDelayArrayType01(6 downto 0) := (others => (0 ps, 0 ps));
	tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXSTATSBYTEVLD : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXSTATSVLD : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CLIENTEMAC1TXCLIENTCLKIN_EMAC1CLIENTTXACK : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CLIENTEMAC1TXCLIENTCLKIN_EMAC1CLIENTTXCOLLISION : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CLIENTEMAC1TXCLIENTCLKIN_EMAC1CLIENTTXRETRANSMIT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CLIENTEMAC1TXCLIENTCLKIN_EMAC1CLIENTTXSTATS : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CLIENTEMAC1TXCLIENTCLKIN_EMAC1CLIENTTXSTATSBYTEVLD : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CLIENTEMAC1TXCLIENTCLKIN_EMAC1CLIENTTXSTATSVLD : VitalDelayType01 := (0 ps, 0 ps);
	tpd_DCREMACCLK_EMACDCRACK : VitalDelayType01 := (0 ps, 0 ps);
	tpd_DCREMACCLK_EMACDCRDBUS : VitalDelayArrayType01(0 to 31) := (others => (0 ps, 0 ps));
	tpd_HOSTCLK_DCRHOSTDONEIR : VitalDelayType01 := (0 ps, 0 ps);
	tpd_HOSTCLK_EMAC0PHYMCLKOUT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_HOSTCLK_EMAC0PHYMDOUT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_HOSTCLK_EMAC0PHYMDTRI : VitalDelayType01 := (0 ps, 0 ps);
	tpd_HOSTCLK_EMAC0SPEEDIS10100 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_HOSTCLK_EMAC1PHYMCLKOUT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_HOSTCLK_EMAC1PHYMDOUT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_HOSTCLK_EMAC1PHYMDTRI : VitalDelayType01 := (0 ps, 0 ps);
	tpd_HOSTCLK_EMAC1SPEEDIS10100 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_HOSTCLK_HOSTMIIMRDY : VitalDelayType01 := (0 ps, 0 ps);
	tpd_HOSTCLK_HOSTRDDATA : VitalDelayArrayType01(31 downto 0) := (others => (0 ps, 0 ps));
	tpd_PHYEMAC0GTXCLK_EMAC0CLIENTANINTERRUPT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC0GTXCLK_EMAC0CLIENTRXCLIENTCLKOUT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC0GTXCLK_EMAC0CLIENTTXCLIENTCLKOUT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC0GTXCLK_EMAC0PHYENCOMMAALIGN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC0GTXCLK_EMAC0PHYLOOPBACKMSB : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC0GTXCLK_EMAC0PHYMGTRXRESET : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC0GTXCLK_EMAC0PHYMGTTXRESET : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC0GTXCLK_EMAC0PHYPOWERDOWN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC0GTXCLK_EMAC0PHYSYNCACQSTATUS : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC0GTXCLK_EMAC0PHYTXCHARDISPMODE : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC0GTXCLK_EMAC0PHYTXCHARDISPVAL : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC0GTXCLK_EMAC0PHYTXCHARISK : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC0GTXCLK_EMAC0PHYTXCLK : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC0GTXCLK_EMAC0PHYTXD : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
	tpd_PHYEMAC0GTXCLK_EMAC0PHYTXEN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC0GTXCLK_EMAC0PHYTXER : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC0GTXCLK_EMAC0PHYTXGMIIMIICLKOUT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC0MCLKIN_EMAC0PHYMCLKOUT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC0MCLKIN_EMAC0PHYMDOUT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC0MCLKIN_EMAC0PHYMDTRI : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC0MIITXCLK_EMAC0CLIENTTXCLIENTCLKOUT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC0MIITXCLK_EMAC0PHYTXGMIIMIICLKOUT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC0RXCLK_EMAC0CLIENTRXBADFRAME : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC0RXCLK_EMAC0CLIENTRXCLIENTCLKOUT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC0RXCLK_EMAC0CLIENTRXD : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
	tpd_PHYEMAC0RXCLK_EMAC0CLIENTRXDVLD : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC0RXCLK_EMAC0CLIENTRXDVLDMSW : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC0RXCLK_EMAC0CLIENTRXFRAMEDROP : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC0RXCLK_EMAC0CLIENTRXGOODFRAME : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC0RXCLK_EMAC0CLIENTRXSTATS : VitalDelayArrayType01(6 downto 0) := (others => (0 ps, 0 ps));
	tpd_PHYEMAC0RXCLK_EMAC0CLIENTRXSTATSBYTEVLD : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC0RXCLK_EMAC0CLIENTRXSTATSVLD : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0CLIENTTXACK : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0CLIENTTXCLIENTCLKOUT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0CLIENTTXCOLLISION : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0CLIENTTXRETRANSMIT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0CLIENTTXSTATS : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0CLIENTTXSTATSBYTEVLD : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0CLIENTTXSTATSVLD : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYSYNCACQSTATUS : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYTXCHARDISPMODE : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYTXCHARDISPVAL : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYTXCHARISK : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYTXCLK : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYTXD : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
	tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYTXEN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYTXER : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1GTXCLK_EMAC1CLIENTANINTERRUPT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1GTXCLK_EMAC1CLIENTRXCLIENTCLKOUT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1GTXCLK_EMAC1CLIENTTXCLIENTCLKOUT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1GTXCLK_EMAC1PHYENCOMMAALIGN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1GTXCLK_EMAC1PHYLOOPBACKMSB : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1GTXCLK_EMAC1PHYMGTRXRESET : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1GTXCLK_EMAC1PHYMGTTXRESET : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1GTXCLK_EMAC1PHYPOWERDOWN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1GTXCLK_EMAC1PHYSYNCACQSTATUS : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1GTXCLK_EMAC1PHYTXCHARDISPMODE : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1GTXCLK_EMAC1PHYTXCHARDISPVAL : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1GTXCLK_EMAC1PHYTXCHARISK : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1GTXCLK_EMAC1PHYTXCLK : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1GTXCLK_EMAC1PHYTXD : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
	tpd_PHYEMAC1GTXCLK_EMAC1PHYTXEN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1GTXCLK_EMAC1PHYTXER : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1GTXCLK_EMAC1PHYTXGMIIMIICLKOUT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1MCLKIN_EMAC1PHYMCLKOUT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1MCLKIN_EMAC1PHYMDOUT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1MCLKIN_EMAC1PHYMDTRI : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1MIITXCLK_EMAC1CLIENTTXCLIENTCLKOUT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1MIITXCLK_EMAC1PHYTXGMIIMIICLKOUT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1RXCLK_EMAC1CLIENTRXBADFRAME : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1RXCLK_EMAC1CLIENTRXCLIENTCLKOUT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1RXCLK_EMAC1CLIENTRXD : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
	tpd_PHYEMAC1RXCLK_EMAC1CLIENTRXDVLD : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1RXCLK_EMAC1CLIENTRXDVLDMSW : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1RXCLK_EMAC1CLIENTRXFRAMEDROP : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1RXCLK_EMAC1CLIENTRXGOODFRAME : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1RXCLK_EMAC1CLIENTRXSTATS : VitalDelayArrayType01(6 downto 0) := (others => (0 ps, 0 ps));
	tpd_PHYEMAC1RXCLK_EMAC1CLIENTRXSTATSBYTEVLD : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1RXCLK_EMAC1CLIENTRXSTATSVLD : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1CLIENTTXACK : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1CLIENTTXCLIENTCLKOUT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1CLIENTTXCOLLISION : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1CLIENTTXRETRANSMIT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1CLIENTTXSTATS : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1CLIENTTXSTATSBYTEVLD : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1CLIENTTXSTATSVLD : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYSYNCACQSTATUS : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYTXCHARDISPMODE : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYTXCHARDISPVAL : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYTXCHARISK : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYTXCLK : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYTXD : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
	tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYTXEN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYTXER : VitalDelayType01 := (0 ps, 0 ps);

	trecovery_RESET_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0 ps;
	trecovery_RESET_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0 ps;
	trecovery_RESET_HOSTCLK_negedge_posedge : VitalDelayType := 0 ps;
	trecovery_RESET_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	trecovery_RESET_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge : VitalDelayType := 0 ps;
	trecovery_RESET_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	trecovery_RESET_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge : VitalDelayType := 0 ps;
	tremoval_RESET_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0 ps;
	tremoval_RESET_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0 ps;
	tremoval_RESET_HOSTCLK_negedge_posedge : VitalDelayType := 0 ps;
	tremoval_RESET_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tremoval_RESET_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge : VitalDelayType := 0 ps;
	tremoval_RESET_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tremoval_RESET_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge : VitalDelayType := 0 ps;

	thold_CLIENTEMAC0DCMLOCKED_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC0DCMLOCKED_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC0DCMLOCKED_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC0DCMLOCKED_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC0PAUSEREQ_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC0PAUSEREQ_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC0PAUSEREQ_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC0PAUSEREQ_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	thold_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	thold_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	thold_CLIENTEMAC0TXDVLDMSW_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC0TXDVLDMSW_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC0TXDVLDMSW_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC0TXDVLDMSW_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC0TXDVLD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC0TXDVLD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC0TXDVLD_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC0TXDVLD_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	thold_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	thold_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	thold_CLIENTEMAC0TXFIRSTBYTE_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC0TXFIRSTBYTE_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC0TXFIRSTBYTE_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC0TXFIRSTBYTE_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_CLIENTEMAC0TXUNDERRUN_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC0TXUNDERRUN_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC0TXUNDERRUN_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC0TXUNDERRUN_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC1DCMLOCKED_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC1DCMLOCKED_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC1DCMLOCKED_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC1DCMLOCKED_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC1PAUSEREQ_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC1PAUSEREQ_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC1PAUSEREQ_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC1PAUSEREQ_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	thold_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	thold_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	thold_CLIENTEMAC1TXDVLDMSW_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC1TXDVLDMSW_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC1TXDVLDMSW_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC1TXDVLDMSW_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC1TXDVLD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC1TXDVLD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC1TXDVLD_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC1TXDVLD_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	thold_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	thold_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	thold_CLIENTEMAC1TXFIRSTBYTE_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC1TXFIRSTBYTE_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC1TXFIRSTBYTE_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC1TXFIRSTBYTE_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_CLIENTEMAC1TXUNDERRUN_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC1TXUNDERRUN_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC1TXUNDERRUN_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge : VitalDelayType := 0 ps;
	thold_CLIENTEMAC1TXUNDERRUN_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge : VitalDelayType := 0 ps;
	thold_DCREMACABUS_DCREMACCLK_negedge_posedge : VitalDelayArrayType(0 to 9) := (others => 0 ps);
	thold_DCREMACABUS_DCREMACCLK_posedge_posedge : VitalDelayArrayType(0 to 9) := (others => 0 ps);
	thold_DCREMACDBUS_DCREMACCLK_negedge_posedge : VitalDelayArrayType(0 to 31) := (others => 0 ps);
	thold_DCREMACDBUS_DCREMACCLK_posedge_posedge : VitalDelayArrayType(0 to 31) := (others => 0 ps);
	thold_DCREMACENABLE_DCREMACCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_DCREMACENABLE_DCREMACCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_DCREMACREAD_DCREMACCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_DCREMACREAD_DCREMACCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_DCREMACWRITE_DCREMACCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_DCREMACWRITE_DCREMACCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_HOSTADDR_HOSTCLK_negedge_posedge : VitalDelayArrayType(9 downto 0) := (others => 0 ps);
	thold_HOSTADDR_HOSTCLK_posedge_posedge : VitalDelayArrayType(9 downto 0) := (others => 0 ps);
	thold_HOSTEMAC1SEL_HOSTCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_HOSTEMAC1SEL_HOSTCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_HOSTMIIMSEL_HOSTCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_HOSTMIIMSEL_HOSTCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_HOSTOPCODE_HOSTCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	thold_HOSTOPCODE_HOSTCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	thold_HOSTREQ_HOSTCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_HOSTREQ_HOSTCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_HOSTWRDATA_HOSTCLK_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
	thold_HOSTWRDATA_HOSTCLK_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
	thold_PHYEMAC0COL_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0COL_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0COL_PHYEMAC0RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0COL_PHYEMAC0RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0CRS_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0CRS_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0CRS_PHYEMAC0RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0CRS_PHYEMAC0RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0MDIN_HOSTCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0MDIN_HOSTCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0MDIN_PHYEMAC0MCLKIN_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0MDIN_PHYEMAC0MCLKIN_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0PHYAD_HOSTCLK_negedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
	thold_PHYEMAC0PHYAD_HOSTCLK_posedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
	thold_PHYEMAC0RXBUFERR_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0RXBUFERR_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0RXBUFERR_PHYEMAC0RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0RXBUFERR_PHYEMAC0RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0RXBUFSTATUS_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	thold_PHYEMAC0RXBUFSTATUS_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	thold_PHYEMAC0RXBUFSTATUS_PHYEMAC0RXCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	thold_PHYEMAC0RXBUFSTATUS_PHYEMAC0RXCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	thold_PHYEMAC0RXCHARISCOMMA_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0RXCHARISCOMMA_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0RXCHARISCOMMA_PHYEMAC0RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0RXCHARISCOMMA_PHYEMAC0RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0RXCHARISK_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0RXCHARISK_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0RXCHARISK_PHYEMAC0RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0RXCHARISK_PHYEMAC0RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0RXCHECKINGCRC_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0RXCHECKINGCRC_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0RXCHECKINGCRC_PHYEMAC0RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0RXCHECKINGCRC_PHYEMAC0RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0RXCLKCORCNT_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	thold_PHYEMAC0RXCLKCORCNT_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	thold_PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	thold_PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	thold_PHYEMAC0RXCOMMADET_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0RXCOMMADET_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0RXCOMMADET_PHYEMAC0RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0RXCOMMADET_PHYEMAC0RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0RXDISPERR_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0RXDISPERR_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0RXDISPERR_PHYEMAC0RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0RXDISPERR_PHYEMAC0RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0RXDV_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0RXDV_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0RXDV_PHYEMAC0RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0RXDV_PHYEMAC0RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0RXD_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_PHYEMAC0RXD_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_negedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_negedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_PHYEMAC0RXER_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0RXER_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0RXER_PHYEMAC0RXCLK_negedge_negedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0RXER_PHYEMAC0RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0RXER_PHYEMAC0RXCLK_posedge_negedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0RXER_PHYEMAC0RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	thold_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	thold_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0RXCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	thold_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0RXCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	thold_PHYEMAC0RXNOTINTABLE_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0RXNOTINTABLE_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0RXNOTINTABLE_PHYEMAC0RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0RXNOTINTABLE_PHYEMAC0RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0RXRUNDISP_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0RXRUNDISP_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0RXRUNDISP_PHYEMAC0RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0RXRUNDISP_PHYEMAC0RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0SIGNALDET_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0SIGNALDET_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0SIGNALDET_PHYEMAC0RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0SIGNALDET_PHYEMAC0RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0TXBUFERR_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0TXBUFERR_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0TXBUFERR_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC0TXBUFERR_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1COL_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1COL_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1COL_PHYEMAC1RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1COL_PHYEMAC1RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1CRS_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1CRS_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1CRS_PHYEMAC1RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1CRS_PHYEMAC1RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1MDIN_HOSTCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1MDIN_HOSTCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1MDIN_PHYEMAC1MCLKIN_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1MDIN_PHYEMAC1MCLKIN_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1PHYAD_HOSTCLK_negedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
	thold_PHYEMAC1PHYAD_HOSTCLK_posedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
	thold_PHYEMAC1RXBUFERR_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1RXBUFERR_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1RXBUFERR_PHYEMAC1RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1RXBUFERR_PHYEMAC1RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1RXBUFSTATUS_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	thold_PHYEMAC1RXBUFSTATUS_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	thold_PHYEMAC1RXBUFSTATUS_PHYEMAC1RXCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	thold_PHYEMAC1RXBUFSTATUS_PHYEMAC1RXCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	thold_PHYEMAC1RXCHARISCOMMA_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1RXCHARISCOMMA_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1RXCHARISCOMMA_PHYEMAC1RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1RXCHARISCOMMA_PHYEMAC1RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1RXCHARISK_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1RXCHARISK_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1RXCHARISK_PHYEMAC1RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1RXCHARISK_PHYEMAC1RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1RXCHECKINGCRC_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1RXCHECKINGCRC_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1RXCHECKINGCRC_PHYEMAC1RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1RXCHECKINGCRC_PHYEMAC1RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1RXCLKCORCNT_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	thold_PHYEMAC1RXCLKCORCNT_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	thold_PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	thold_PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	thold_PHYEMAC1RXCOMMADET_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1RXCOMMADET_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1RXCOMMADET_PHYEMAC1RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1RXCOMMADET_PHYEMAC1RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1RXDISPERR_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1RXDISPERR_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1RXDISPERR_PHYEMAC1RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1RXDISPERR_PHYEMAC1RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1RXDV_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1RXDV_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1RXDV_PHYEMAC1RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1RXDV_PHYEMAC1RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1RXD_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_PHYEMAC1RXD_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_negedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_negedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_PHYEMAC1RXER_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1RXER_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1RXER_PHYEMAC1RXCLK_negedge_negedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1RXER_PHYEMAC1RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1RXER_PHYEMAC1RXCLK_posedge_negedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1RXER_PHYEMAC1RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	thold_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	thold_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1RXCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	thold_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1RXCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	thold_PHYEMAC1RXNOTINTABLE_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1RXNOTINTABLE_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1RXNOTINTABLE_PHYEMAC1RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1RXNOTINTABLE_PHYEMAC1RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1RXRUNDISP_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1RXRUNDISP_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1RXRUNDISP_PHYEMAC1RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1RXRUNDISP_PHYEMAC1RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1SIGNALDET_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1SIGNALDET_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1SIGNALDET_PHYEMAC1RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1SIGNALDET_PHYEMAC1RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1TXBUFERR_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1TXBUFERR_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1TXBUFERR_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge : VitalDelayType := 0 ps;
	thold_PHYEMAC1TXBUFERR_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC0DCMLOCKED_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC0DCMLOCKED_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC0DCMLOCKED_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC0DCMLOCKED_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC0PAUSEREQ_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC0PAUSEREQ_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC0PAUSEREQ_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC0PAUSEREQ_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	tsetup_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	tsetup_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	tsetup_CLIENTEMAC0TXDVLDMSW_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC0TXDVLDMSW_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC0TXDVLDMSW_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC0TXDVLDMSW_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC0TXDVLD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC0TXDVLD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC0TXDVLD_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC0TXDVLD_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	tsetup_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	tsetup_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	tsetup_CLIENTEMAC0TXFIRSTBYTE_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC0TXFIRSTBYTE_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC0TXFIRSTBYTE_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC0TXFIRSTBYTE_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_CLIENTEMAC0TXUNDERRUN_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC0TXUNDERRUN_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC0TXUNDERRUN_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC0TXUNDERRUN_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC1DCMLOCKED_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC1DCMLOCKED_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC1DCMLOCKED_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC1DCMLOCKED_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC1PAUSEREQ_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC1PAUSEREQ_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC1PAUSEREQ_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC1PAUSEREQ_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	tsetup_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	tsetup_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	tsetup_CLIENTEMAC1TXDVLDMSW_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC1TXDVLDMSW_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC1TXDVLDMSW_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC1TXDVLDMSW_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC1TXDVLD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC1TXDVLD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC1TXDVLD_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC1TXDVLD_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	tsetup_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	tsetup_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	tsetup_CLIENTEMAC1TXFIRSTBYTE_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC1TXFIRSTBYTE_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC1TXFIRSTBYTE_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC1TXFIRSTBYTE_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_CLIENTEMAC1TXUNDERRUN_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC1TXUNDERRUN_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC1TXUNDERRUN_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_CLIENTEMAC1TXUNDERRUN_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_DCREMACABUS_DCREMACCLK_negedge_posedge : VitalDelayArrayType(0 to 9) := (others => 0 ps);
	tsetup_DCREMACABUS_DCREMACCLK_posedge_posedge : VitalDelayArrayType(0 to 9) := (others => 0 ps);
	tsetup_DCREMACDBUS_DCREMACCLK_negedge_posedge : VitalDelayArrayType(0 to 31) := (others => 0 ps);
	tsetup_DCREMACDBUS_DCREMACCLK_posedge_posedge : VitalDelayArrayType(0 to 31) := (others => 0 ps);
	tsetup_DCREMACENABLE_DCREMACCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_DCREMACENABLE_DCREMACCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_DCREMACREAD_DCREMACCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_DCREMACREAD_DCREMACCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_DCREMACWRITE_DCREMACCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_DCREMACWRITE_DCREMACCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_HOSTADDR_HOSTCLK_negedge_posedge : VitalDelayArrayType(9 downto 0) := (others => 0 ps);
	tsetup_HOSTADDR_HOSTCLK_posedge_posedge : VitalDelayArrayType(9 downto 0) := (others => 0 ps);
	tsetup_HOSTEMAC1SEL_HOSTCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_HOSTEMAC1SEL_HOSTCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_HOSTMIIMSEL_HOSTCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_HOSTMIIMSEL_HOSTCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_HOSTOPCODE_HOSTCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tsetup_HOSTOPCODE_HOSTCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tsetup_HOSTREQ_HOSTCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_HOSTREQ_HOSTCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_HOSTWRDATA_HOSTCLK_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
	tsetup_HOSTWRDATA_HOSTCLK_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
	tsetup_PHYEMAC0COL_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0COL_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0COL_PHYEMAC0RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0COL_PHYEMAC0RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0CRS_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0CRS_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0CRS_PHYEMAC0RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0CRS_PHYEMAC0RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0MDIN_HOSTCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0MDIN_HOSTCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0MDIN_PHYEMAC0MCLKIN_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0MDIN_PHYEMAC0MCLKIN_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0PHYAD_HOSTCLK_negedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
	tsetup_PHYEMAC0PHYAD_HOSTCLK_posedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
	tsetup_PHYEMAC0RXBUFERR_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0RXBUFERR_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0RXBUFERR_PHYEMAC0RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0RXBUFERR_PHYEMAC0RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0RXBUFSTATUS_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tsetup_PHYEMAC0RXBUFSTATUS_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tsetup_PHYEMAC0RXBUFSTATUS_PHYEMAC0RXCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tsetup_PHYEMAC0RXBUFSTATUS_PHYEMAC0RXCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tsetup_PHYEMAC0RXCHARISCOMMA_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0RXCHARISCOMMA_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0RXCHARISCOMMA_PHYEMAC0RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0RXCHARISCOMMA_PHYEMAC0RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0RXCHARISK_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0RXCHARISK_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0RXCHARISK_PHYEMAC0RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0RXCHARISK_PHYEMAC0RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0RXCHECKINGCRC_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0RXCHECKINGCRC_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0RXCHECKINGCRC_PHYEMAC0RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0RXCHECKINGCRC_PHYEMAC0RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0RXCLKCORCNT_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tsetup_PHYEMAC0RXCLKCORCNT_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tsetup_PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tsetup_PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tsetup_PHYEMAC0RXCOMMADET_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0RXCOMMADET_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0RXCOMMADET_PHYEMAC0RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0RXCOMMADET_PHYEMAC0RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0RXDISPERR_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0RXDISPERR_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0RXDISPERR_PHYEMAC0RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0RXDISPERR_PHYEMAC0RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0RXDV_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0RXDV_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0RXDV_PHYEMAC0RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0RXDV_PHYEMAC0RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0RXD_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_PHYEMAC0RXD_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_negedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_negedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_PHYEMAC0RXER_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0RXER_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0RXER_PHYEMAC0RXCLK_negedge_negedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0RXER_PHYEMAC0RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0RXER_PHYEMAC0RXCLK_posedge_negedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0RXER_PHYEMAC0RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tsetup_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tsetup_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0RXCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tsetup_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0RXCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tsetup_PHYEMAC0RXNOTINTABLE_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0RXNOTINTABLE_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0RXNOTINTABLE_PHYEMAC0RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0RXNOTINTABLE_PHYEMAC0RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0RXRUNDISP_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0RXRUNDISP_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0RXRUNDISP_PHYEMAC0RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0RXRUNDISP_PHYEMAC0RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0SIGNALDET_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0SIGNALDET_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0SIGNALDET_PHYEMAC0RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0SIGNALDET_PHYEMAC0RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0TXBUFERR_PHYEMAC0GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0TXBUFERR_PHYEMAC0GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0TXBUFERR_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC0TXBUFERR_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1COL_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1COL_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1COL_PHYEMAC1RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1COL_PHYEMAC1RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1CRS_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1CRS_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1CRS_PHYEMAC1RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1CRS_PHYEMAC1RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1MDIN_HOSTCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1MDIN_HOSTCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1MDIN_PHYEMAC1MCLKIN_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1MDIN_PHYEMAC1MCLKIN_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1PHYAD_HOSTCLK_negedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
	tsetup_PHYEMAC1PHYAD_HOSTCLK_posedge_posedge : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
	tsetup_PHYEMAC1RXBUFERR_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1RXBUFERR_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1RXBUFERR_PHYEMAC1RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1RXBUFERR_PHYEMAC1RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1RXBUFSTATUS_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tsetup_PHYEMAC1RXBUFSTATUS_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tsetup_PHYEMAC1RXBUFSTATUS_PHYEMAC1RXCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tsetup_PHYEMAC1RXBUFSTATUS_PHYEMAC1RXCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tsetup_PHYEMAC1RXCHARISCOMMA_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1RXCHARISCOMMA_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1RXCHARISCOMMA_PHYEMAC1RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1RXCHARISCOMMA_PHYEMAC1RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1RXCHARISK_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1RXCHARISK_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1RXCHARISK_PHYEMAC1RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1RXCHARISK_PHYEMAC1RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1RXCHECKINGCRC_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1RXCHECKINGCRC_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1RXCHECKINGCRC_PHYEMAC1RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1RXCHECKINGCRC_PHYEMAC1RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1RXCLKCORCNT_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tsetup_PHYEMAC1RXCLKCORCNT_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tsetup_PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tsetup_PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tsetup_PHYEMAC1RXCOMMADET_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1RXCOMMADET_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1RXCOMMADET_PHYEMAC1RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1RXCOMMADET_PHYEMAC1RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1RXDISPERR_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1RXDISPERR_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1RXDISPERR_PHYEMAC1RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1RXDISPERR_PHYEMAC1RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1RXDV_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1RXDV_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1RXDV_PHYEMAC1RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1RXDV_PHYEMAC1RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1RXD_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_PHYEMAC1RXD_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_negedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_negedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_PHYEMAC1RXER_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1RXER_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1RXER_PHYEMAC1RXCLK_negedge_negedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1RXER_PHYEMAC1RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1RXER_PHYEMAC1RXCLK_posedge_negedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1RXER_PHYEMAC1RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tsetup_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tsetup_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1RXCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tsetup_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1RXCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tsetup_PHYEMAC1RXNOTINTABLE_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1RXNOTINTABLE_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1RXNOTINTABLE_PHYEMAC1RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1RXNOTINTABLE_PHYEMAC1RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1RXRUNDISP_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1RXRUNDISP_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1RXRUNDISP_PHYEMAC1RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1RXRUNDISP_PHYEMAC1RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1SIGNALDET_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1SIGNALDET_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1SIGNALDET_PHYEMAC1RXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1SIGNALDET_PHYEMAC1RXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1TXBUFERR_PHYEMAC1GTXCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1TXBUFERR_PHYEMAC1GTXCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1TXBUFERR_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PHYEMAC1TXBUFERR_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge : VitalDelayType := 0 ps;

	ticd_CLIENTEMAC0TXCLIENTCLKIN : VitalDelayType := 0 ps;
	ticd_CLIENTEMAC1TXCLIENTCLKIN : VitalDelayType := 0 ps;
	ticd_DCREMACCLK : VitalDelayType := 0 ps;
	ticd_HOSTCLK : VitalDelayType := 0 ps;
	ticd_PHYEMAC0GTXCLK : VitalDelayType := 0 ps;
	ticd_PHYEMAC0MCLKIN : VitalDelayType := 0 ps;
	ticd_PHYEMAC0RXCLK : VitalDelayType := 0 ps;
	ticd_PHYEMAC0TXGMIIMIICLKIN : VitalDelayType := 0 ps;
	ticd_PHYEMAC1GTXCLK : VitalDelayType := 0 ps;
	ticd_PHYEMAC1MCLKIN : VitalDelayType := 0 ps;
	ticd_PHYEMAC1RXCLK : VitalDelayType := 0 ps;
	ticd_PHYEMAC1TXGMIIMIICLKIN : VitalDelayType := 0 ps;

	tisd_CLIENTEMAC0DCMLOCKED_CLIENTEMAC0TXCLIENTCLKIN : VitalDelayType := 0 ps;
        tisd_CLIENTEMAC0DCMLOCKED_PHYEMAC0TXGMIIMIICLKIN : VitalDelayType := 0 ps;
	tisd_CLIENTEMAC0PAUSEREQ_CLIENTEMAC0TXCLIENTCLKIN : VitalDelayType := 0 ps;
        tisd_CLIENTEMAC0PAUSEREQ_PHYEMAC0TXGMIIMIICLKIN : VitalDelayType := 0 ps;
	tisd_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
        tisd_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	tisd_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
        tisd_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	tisd_CLIENTEMAC0TXDVLD_CLIENTEMAC0TXCLIENTCLKIN : VitalDelayType := 0 ps;
        tisd_CLIENTEMAC0TXDVLD_PHYEMAC0TXGMIIMIICLKIN : VitalDelayType := 0 ps;
       	tisd_CLIENTEMAC0TXDVLDMSW_CLIENTEMAC0TXCLIENTCLKIN : VitalDelayType := 0 ps;
	tisd_CLIENTEMAC0TXDVLDMSW_PHYEMAC0TXGMIIMIICLKIN : VitalDelayType := 0 ps;
	tisd_CLIENTEMAC0TXFIRSTBYTE_CLIENTEMAC0TXCLIENTCLKIN : VitalDelayType := 0 ps;
        tisd_CLIENTEMAC0TXFIRSTBYTE_PHYEMAC0TXGMIIMIICLKIN : VitalDelayType := 0 ps;
	tisd_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
        tisd_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
        tisd_CLIENTEMAC0TXUNDERRUN_CLIENTEMAC0TXCLIENTCLKIN : VitalDelayType := 0 ps;
        tisd_CLIENTEMAC0TXUNDERRUN_PHYEMAC0TXGMIIMIICLKIN : VitalDelayType := 0 ps;
	tisd_CLIENTEMAC1DCMLOCKED_CLIENTEMAC1TXCLIENTCLKIN : VitalDelayType := 0 ps;
        tisd_CLIENTEMAC1DCMLOCKED_PHYEMAC1TXGMIIMIICLKIN : VitalDelayType := 0 ps;
        tisd_CLIENTEMAC1PAUSEREQ_CLIENTEMAC1TXCLIENTCLKIN : VitalDelayType := 0 ps;
        tisd_CLIENTEMAC1PAUSEREQ_PHYEMAC1TXGMIIMIICLKIN : VitalDelayType := 0 ps;
	tisd_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
        tisd_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	tisd_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
        tisd_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	tisd_CLIENTEMAC1TXDVLD_CLIENTEMAC1TXCLIENTCLKIN : VitalDelayType := 0 ps;
        tisd_CLIENTEMAC1TXDVLD_PHYEMAC1TXGMIIMIICLKIN : VitalDelayType := 0 ps;
	tisd_CLIENTEMAC1TXDVLDMSW_CLIENTEMAC1TXCLIENTCLKIN : VitalDelayType := 0 ps;
        tisd_CLIENTEMAC1TXDVLDMSW_PHYEMAC1TXGMIIMIICLKIN : VitalDelayType := 0 ps;
	tisd_CLIENTEMAC1TXFIRSTBYTE_CLIENTEMAC1TXCLIENTCLKIN : VitalDelayType := 0 ps;
        tisd_CLIENTEMAC1TXFIRSTBYTE_PHYEMAC1TXGMIIMIICLKIN : VitalDelayType := 0 ps;
	tisd_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
        tisd_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tisd_CLIENTEMAC1TXUNDERRUN_CLIENTEMAC1TXCLIENTCLKIN : VitalDelayType := 0 ps;
        tisd_CLIENTEMAC1TXUNDERRUN_PHYEMAC1TXGMIIMIICLKIN : VitalDelayType := 0 ps;
	tisd_DCREMACABUS_DCREMACCLK : VitalDelayArrayType(0 to 9) := (others => 0 ps);
	tisd_DCREMACDBUS_DCREMACCLK : VitalDelayArrayType(0 to 31) := (others => 0 ps);
	tisd_DCREMACENABLE_DCREMACCLK : VitalDelayType := 0 ps;
	tisd_DCREMACREAD_DCREMACCLK : VitalDelayType := 0 ps;
	tisd_DCREMACWRITE_DCREMACCLK : VitalDelayType := 0 ps;
	tisd_HOSTADDR_HOSTCLK : VitalDelayArrayType(9 downto 0) := (others => 0 ps);
	tisd_HOSTEMAC1SEL_HOSTCLK : VitalDelayType := 0 ps;
	tisd_HOSTMIIMSEL_HOSTCLK : VitalDelayType := 0 ps;
	tisd_HOSTOPCODE_HOSTCLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tisd_HOSTREQ_HOSTCLK : VitalDelayType := 0 ps;
	tisd_HOSTWRDATA_HOSTCLK : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
	tisd_PHYEMAC0COL_PHYEMAC0GTXCLK : VitalDelayType := 0 ps;
        tisd_PHYEMAC0COL_PHYEMAC0RXCLK : VitalDelayType := 0 ps;
	tisd_PHYEMAC0CRS_PHYEMAC0GTXCLK : VitalDelayType := 0 ps;
        tisd_PHYEMAC0CRS_PHYEMAC0RXCLK : VitalDelayType := 0 ps;
	tisd_PHYEMAC0MDIN_HOSTCLK : VitalDelayType := 0 ps;
        tisd_PHYEMAC0MDIN_PHYEMAC0MCLKIN : VitalDelayType := 0 ps;
        tisd_PHYEMAC0PHYAD_HOSTCLK : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
	tisd_PHYEMAC0RXBUFERR_PHYEMAC0GTXCLK : VitalDelayType := 0 ps;
        tisd_PHYEMAC0RXBUFERR_PHYEMAC0RXCLK : VitalDelayType := 0 ps;
	tisd_PHYEMAC0RXBUFSTATUS_PHYEMAC0GTXCLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
        tisd_PHYEMAC0RXBUFSTATUS_PHYEMAC0RXCLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tisd_PHYEMAC0RXCHARISCOMMA_PHYEMAC0GTXCLK : VitalDelayType := 0 ps;
        tisd_PHYEMAC0RXCHARISCOMMA_PHYEMAC0RXCLK : VitalDelayType := 0 ps;
	tisd_PHYEMAC0RXCHARISK_PHYEMAC0GTXCLK : VitalDelayType := 0 ps;
        tisd_PHYEMAC0RXCHARISK_PHYEMAC0RXCLK : VitalDelayType := 0 ps;
	tisd_PHYEMAC0RXCHECKINGCRC_PHYEMAC0GTXCLK : VitalDelayType := 0 ps;
        tisd_PHYEMAC0RXCHECKINGCRC_PHYEMAC0RXCLK : VitalDelayType := 0 ps;
	tisd_PHYEMAC0RXCLKCORCNT_PHYEMAC0GTXCLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
        tisd_PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tisd_PHYEMAC0RXCOMMADET_PHYEMAC0GTXCLK : VitalDelayType := 0 ps;
        tisd_PHYEMAC0RXCOMMADET_PHYEMAC0RXCLK : VitalDelayType := 0 ps;
	tisd_PHYEMAC0RXD_PHYEMAC0GTXCLK : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
        tisd_PHYEMAC0RXD_PHYEMAC0RXCLK : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tisd_PHYEMAC0RXDISPERR_PHYEMAC0GTXCLK : VitalDelayType := 0 ps;
        tisd_PHYEMAC0RXDISPERR_PHYEMAC0RXCLK : VitalDelayType := 0 ps;
        tisd_PHYEMAC0RXDV_PHYEMAC0GTXCLK : VitalDelayType := 0 ps;
	tisd_PHYEMAC0RXDV_PHYEMAC0RXCLK : VitalDelayType := 0 ps;
	tisd_PHYEMAC0RXER_PHYEMAC0GTXCLK : VitalDelayType := 0 ps;
        tisd_PHYEMAC0RXER_PHYEMAC0RXCLK : VitalDelayType := 0 ps;
	tisd_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0GTXCLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
        tisd_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0RXCLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tisd_PHYEMAC0RXNOTINTABLE_PHYEMAC0GTXCLK : VitalDelayType := 0 ps;
       	tisd_PHYEMAC0RXNOTINTABLE_PHYEMAC0RXCLK : VitalDelayType := 0 ps;
	tisd_PHYEMAC0RXRUNDISP_PHYEMAC0GTXCLK : VitalDelayType := 0 ps;
        tisd_PHYEMAC0RXRUNDISP_PHYEMAC0RXCLK : VitalDelayType := 0 ps;
	tisd_PHYEMAC0SIGNALDET_PHYEMAC0GTXCLK : VitalDelayType := 0 ps;
        tisd_PHYEMAC0SIGNALDET_PHYEMAC0RXCLK : VitalDelayType := 0 ps;
	tisd_PHYEMAC0TXBUFERR_PHYEMAC0GTXCLK : VitalDelayType := 0 ps;
        tisd_PHYEMAC0TXBUFERR_PHYEMAC0TXGMIIMIICLKIN : VitalDelayType := 0 ps;
	tisd_PHYEMAC1COL_PHYEMAC1GTXCLK : VitalDelayType := 0 ps;
       	tisd_PHYEMAC1COL_PHYEMAC1RXCLK : VitalDelayType := 0 ps;
	tisd_PHYEMAC1CRS_PHYEMAC1GTXCLK : VitalDelayType := 0 ps;
        tisd_PHYEMAC1CRS_PHYEMAC1RXCLK : VitalDelayType := 0 ps;
	tisd_PHYEMAC1MDIN_HOSTCLK : VitalDelayType := 0 ps;
        tisd_PHYEMAC1MDIN_PHYEMAC1MCLKIN : VitalDelayType := 0 ps;
        tisd_PHYEMAC1PHYAD_HOSTCLK : VitalDelayArrayType(4 downto 0) := (others => 0 ps);
	tisd_PHYEMAC1RXBUFERR_PHYEMAC1GTXCLK : VitalDelayType := 0 ps;
        tisd_PHYEMAC1RXBUFERR_PHYEMAC1RXCLK : VitalDelayType := 0 ps;
	tisd_PHYEMAC1RXBUFSTATUS_PHYEMAC1GTXCLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
        tisd_PHYEMAC1RXBUFSTATUS_PHYEMAC1RXCLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tisd_PHYEMAC1RXCHARISCOMMA_PHYEMAC1GTXCLK : VitalDelayType := 0 ps;
       	tisd_PHYEMAC1RXCHARISCOMMA_PHYEMAC1RXCLK : VitalDelayType := 0 ps;
	tisd_PHYEMAC1RXCHARISK_PHYEMAC1GTXCLK : VitalDelayType := 0 ps;
        tisd_PHYEMAC1RXCHARISK_PHYEMAC1RXCLK : VitalDelayType := 0 ps;
	tisd_PHYEMAC1RXCHECKINGCRC_PHYEMAC1GTXCLK : VitalDelayType := 0 ps;
        tisd_PHYEMAC1RXCHECKINGCRC_PHYEMAC1RXCLK : VitalDelayType := 0 ps;
	tisd_PHYEMAC1RXCLKCORCNT_PHYEMAC1GTXCLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
        tisd_PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tisd_PHYEMAC1RXCOMMADET_PHYEMAC1GTXCLK : VitalDelayType := 0 ps;
        tisd_PHYEMAC1RXCOMMADET_PHYEMAC1RXCLK : VitalDelayType := 0 ps;
	tisd_PHYEMAC1RXD_PHYEMAC1GTXCLK : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
        tisd_PHYEMAC1RXD_PHYEMAC1RXCLK : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tisd_PHYEMAC1RXDISPERR_PHYEMAC1GTXCLK : VitalDelayType := 0 ps;
        tisd_PHYEMAC1RXDISPERR_PHYEMAC1RXCLK : VitalDelayType := 0 ps;
	tisd_PHYEMAC1RXDV_PHYEMAC1GTXCLK : VitalDelayType := 0 ps;
        tisd_PHYEMAC1RXDV_PHYEMAC1RXCLK : VitalDelayType := 0 ps;
	tisd_PHYEMAC1RXER_PHYEMAC1GTXCLK : VitalDelayType := 0 ps;
        tisd_PHYEMAC1RXER_PHYEMAC1RXCLK : VitalDelayType := 0 ps;
	tisd_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1GTXCLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
        tisd_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1RXCLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
        tisd_PHYEMAC1RXNOTINTABLE_PHYEMAC1GTXCLK : VitalDelayType := 0 ps;
        tisd_PHYEMAC1RXNOTINTABLE_PHYEMAC1RXCLK : VitalDelayType := 0 ps;
	tisd_PHYEMAC1RXRUNDISP_PHYEMAC1GTXCLK : VitalDelayType := 0 ps;
        tisd_PHYEMAC1RXRUNDISP_PHYEMAC1RXCLK : VitalDelayType := 0 ps;
	tisd_PHYEMAC1SIGNALDET_PHYEMAC1GTXCLK : VitalDelayType := 0 ps;
        tisd_PHYEMAC1SIGNALDET_PHYEMAC1RXCLK : VitalDelayType := 0 ps;
	tisd_PHYEMAC1TXBUFERR_PHYEMAC1GTXCLK : VitalDelayType := 0 ps;
       	tisd_PHYEMAC1TXBUFERR_PHYEMAC1TXGMIIMIICLKIN : VitalDelayType := 0 ps;

        tisd_RESET_HOSTCLK : VitalDelayType := 0 ps;
        tisd_RESET_CLIENTEMAC0TXCLIENTCLKIN : VitalDelayType := 0 ps;
        tisd_RESET_CLIENTEMAC1TXCLIENTCLKIN : VitalDelayType := 0 ps;
        tisd_RESET_PHYEMAC0TXGMIIMIICLKIN : VitalDelayType := 0 ps;
        tisd_RESET_PHYEMAC1TXGMIIMIICLKIN : VitalDelayType := 0 ps;
        tisd_RESET_PHYEMAC0GTXCLK : VitalDelayType := 0 ps;
        tisd_RESET_PHYEMAC1GTXCLK : VitalDelayType := 0 ps

  );

port (
		DCRHOSTDONEIR : out std_ulogic;
		EMAC0CLIENTANINTERRUPT : out std_ulogic;
		EMAC0CLIENTRXBADFRAME : out std_ulogic;
		EMAC0CLIENTRXCLIENTCLKOUT : out std_ulogic;
		EMAC0CLIENTRXD : out std_logic_vector(15 downto 0);
		EMAC0CLIENTRXDVLD : out std_ulogic;
		EMAC0CLIENTRXDVLDMSW : out std_ulogic;
		EMAC0CLIENTRXFRAMEDROP : out std_ulogic;
		EMAC0CLIENTRXGOODFRAME : out std_ulogic;
		EMAC0CLIENTRXSTATS : out std_logic_vector(6 downto 0);
		EMAC0CLIENTRXSTATSBYTEVLD : out std_ulogic;
		EMAC0CLIENTRXSTATSVLD : out std_ulogic;
		EMAC0CLIENTTXACK : out std_ulogic;
		EMAC0CLIENTTXCLIENTCLKOUT : out std_ulogic;
		EMAC0CLIENTTXCOLLISION : out std_ulogic;
		EMAC0CLIENTTXRETRANSMIT : out std_ulogic;
		EMAC0CLIENTTXSTATS : out std_ulogic;
		EMAC0CLIENTTXSTATSBYTEVLD : out std_ulogic;
		EMAC0CLIENTTXSTATSVLD : out std_ulogic;
		EMAC0PHYENCOMMAALIGN : out std_ulogic;
		EMAC0PHYLOOPBACKMSB : out std_ulogic;
		EMAC0PHYMCLKOUT : out std_ulogic;
		EMAC0PHYMDOUT : out std_ulogic;
		EMAC0PHYMDTRI : out std_ulogic;
		EMAC0PHYMGTRXRESET : out std_ulogic;
		EMAC0PHYMGTTXRESET : out std_ulogic;
		EMAC0PHYPOWERDOWN : out std_ulogic;
		EMAC0PHYSYNCACQSTATUS : out std_ulogic;
		EMAC0PHYTXCHARDISPMODE : out std_ulogic;
		EMAC0PHYTXCHARDISPVAL : out std_ulogic;
		EMAC0PHYTXCHARISK : out std_ulogic;
		EMAC0PHYTXCLK : out std_ulogic;
		EMAC0PHYTXD : out std_logic_vector(7 downto 0);
		EMAC0PHYTXEN : out std_ulogic;
		EMAC0PHYTXER : out std_ulogic;
		EMAC0PHYTXGMIIMIICLKOUT : out std_ulogic;
		EMAC0SPEEDIS10100 : out std_ulogic;
		EMAC1CLIENTANINTERRUPT : out std_ulogic;
		EMAC1CLIENTRXBADFRAME : out std_ulogic;
		EMAC1CLIENTRXCLIENTCLKOUT : out std_ulogic;
		EMAC1CLIENTRXD : out std_logic_vector(15 downto 0);
		EMAC1CLIENTRXDVLD : out std_ulogic;
		EMAC1CLIENTRXDVLDMSW : out std_ulogic;
		EMAC1CLIENTRXFRAMEDROP : out std_ulogic;
		EMAC1CLIENTRXGOODFRAME : out std_ulogic;
		EMAC1CLIENTRXSTATS : out std_logic_vector(6 downto 0);
		EMAC1CLIENTRXSTATSBYTEVLD : out std_ulogic;
		EMAC1CLIENTRXSTATSVLD : out std_ulogic;
		EMAC1CLIENTTXACK : out std_ulogic;
		EMAC1CLIENTTXCLIENTCLKOUT : out std_ulogic;
		EMAC1CLIENTTXCOLLISION : out std_ulogic;
		EMAC1CLIENTTXRETRANSMIT : out std_ulogic;
		EMAC1CLIENTTXSTATS : out std_ulogic;
		EMAC1CLIENTTXSTATSBYTEVLD : out std_ulogic;
		EMAC1CLIENTTXSTATSVLD : out std_ulogic;
		EMAC1PHYENCOMMAALIGN : out std_ulogic;
		EMAC1PHYLOOPBACKMSB : out std_ulogic;
		EMAC1PHYMCLKOUT : out std_ulogic;
		EMAC1PHYMDOUT : out std_ulogic;
		EMAC1PHYMDTRI : out std_ulogic;
		EMAC1PHYMGTRXRESET : out std_ulogic;
		EMAC1PHYMGTTXRESET : out std_ulogic;
		EMAC1PHYPOWERDOWN : out std_ulogic;
		EMAC1PHYSYNCACQSTATUS : out std_ulogic;
		EMAC1PHYTXCHARDISPMODE : out std_ulogic;
		EMAC1PHYTXCHARDISPVAL : out std_ulogic;
		EMAC1PHYTXCHARISK : out std_ulogic;
		EMAC1PHYTXCLK : out std_ulogic;
		EMAC1PHYTXD : out std_logic_vector(7 downto 0);
		EMAC1PHYTXEN : out std_ulogic;
		EMAC1PHYTXER : out std_ulogic;
		EMAC1PHYTXGMIIMIICLKOUT : out std_ulogic;
		EMAC1SPEEDIS10100 : out std_ulogic;
		EMACDCRACK : out std_ulogic;
		EMACDCRDBUS : out std_logic_vector(0 to 31);
		HOSTMIIMRDY : out std_ulogic;
		HOSTRDDATA : out std_logic_vector(31 downto 0);

		CLIENTEMAC0DCMLOCKED : in std_ulogic;
		CLIENTEMAC0PAUSEREQ : in std_ulogic;
		CLIENTEMAC0PAUSEVAL : in std_logic_vector(15 downto 0);
		CLIENTEMAC0RXCLIENTCLKIN : in std_ulogic;
		CLIENTEMAC0TXCLIENTCLKIN : in std_ulogic;
		CLIENTEMAC0TXD : in std_logic_vector(15 downto 0);
		CLIENTEMAC0TXDVLD : in std_ulogic;
		CLIENTEMAC0TXDVLDMSW : in std_ulogic;
		CLIENTEMAC0TXFIRSTBYTE : in std_ulogic;
		CLIENTEMAC0TXIFGDELAY : in std_logic_vector(7 downto 0);
		CLIENTEMAC0TXUNDERRUN : in std_ulogic;
		CLIENTEMAC1DCMLOCKED : in std_ulogic;
		CLIENTEMAC1PAUSEREQ : in std_ulogic;
		CLIENTEMAC1PAUSEVAL : in std_logic_vector(15 downto 0);
		CLIENTEMAC1RXCLIENTCLKIN : in std_ulogic;
		CLIENTEMAC1TXCLIENTCLKIN : in std_ulogic;
		CLIENTEMAC1TXD : in std_logic_vector(15 downto 0);
		CLIENTEMAC1TXDVLD : in std_ulogic;
		CLIENTEMAC1TXDVLDMSW : in std_ulogic;
		CLIENTEMAC1TXFIRSTBYTE : in std_ulogic;
		CLIENTEMAC1TXIFGDELAY : in std_logic_vector(7 downto 0);
		CLIENTEMAC1TXUNDERRUN : in std_ulogic;
		DCREMACABUS : in std_logic_vector(0 to 9);
		DCREMACCLK : in std_ulogic;
		DCREMACDBUS : in std_logic_vector(0 to 31);
		DCREMACENABLE : in std_ulogic;
		DCREMACREAD : in std_ulogic;
		DCREMACWRITE : in std_ulogic;
		HOSTADDR : in std_logic_vector(9 downto 0);
		HOSTCLK : in std_ulogic;
		HOSTEMAC1SEL : in std_ulogic;
		HOSTMIIMSEL : in std_ulogic;
		HOSTOPCODE : in std_logic_vector(1 downto 0);
		HOSTREQ : in std_ulogic;
		HOSTWRDATA : in std_logic_vector(31 downto 0);
		PHYEMAC0COL : in std_ulogic;
		PHYEMAC0CRS : in std_ulogic;
		PHYEMAC0GTXCLK : in std_ulogic;
		PHYEMAC0MCLKIN : in std_ulogic;
		PHYEMAC0MDIN : in std_ulogic;
		PHYEMAC0MIITXCLK : in std_ulogic;
		PHYEMAC0PHYAD : in std_logic_vector(4 downto 0);
		PHYEMAC0RXBUFERR : in std_ulogic;
		PHYEMAC0RXBUFSTATUS : in std_logic_vector(1 downto 0);
		PHYEMAC0RXCHARISCOMMA : in std_ulogic;
		PHYEMAC0RXCHARISK : in std_ulogic;
		PHYEMAC0RXCHECKINGCRC : in std_ulogic;
		PHYEMAC0RXCLK : in std_ulogic;
		PHYEMAC0RXCLKCORCNT : in std_logic_vector(2 downto 0);
		PHYEMAC0RXCOMMADET : in std_ulogic;
		PHYEMAC0RXD : in std_logic_vector(7 downto 0);
		PHYEMAC0RXDISPERR : in std_ulogic;
		PHYEMAC0RXDV : in std_ulogic;
		PHYEMAC0RXER : in std_ulogic;
		PHYEMAC0RXLOSSOFSYNC : in std_logic_vector(1 downto 0);
		PHYEMAC0RXNOTINTABLE : in std_ulogic;
		PHYEMAC0RXRUNDISP : in std_ulogic;
		PHYEMAC0SIGNALDET : in std_ulogic;
		PHYEMAC0TXBUFERR : in std_ulogic;
		PHYEMAC0TXGMIIMIICLKIN : in std_ulogic;
		PHYEMAC1COL : in std_ulogic;
		PHYEMAC1CRS : in std_ulogic;
		PHYEMAC1GTXCLK : in std_ulogic;
		PHYEMAC1MCLKIN : in std_ulogic;
		PHYEMAC1MDIN : in std_ulogic;
		PHYEMAC1MIITXCLK : in std_ulogic;
		PHYEMAC1PHYAD : in std_logic_vector(4 downto 0);
		PHYEMAC1RXBUFERR : in std_ulogic;
		PHYEMAC1RXBUFSTATUS : in std_logic_vector(1 downto 0);
		PHYEMAC1RXCHARISCOMMA : in std_ulogic;
		PHYEMAC1RXCHARISK : in std_ulogic;
		PHYEMAC1RXCHECKINGCRC : in std_ulogic;
		PHYEMAC1RXCLK : in std_ulogic;
		PHYEMAC1RXCLKCORCNT : in std_logic_vector(2 downto 0);
		PHYEMAC1RXCOMMADET : in std_ulogic;
		PHYEMAC1RXD : in std_logic_vector(7 downto 0);
		PHYEMAC1RXDISPERR : in std_ulogic;
		PHYEMAC1RXDV : in std_ulogic;
		PHYEMAC1RXER : in std_ulogic;
		PHYEMAC1RXLOSSOFSYNC : in std_logic_vector(1 downto 0);
		PHYEMAC1RXNOTINTABLE : in std_ulogic;
		PHYEMAC1RXRUNDISP : in std_ulogic;
		PHYEMAC1SIGNALDET : in std_ulogic;
		PHYEMAC1TXBUFERR : in std_ulogic;
		PHYEMAC1TXGMIIMIICLKIN : in std_ulogic;
		RESET : in std_ulogic
     );

attribute VITAL_LEVEL0 of X_TEMAC :     entity is true;

end X_TEMAC;

architecture X_TEMAC_V of X_TEMAC is

  component TEMAC_SWIFT
    port (
      DCRHOSTDONEIR        : out std_ulogic;
      EMAC0CLIENTANINTERRUPT : out std_ulogic;
      EMAC0CLIENTRXBADFRAME : out std_ulogic;
      EMAC0CLIENTRXCLIENTCLKOUT : out std_ulogic;
      EMAC0CLIENTRXD       : out std_logic_vector(15 downto 0);
      EMAC0CLIENTRXDVLD    : out std_ulogic;
      EMAC0CLIENTRXDVLDMSW : out std_ulogic;
      EMAC0CLIENTRXFRAMEDROP : out std_ulogic;
      EMAC0CLIENTRXGOODFRAME : out std_ulogic;
      EMAC0CLIENTRXSTATS   : out std_logic_vector(6 downto 0);
      EMAC0CLIENTRXSTATSBYTEVLD : out std_ulogic;
      EMAC0CLIENTRXSTATSVLD : out std_ulogic;
      EMAC0CLIENTTXACK     : out std_ulogic;
      EMAC0CLIENTTXCLIENTCLKOUT : out std_ulogic;
      EMAC0CLIENTTXCOLLISION : out std_ulogic;
      EMAC0CLIENTTXRETRANSMIT : out std_ulogic;
      EMAC0CLIENTTXSTATS   : out std_ulogic;
      EMAC0CLIENTTXSTATSBYTEVLD : out std_ulogic;
      EMAC0CLIENTTXSTATSVLD : out std_ulogic;
      EMAC0PHYENCOMMAALIGN : out std_ulogic;
      EMAC0PHYLOOPBACKMSB  : out std_ulogic;
      EMAC0PHYMCLKOUT      : out std_ulogic;
      EMAC0PHYMDOUT        : out std_ulogic;
      EMAC0PHYMDTRI        : out std_ulogic;
      EMAC0PHYMGTRXRESET   : out std_ulogic;
      EMAC0PHYMGTTXRESET   : out std_ulogic;
      EMAC0PHYPOWERDOWN    : out std_ulogic;
      EMAC0PHYSYNCACQSTATUS : out std_ulogic;
      EMAC0PHYTXCHARDISPMODE : out std_ulogic;
      EMAC0PHYTXCHARDISPVAL : out std_ulogic;
      EMAC0PHYTXCHARISK    : out std_ulogic;
      EMAC0PHYTXCLK        : out std_ulogic;
      EMAC0PHYTXD          : out std_logic_vector(7 downto 0);
      EMAC0PHYTXEN         : out std_ulogic;
      EMAC0PHYTXER         : out std_ulogic;
      EMAC0PHYTXGMIIMIICLKOUT : out std_ulogic;
      EMAC0SPEEDIS10100    : out std_ulogic;
      EMAC1CLIENTANINTERRUPT : out std_ulogic;
      EMAC1CLIENTRXBADFRAME : out std_ulogic;
      EMAC1CLIENTRXCLIENTCLKOUT : out std_ulogic;
      EMAC1CLIENTRXD       : out std_logic_vector(15 downto 0);
      EMAC1CLIENTRXDVLD    : out std_ulogic;
      EMAC1CLIENTRXDVLDMSW : out std_ulogic;
      EMAC1CLIENTRXFRAMEDROP : out std_ulogic;
      EMAC1CLIENTRXGOODFRAME : out std_ulogic;
      EMAC1CLIENTRXSTATS   : out std_logic_vector(6 downto 0);
      EMAC1CLIENTRXSTATSBYTEVLD : out std_ulogic;
      EMAC1CLIENTRXSTATSVLD : out std_ulogic;
      EMAC1CLIENTTXACK     : out std_ulogic;
      EMAC1CLIENTTXCLIENTCLKOUT : out std_ulogic;
      EMAC1CLIENTTXCOLLISION : out std_ulogic;
      EMAC1CLIENTTXRETRANSMIT : out std_ulogic;
      EMAC1CLIENTTXSTATS   : out std_ulogic;
      EMAC1CLIENTTXSTATSBYTEVLD : out std_ulogic;
      EMAC1CLIENTTXSTATSVLD : out std_ulogic;
      EMAC1PHYENCOMMAALIGN : out std_ulogic;
      EMAC1PHYLOOPBACKMSB  : out std_ulogic;
      EMAC1PHYMCLKOUT      : out std_ulogic;
      EMAC1PHYMDOUT        : out std_ulogic;
      EMAC1PHYMDTRI        : out std_ulogic;
      EMAC1PHYMGTRXRESET   : out std_ulogic;
      EMAC1PHYMGTTXRESET   : out std_ulogic;
      EMAC1PHYPOWERDOWN    : out std_ulogic;
      EMAC1PHYSYNCACQSTATUS : out std_ulogic;
      EMAC1PHYTXCHARDISPMODE : out std_ulogic;
      EMAC1PHYTXCHARDISPVAL : out std_ulogic;
      EMAC1PHYTXCHARISK    : out std_ulogic;
      EMAC1PHYTXCLK        : out std_ulogic;
      EMAC1PHYTXD          : out std_logic_vector(7 downto 0);
      EMAC1PHYTXEN         : out std_ulogic;
      EMAC1PHYTXER         : out std_ulogic;
      EMAC1PHYTXGMIIMIICLKOUT : out std_ulogic;
      EMAC1SPEEDIS10100    : out std_ulogic;
      EMACDCRACK           : out std_ulogic;
      EMACDCRDBUS          : out std_logic_vector(0 to 31);
      HOSTMIIMRDY          : out std_ulogic;
      HOSTRDDATA           : out std_logic_vector(31 downto 0);

      CLIENTEMAC0DCMLOCKED : in std_ulogic;
      CLIENTEMAC0PAUSEREQ  : in std_ulogic;
      CLIENTEMAC0PAUSEVAL  : in std_logic_vector(15 downto 0);
      CLIENTEMAC0RXCLIENTCLKIN : in std_ulogic;
      CLIENTEMAC0TXCLIENTCLKIN : in std_ulogic;
      CLIENTEMAC0TXD       : in std_logic_vector(15 downto 0);
      CLIENTEMAC0TXDVLD    : in std_ulogic;
      CLIENTEMAC0TXDVLDMSW : in std_ulogic;
      CLIENTEMAC0TXFIRSTBYTE : in std_ulogic;
      CLIENTEMAC0TXIFGDELAY : in std_logic_vector(7 downto 0);
      CLIENTEMAC0TXUNDERRUN : in std_ulogic;
      CLIENTEMAC1DCMLOCKED : in std_ulogic;
      CLIENTEMAC1PAUSEREQ  : in std_ulogic;
      CLIENTEMAC1PAUSEVAL  : in std_logic_vector(15 downto 0);
      CLIENTEMAC1RXCLIENTCLKIN : in std_ulogic;
      CLIENTEMAC1TXCLIENTCLKIN : in std_ulogic;
      CLIENTEMAC1TXD       : in std_logic_vector(15 downto 0);
      CLIENTEMAC1TXDVLD    : in std_ulogic;
      CLIENTEMAC1TXDVLDMSW : in std_ulogic;
      CLIENTEMAC1TXFIRSTBYTE : in std_ulogic;
      CLIENTEMAC1TXIFGDELAY : in std_logic_vector(7 downto 0);
      CLIENTEMAC1TXUNDERRUN : in std_ulogic;
      DCREMACABUS          : in std_logic_vector(0 to 9);
      DCREMACCLK           : in std_ulogic;
      DCREMACDBUS          : in std_logic_vector(0 to 31);
      DCREMACENABLE        : in std_ulogic;
      DCREMACREAD          : in std_ulogic;
      DCREMACWRITE         : in std_ulogic;
      HOSTADDR             : in std_logic_vector(9 downto 0);
      HOSTCLK              : in std_ulogic;
      HOSTEMAC1SEL         : in std_ulogic;
      HOSTMIIMSEL          : in std_ulogic;
      HOSTOPCODE           : in std_logic_vector(1 downto 0);
      HOSTREQ              : in std_ulogic;
      HOSTWRDATA           : in std_logic_vector(31 downto 0);
      PHYEMAC0COL          : in std_ulogic;
      PHYEMAC0CRS          : in std_ulogic;
      PHYEMAC0GTXCLK       : in std_ulogic;
      PHYEMAC0MCLKIN       : in std_ulogic;
      PHYEMAC0MDIN         : in std_ulogic;
      PHYEMAC0MIITXCLK     : in std_ulogic;
      PHYEMAC0PHYAD        : in std_logic_vector(4 downto 0);
      PHYEMAC0RXBUFERR     : in std_ulogic;
      PHYEMAC0RXBUFSTATUS  : in std_logic_vector(1 downto 0);
      PHYEMAC0RXCHARISCOMMA : in std_ulogic;
      PHYEMAC0RXCHARISK    : in std_ulogic;
      PHYEMAC0RXCHECKINGCRC : in std_ulogic;
      PHYEMAC0RXCLK        : in std_ulogic;
      PHYEMAC0RXCLKCORCNT  : in std_logic_vector(2 downto 0);
      PHYEMAC0RXCOMMADET   : in std_ulogic;
      PHYEMAC0RXD          : in std_logic_vector(7 downto 0);
      PHYEMAC0RXDISPERR    : in std_ulogic;
      PHYEMAC0RXDV         : in std_ulogic;
      PHYEMAC0RXER         : in std_ulogic;
      PHYEMAC0RXLOSSOFSYNC : in std_logic_vector(1 downto 0);
      PHYEMAC0RXNOTINTABLE : in std_ulogic;
      PHYEMAC0RXRUNDISP    : in std_ulogic;
      PHYEMAC0SIGNALDET    : in std_ulogic;
      PHYEMAC0TXBUFERR     : in std_ulogic;
      PHYEMAC0TXGMIIMIICLKIN : in std_ulogic;
      PHYEMAC1COL          : in std_ulogic;
      PHYEMAC1CRS          : in std_ulogic;
      PHYEMAC1GTXCLK       : in std_ulogic;
      PHYEMAC1MCLKIN       : in std_ulogic;
      PHYEMAC1MDIN         : in std_ulogic;
      PHYEMAC1MIITXCLK     : in std_ulogic;
      PHYEMAC1PHYAD        : in std_logic_vector(4 downto 0);
      PHYEMAC1RXBUFERR     : in std_ulogic;
      PHYEMAC1RXBUFSTATUS  : in std_logic_vector(1 downto 0);
      PHYEMAC1RXCHARISCOMMA : in std_ulogic;
      PHYEMAC1RXCHARISK    : in std_ulogic;
      PHYEMAC1RXCHECKINGCRC : in std_ulogic;
      PHYEMAC1RXCLK        : in std_ulogic;
      PHYEMAC1RXCLKCORCNT  : in std_logic_vector(2 downto 0);
      PHYEMAC1RXCOMMADET   : in std_ulogic;
      PHYEMAC1RXD          : in std_logic_vector(7 downto 0);
      PHYEMAC1RXDISPERR    : in std_ulogic;
      PHYEMAC1RXDV         : in std_ulogic;
      PHYEMAC1RXER         : in std_ulogic;
      PHYEMAC1RXLOSSOFSYNC : in std_logic_vector(1 downto 0);
      PHYEMAC1RXNOTINTABLE : in std_ulogic;
      PHYEMAC1RXRUNDISP    : in std_ulogic;
      PHYEMAC1SIGNALDET    : in std_ulogic;
      PHYEMAC1TXBUFERR     : in std_ulogic;
      PHYEMAC1TXGMIIMIICLKIN : in std_ulogic;
      RESET                : in std_ulogic;

      EMAC0_1000BASEX_ENABLE    : in std_ulogic;
      EMAC0_ADDRFILTER_ENABLE   : in std_ulogic;
      EMAC0_BYTEPHY             : in std_ulogic;
      EMAC0_CONFIGVEC_79        : in std_ulogic;
      EMAC0_DCRBASEADDR         : in std_logic_vector(0 to 7);
      EMAC0_GTLOOPBACK          : in std_ulogic;
      EMAC0_HOST_ENABLE         : in std_ulogic;
      EMAC0_LINKTIMERVAL        : in std_logic_vector(8 downto 0);
      EMAC0_LTCHECK_DISABLE     : in std_ulogic;
      EMAC0_MDIO_ENABLE         : in std_ulogic;
      EMAC0_PAUSEADDR           : in std_logic_vector(47 downto 0);
      EMAC0_PHYINITAUTONEG_ENABLE : in std_ulogic;
      EMAC0_PHYISOLATE          : in std_ulogic;
      EMAC0_PHYLOOPBACKMSB      : in std_ulogic;
      EMAC0_PHYPOWERDOWN        : in std_ulogic;
      EMAC0_PHYRESET            : in std_ulogic;
      EMAC0_RGMII_ENABLE        : in std_ulogic;
      EMAC0_RX16BITCLIENT_ENABLE : in std_ulogic;
      EMAC0_RXFLOWCTRL_ENABLE   : in std_ulogic;
      EMAC0_RXHALFDUPLEX        : in std_ulogic;
      EMAC0_RXINBANDFCS_ENABLE  : in std_ulogic;
      EMAC0_RXJUMBOFRAME_ENABLE : in std_ulogic;
      EMAC0_RXRESET             : in std_ulogic;
      EMAC0_RXVLAN_ENABLE       : in std_ulogic;
      EMAC0_RX_ENABLE           : in std_ulogic;
      EMAC0_SGMII_ENABLE        : in std_ulogic;
      EMAC0_SPEED_LSB           : in std_ulogic;
      EMAC0_SPEED_MSB           : in std_ulogic;
      EMAC0_TX16BITCLIENT_ENABLE : in std_ulogic;
      EMAC0_TXFLOWCTRL_ENABLE   : in std_ulogic;
      EMAC0_TXHALFDUPLEX        : in std_ulogic;
      EMAC0_TXIFGADJUST_ENABLE  : in std_ulogic;
      EMAC0_TXINBANDFCS_ENABLE  : in std_ulogic;
      EMAC0_TXJUMBOFRAME_ENABLE : in std_ulogic;
      EMAC0_TXRESET             : in std_ulogic;
      EMAC0_TXVLAN_ENABLE       : in std_ulogic;
      EMAC0_TX_ENABLE           : in std_ulogic;
      EMAC0_UNICASTADDR         : in std_logic_vector(47 downto 0);
      EMAC0_UNIDIRECTION_ENABLE : in std_ulogic;
      EMAC0_USECLKEN            : in std_ulogic;
      EMAC1_1000BASEX_ENABLE    : in std_ulogic;
      EMAC1_ADDRFILTER_ENABLE   : in std_ulogic;
      EMAC1_BYTEPHY             : in std_ulogic;
      EMAC1_CONFIGVEC_79        : in std_ulogic;
      EMAC1_DCRBASEADDR         : in std_logic_vector(0 to 7);
      EMAC1_GTLOOPBACK          : in std_ulogic;
      EMAC1_HOST_ENABLE         : in std_ulogic;
      EMAC1_LINKTIMERVAL        : in std_logic_vector(8 downto 0);
      EMAC1_LTCHECK_DISABLE     : in std_ulogic;
      EMAC1_MDIO_ENABLE         : in std_ulogic;
      EMAC1_PAUSEADDR           : in std_logic_vector(47 downto 0);
      EMAC1_PHYINITAUTONEG_ENABLE : in std_ulogic;
      EMAC1_PHYISOLATE          : in std_ulogic;
      EMAC1_PHYLOOPBACKMSB      : in std_ulogic;
      EMAC1_PHYPOWERDOWN        : in std_ulogic;
      EMAC1_PHYRESET            : in std_ulogic;
      EMAC1_RGMII_ENABLE        : in std_ulogic;
      EMAC1_RX16BITCLIENT_ENABLE : in std_ulogic;
      EMAC1_RXFLOWCTRL_ENABLE   : in std_ulogic;
      EMAC1_RXHALFDUPLEX        : in std_ulogic;
      EMAC1_RXINBANDFCS_ENABLE  : in std_ulogic;
      EMAC1_RXJUMBOFRAME_ENABLE : in std_ulogic;
      EMAC1_RXRESET             : in std_ulogic;
      EMAC1_RXVLAN_ENABLE       : in std_ulogic;
      EMAC1_RX_ENABLE           : in std_ulogic;
      EMAC1_SGMII_ENABLE        : in std_ulogic;
      EMAC1_SPEED_LSB           : in std_ulogic;
      EMAC1_SPEED_MSB           : in std_ulogic;
      EMAC1_TX16BITCLIENT_ENABLE : in std_ulogic;
      EMAC1_TXFLOWCTRL_ENABLE   : in std_ulogic;
      EMAC1_TXHALFDUPLEX        : in std_ulogic;
      EMAC1_TXIFGADJUST_ENABLE  : in std_ulogic;
      EMAC1_TXINBANDFCS_ENABLE  : in std_ulogic;
      EMAC1_TXJUMBOFRAME_ENABLE : in std_ulogic;
      EMAC1_TXRESET             : in std_ulogic;
      EMAC1_TXVLAN_ENABLE       : in std_ulogic;
      EMAC1_TX_ENABLE           : in std_ulogic;
      EMAC1_UNICASTADDR         : in std_logic_vector(47 downto 0);
      EMAC1_UNIDIRECTION_ENABLE : in std_ulogic;
      EMAC1_USECLKEN            : in std_ulogic
    );
  end component;

  function GetValue_EMAC0 (
    EMAC0_TX16BITCLIENT_ENABLE : in boolean
    )  return time is 
    variable delay_time : time;
  begin 
    case EMAC0_TX16BITCLIENT_ENABLE is 
      when TRUE => delay_time := 25 ps;
      when FALSE => delay_time := 0 ps;
    end case;
    return delay_time;
  end;

  function GetValue_EMAC1 (
    EMAC1_TX16BITCLIENT_ENABLE : in boolean
    )  return time is 
    variable delay_time : time;
  begin 
    case EMAC1_TX16BITCLIENT_ENABLE is 
      when TRUE => delay_time := 25 ps;
      when FALSE => delay_time := 0 ps;
    end case;
    return delay_time;
  end;

  constant IN_DELAY : time := 50 ps;
	constant OUT_DELAY : time := 0 ps;
        constant CLK_DELAY : time := 0 ps;  
        constant EMAC0MIITXCLK_DELAY : time := GetValue_EMAC0(EMAC0_TX16BITCLIENT_ENABLE);
        constant EMAC1MIITXCLK_DELAY : time := GetValue_EMAC1(EMAC1_TX16BITCLIENT_ENABLE);

	signal   EMAC0_PAUSEADDR_BINARY  :  std_logic_vector(47 downto 0) := To_StdLogicVector(EMAC0_PAUSEADDR);
	signal   EMAC0_RXHALFDUPLEX_BINARY  :  std_ulogic;
	signal   EMAC0_RXVLAN_ENABLE_BINARY  :  std_ulogic;
	signal   EMAC0_RX_ENABLE_BINARY  :  std_ulogic;
	signal   EMAC0_RXINBANDFCS_ENABLE_BINARY  :  std_ulogic;
	signal   EMAC0_RXJUMBOFRAME_ENABLE_BINARY  :  std_ulogic;
	signal   EMAC0_RXRESET_BINARY  :  std_ulogic;
	signal   EMAC0_TXIFGADJUST_ENABLE_BINARY  :  std_ulogic;
	signal   EMAC0_TXHALFDUPLEX_BINARY  :  std_ulogic;
	signal   EMAC0_TXVLAN_ENABLE_BINARY  :  std_ulogic;
	signal   EMAC0_TX_ENABLE_BINARY  :  std_ulogic;
	signal   EMAC0_TXINBANDFCS_ENABLE_BINARY  :  std_ulogic;
	signal   EMAC0_TXJUMBOFRAME_ENABLE_BINARY  :  std_ulogic;
	signal   EMAC0_TXRESET_BINARY  :  std_ulogic;
	signal   EMAC0_TXFLOWCTRL_ENABLE_BINARY  :  std_ulogic;
	signal   EMAC0_RXFLOWCTRL_ENABLE_BINARY  :  std_ulogic;
	signal   EMAC0_LTCHECK_DISABLE_BINARY  :  std_ulogic;
	signal   EMAC0_ADDRFILTER_ENABLE_BINARY  :  std_ulogic;
	signal   EMAC0_RX16BITCLIENT_ENABLE_BINARY  :  std_ulogic;
	signal   EMAC0_TX16BITCLIENT_ENABLE_BINARY  :  std_ulogic;
	signal   EMAC0_HOST_ENABLE_BINARY  :  std_ulogic;
	signal   EMAC0_1000BASEX_ENABLE_BINARY  :  std_ulogic;
	signal   EMAC0_SGMII_ENABLE_BINARY  :  std_ulogic;
	signal   EMAC0_RGMII_ENABLE_BINARY  :  std_ulogic;
	signal   EMAC0_SPEED_LSB_BINARY  :  std_ulogic;
	signal   EMAC0_SPEED_MSB_BINARY  :  std_ulogic;
	signal   EMAC0_MDIO_ENABLE_BINARY  :  std_ulogic;
	signal   EMAC0_PHYLOOPBACKMSB_BINARY  :  std_ulogic;
	signal   EMAC0_PHYPOWERDOWN_BINARY  :  std_ulogic;
	signal   EMAC0_PHYISOLATE_BINARY  :  std_ulogic;
	signal   EMAC0_PHYINITAUTONEG_ENABLE_BINARY  :  std_ulogic;
	signal   EMAC0_PHYRESET_BINARY  :  std_ulogic;
	signal   EMAC0_CONFIGVEC_79_BINARY  :  std_ulogic;
	signal   EMAC0_UNIDIRECTION_ENABLE_BINARY  :  std_ulogic;
	signal   EMAC0_GTLOOPBACK_BINARY  :  std_ulogic;
	signal   EMAC0_UNICASTADDR_BINARY  :  std_logic_vector(47 downto 0) := To_StdLogicVector(EMAC0_UNICASTADDR);
	signal   EMAC0_LINKTIMERVAL_BINARY  :  std_logic_vector(8 downto 0) := To_StdLogicVector(EMAC0_LINKTIMERVAL)(8 downto 0);
	signal   EMAC0_BYTEPHY_BINARY  :  std_ulogic;
	signal   EMAC0_USECLKEN_BINARY  :  std_ulogic;
	signal   EMAC0_DCRBASEADDR_BINARY  :  std_logic_vector(0 to 7) := To_StdLogicVector(EMAC0_DCRBASEADDR);
	signal   EMAC1_PAUSEADDR_BINARY  :  std_logic_vector(47 downto 0) := To_StdLogicVector(EMAC1_PAUSEADDR);
	signal   EMAC1_RXHALFDUPLEX_BINARY  :  std_ulogic;
	signal   EMAC1_RXVLAN_ENABLE_BINARY  :  std_ulogic;
	signal   EMAC1_RX_ENABLE_BINARY  :  std_ulogic;
	signal   EMAC1_RXINBANDFCS_ENABLE_BINARY  :  std_ulogic;
	signal   EMAC1_RXJUMBOFRAME_ENABLE_BINARY  :  std_ulogic;
	signal   EMAC1_RXRESET_BINARY  :  std_ulogic;
	signal   EMAC1_TXIFGADJUST_ENABLE_BINARY  :  std_ulogic;
	signal   EMAC1_TXHALFDUPLEX_BINARY  :  std_ulogic;
	signal   EMAC1_TXVLAN_ENABLE_BINARY  :  std_ulogic;
	signal   EMAC1_TX_ENABLE_BINARY  :  std_ulogic;
	signal   EMAC1_TXINBANDFCS_ENABLE_BINARY  :  std_ulogic;
	signal   EMAC1_TXJUMBOFRAME_ENABLE_BINARY  :  std_ulogic;
	signal   EMAC1_TXRESET_BINARY  :  std_ulogic;
	signal   EMAC1_TXFLOWCTRL_ENABLE_BINARY  :  std_ulogic;
	signal   EMAC1_RXFLOWCTRL_ENABLE_BINARY  :  std_ulogic;
	signal   EMAC1_LTCHECK_DISABLE_BINARY  :  std_ulogic;
	signal   EMAC1_ADDRFILTER_ENABLE_BINARY  :  std_ulogic;
	signal   EMAC1_RX16BITCLIENT_ENABLE_BINARY  :  std_ulogic;
	signal   EMAC1_TX16BITCLIENT_ENABLE_BINARY  :  std_ulogic;
	signal   EMAC1_HOST_ENABLE_BINARY  :  std_ulogic;
	signal   EMAC1_1000BASEX_ENABLE_BINARY  :  std_ulogic;
	signal   EMAC1_SGMII_ENABLE_BINARY  :  std_ulogic;
	signal   EMAC1_RGMII_ENABLE_BINARY  :  std_ulogic;
	signal   EMAC1_SPEED_LSB_BINARY  :  std_ulogic;
	signal   EMAC1_SPEED_MSB_BINARY  :  std_ulogic;
	signal   EMAC1_MDIO_ENABLE_BINARY  :  std_ulogic;
	signal   EMAC1_PHYLOOPBACKMSB_BINARY  :  std_ulogic;
	signal   EMAC1_PHYPOWERDOWN_BINARY  :  std_ulogic;
	signal   EMAC1_PHYISOLATE_BINARY  :  std_ulogic;
	signal   EMAC1_PHYINITAUTONEG_ENABLE_BINARY  :  std_ulogic;
	signal   EMAC1_PHYRESET_BINARY  :  std_ulogic;
	signal   EMAC1_CONFIGVEC_79_BINARY  :  std_ulogic;
	signal   EMAC1_UNIDIRECTION_ENABLE_BINARY  :  std_ulogic;
	signal   EMAC1_GTLOOPBACK_BINARY  :  std_ulogic;
	signal   EMAC1_UNICASTADDR_BINARY  :  std_logic_vector(47 downto 0) := To_StdLogicVector(EMAC1_UNICASTADDR);
	signal   EMAC1_LINKTIMERVAL_BINARY  :  std_logic_vector(8 downto 0) := To_StdLogicVector(EMAC1_LINKTIMERVAL)(8 downto 0);
	signal   EMAC1_BYTEPHY_BINARY  :  std_ulogic;
	signal   EMAC1_USECLKEN_BINARY  :  std_ulogic;
	signal   EMAC1_DCRBASEADDR_BINARY  :  std_logic_vector(0 to 7) := To_StdLogicVector(EMAC1_DCRBASEADDR);

	signal   DCRHOSTDONEIR_out  :  std_ulogic;
	signal   EMAC0CLIENTANINTERRUPT_out  :  std_ulogic;
	signal   EMAC0CLIENTRXBADFRAME_out  :  std_ulogic;
	signal   EMAC0CLIENTRXCLIENTCLKOUT_out  :  std_ulogic;
	signal   EMAC0CLIENTRXD_out  :  std_logic_vector(15 downto 0);
	signal   EMAC0CLIENTRXDVLD_out  :  std_ulogic;
	signal   EMAC0CLIENTRXDVLDMSW_out  :  std_ulogic;
	signal   EMAC0CLIENTRXFRAMEDROP_out  :  std_ulogic;
	signal   EMAC0CLIENTRXGOODFRAME_out  :  std_ulogic;
	signal   EMAC0CLIENTRXSTATS_out  :  std_logic_vector(6 downto 0);
	signal   EMAC0CLIENTRXSTATSBYTEVLD_out  :  std_ulogic;
	signal   EMAC0CLIENTRXSTATSVLD_out  :  std_ulogic;
	signal   EMAC0CLIENTTXACK_out  :  std_ulogic;
	signal   EMAC0CLIENTTXCLIENTCLKOUT_out  :  std_ulogic;
	signal   EMAC0CLIENTTXCOLLISION_out  :  std_ulogic;
	signal   EMAC0PHYTXGMIIMIICLKOUT_out  :  std_ulogic;
	signal   EMAC0CLIENTTXRETRANSMIT_out  :  std_ulogic;
	signal   EMAC0CLIENTTXSTATS_out  :  std_ulogic;
	signal   EMAC0CLIENTTXSTATSBYTEVLD_out  :  std_ulogic;
	signal   EMAC0CLIENTTXSTATSVLD_out  :  std_ulogic;
	signal   EMAC0PHYENCOMMAALIGN_out  :  std_ulogic;
	signal   EMAC0PHYLOOPBACKMSB_out  :  std_ulogic;
	signal   EMAC0PHYMCLKOUT_out  :  std_ulogic;
	signal   EMAC0PHYMDOUT_out  :  std_ulogic;
	signal   EMAC0PHYMDTRI_out  :  std_ulogic;
	signal   EMAC0PHYMGTRXRESET_out  :  std_ulogic;
	signal   EMAC0PHYMGTTXRESET_out  :  std_ulogic;
	signal   EMAC0PHYPOWERDOWN_out  :  std_ulogic;
	signal   EMAC0PHYSYNCACQSTATUS_out  :  std_ulogic;
	signal   EMAC0PHYTXCHARDISPMODE_out  :  std_ulogic;
	signal   EMAC0PHYTXCHARDISPVAL_out  :  std_ulogic;
	signal   EMAC0PHYTXCHARISK_out  :  std_ulogic;
	signal   EMAC0PHYTXCLK_out  :  std_ulogic;
	signal   EMAC0PHYTXD_out  :  std_logic_vector(7 downto 0);
	signal   EMAC0PHYTXEN_out  :  std_ulogic;
	signal   EMAC0PHYTXER_out  :  std_ulogic;
	signal   EMAC0SPEEDIS10100_out  :  std_ulogic;
	signal   EMAC1CLIENTANINTERRUPT_out  :  std_ulogic;
	signal   EMAC1CLIENTRXBADFRAME_out  :  std_ulogic;
	signal   EMAC1CLIENTRXCLIENTCLKOUT_out  :  std_ulogic;
	signal   EMAC1CLIENTRXD_out  :  std_logic_vector(15 downto 0);
	signal   EMAC1CLIENTRXDVLD_out  :  std_ulogic;
	signal   EMAC1CLIENTRXDVLDMSW_out  :  std_ulogic;
	signal   EMAC1CLIENTRXFRAMEDROP_out  :  std_ulogic;
	signal   EMAC1CLIENTRXGOODFRAME_out  :  std_ulogic;
	signal   EMAC1CLIENTRXSTATS_out  :  std_logic_vector(6 downto 0);
	signal   EMAC1CLIENTRXSTATSBYTEVLD_out  :  std_ulogic;
	signal   EMAC1CLIENTRXSTATSVLD_out  :  std_ulogic;
	signal   EMAC1CLIENTTXACK_out  :  std_ulogic;
	signal   EMAC1CLIENTTXCLIENTCLKOUT_out  :  std_ulogic;
	signal   EMAC1CLIENTTXCOLLISION_out  :  std_ulogic;
	signal   EMAC1PHYTXGMIIMIICLKOUT_out  :  std_ulogic;
	signal   EMAC1CLIENTTXRETRANSMIT_out  :  std_ulogic;
	signal   EMAC1CLIENTTXSTATS_out  :  std_ulogic;
	signal   EMAC1CLIENTTXSTATSBYTEVLD_out  :  std_ulogic;
	signal   EMAC1CLIENTTXSTATSVLD_out  :  std_ulogic;
	signal   EMAC1PHYENCOMMAALIGN_out  :  std_ulogic;
	signal   EMAC1PHYLOOPBACKMSB_out  :  std_ulogic;
	signal   EMAC1PHYMCLKOUT_out  :  std_ulogic;
	signal   EMAC1PHYMDOUT_out  :  std_ulogic;
	signal   EMAC1PHYMDTRI_out  :  std_ulogic;
	signal   EMAC1PHYMGTRXRESET_out  :  std_ulogic;
	signal   EMAC1PHYMGTTXRESET_out  :  std_ulogic;
	signal   EMAC1PHYPOWERDOWN_out  :  std_ulogic;
	signal   EMAC1PHYSYNCACQSTATUS_out  :  std_ulogic;
	signal   EMAC1PHYTXCHARDISPMODE_out  :  std_ulogic;
	signal   EMAC1PHYTXCHARDISPVAL_out  :  std_ulogic;
	signal   EMAC1PHYTXCHARISK_out  :  std_ulogic;
	signal   EMAC1PHYTXCLK_out  :  std_ulogic;
	signal   EMAC1PHYTXD_out  :  std_logic_vector(7 downto 0);
	signal   EMAC1PHYTXEN_out  :  std_ulogic;
	signal   EMAC1PHYTXER_out  :  std_ulogic;
	signal   EMAC1SPEEDIS10100_out  :  std_ulogic;
	signal   EMACDCRACK_out  :  std_ulogic;
	signal   EMACDCRDBUS_out  :  std_logic_vector(0 to 31);
	signal   HOSTMIIMRDY_out  :  std_ulogic;
	signal   HOSTRDDATA_out  :  std_logic_vector(31 downto 0);

       	signal   EMAC0CLIENTRXCLIENTCLKOUT_outdelay  :  std_ulogic;
	signal   EMAC0CLIENTTXCLIENTCLKOUT_outdelay  :  std_ulogic;
	signal   EMAC0PHYTXGMIIMIICLKOUT_outdelay  :  std_ulogic;
	signal   EMAC0PHYMCLKOUT_outdelay  :  std_ulogic;
	signal   EMAC0PHYTXCLK_outdelay  :  std_ulogic;
	signal   EMAC1CLIENTRXCLIENTCLKOUT_outdelay  :  std_ulogic;
	signal   EMAC1CLIENTTXCLIENTCLKOUT_outdelay  :  std_ulogic;
	signal   EMAC1PHYTXGMIIMIICLKOUT_outdelay  :  std_ulogic;
	signal   EMAC1PHYMCLKOUT_outdelay  :  std_ulogic;
	signal   EMAC1PHYTXCLK_outdelay  :  std_ulogic;

	signal   DCRHOSTDONEIR_outdelay  :  std_ulogic;
	signal   EMAC0CLIENTANINTERRUPT_outdelay  :  std_ulogic;
	signal   EMAC0CLIENTRXBADFRAME_outdelay  :  std_ulogic;
	signal   EMAC0CLIENTRXD_outdelay  :  std_logic_vector(15 downto 0);
	signal   EMAC0CLIENTRXDVLD_outdelay  :  std_ulogic;
	signal   EMAC0CLIENTRXDVLDMSW_outdelay  :  std_ulogic;
	signal   EMAC0CLIENTRXFRAMEDROP_outdelay  :  std_ulogic;
	signal   EMAC0CLIENTRXGOODFRAME_outdelay  :  std_ulogic;
	signal   EMAC0CLIENTRXSTATS_outdelay  :  std_logic_vector(6 downto 0);
	signal   EMAC0CLIENTRXSTATSBYTEVLD_outdelay  :  std_ulogic;
	signal   EMAC0CLIENTRXSTATSVLD_outdelay  :  std_ulogic;
	signal   EMAC0CLIENTTXACK_outdelay  :  std_ulogic;
	signal   EMAC0CLIENTTXCOLLISION_outdelay  :  std_ulogic;
	signal   EMAC0CLIENTTXRETRANSMIT_outdelay  :  std_ulogic;
	signal   EMAC0CLIENTTXSTATS_outdelay  :  std_ulogic;
	signal   EMAC0CLIENTTXSTATSBYTEVLD_outdelay  :  std_ulogic;
	signal   EMAC0CLIENTTXSTATSVLD_outdelay  :  std_ulogic;
	signal   EMAC0PHYENCOMMAALIGN_outdelay  :  std_ulogic;
	signal   EMAC0PHYLOOPBACKMSB_outdelay  :  std_ulogic;
	signal   EMAC0PHYMDOUT_outdelay  :  std_ulogic;
	signal   EMAC0PHYMDTRI_outdelay  :  std_ulogic;
	signal   EMAC0PHYMGTRXRESET_outdelay  :  std_ulogic;
	signal   EMAC0PHYMGTTXRESET_outdelay  :  std_ulogic;
	signal   EMAC0PHYPOWERDOWN_outdelay  :  std_ulogic;
	signal   EMAC0PHYSYNCACQSTATUS_outdelay  :  std_ulogic;
	signal   EMAC0PHYTXCHARDISPMODE_outdelay  :  std_ulogic;
	signal   EMAC0PHYTXCHARDISPVAL_outdelay  :  std_ulogic;
	signal   EMAC0PHYTXCHARISK_outdelay  :  std_ulogic;
	signal   EMAC0PHYTXD_outdelay  :  std_logic_vector(7 downto 0);
	signal   EMAC0PHYTXEN_outdelay  :  std_ulogic;
	signal   EMAC0PHYTXER_outdelay  :  std_ulogic;
	signal   EMAC0SPEEDIS10100_outdelay  :  std_ulogic;
	signal   EMAC1CLIENTANINTERRUPT_outdelay  :  std_ulogic;
	signal   EMAC1CLIENTRXBADFRAME_outdelay  :  std_ulogic;
	signal   EMAC1CLIENTRXD_outdelay  :  std_logic_vector(15 downto 0);
	signal   EMAC1CLIENTRXDVLD_outdelay  :  std_ulogic;
	signal   EMAC1CLIENTRXDVLDMSW_outdelay  :  std_ulogic;
	signal   EMAC1CLIENTRXFRAMEDROP_outdelay  :  std_ulogic;
	signal   EMAC1CLIENTRXGOODFRAME_outdelay  :  std_ulogic;
	signal   EMAC1CLIENTRXSTATS_outdelay  :  std_logic_vector(6 downto 0);
	signal   EMAC1CLIENTRXSTATSBYTEVLD_outdelay  :  std_ulogic;
	signal   EMAC1CLIENTRXSTATSVLD_outdelay  :  std_ulogic;
	signal   EMAC1CLIENTTXACK_outdelay  :  std_ulogic;
	signal   EMAC1CLIENTTXCOLLISION_outdelay  :  std_ulogic;
	signal   EMAC1CLIENTTXRETRANSMIT_outdelay  :  std_ulogic;
	signal   EMAC1CLIENTTXSTATS_outdelay  :  std_ulogic;
	signal   EMAC1CLIENTTXSTATSBYTEVLD_outdelay  :  std_ulogic;
	signal   EMAC1CLIENTTXSTATSVLD_outdelay  :  std_ulogic;
	signal   EMAC1PHYENCOMMAALIGN_outdelay  :  std_ulogic;
	signal   EMAC1PHYLOOPBACKMSB_outdelay  :  std_ulogic;
	signal   EMAC1PHYMDOUT_outdelay  :  std_ulogic;
	signal   EMAC1PHYMDTRI_outdelay  :  std_ulogic;
	signal   EMAC1PHYMGTRXRESET_outdelay  :  std_ulogic;
	signal   EMAC1PHYMGTTXRESET_outdelay  :  std_ulogic;
	signal   EMAC1PHYPOWERDOWN_outdelay  :  std_ulogic;
	signal   EMAC1PHYSYNCACQSTATUS_outdelay  :  std_ulogic;
	signal   EMAC1PHYTXCHARDISPMODE_outdelay  :  std_ulogic;
	signal   EMAC1PHYTXCHARDISPVAL_outdelay  :  std_ulogic;
	signal   EMAC1PHYTXCHARISK_outdelay  :  std_ulogic;
	signal   EMAC1PHYTXD_outdelay  :  std_logic_vector(7 downto 0);
	signal   EMAC1PHYTXEN_outdelay  :  std_ulogic;
	signal   EMAC1PHYTXER_outdelay  :  std_ulogic;
	signal   EMAC1SPEEDIS10100_outdelay  :  std_ulogic;
	signal   EMACDCRACK_outdelay  :  std_ulogic;
	signal   EMACDCRDBUS_outdelay  :  std_logic_vector(0 to 31);
	signal   HOSTMIIMRDY_outdelay  :  std_ulogic;
	signal   HOSTRDDATA_outdelay  :  std_logic_vector(31 downto 0);

	signal   CLIENTEMAC0DCMLOCKED_ipd  :  std_ulogic;
	signal   CLIENTEMAC0PAUSEREQ_ipd  :  std_ulogic;
	signal   CLIENTEMAC0PAUSEVAL_ipd  :  std_logic_vector(15 downto 0);
	signal   CLIENTEMAC0RXCLIENTCLKIN_ipd  :  std_ulogic;
	signal   CLIENTEMAC0TXCLIENTCLKIN_ipd  :  std_ulogic;
	signal   CLIENTEMAC0TXD_ipd  :  std_logic_vector(15 downto 0);
	signal   CLIENTEMAC0TXDVLD_ipd  :  std_ulogic;
	signal   CLIENTEMAC0TXDVLDMSW_ipd  :  std_ulogic;
	signal   CLIENTEMAC0TXFIRSTBYTE_ipd  :  std_ulogic;
	signal   PHYEMAC0TXGMIIMIICLKIN_ipd  :  std_ulogic;
	signal   CLIENTEMAC0TXIFGDELAY_ipd  :  std_logic_vector(7 downto 0);
	signal   CLIENTEMAC0TXUNDERRUN_ipd  :  std_ulogic;
	signal   CLIENTEMAC1DCMLOCKED_ipd  :  std_ulogic;
	signal   CLIENTEMAC1PAUSEREQ_ipd  :  std_ulogic;
	signal   CLIENTEMAC1PAUSEVAL_ipd  :  std_logic_vector(15 downto 0);
	signal   CLIENTEMAC1RXCLIENTCLKIN_ipd  :  std_ulogic;
	signal   CLIENTEMAC1TXCLIENTCLKIN_ipd  :  std_ulogic;
	signal   CLIENTEMAC1TXD_ipd  :  std_logic_vector(15 downto 0);
	signal   CLIENTEMAC1TXDVLD_ipd  :  std_ulogic;
	signal   CLIENTEMAC1TXDVLDMSW_ipd  :  std_ulogic;
	signal   CLIENTEMAC1TXFIRSTBYTE_ipd  :  std_ulogic;
	signal   PHYEMAC1TXGMIIMIICLKIN_ipd  :  std_ulogic;
	signal   CLIENTEMAC1TXIFGDELAY_ipd  :  std_logic_vector(7 downto 0);
	signal   CLIENTEMAC1TXUNDERRUN_ipd  :  std_ulogic;
	signal   DCREMACABUS_ipd  :  std_logic_vector(0 to 9);
	signal   DCREMACCLK_ipd  :  std_ulogic;
	signal   DCREMACDBUS_ipd  :  std_logic_vector(0 to 31);
	signal   DCREMACENABLE_ipd  :  std_ulogic;
	signal   DCREMACREAD_ipd  :  std_ulogic;
	signal   DCREMACWRITE_ipd  :  std_ulogic;
	signal   HOSTADDR_ipd  :  std_logic_vector(9 downto 0);
	signal   HOSTCLK_ipd  :  std_ulogic;
	signal   HOSTEMAC1SEL_ipd  :  std_ulogic;
	signal   HOSTMIIMSEL_ipd  :  std_ulogic;
	signal   HOSTOPCODE_ipd  :  std_logic_vector(1 downto 0);
	signal   HOSTREQ_ipd  :  std_ulogic;
	signal   HOSTWRDATA_ipd  :  std_logic_vector(31 downto 0);
	signal   PHYEMAC0COL_ipd  :  std_ulogic;
	signal   PHYEMAC0CRS_ipd  :  std_ulogic;
	signal   PHYEMAC0GTXCLK_ipd  :  std_ulogic;
	signal   PHYEMAC0MCLKIN_ipd  :  std_ulogic;
	signal   PHYEMAC0MDIN_ipd  :  std_ulogic;
	signal   PHYEMAC0MIITXCLK_ipd  :  std_ulogic;
	signal   PHYEMAC0PHYAD_ipd  :  std_logic_vector(4 downto 0);
	signal   PHYEMAC0RXBUFERR_ipd  :  std_ulogic;
	signal   PHYEMAC0RXBUFSTATUS_ipd  :  std_logic_vector(1 downto 0);
	signal   PHYEMAC0RXCHARISCOMMA_ipd  :  std_ulogic;
	signal   PHYEMAC0RXCHARISK_ipd  :  std_ulogic;
	signal   PHYEMAC0RXCHECKINGCRC_ipd  :  std_ulogic;
	signal   PHYEMAC0RXCLK_ipd  :  std_ulogic;
	signal   PHYEMAC0RXCLKCORCNT_ipd  :  std_logic_vector(2 downto 0);
	signal   PHYEMAC0RXCOMMADET_ipd  :  std_ulogic;
	signal   PHYEMAC0RXD_ipd  :  std_logic_vector(7 downto 0);
	signal   PHYEMAC0RXDISPERR_ipd  :  std_ulogic;
	signal   PHYEMAC0RXDV_ipd  :  std_ulogic;
	signal   PHYEMAC0RXER_ipd  :  std_ulogic;
	signal   PHYEMAC0RXLOSSOFSYNC_ipd  :  std_logic_vector(1 downto 0);
	signal   PHYEMAC0RXNOTINTABLE_ipd  :  std_ulogic;
	signal   PHYEMAC0RXRUNDISP_ipd  :  std_ulogic;
	signal   PHYEMAC0SIGNALDET_ipd  :  std_ulogic;
	signal   PHYEMAC0TXBUFERR_ipd  :  std_ulogic;
	signal   PHYEMAC1COL_ipd  :  std_ulogic;
	signal   PHYEMAC1CRS_ipd  :  std_ulogic;
	signal   PHYEMAC1GTXCLK_ipd  :  std_ulogic;
	signal   PHYEMAC1MCLKIN_ipd  :  std_ulogic;
	signal   PHYEMAC1MDIN_ipd  :  std_ulogic;
	signal   PHYEMAC1MIITXCLK_ipd  :  std_ulogic;
	signal   PHYEMAC1PHYAD_ipd  :  std_logic_vector(4 downto 0);
	signal   PHYEMAC1RXBUFERR_ipd  :  std_ulogic;
	signal   PHYEMAC1RXBUFSTATUS_ipd  :  std_logic_vector(1 downto 0);
	signal   PHYEMAC1RXCHARISCOMMA_ipd  :  std_ulogic;
	signal   PHYEMAC1RXCHARISK_ipd  :  std_ulogic;
	signal   PHYEMAC1RXCHECKINGCRC_ipd  :  std_ulogic;
	signal   PHYEMAC1RXCLK_ipd  :  std_ulogic;
	signal   PHYEMAC1RXCLKCORCNT_ipd  :  std_logic_vector(2 downto 0);
	signal   PHYEMAC1RXCOMMADET_ipd  :  std_ulogic;
	signal   PHYEMAC1RXD_ipd  :  std_logic_vector(7 downto 0);
	signal   PHYEMAC1RXDISPERR_ipd  :  std_ulogic;
	signal   PHYEMAC1RXDV_ipd  :  std_ulogic;
	signal   PHYEMAC1RXER_ipd  :  std_ulogic;
	signal   PHYEMAC1RXLOSSOFSYNC_ipd  :  std_logic_vector(1 downto 0);
	signal   PHYEMAC1RXNOTINTABLE_ipd  :  std_ulogic;
	signal   PHYEMAC1RXRUNDISP_ipd  :  std_ulogic;
	signal   PHYEMAC1SIGNALDET_ipd  :  std_ulogic;
	signal   PHYEMAC1TXBUFERR_ipd  :  std_ulogic;
	signal   RESET_ipd  :  std_ulogic;

	signal   CLIENTEMAC0DCMLOCKED_dly  :  std_ulogic;
	signal   CLIENTEMAC0PAUSEREQ_dly  :  std_ulogic;
	signal   CLIENTEMAC0PAUSEVAL_dly  :  std_logic_vector(15 downto 0);
	signal   CLIENTEMAC0RXCLIENTCLKIN_dly  :  std_ulogic;
	signal   CLIENTEMAC0TXCLIENTCLKIN_dly  :  std_ulogic;
	signal   CLIENTEMAC0TXD_dly  :  std_logic_vector(15 downto 0);
	signal   CLIENTEMAC0TXDVLD_dly  :  std_ulogic;
	signal   CLIENTEMAC0TXDVLDMSW_dly  :  std_ulogic;
	signal   CLIENTEMAC0TXFIRSTBYTE_dly  :  std_ulogic;
	signal   PHYEMAC0TXGMIIMIICLKIN_dly  :  std_ulogic;
	signal   CLIENTEMAC0TXIFGDELAY_dly  :  std_logic_vector(7 downto 0);
	signal   CLIENTEMAC0TXUNDERRUN_dly  :  std_ulogic;
	signal   CLIENTEMAC1DCMLOCKED_dly  :  std_ulogic;
	signal   CLIENTEMAC1PAUSEREQ_dly  :  std_ulogic;
	signal   CLIENTEMAC1PAUSEVAL_dly  :  std_logic_vector(15 downto 0);
	signal   CLIENTEMAC1RXCLIENTCLKIN_dly  :  std_ulogic;
	signal   CLIENTEMAC1TXCLIENTCLKIN_dly  :  std_ulogic;
	signal   CLIENTEMAC1TXD_dly  :  std_logic_vector(15 downto 0);
	signal   CLIENTEMAC1TXDVLD_dly  :  std_ulogic;
	signal   CLIENTEMAC1TXDVLDMSW_dly  :  std_ulogic;
	signal   CLIENTEMAC1TXFIRSTBYTE_dly  :  std_ulogic;
	signal   PHYEMAC1TXGMIIMIICLKIN_dly  :  std_ulogic;
	signal   CLIENTEMAC1TXIFGDELAY_dly  :  std_logic_vector(7 downto 0);
	signal   CLIENTEMAC1TXUNDERRUN_dly  :  std_ulogic;
	signal   DCREMACABUS_dly  :  std_logic_vector(0 to 9);
	signal   DCREMACCLK_dly  :  std_ulogic;
	signal   DCREMACDBUS_dly  :  std_logic_vector(0 to 31);
	signal   DCREMACENABLE_dly  :  std_ulogic;
	signal   DCREMACREAD_dly  :  std_ulogic;
	signal   DCREMACWRITE_dly  :  std_ulogic;
	signal   HOSTADDR_dly  :  std_logic_vector(9 downto 0);
	signal   HOSTCLK_dly  :  std_ulogic;
	signal   HOSTEMAC1SEL_dly  :  std_ulogic;
	signal   HOSTMIIMSEL_dly  :  std_ulogic;
	signal   HOSTOPCODE_dly  :  std_logic_vector(1 downto 0);
	signal   HOSTREQ_dly  :  std_ulogic;
	signal   HOSTWRDATA_dly  :  std_logic_vector(31 downto 0);
	signal   PHYEMAC0COL_dly  :  std_ulogic;
	signal   PHYEMAC0CRS_dly  :  std_ulogic;
	signal   PHYEMAC0GTXCLK_dly  :  std_ulogic;
	signal   PHYEMAC0MCLKIN_dly  :  std_ulogic;
	signal   PHYEMAC0MDIN_dly  :  std_ulogic;
	signal   PHYEMAC0MIITXCLK_dly  :  std_ulogic;
	signal   PHYEMAC0PHYAD_dly  :  std_logic_vector(4 downto 0);
	signal   PHYEMAC0RXBUFERR_dly  :  std_ulogic;
	signal   PHYEMAC0RXBUFSTATUS_dly  :  std_logic_vector(1 downto 0);
	signal   PHYEMAC0RXCHARISCOMMA_dly  :  std_ulogic;
	signal   PHYEMAC0RXCHARISK_dly  :  std_ulogic;
	signal   PHYEMAC0RXCHECKINGCRC_dly  :  std_ulogic;
	signal   PHYEMAC0RXCLK_dly  :  std_ulogic;
	signal   PHYEMAC0RXCLKCORCNT_dly  :  std_logic_vector(2 downto 0);
	signal   PHYEMAC0RXCOMMADET_dly  :  std_ulogic;
	signal   PHYEMAC0RXD_dly  :  std_logic_vector(7 downto 0);
	signal   PHYEMAC0RXDISPERR_dly  :  std_ulogic;
	signal   PHYEMAC0RXDV_dly  :  std_ulogic;
	signal   PHYEMAC0RXER_dly  :  std_ulogic;
	signal   PHYEMAC0RXLOSSOFSYNC_dly  :  std_logic_vector(1 downto 0);
	signal   PHYEMAC0RXNOTINTABLE_dly  :  std_ulogic;
	signal   PHYEMAC0RXRUNDISP_dly  :  std_ulogic;
	signal   PHYEMAC0SIGNALDET_dly  :  std_ulogic;
	signal   PHYEMAC0TXBUFERR_dly  :  std_ulogic;
	signal   PHYEMAC1COL_dly  :  std_ulogic;
	signal   PHYEMAC1CRS_dly  :  std_ulogic;
	signal   PHYEMAC1GTXCLK_dly  :  std_ulogic;
	signal   PHYEMAC1MCLKIN_dly  :  std_ulogic;
	signal   PHYEMAC1MDIN_dly  :  std_ulogic;
	signal   PHYEMAC1MIITXCLK_dly  :  std_ulogic;
	signal   PHYEMAC1PHYAD_dly  :  std_logic_vector(4 downto 0);
	signal   PHYEMAC1RXBUFERR_dly  :  std_ulogic;
	signal   PHYEMAC1RXBUFSTATUS_dly  :  std_logic_vector(1 downto 0);
	signal   PHYEMAC1RXCHARISCOMMA_dly  :  std_ulogic;
	signal   PHYEMAC1RXCHARISK_dly  :  std_ulogic;
	signal   PHYEMAC1RXCHECKINGCRC_dly  :  std_ulogic;
	signal   PHYEMAC1RXCLK_dly  :  std_ulogic;
	signal   PHYEMAC1RXCLKCORCNT_dly  :  std_logic_vector(2 downto 0);
	signal   PHYEMAC1RXCOMMADET_dly  :  std_ulogic;
	signal   PHYEMAC1RXD_dly  :  std_logic_vector(7 downto 0);
	signal   PHYEMAC1RXDISPERR_dly  :  std_ulogic;
	signal   PHYEMAC1RXDV_dly  :  std_ulogic;
	signal   PHYEMAC1RXER_dly  :  std_ulogic;
	signal   PHYEMAC1RXLOSSOFSYNC_dly  :  std_logic_vector(1 downto 0);
	signal   PHYEMAC1RXNOTINTABLE_dly  :  std_ulogic;
	signal   PHYEMAC1RXRUNDISP_dly  :  std_ulogic;
	signal   PHYEMAC1SIGNALDET_dly  :  std_ulogic;
	signal   PHYEMAC1TXBUFERR_dly  :  std_ulogic;
	signal   RESET_dly  :  std_ulogic;

        signal CLIENTEMAC0DCMLOCKED_CLIENTEMAC0TXCLIENTCLKIN_dly  :  std_ulogic;
        signal CLIENTEMAC0DCMLOCKED_PHYEMAC0TXGMIIMIICLKIN_dly  :  std_ulogic;
        signal CLIENTEMAC0PAUSEREQ_CLIENTEMAC0TXCLIENTCLKIN_dly : std_ulogic;
        signal CLIENTEMAC0PAUSEREQ_PHYEMAC0TXGMIIMIICLKIN_dly : std_ulogic;
	signal CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_dly : std_logic_vector(15 downto 0);
        signal CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_dly : std_logic_vector(15 downto 0);
	signal CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_dly : std_logic_vector(15 downto 0);
        signal CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_dly : std_logic_vector(15 downto 0);
	signal CLIENTEMAC0TXDVLD_CLIENTEMAC0TXCLIENTCLKIN_dly : std_ulogic;
        signal CLIENTEMAC0TXDVLD_PHYEMAC0TXGMIIMIICLKIN_dly : std_ulogic;
       	signal CLIENTEMAC0TXDVLDMSW_CLIENTEMAC0TXCLIENTCLKIN_dly : std_ulogic;
	signal CLIENTEMAC0TXDVLDMSW_PHYEMAC0TXGMIIMIICLKIN_dly : std_ulogic;
	signal CLIENTEMAC0TXFIRSTBYTE_CLIENTEMAC0TXCLIENTCLKIN_dly : std_ulogic;
        signal CLIENTEMAC0TXFIRSTBYTE_PHYEMAC0TXGMIIMIICLKIN_dly : std_ulogic;
	signal CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_dly : std_logic_vector(7 downto 0);
        signal CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_dly : std_logic_vector(7 downto 0);
        signal CLIENTEMAC0TXUNDERRUN_CLIENTEMAC0TXCLIENTCLKIN_dly : std_ulogic;
        signal CLIENTEMAC0TXUNDERRUN_PHYEMAC0TXGMIIMIICLKIN_dly : std_ulogic;
	signal CLIENTEMAC1DCMLOCKED_CLIENTEMAC1TXCLIENTCLKIN_dly : std_ulogic;
        signal CLIENTEMAC1DCMLOCKED_PHYEMAC1TXGMIIMIICLKIN_dly : std_ulogic;
        signal CLIENTEMAC1PAUSEREQ_CLIENTEMAC1TXCLIENTCLKIN_dly : std_ulogic;
        signal CLIENTEMAC1PAUSEREQ_PHYEMAC1TXGMIIMIICLKIN_dly : std_ulogic;
	signal CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_dly : std_logic_vector(15 downto 0);
        signal CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_dly : std_logic_vector(15 downto 0);
	signal CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_dly : std_logic_vector(15 downto 0);
        signal CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_dly : std_logic_vector(15 downto 0);
	signal CLIENTEMAC1TXDVLD_CLIENTEMAC1TXCLIENTCLKIN_dly : std_ulogic;
        signal CLIENTEMAC1TXDVLD_PHYEMAC1TXGMIIMIICLKIN_dly : std_ulogic;
	signal CLIENTEMAC1TXDVLDMSW_CLIENTEMAC1TXCLIENTCLKIN_dly : std_ulogic;
        signal CLIENTEMAC1TXDVLDMSW_PHYEMAC1TXGMIIMIICLKIN_dly : std_ulogic;
	signal CLIENTEMAC1TXFIRSTBYTE_CLIENTEMAC1TXCLIENTCLKIN_dly : std_ulogic;
        signal CLIENTEMAC1TXFIRSTBYTE_PHYEMAC1TXGMIIMIICLKIN_dly : std_ulogic;
	signal CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_dly : std_logic_vector(7 downto 0);
        signal CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_dly : std_logic_vector(7 downto 0);
	signal CLIENTEMAC1TXUNDERRUN_CLIENTEMAC1TXCLIENTCLKIN_dly : std_ulogic;
        signal CLIENTEMAC1TXUNDERRUN_PHYEMAC1TXGMIIMIICLKIN_dly : std_ulogic;
	signal DCREMACABUS_DCREMACCLK_dly : std_logic_vector(0 to 9);
	signal DCREMACDBUS_DCREMACCLK_dly : std_logic_vector(0 to 31);
	signal DCREMACENABLE_DCREMACCLK_dly : std_ulogic;
	signal DCREMACREAD_DCREMACCLK_dly : std_ulogic;
	signal DCREMACWRITE_DCREMACCLK_dly : std_ulogic;
	signal HOSTADDR_HOSTCLK_dly : std_logic_vector(9 downto 0);
	signal HOSTEMAC1SEL_HOSTCLK_dly : std_ulogic;
	signal HOSTMIIMSEL_HOSTCLK_dly : std_ulogic;
	signal HOSTOPCODE_HOSTCLK_dly : std_logic_vector(1 downto 0);
	signal HOSTREQ_HOSTCLK_dly : std_ulogic;
	signal HOSTWRDATA_HOSTCLK_dly : std_logic_vector(31 downto 0);
	signal PHYEMAC0COL_PHYEMAC0GTXCLK_dly : std_ulogic;
        signal PHYEMAC0COL_PHYEMAC0RXCLK_dly : std_ulogic;
	signal PHYEMAC0CRS_PHYEMAC0GTXCLK_dly : std_ulogic;
        signal PHYEMAC0CRS_PHYEMAC0RXCLK_dly : std_ulogic;
	signal PHYEMAC0MDIN_HOSTCLK_dly : std_ulogic;
        signal PHYEMAC0MDIN_PHYEMAC0MCLKIN_dly : std_ulogic;
        signal PHYEMAC0PHYAD_HOSTCLK_dly : std_logic_vector(4 downto 0);
	signal PHYEMAC0RXBUFERR_PHYEMAC0GTXCLK_dly : std_ulogic;
        signal PHYEMAC0RXBUFERR_PHYEMAC0RXCLK_dly : std_ulogic;
	signal PHYEMAC0RXBUFSTATUS_PHYEMAC0GTXCLK_dly : std_logic_vector(1 downto 0);
        signal PHYEMAC0RXBUFSTATUS_PHYEMAC0RXCLK_dly : std_logic_vector(1 downto 0);
	signal PHYEMAC0RXCHARISCOMMA_PHYEMAC0GTXCLK_dly : std_ulogic;
        signal PHYEMAC0RXCHARISCOMMA_PHYEMAC0RXCLK_dly : std_ulogic;
	signal PHYEMAC0RXCHARISK_PHYEMAC0GTXCLK_dly : std_ulogic;
        signal PHYEMAC0RXCHARISK_PHYEMAC0RXCLK_dly : std_ulogic;
	signal PHYEMAC0RXCHECKINGCRC_PHYEMAC0GTXCLK_dly : std_ulogic;
        signal PHYEMAC0RXCHECKINGCRC_PHYEMAC0RXCLK_dly : std_ulogic;
	signal PHYEMAC0RXCLKCORCNT_PHYEMAC0GTXCLK_dly : std_logic_vector(2 downto 0);
        signal PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK_dly : std_logic_vector(2 downto 0);
	signal PHYEMAC0RXCOMMADET_PHYEMAC0GTXCLK_dly : std_ulogic;
        signal PHYEMAC0RXCOMMADET_PHYEMAC0RXCLK_dly : std_ulogic;
	signal PHYEMAC0RXD_PHYEMAC0GTXCLK_dly : std_logic_vector(7 downto 0);
        signal PHYEMAC0RXD_PHYEMAC0RXCLK_dly : std_logic_vector(7 downto 0);
	signal PHYEMAC0RXDISPERR_PHYEMAC0GTXCLK_dly : std_ulogic;
        signal PHYEMAC0RXDISPERR_PHYEMAC0RXCLK_dly : std_ulogic;
        signal PHYEMAC0RXDV_PHYEMAC0GTXCLK_dly : std_ulogic;
	signal PHYEMAC0RXDV_PHYEMAC0RXCLK_dly : std_ulogic;
	signal PHYEMAC0RXER_PHYEMAC0GTXCLK_dly : std_ulogic;
        signal PHYEMAC0RXER_PHYEMAC0RXCLK_dly : std_ulogic;
	signal PHYEMAC0RXLOSSOFSYNC_PHYEMAC0GTXCLK_dly : std_logic_vector(1 downto 0);
        signal PHYEMAC0RXLOSSOFSYNC_PHYEMAC0RXCLK_dly : std_logic_vector(1 downto 0);
	signal PHYEMAC0RXNOTINTABLE_PHYEMAC0GTXCLK_dly : std_ulogic;
       	signal PHYEMAC0RXNOTINTABLE_PHYEMAC0RXCLK_dly : std_ulogic;
	signal PHYEMAC0RXRUNDISP_PHYEMAC0GTXCLK_dly : std_ulogic;
        signal PHYEMAC0RXRUNDISP_PHYEMAC0RXCLK_dly : std_ulogic;
	signal PHYEMAC0SIGNALDET_PHYEMAC0GTXCLK_dly : std_ulogic;
        signal PHYEMAC0SIGNALDET_PHYEMAC0RXCLK_dly : std_ulogic;
	signal PHYEMAC0TXBUFERR_PHYEMAC0GTXCLK_dly : std_ulogic;
        signal PHYEMAC0TXBUFERR_PHYEMAC0TXGMIIMIICLKIN_dly : std_ulogic;
	signal PHYEMAC1COL_PHYEMAC1GTXCLK_dly : std_ulogic;
       	signal PHYEMAC1COL_PHYEMAC1RXCLK_dly : std_ulogic;
	signal PHYEMAC1CRS_PHYEMAC1GTXCLK_dly : std_ulogic;
        signal PHYEMAC1CRS_PHYEMAC1RXCLK_dly : std_ulogic;
	signal PHYEMAC1MDIN_HOSTCLK_dly : std_ulogic;
        signal PHYEMAC1MDIN_PHYEMAC1MCLKIN_dly : std_ulogic;
        signal PHYEMAC1PHYAD_HOSTCLK_dly : std_logic_vector(4 downto 0);
	signal PHYEMAC1RXBUFERR_PHYEMAC1GTXCLK_dly : std_ulogic;
        signal PHYEMAC1RXBUFERR_PHYEMAC1RXCLK_dly : std_ulogic;
	signal PHYEMAC1RXBUFSTATUS_PHYEMAC1GTXCLK_dly : std_logic_vector(1 downto 0);
        signal PHYEMAC1RXBUFSTATUS_PHYEMAC1RXCLK_dly : std_logic_vector(1 downto 0);
	signal PHYEMAC1RXCHARISCOMMA_PHYEMAC1GTXCLK_dly : std_ulogic;
       	signal PHYEMAC1RXCHARISCOMMA_PHYEMAC1RXCLK_dly : std_ulogic;
	signal PHYEMAC1RXCHARISK_PHYEMAC1GTXCLK_dly : std_ulogic;
        signal PHYEMAC1RXCHARISK_PHYEMAC1RXCLK_dly : std_ulogic;
	signal PHYEMAC1RXCHECKINGCRC_PHYEMAC1GTXCLK_dly : std_ulogic;
        signal PHYEMAC1RXCHECKINGCRC_PHYEMAC1RXCLK_dly : std_ulogic;
	signal PHYEMAC1RXCLKCORCNT_PHYEMAC1GTXCLK_dly : std_logic_vector(2 downto 0);
        signal PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK_dly : std_logic_vector(2 downto 0);
	signal PHYEMAC1RXCOMMADET_PHYEMAC1GTXCLK_dly : std_ulogic;
        signal PHYEMAC1RXCOMMADET_PHYEMAC1RXCLK_dly : std_ulogic;
	signal PHYEMAC1RXD_PHYEMAC1GTXCLK_dly : std_logic_vector(7 downto 0);
        signal PHYEMAC1RXD_PHYEMAC1RXCLK_dly : std_logic_vector(7 downto 0);
	signal PHYEMAC1RXDISPERR_PHYEMAC1GTXCLK_dly : std_ulogic;
        signal PHYEMAC1RXDISPERR_PHYEMAC1RXCLK_dly : std_ulogic;
	signal PHYEMAC1RXDV_PHYEMAC1GTXCLK_dly : std_ulogic;
        signal PHYEMAC1RXDV_PHYEMAC1RXCLK_dly : std_ulogic;
	signal PHYEMAC1RXER_PHYEMAC1GTXCLK_dly : std_ulogic;
        signal PHYEMAC1RXER_PHYEMAC1RXCLK_dly : std_ulogic;
	signal PHYEMAC1RXLOSSOFSYNC_PHYEMAC1GTXCLK_dly : std_logic_vector(1 downto 0);
        signal PHYEMAC1RXLOSSOFSYNC_PHYEMAC1RXCLK_dly : std_logic_vector(1 downto 0);
        signal PHYEMAC1RXNOTINTABLE_PHYEMAC1GTXCLK_dly : std_ulogic;
        signal PHYEMAC1RXNOTINTABLE_PHYEMAC1RXCLK_dly : std_ulogic;
	signal PHYEMAC1RXRUNDISP_PHYEMAC1GTXCLK_dly : std_ulogic;
        signal PHYEMAC1RXRUNDISP_PHYEMAC1RXCLK_dly : std_ulogic;
	signal PHYEMAC1SIGNALDET_PHYEMAC1GTXCLK_dly : std_ulogic;
        signal PHYEMAC1SIGNALDET_PHYEMAC1RXCLK_dly : std_ulogic;
	signal PHYEMAC1TXBUFERR_PHYEMAC1GTXCLK_dly : std_ulogic;
       	signal PHYEMAC1TXBUFERR_PHYEMAC1TXGMIIMIICLKIN_dly : std_ulogic;

        signal RESET_HOSTCLK_dly : std_ulogic;
        signal RESET_CLIENTEMAC0TXCLIENTCLKIN_dly : std_ulogic;
        signal RESET_CLIENTEMAC1TXCLIENTCLKIN_dly : std_ulogic;
        signal RESET_PHYEMAC0TXGMIIMIICLKIN_dly : std_ulogic;
        signal RESET_PHYEMAC1TXGMIIMIICLKIN_dly : std_ulogic;
        signal RESET_PHYEMAC0GTXCLK_dly : std_ulogic;
        signal RESET_PHYEMAC1GTXCLK_dly  : std_ulogic;

	signal   CLIENTEMAC0DCMLOCKED_indelay  :  std_ulogic;
	signal   CLIENTEMAC0PAUSEREQ_indelay  :  std_ulogic;
	signal   CLIENTEMAC0PAUSEVAL_indelay  :  std_logic_vector(15 downto 0);
	signal   CLIENTEMAC0RXCLIENTCLKIN_indelay  :  std_ulogic;
	signal   CLIENTEMAC0TXCLIENTCLKIN_indelay  :  std_ulogic;
	signal   CLIENTEMAC0TXD_indelay  :  std_logic_vector(15 downto 0);
	signal   CLIENTEMAC0TXDVLD_indelay  :  std_ulogic;
	signal   CLIENTEMAC0TXDVLDMSW_indelay  :  std_ulogic;
	signal   CLIENTEMAC0TXFIRSTBYTE_indelay  :  std_ulogic;
	signal   PHYEMAC0TXGMIIMIICLKIN_indelay  :  std_ulogic;
	signal   CLIENTEMAC0TXIFGDELAY_indelay  :  std_logic_vector(7 downto 0);
	signal   CLIENTEMAC0TXUNDERRUN_indelay  :  std_ulogic;
	signal   CLIENTEMAC1DCMLOCKED_indelay  :  std_ulogic;
	signal   CLIENTEMAC1PAUSEREQ_indelay  :  std_ulogic;
	signal   CLIENTEMAC1PAUSEVAL_indelay  :  std_logic_vector(15 downto 0);
	signal   CLIENTEMAC1RXCLIENTCLKIN_indelay  :  std_ulogic;
	signal   CLIENTEMAC1TXCLIENTCLKIN_indelay  :  std_ulogic;
	signal   CLIENTEMAC1TXD_indelay  :  std_logic_vector(15 downto 0);
	signal   CLIENTEMAC1TXDVLD_indelay  :  std_ulogic;
	signal   CLIENTEMAC1TXDVLDMSW_indelay  :  std_ulogic;
	signal   CLIENTEMAC1TXFIRSTBYTE_indelay  :  std_ulogic;
	signal   PHYEMAC1TXGMIIMIICLKIN_indelay  :  std_ulogic;
	signal   CLIENTEMAC1TXIFGDELAY_indelay  :  std_logic_vector(7 downto 0);
	signal   CLIENTEMAC1TXUNDERRUN_indelay  :  std_ulogic;
	signal   DCREMACABUS_indelay  :  std_logic_vector(0 to 9);
	signal   DCREMACCLK_indelay  :  std_ulogic;
	signal   DCREMACDBUS_indelay  :  std_logic_vector(0 to 31);
	signal   DCREMACENABLE_indelay  :  std_ulogic;
	signal   DCREMACREAD_indelay  :  std_ulogic;
	signal   DCREMACWRITE_indelay  :  std_ulogic;
	signal   HOSTADDR_indelay  :  std_logic_vector(9 downto 0);
	signal   HOSTCLK_indelay  :  std_ulogic;
	signal   HOSTEMAC1SEL_indelay  :  std_ulogic;
	signal   HOSTMIIMSEL_indelay  :  std_ulogic;
	signal   HOSTOPCODE_indelay  :  std_logic_vector(1 downto 0);
	signal   HOSTREQ_indelay  :  std_ulogic;
	signal   HOSTWRDATA_indelay  :  std_logic_vector(31 downto 0);
	signal   PHYEMAC0COL_indelay  :  std_ulogic;
	signal   PHYEMAC0CRS_indelay  :  std_ulogic;
	signal   PHYEMAC0GTXCLK_indelay  :  std_ulogic;
	signal   PHYEMAC0MCLKIN_indelay  :  std_ulogic;
	signal   PHYEMAC0MDIN_indelay  :  std_ulogic;
	signal   PHYEMAC0MIITXCLK_indelay  :  std_ulogic;
	signal   PHYEMAC0PHYAD_indelay  :  std_logic_vector(4 downto 0);
	signal   PHYEMAC0RXBUFERR_indelay  :  std_ulogic;
	signal   PHYEMAC0RXBUFSTATUS_indelay  :  std_logic_vector(1 downto 0);
	signal   PHYEMAC0RXCHARISCOMMA_indelay  :  std_ulogic;
	signal   PHYEMAC0RXCHARISK_indelay  :  std_ulogic;
	signal   PHYEMAC0RXCHECKINGCRC_indelay  :  std_ulogic;
	signal   PHYEMAC0RXCLK_indelay  :  std_ulogic;
	signal   PHYEMAC0RXCLKCORCNT_indelay  :  std_logic_vector(2 downto 0);
	signal   PHYEMAC0RXCOMMADET_indelay  :  std_ulogic;
	signal   PHYEMAC0RXD_indelay  :  std_logic_vector(7 downto 0);
	signal   PHYEMAC0RXDISPERR_indelay  :  std_ulogic;
	signal   PHYEMAC0RXDV_indelay  :  std_ulogic;
	signal   PHYEMAC0RXER_indelay  :  std_ulogic;
	signal   PHYEMAC0RXLOSSOFSYNC_indelay  :  std_logic_vector(1 downto 0);
	signal   PHYEMAC0RXNOTINTABLE_indelay  :  std_ulogic;
	signal   PHYEMAC0RXRUNDISP_indelay  :  std_ulogic;
	signal   PHYEMAC0SIGNALDET_indelay  :  std_ulogic;
	signal   PHYEMAC0TXBUFERR_indelay  :  std_ulogic;
	signal   PHYEMAC1COL_indelay  :  std_ulogic;
	signal   PHYEMAC1CRS_indelay  :  std_ulogic;
	signal   PHYEMAC1GTXCLK_indelay  :  std_ulogic;
	signal   PHYEMAC1MCLKIN_indelay  :  std_ulogic;
	signal   PHYEMAC1MDIN_indelay  :  std_ulogic;
	signal   PHYEMAC1MIITXCLK_indelay  :  std_ulogic;
	signal   PHYEMAC1PHYAD_indelay  :  std_logic_vector(4 downto 0);
	signal   PHYEMAC1RXBUFERR_indelay  :  std_ulogic;
	signal   PHYEMAC1RXBUFSTATUS_indelay  :  std_logic_vector(1 downto 0);
	signal   PHYEMAC1RXCHARISCOMMA_indelay  :  std_ulogic;
	signal   PHYEMAC1RXCHARISK_indelay  :  std_ulogic;
	signal   PHYEMAC1RXCHECKINGCRC_indelay  :  std_ulogic;
	signal   PHYEMAC1RXCLK_indelay  :  std_ulogic;
	signal   PHYEMAC1RXCLKCORCNT_indelay  :  std_logic_vector(2 downto 0);
	signal   PHYEMAC1RXCOMMADET_indelay  :  std_ulogic;
	signal   PHYEMAC1RXD_indelay  :  std_logic_vector(7 downto 0);
	signal   PHYEMAC1RXDISPERR_indelay  :  std_ulogic;
	signal   PHYEMAC1RXDV_indelay  :  std_ulogic;
	signal   PHYEMAC1RXER_indelay  :  std_ulogic;
	signal   PHYEMAC1RXLOSSOFSYNC_indelay  :  std_logic_vector(1 downto 0);
	signal   PHYEMAC1RXNOTINTABLE_indelay  :  std_ulogic;
	signal   PHYEMAC1RXRUNDISP_indelay  :  std_ulogic;
	signal   PHYEMAC1SIGNALDET_indelay  :  std_ulogic;
	signal   PHYEMAC1TXBUFERR_indelay  :  std_ulogic;
	signal   RESET_indelay  :  std_ulogic;

        signal   CLIENTEMAC0DCMLOCKED_indly  :  std_ulogic;
	signal   CLIENTEMAC0PAUSEREQ_indly  :  std_ulogic;
	signal   CLIENTEMAC0PAUSEVAL_indly  :  std_logic_vector(15 downto 0);
	signal   CLIENTEMAC0RXCLIENTCLKIN_indly  :  std_ulogic;
	signal   CLIENTEMAC0TXCLIENTCLKIN_indly  :  std_ulogic;
	signal   CLIENTEMAC0TXD_indly  :  std_logic_vector(15 downto 0);
	signal   CLIENTEMAC0TXDVLD_indly  :  std_ulogic;
	signal   CLIENTEMAC0TXDVLDMSW_indly  :  std_ulogic;
	signal   CLIENTEMAC0TXFIRSTBYTE_indly  :  std_ulogic;
	signal   PHYEMAC0TXGMIIMIICLKIN_indly  :  std_ulogic;
	signal   CLIENTEMAC0TXIFGDELAY_indly  :  std_logic_vector(7 downto 0);
	signal   CLIENTEMAC0TXUNDERRUN_indly  :  std_ulogic;
	signal   CLIENTEMAC1DCMLOCKED_indly  :  std_ulogic;
	signal   CLIENTEMAC1PAUSEREQ_indly  :  std_ulogic;
	signal   CLIENTEMAC1PAUSEVAL_indly  :  std_logic_vector(15 downto 0);
	signal   CLIENTEMAC1RXCLIENTCLKIN_indly  :  std_ulogic;
	signal   CLIENTEMAC1TXCLIENTCLKIN_indly  :  std_ulogic;
	signal   CLIENTEMAC1TXD_indly  :  std_logic_vector(15 downto 0);
	signal   CLIENTEMAC1TXDVLD_indly  :  std_ulogic;
	signal   CLIENTEMAC1TXDVLDMSW_indly  :  std_ulogic;
	signal   CLIENTEMAC1TXFIRSTBYTE_indly  :  std_ulogic;
	signal   PHYEMAC1TXGMIIMIICLKIN_indly  :  std_ulogic;
	signal   CLIENTEMAC1TXIFGDELAY_indly  :  std_logic_vector(7 downto 0);
	signal   CLIENTEMAC1TXUNDERRUN_indly  :  std_ulogic;
	signal   DCREMACABUS_indly  :  std_logic_vector(0 to 9);
	signal   DCREMACCLK_indly  :  std_ulogic;
	signal   DCREMACDBUS_indly  :  std_logic_vector(0 to 31);
	signal   DCREMACENABLE_indly  :  std_ulogic;
	signal   DCREMACREAD_indly  :  std_ulogic;
	signal   DCREMACWRITE_indly  :  std_ulogic;
	signal   HOSTADDR_indly  :  std_logic_vector(9 downto 0);
	signal   HOSTCLK_indly  :  std_ulogic;
	signal   HOSTEMAC1SEL_indly  :  std_ulogic;
	signal   HOSTMIIMSEL_indly  :  std_ulogic;
	signal   HOSTOPCODE_indly  :  std_logic_vector(1 downto 0);
	signal   HOSTREQ_indly  :  std_ulogic;
	signal   HOSTWRDATA_indly  :  std_logic_vector(31 downto 0);
	signal   PHYEMAC0COL_indly  :  std_ulogic;
	signal   PHYEMAC0CRS_indly  :  std_ulogic;
	signal   PHYEMAC0GTXCLK_indly  :  std_ulogic;
	signal   PHYEMAC0MCLKIN_indly  :  std_ulogic;
	signal   PHYEMAC0MDIN_indly  :  std_ulogic;
	signal   PHYEMAC0MIITXCLK_indly  :  std_ulogic;
	signal   PHYEMAC0PHYAD_indly  :  std_logic_vector(4 downto 0);
	signal   PHYEMAC0RXBUFERR_indly  :  std_ulogic;
	signal   PHYEMAC0RXBUFSTATUS_indly  :  std_logic_vector(1 downto 0);
	signal   PHYEMAC0RXCHARISCOMMA_indly  :  std_ulogic;
	signal   PHYEMAC0RXCHARISK_indly  :  std_ulogic;
	signal   PHYEMAC0RXCHECKINGCRC_indly  :  std_ulogic;
	signal   PHYEMAC0RXCLK_indly  :  std_ulogic;
	signal   PHYEMAC0RXCLKCORCNT_indly  :  std_logic_vector(2 downto 0);
	signal   PHYEMAC0RXCOMMADET_indly  :  std_ulogic;
	signal   PHYEMAC0RXD_indly  :  std_logic_vector(7 downto 0);
	signal   PHYEMAC0RXDISPERR_indly  :  std_ulogic;
	signal   PHYEMAC0RXDV_indly  :  std_ulogic;
	signal   PHYEMAC0RXER_indly  :  std_ulogic;
	signal   PHYEMAC0RXLOSSOFSYNC_indly  :  std_logic_vector(1 downto 0);
	signal   PHYEMAC0RXNOTINTABLE_indly  :  std_ulogic;
	signal   PHYEMAC0RXRUNDISP_indly  :  std_ulogic;
	signal   PHYEMAC0SIGNALDET_indly  :  std_ulogic;
	signal   PHYEMAC0TXBUFERR_indly  :  std_ulogic;
	signal   PHYEMAC1COL_indly  :  std_ulogic;
	signal   PHYEMAC1CRS_indly  :  std_ulogic;
	signal   PHYEMAC1GTXCLK_indly  :  std_ulogic;
	signal   PHYEMAC1MCLKIN_indly  :  std_ulogic;
	signal   PHYEMAC1MDIN_indly  :  std_ulogic;
	signal   PHYEMAC1MIITXCLK_indly  :  std_ulogic;
	signal   PHYEMAC1PHYAD_indly  :  std_logic_vector(4 downto 0);
	signal   PHYEMAC1RXBUFERR_indly  :  std_ulogic;
	signal   PHYEMAC1RXBUFSTATUS_indly  :  std_logic_vector(1 downto 0);
	signal   PHYEMAC1RXCHARISCOMMA_indly  :  std_ulogic;
	signal   PHYEMAC1RXCHARISK_indly  :  std_ulogic;
	signal   PHYEMAC1RXCHECKINGCRC_indly  :  std_ulogic;
	signal   PHYEMAC1RXCLK_indly  :  std_ulogic;
	signal   PHYEMAC1RXCLKCORCNT_indly  :  std_logic_vector(2 downto 0);
	signal   PHYEMAC1RXCOMMADET_indly  :  std_ulogic;
	signal   PHYEMAC1RXD_indly  :  std_logic_vector(7 downto 0);
	signal   PHYEMAC1RXDISPERR_indly  :  std_ulogic;
	signal   PHYEMAC1RXDV_indly  :  std_ulogic;
	signal   PHYEMAC1RXER_indly  :  std_ulogic;
	signal   PHYEMAC1RXLOSSOFSYNC_indly  :  std_logic_vector(1 downto 0);
	signal   PHYEMAC1RXNOTINTABLE_indly  :  std_ulogic;
	signal   PHYEMAC1RXRUNDISP_indly  :  std_ulogic;
	signal   PHYEMAC1SIGNALDET_indly  :  std_ulogic;
	signal   PHYEMAC1TXBUFERR_indly  :  std_ulogic;
	signal   RESET_indly  :  std_ulogic;

begin
	WireDelay : block
	begin
              VitalWireDelay (CLIENTEMAC0DCMLOCKED_ipd,CLIENTEMAC0DCMLOCKED,tipd_CLIENTEMAC0DCMLOCKED);
              VitalWireDelay (CLIENTEMAC0PAUSEREQ_ipd,CLIENTEMAC0PAUSEREQ,tipd_CLIENTEMAC0PAUSEREQ);
           CLIENTEMAC0PAUSEVAL_DELAY : for i in 15 downto 0 generate
              VitalWireDelay (CLIENTEMAC0PAUSEVAL_ipd(i),CLIENTEMAC0PAUSEVAL(i),tipd_CLIENTEMAC0PAUSEVAL(i));
           end generate CLIENTEMAC0PAUSEVAL_DELAY;
              VitalWireDelay (CLIENTEMAC0RXCLIENTCLKIN_ipd,CLIENTEMAC0RXCLIENTCLKIN,tipd_CLIENTEMAC0RXCLIENTCLKIN);
              VitalWireDelay (CLIENTEMAC0TXCLIENTCLKIN_ipd,CLIENTEMAC0TXCLIENTCLKIN,tipd_CLIENTEMAC0TXCLIENTCLKIN);
           CLIENTEMAC0TXD_DELAY : for i in 15 downto 0 generate
              VitalWireDelay (CLIENTEMAC0TXD_ipd(i),CLIENTEMAC0TXD(i),tipd_CLIENTEMAC0TXD(i));
           end generate CLIENTEMAC0TXD_DELAY;
              VitalWireDelay (CLIENTEMAC0TXDVLD_ipd,CLIENTEMAC0TXDVLD,tipd_CLIENTEMAC0TXDVLD);
              VitalWireDelay (CLIENTEMAC0TXDVLDMSW_ipd,CLIENTEMAC0TXDVLDMSW,tipd_CLIENTEMAC0TXDVLDMSW);
              VitalWireDelay (CLIENTEMAC0TXFIRSTBYTE_ipd,CLIENTEMAC0TXFIRSTBYTE,tipd_CLIENTEMAC0TXFIRSTBYTE);
              VitalWireDelay (PHYEMAC0TXGMIIMIICLKIN_ipd,PHYEMAC0TXGMIIMIICLKIN,tipd_PHYEMAC0TXGMIIMIICLKIN);
           CLIENTEMAC0TXIFGDELAY_DELAY : for i in 7 downto 0 generate
              VitalWireDelay (CLIENTEMAC0TXIFGDELAY_ipd(i),CLIENTEMAC0TXIFGDELAY(i),tipd_CLIENTEMAC0TXIFGDELAY(i));
           end generate CLIENTEMAC0TXIFGDELAY_DELAY;
              VitalWireDelay (CLIENTEMAC0TXUNDERRUN_ipd,CLIENTEMAC0TXUNDERRUN,tipd_CLIENTEMAC0TXUNDERRUN);
              VitalWireDelay (CLIENTEMAC1DCMLOCKED_ipd,CLIENTEMAC1DCMLOCKED,tipd_CLIENTEMAC1DCMLOCKED);
              VitalWireDelay (CLIENTEMAC1PAUSEREQ_ipd,CLIENTEMAC1PAUSEREQ,tipd_CLIENTEMAC1PAUSEREQ);
           CLIENTEMAC1PAUSEVAL_DELAY : for i in 15 downto 0 generate
              VitalWireDelay (CLIENTEMAC1PAUSEVAL_ipd(i),CLIENTEMAC1PAUSEVAL(i),tipd_CLIENTEMAC1PAUSEVAL(i));
           end generate CLIENTEMAC1PAUSEVAL_DELAY;
              VitalWireDelay (CLIENTEMAC1RXCLIENTCLKIN_ipd,CLIENTEMAC1RXCLIENTCLKIN,tipd_CLIENTEMAC1RXCLIENTCLKIN);
              VitalWireDelay (CLIENTEMAC1TXCLIENTCLKIN_ipd,CLIENTEMAC1TXCLIENTCLKIN,tipd_CLIENTEMAC1TXCLIENTCLKIN);
           CLIENTEMAC1TXD_DELAY : for i in 15 downto 0 generate
              VitalWireDelay (CLIENTEMAC1TXD_ipd(i),CLIENTEMAC1TXD(i),tipd_CLIENTEMAC1TXD(i));
           end generate CLIENTEMAC1TXD_DELAY;
              VitalWireDelay (CLIENTEMAC1TXDVLD_ipd,CLIENTEMAC1TXDVLD,tipd_CLIENTEMAC1TXDVLD);
              VitalWireDelay (CLIENTEMAC1TXDVLDMSW_ipd,CLIENTEMAC1TXDVLDMSW,tipd_CLIENTEMAC1TXDVLDMSW);
              VitalWireDelay (CLIENTEMAC1TXFIRSTBYTE_ipd,CLIENTEMAC1TXFIRSTBYTE,tipd_CLIENTEMAC1TXFIRSTBYTE);
              VitalWireDelay (PHYEMAC1TXGMIIMIICLKIN_ipd,PHYEMAC1TXGMIIMIICLKIN,tipd_PHYEMAC1TXGMIIMIICLKIN);
           CLIENTEMAC1TXIFGDELAY_DELAY : for i in 7 downto 0 generate
              VitalWireDelay (CLIENTEMAC1TXIFGDELAY_ipd(i),CLIENTEMAC1TXIFGDELAY(i),tipd_CLIENTEMAC1TXIFGDELAY(i));
           end generate CLIENTEMAC1TXIFGDELAY_DELAY;
              VitalWireDelay (CLIENTEMAC1TXUNDERRUN_ipd,CLIENTEMAC1TXUNDERRUN,tipd_CLIENTEMAC1TXUNDERRUN);
           DCREMACABUS_DELAY : for i in 0 to 9 generate
              VitalWireDelay (DCREMACABUS_ipd(i),DCREMACABUS(i),tipd_DCREMACABUS(i));
           end generate DCREMACABUS_DELAY;
              VitalWireDelay (DCREMACCLK_ipd,DCREMACCLK,tipd_DCREMACCLK);
           DCREMACDBUS_DELAY : for i in 0 to 31 generate
              VitalWireDelay (DCREMACDBUS_ipd(i),DCREMACDBUS(i),tipd_DCREMACDBUS(i));
           end generate DCREMACDBUS_DELAY;
              VitalWireDelay (DCREMACENABLE_ipd,DCREMACENABLE,tipd_DCREMACENABLE);
              VitalWireDelay (DCREMACREAD_ipd,DCREMACREAD,tipd_DCREMACREAD);
              VitalWireDelay (DCREMACWRITE_ipd,DCREMACWRITE,tipd_DCREMACWRITE);
           HOSTADDR_DELAY : for i in 9 downto 0 generate
              VitalWireDelay (HOSTADDR_ipd(i),HOSTADDR(i),tipd_HOSTADDR(i));
           end generate HOSTADDR_DELAY;
              VitalWireDelay (HOSTCLK_ipd,HOSTCLK,tipd_HOSTCLK);
              VitalWireDelay (HOSTEMAC1SEL_ipd,HOSTEMAC1SEL,tipd_HOSTEMAC1SEL);
              VitalWireDelay (HOSTMIIMSEL_ipd,HOSTMIIMSEL,tipd_HOSTMIIMSEL);
           HOSTOPCODE_DELAY : for i in 1 downto 0 generate
              VitalWireDelay (HOSTOPCODE_ipd(i),HOSTOPCODE(i),tipd_HOSTOPCODE(i));
           end generate HOSTOPCODE_DELAY;
              VitalWireDelay (HOSTREQ_ipd,HOSTREQ,tipd_HOSTREQ);
           HOSTWRDATA_DELAY : for i in 31 downto 0 generate
              VitalWireDelay (HOSTWRDATA_ipd(i),HOSTWRDATA(i),tipd_HOSTWRDATA(i));
           end generate HOSTWRDATA_DELAY;
              VitalWireDelay (PHYEMAC0COL_ipd,PHYEMAC0COL,tipd_PHYEMAC0COL);
              VitalWireDelay (PHYEMAC0CRS_ipd,PHYEMAC0CRS,tipd_PHYEMAC0CRS);
              VitalWireDelay (PHYEMAC0GTXCLK_ipd,PHYEMAC0GTXCLK,tipd_PHYEMAC0GTXCLK);
              VitalWireDelay (PHYEMAC0MCLKIN_ipd,PHYEMAC0MCLKIN,tipd_PHYEMAC0MCLKIN);
              VitalWireDelay (PHYEMAC0MDIN_ipd,PHYEMAC0MDIN,tipd_PHYEMAC0MDIN);
              VitalWireDelay (PHYEMAC0MIITXCLK_ipd,PHYEMAC0MIITXCLK,tipd_PHYEMAC0MIITXCLK);
           PHYEMAC0PHYAD_DELAY : for i in 4 downto 0 generate
              VitalWireDelay (PHYEMAC0PHYAD_ipd(i),PHYEMAC0PHYAD(i),tipd_PHYEMAC0PHYAD(i));
           end generate PHYEMAC0PHYAD_DELAY;
              VitalWireDelay (PHYEMAC0RXBUFERR_ipd,PHYEMAC0RXBUFERR,tipd_PHYEMAC0RXBUFERR);
           PHYEMAC0RXBUFSTATUS_DELAY : for i in 1 downto 0 generate
              VitalWireDelay (PHYEMAC0RXBUFSTATUS_ipd(i),PHYEMAC0RXBUFSTATUS(i),tipd_PHYEMAC0RXBUFSTATUS(i));
           end generate PHYEMAC0RXBUFSTATUS_DELAY;
              VitalWireDelay (PHYEMAC0RXCHARISCOMMA_ipd,PHYEMAC0RXCHARISCOMMA,tipd_PHYEMAC0RXCHARISCOMMA);
              VitalWireDelay (PHYEMAC0RXCHARISK_ipd,PHYEMAC0RXCHARISK,tipd_PHYEMAC0RXCHARISK);
              VitalWireDelay (PHYEMAC0RXCHECKINGCRC_ipd,PHYEMAC0RXCHECKINGCRC,tipd_PHYEMAC0RXCHECKINGCRC);
              VitalWireDelay (PHYEMAC0RXCLK_ipd,PHYEMAC0RXCLK,tipd_PHYEMAC0RXCLK);
           PHYEMAC0RXCLKCORCNT_DELAY : for i in 2 downto 0 generate
              VitalWireDelay (PHYEMAC0RXCLKCORCNT_ipd(i),PHYEMAC0RXCLKCORCNT(i),tipd_PHYEMAC0RXCLKCORCNT(i));
           end generate PHYEMAC0RXCLKCORCNT_DELAY;
              VitalWireDelay (PHYEMAC0RXCOMMADET_ipd,PHYEMAC0RXCOMMADET,tipd_PHYEMAC0RXCOMMADET);
           PHYEMAC0RXD_DELAY : for i in 7 downto 0 generate
              VitalWireDelay (PHYEMAC0RXD_ipd(i),PHYEMAC0RXD(i),tipd_PHYEMAC0RXD(i));
           end generate PHYEMAC0RXD_DELAY;
              VitalWireDelay (PHYEMAC0RXDISPERR_ipd,PHYEMAC0RXDISPERR,tipd_PHYEMAC0RXDISPERR);
              VitalWireDelay (PHYEMAC0RXDV_ipd,PHYEMAC0RXDV,tipd_PHYEMAC0RXDV);
              VitalWireDelay (PHYEMAC0RXER_ipd,PHYEMAC0RXER,tipd_PHYEMAC0RXER);
           PHYEMAC0RXLOSSOFSYNC_DELAY : for i in 1 downto 0 generate
              VitalWireDelay (PHYEMAC0RXLOSSOFSYNC_ipd(i),PHYEMAC0RXLOSSOFSYNC(i),tipd_PHYEMAC0RXLOSSOFSYNC(i));
           end generate PHYEMAC0RXLOSSOFSYNC_DELAY;
              VitalWireDelay (PHYEMAC0RXNOTINTABLE_ipd,PHYEMAC0RXNOTINTABLE,tipd_PHYEMAC0RXNOTINTABLE);
              VitalWireDelay (PHYEMAC0RXRUNDISP_ipd,PHYEMAC0RXRUNDISP,tipd_PHYEMAC0RXRUNDISP);
              VitalWireDelay (PHYEMAC0SIGNALDET_ipd,PHYEMAC0SIGNALDET,tipd_PHYEMAC0SIGNALDET);
              VitalWireDelay (PHYEMAC0TXBUFERR_ipd,PHYEMAC0TXBUFERR,tipd_PHYEMAC0TXBUFERR);
              VitalWireDelay (PHYEMAC1COL_ipd,PHYEMAC1COL,tipd_PHYEMAC1COL);
              VitalWireDelay (PHYEMAC1CRS_ipd,PHYEMAC1CRS,tipd_PHYEMAC1CRS);
              VitalWireDelay (PHYEMAC1GTXCLK_ipd,PHYEMAC1GTXCLK,tipd_PHYEMAC1GTXCLK);
              VitalWireDelay (PHYEMAC1MCLKIN_ipd,PHYEMAC1MCLKIN,tipd_PHYEMAC1MCLKIN);
              VitalWireDelay (PHYEMAC1MDIN_ipd,PHYEMAC1MDIN,tipd_PHYEMAC1MDIN);
              VitalWireDelay (PHYEMAC1MIITXCLK_ipd,PHYEMAC1MIITXCLK,tipd_PHYEMAC1MIITXCLK);
           PHYEMAC1PHYAD_DELAY : for i in 4 downto 0 generate
              VitalWireDelay (PHYEMAC1PHYAD_ipd(i),PHYEMAC1PHYAD(i),tipd_PHYEMAC1PHYAD(i));
           end generate PHYEMAC1PHYAD_DELAY;
              VitalWireDelay (PHYEMAC1RXBUFERR_ipd,PHYEMAC1RXBUFERR,tipd_PHYEMAC1RXBUFERR);
           PHYEMAC1RXBUFSTATUS_DELAY : for i in 1 downto 0 generate
              VitalWireDelay (PHYEMAC1RXBUFSTATUS_ipd(i),PHYEMAC1RXBUFSTATUS(i),tipd_PHYEMAC1RXBUFSTATUS(i));
           end generate PHYEMAC1RXBUFSTATUS_DELAY;
              VitalWireDelay (PHYEMAC1RXCHARISCOMMA_ipd,PHYEMAC1RXCHARISCOMMA,tipd_PHYEMAC1RXCHARISCOMMA);
              VitalWireDelay (PHYEMAC1RXCHARISK_ipd,PHYEMAC1RXCHARISK,tipd_PHYEMAC1RXCHARISK);
              VitalWireDelay (PHYEMAC1RXCHECKINGCRC_ipd,PHYEMAC1RXCHECKINGCRC,tipd_PHYEMAC1RXCHECKINGCRC);
              VitalWireDelay (PHYEMAC1RXCLK_ipd,PHYEMAC1RXCLK,tipd_PHYEMAC1RXCLK);
           PHYEMAC1RXCLKCORCNT_DELAY : for i in 2 downto 0 generate
              VitalWireDelay (PHYEMAC1RXCLKCORCNT_ipd(i),PHYEMAC1RXCLKCORCNT(i),tipd_PHYEMAC1RXCLKCORCNT(i));
           end generate PHYEMAC1RXCLKCORCNT_DELAY;
              VitalWireDelay (PHYEMAC1RXCOMMADET_ipd,PHYEMAC1RXCOMMADET,tipd_PHYEMAC1RXCOMMADET);
           PHYEMAC1RXD_DELAY : for i in 7 downto 0 generate
              VitalWireDelay (PHYEMAC1RXD_ipd(i),PHYEMAC1RXD(i),tipd_PHYEMAC1RXD(i));
           end generate PHYEMAC1RXD_DELAY;
              VitalWireDelay (PHYEMAC1RXDISPERR_ipd,PHYEMAC1RXDISPERR,tipd_PHYEMAC1RXDISPERR);
              VitalWireDelay (PHYEMAC1RXDV_ipd,PHYEMAC1RXDV,tipd_PHYEMAC1RXDV);
              VitalWireDelay (PHYEMAC1RXER_ipd,PHYEMAC1RXER,tipd_PHYEMAC1RXER);
           PHYEMAC1RXLOSSOFSYNC_DELAY : for i in 1 downto 0 generate
              VitalWireDelay (PHYEMAC1RXLOSSOFSYNC_ipd(i),PHYEMAC1RXLOSSOFSYNC(i),tipd_PHYEMAC1RXLOSSOFSYNC(i));
           end generate PHYEMAC1RXLOSSOFSYNC_DELAY;
              VitalWireDelay (PHYEMAC1RXNOTINTABLE_ipd,PHYEMAC1RXNOTINTABLE,tipd_PHYEMAC1RXNOTINTABLE);
              VitalWireDelay (PHYEMAC1RXRUNDISP_ipd,PHYEMAC1RXRUNDISP,tipd_PHYEMAC1RXRUNDISP);
              VitalWireDelay (PHYEMAC1SIGNALDET_ipd,PHYEMAC1SIGNALDET,tipd_PHYEMAC1SIGNALDET);
              VitalWireDelay (PHYEMAC1TXBUFERR_ipd,PHYEMAC1TXBUFERR,tipd_PHYEMAC1TXBUFERR);
              VitalWireDelay (RESET_ipd,RESET,tipd_RESET);
	end block;

	SignalDelay : block
	begin
	VitalSignalDelay (CLIENTEMAC0DCMLOCKED_CLIENTEMAC0TXCLIENTCLKIN_dly,CLIENTEMAC0DCMLOCKED_ipd,tisd_CLIENTEMAC0DCMLOCKED_CLIENTEMAC0TXCLIENTCLKIN);
        VitalSignalDelay (CLIENTEMAC0DCMLOCKED_PHYEMAC0TXGMIIMIICLKIN_dly,CLIENTEMAC0DCMLOCKED_ipd,tisd_CLIENTEMAC0DCMLOCKED_PHYEMAC0TXGMIIMIICLKIN);

	VitalSignalDelay (CLIENTEMAC0PAUSEREQ_CLIENTEMAC0TXCLIENTCLKIN_dly,CLIENTEMAC0PAUSEREQ_ipd,tisd_CLIENTEMAC0PAUSEREQ_CLIENTEMAC0TXCLIENTCLKIN);
        VitalSignalDelay (CLIENTEMAC0PAUSEREQ_PHYEMAC0TXGMIIMIICLKIN_dly,CLIENTEMAC0PAUSEREQ_ipd,tisd_CLIENTEMAC0PAUSEREQ_PHYEMAC0TXGMIIMIICLKIN);
	CLIENTEMAC0PAUSEVAL_DELAY : for i in 15 downto 0 generate
      	VitalSignalDelay (CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_dly(i),CLIENTEMAC0PAUSEVAL_ipd(i),tisd_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN(i));
        VitalSignalDelay (CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_dly(i),CLIENTEMAC0PAUSEVAL_ipd(i),tisd_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN(i));
	end generate CLIENTEMAC0PAUSEVAL_DELAY;
	
	CLIENTEMAC0TXD_DELAY : for i in 15 downto 0 generate
	VitalSignalDelay (CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_dly(i),CLIENTEMAC0TXD_ipd(i),tisd_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN(i));
        VitalSignalDelay (CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_dly(i),CLIENTEMAC0TXD_ipd(i),tisd_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN(i));
	end generate CLIENTEMAC0TXD_DELAY;
	VitalSignalDelay (CLIENTEMAC0TXDVLD_CLIENTEMAC0TXCLIENTCLKIN_dly,CLIENTEMAC0TXDVLD_ipd,tisd_CLIENTEMAC0TXDVLD_CLIENTEMAC0TXCLIENTCLKIN);
       	VitalSignalDelay (CLIENTEMAC0TXDVLD_PHYEMAC0TXGMIIMIICLKIN_dly,CLIENTEMAC0TXDVLD_ipd,tisd_CLIENTEMAC0TXDVLD_PHYEMAC0TXGMIIMIICLKIN);
	VitalSignalDelay (CLIENTEMAC0TXDVLDMSW_CLIENTEMAC0TXCLIENTCLKIN_dly,CLIENTEMAC0TXDVLDMSW_ipd,tisd_CLIENTEMAC0TXDVLDMSW_CLIENTEMAC0TXCLIENTCLKIN);
        VitalSignalDelay (CLIENTEMAC0TXDVLDMSW_PHYEMAC0TXGMIIMIICLKIN_dly,CLIENTEMAC0TXDVLDMSW_ipd,tisd_CLIENTEMAC0TXDVLDMSW_PHYEMAC0TXGMIIMIICLKIN );
	VitalSignalDelay (CLIENTEMAC0TXFIRSTBYTE_CLIENTEMAC0TXCLIENTCLKIN_dly,CLIENTEMAC0TXFIRSTBYTE_ipd,tisd_CLIENTEMAC0TXFIRSTBYTE_CLIENTEMAC0TXCLIENTCLKIN);
        VitalSignalDelay (CLIENTEMAC0TXFIRSTBYTE_PHYEMAC0TXGMIIMIICLKIN_dly,CLIENTEMAC0TXFIRSTBYTE_ipd,tisd_CLIENTEMAC0TXFIRSTBYTE_PHYEMAC0TXGMIIMIICLKIN);
	CLIENTEMAC0TXIFGDELAY_DELAY : for i in 7 downto 0 generate
	VitalSignalDelay (CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_dly(i),CLIENTEMAC0TXIFGDELAY_ipd(i),tisd_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN(i));
	VitalSignalDelay (CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_dly(i),CLIENTEMAC0TXIFGDELAY_ipd(i),tisd_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN(i));
	end generate CLIENTEMAC0TXIFGDELAY_DELAY;
	VitalSignalDelay (CLIENTEMAC0TXUNDERRUN_CLIENTEMAC0TXCLIENTCLKIN_dly,CLIENTEMAC0TXUNDERRUN_ipd,tisd_CLIENTEMAC0TXUNDERRUN_CLIENTEMAC0TXCLIENTCLKIN);
       	VitalSignalDelay (CLIENTEMAC0TXUNDERRUN_PHYEMAC0TXGMIIMIICLKIN_dly,CLIENTEMAC0TXUNDERRUN_ipd,tisd_CLIENTEMAC0TXUNDERRUN_PHYEMAC0TXGMIIMIICLKIN);
	VitalSignalDelay (CLIENTEMAC1DCMLOCKED_CLIENTEMAC1TXCLIENTCLKIN_dly,CLIENTEMAC1DCMLOCKED_ipd,tisd_CLIENTEMAC1DCMLOCKED_CLIENTEMAC1TXCLIENTCLKIN);
        VitalSignalDelay (CLIENTEMAC1DCMLOCKED_PHYEMAC1TXGMIIMIICLKIN_dly,CLIENTEMAC1DCMLOCKED_ipd,tisd_CLIENTEMAC1DCMLOCKED_PHYEMAC1TXGMIIMIICLKIN);
	VitalSignalDelay (CLIENTEMAC1PAUSEREQ_CLIENTEMAC1TXCLIENTCLKIN_dly,CLIENTEMAC1PAUSEREQ_ipd,tisd_CLIENTEMAC1PAUSEREQ_CLIENTEMAC1TXCLIENTCLKIN);
        VitalSignalDelay (CLIENTEMAC1PAUSEREQ_PHYEMAC1TXGMIIMIICLKIN_dly,CLIENTEMAC1PAUSEREQ_ipd,tisd_CLIENTEMAC1PAUSEREQ_PHYEMAC1TXGMIIMIICLKIN);
	CLIENTEMAC1PAUSEVAL_DELAY : for i in 15 downto 0 generate
	VitalSignalDelay (CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_dly(i),CLIENTEMAC1PAUSEVAL_ipd(i),tisd_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN(i));
	VitalSignalDelay (CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_dly(i),CLIENTEMAC1PAUSEVAL_ipd(i),tisd_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN(i));
	end generate CLIENTEMAC1PAUSEVAL_DELAY;
	CLIENTEMAC1TXD_DELAY : for i in 15 downto 0 generate
	VitalSignalDelay (CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_dly(i),CLIENTEMAC1TXD_ipd(i),tisd_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN(i));
	VitalSignalDelay (CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_dly(i),CLIENTEMAC1TXD_ipd(i),tisd_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN(i));
	end generate CLIENTEMAC1TXD_DELAY;
	VitalSignalDelay (CLIENTEMAC1TXDVLD_CLIENTEMAC1TXCLIENTCLKIN_dly,CLIENTEMAC1TXDVLD_ipd,tisd_CLIENTEMAC1TXDVLD_CLIENTEMAC1TXCLIENTCLKIN);
        VitalSignalDelay (CLIENTEMAC1TXDVLD_PHYEMAC1TXGMIIMIICLKIN_dly,CLIENTEMAC1TXDVLD_ipd,tisd_CLIENTEMAC1TXDVLD_PHYEMAC1TXGMIIMIICLKIN);
	VitalSignalDelay (CLIENTEMAC1TXDVLDMSW_CLIENTEMAC1TXCLIENTCLKIN_dly,CLIENTEMAC1TXDVLDMSW_ipd,tisd_CLIENTEMAC1TXDVLDMSW_CLIENTEMAC1TXCLIENTCLKIN);
        VitalSignalDelay (CLIENTEMAC1TXDVLDMSW_PHYEMAC1TXGMIIMIICLKIN_dly,CLIENTEMAC1TXDVLDMSW_ipd,tisd_CLIENTEMAC1TXDVLDMSW_PHYEMAC1TXGMIIMIICLKIN);
	VitalSignalDelay (CLIENTEMAC1TXFIRSTBYTE_CLIENTEMAC1TXCLIENTCLKIN_dly,CLIENTEMAC1TXFIRSTBYTE_ipd,tisd_CLIENTEMAC1TXFIRSTBYTE_CLIENTEMAC1TXCLIENTCLKIN);
        VitalSignalDelay (CLIENTEMAC1TXFIRSTBYTE_PHYEMAC1TXGMIIMIICLKIN_dly,CLIENTEMAC1TXFIRSTBYTE_ipd,tisd_CLIENTEMAC1TXFIRSTBYTE_PHYEMAC1TXGMIIMIICLKIN);
	CLIENTEMAC1TXIFGDELAY_DELAY : for i in 7 downto 0 generate
	VitalSignalDelay (CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_dly(i),CLIENTEMAC1TXIFGDELAY_ipd(i),tisd_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN(i));
	VitalSignalDelay (CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_dly(i),CLIENTEMAC1TXIFGDELAY_ipd(i),tisd_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN(i));
	end generate CLIENTEMAC1TXIFGDELAY_DELAY;
	VitalSignalDelay (CLIENTEMAC1TXUNDERRUN_CLIENTEMAC1TXCLIENTCLKIN_dly,CLIENTEMAC1TXUNDERRUN_ipd,tisd_CLIENTEMAC1TXUNDERRUN_CLIENTEMAC1TXCLIENTCLKIN);
        VitalSignalDelay (CLIENTEMAC1TXUNDERRUN_PHYEMAC1TXGMIIMIICLKIN_dly,CLIENTEMAC1TXUNDERRUN_ipd,tisd_CLIENTEMAC1TXUNDERRUN_PHYEMAC1TXGMIIMIICLKIN);
	DCREMACABUS_DELAY : for i in 0 to 9 generate
	VitalSignalDelay (DCREMACABUS_DCREMACCLK_dly(i),DCREMACABUS_ipd(i),tisd_DCREMACABUS_DCREMACCLK(i));
        end generate DCREMACABUS_DELAY;
        DCREMACDBUS_DELAY : for i in 0 to 31 generate
	VitalSignalDelay (DCREMACDBUS_DCREMACCLK_dly(i),DCREMACDBUS_ipd(i),tisd_DCREMACDBUS_DCREMACCLK(i));
	end generate DCREMACDBUS_DELAY;
	VitalSignalDelay (DCREMACENABLE_DCREMACCLK_dly,DCREMACENABLE_ipd,tisd_DCREMACENABLE_DCREMACCLK);
	VitalSignalDelay (DCREMACREAD_DCREMACCLK_dly,DCREMACREAD_ipd,tisd_DCREMACREAD_DCREMACCLK);
	VitalSignalDelay (DCREMACWRITE_DCREMACCLK_dly,DCREMACWRITE_ipd,tisd_DCREMACWRITE_DCREMACCLK);
	HOSTADDR_DELAY : for i in 9 downto 0 generate
	VitalSignalDelay (HOSTADDR_HOSTCLK_dly(i),HOSTADDR_ipd(i),tisd_HOSTADDR_HOSTCLK(i));
	end generate HOSTADDR_DELAY;
	VitalSignalDelay (HOSTEMAC1SEL_HOSTCLK_dly,HOSTEMAC1SEL_ipd,tisd_HOSTEMAC1SEL_HOSTCLK);
	VitalSignalDelay (HOSTMIIMSEL_HOSTCLK_dly,HOSTMIIMSEL_ipd,tisd_HOSTMIIMSEL_HOSTCLK);
	HOSTOPCODE_DELAY : for i in 1 downto 0 generate
	VitalSignalDelay (HOSTOPCODE_HOSTCLK_dly(i),HOSTOPCODE_ipd(i),tisd_HOSTOPCODE_HOSTCLK(i));
	end generate HOSTOPCODE_DELAY;
	VitalSignalDelay (HOSTREQ_HOSTCLK_dly,HOSTREQ_ipd,tisd_HOSTREQ_HOSTCLK);
	HOSTWRDATA_DELAY : for i in 31 downto 0 generate
	VitalSignalDelay (HOSTWRDATA_HOSTCLK_dly(i),HOSTWRDATA_ipd(i),tisd_HOSTWRDATA_HOSTCLK(i));
	end generate HOSTWRDATA_DELAY;
	VitalSignalDelay (PHYEMAC0COL_PHYEMAC0GTXCLK_dly,PHYEMAC0COL_ipd,tisd_PHYEMAC0COL_PHYEMAC0GTXCLK);
        VitalSignalDelay (PHYEMAC0COL_PHYEMAC0RXCLK_dly,PHYEMAC0COL_ipd,tisd_PHYEMAC0COL_PHYEMAC0RXCLK);
	VitalSignalDelay (PHYEMAC0CRS_PHYEMAC0GTXCLK_dly,PHYEMAC0CRS_ipd,tisd_PHYEMAC0CRS_PHYEMAC0GTXCLK);
       	VitalSignalDelay (PHYEMAC0CRS_PHYEMAC0RXCLK_dly,PHYEMAC0CRS_ipd,tisd_PHYEMAC0CRS_PHYEMAC0RXCLK);
	VitalSignalDelay (PHYEMAC0MDIN_HOSTCLK_dly,PHYEMAC0MDIN_ipd,tisd_PHYEMAC0MDIN_HOSTCLK);
       	VitalSignalDelay (PHYEMAC0MDIN_PHYEMAC0MCLKIN_dly,PHYEMAC0MDIN_ipd,tisd_PHYEMAC0MDIN_PHYEMAC0MCLKIN);
	PHYEMAC0PHYAD_DELAY : for i in 4 downto 0 generate
	VitalSignalDelay (PHYEMAC0PHYAD_HOSTCLK_dly(i),PHYEMAC0PHYAD_ipd(i),tisd_PHYEMAC0PHYAD_HOSTCLK(i));
	end generate PHYEMAC0PHYAD_DELAY;
	VitalSignalDelay (PHYEMAC0RXBUFERR_PHYEMAC0GTXCLK_dly,PHYEMAC0RXBUFERR_ipd,tisd_PHYEMAC0RXBUFERR_PHYEMAC0GTXCLK);
         VitalSignalDelay (PHYEMAC0RXBUFERR_PHYEMAC0RXCLK_dly,PHYEMAC0RXBUFERR_ipd,tisd_PHYEMAC0RXBUFERR_PHYEMAC0RXCLK);
	PHYEMAC0RXBUFSTATUS_DELAY : for i in 1 downto 0 generate
	VitalSignalDelay (PHYEMAC0RXBUFSTATUS_PHYEMAC0GTXCLK_dly(i),PHYEMAC0RXBUFSTATUS_ipd(i),tisd_PHYEMAC0RXBUFSTATUS_PHYEMAC0GTXCLK(i));
        VitalSignalDelay (PHYEMAC0RXBUFSTATUS_PHYEMAC0RXCLK_dly(i),PHYEMAC0RXBUFSTATUS_ipd(i),tisd_PHYEMAC0RXBUFSTATUS_PHYEMAC0RXCLK(i));
	end generate PHYEMAC0RXBUFSTATUS_DELAY;
	VitalSignalDelay (PHYEMAC0RXCHARISCOMMA_PHYEMAC0GTXCLK_dly,PHYEMAC0RXCHARISCOMMA_ipd,tisd_PHYEMAC0RXCHARISCOMMA_PHYEMAC0GTXCLK);
        VitalSignalDelay (PHYEMAC0RXCHARISCOMMA_PHYEMAC0RXCLK_dly,PHYEMAC0RXCHARISCOMMA_ipd,tisd_PHYEMAC0RXCHARISCOMMA_PHYEMAC0RXCLK);
        VitalSignalDelay (PHYEMAC0RXCHARISK_PHYEMAC0GTXCLK_dly,PHYEMAC0RXCHARISK_ipd,tisd_PHYEMAC0RXCHARISK_PHYEMAC0GTXCLK);
        VitalSignalDelay (PHYEMAC0RXCHARISK_PHYEMAC0RXCLK_dly,PHYEMAC0RXCHARISK_ipd,tisd_PHYEMAC0RXCHARISK_PHYEMAC0RXCLK);
        VitalSignalDelay (PHYEMAC0RXCHECKINGCRC_PHYEMAC0GTXCLK_dly,PHYEMAC0RXCHECKINGCRC_ipd,tisd_PHYEMAC0RXCHECKINGCRC_PHYEMAC0GTXCLK);
        VitalSignalDelay (PHYEMAC0RXCHECKINGCRC_PHYEMAC0RXCLK_dly,PHYEMAC0RXCHECKINGCRC_ipd,tisd_PHYEMAC0RXCHECKINGCRC_PHYEMAC0RXCLK);
	PHYEMAC0RXCLKCORCNT_DELAY : for i in 2 downto 0 generate
	VitalSignalDelay (PHYEMAC0RXCLKCORCNT_PHYEMAC0GTXCLK_dly(i),PHYEMAC0RXCLKCORCNT_ipd(i),tisd_PHYEMAC0RXCLKCORCNT_PHYEMAC0GTXCLK(i));
        VitalSignalDelay (PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK_dly(i),PHYEMAC0RXCLKCORCNT_ipd(i),tisd_PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK(i));
	end generate PHYEMAC0RXCLKCORCNT_DELAY;
	VitalSignalDelay (PHYEMAC0RXCOMMADET_PHYEMAC0GTXCLK_dly,PHYEMAC0RXCOMMADET_ipd,tisd_PHYEMAC0RXCOMMADET_PHYEMAC0GTXCLK);
	VitalSignalDelay (PHYEMAC0RXCOMMADET_PHYEMAC0RXCLK_dly,PHYEMAC0RXCOMMADET_ipd,tisd_PHYEMAC0RXCOMMADET_PHYEMAC0RXCLK);
	PHYEMAC0RXD_DELAY : for i in 7 downto 0 generate
	VitalSignalDelay (PHYEMAC0RXD_PHYEMAC0GTXCLK_dly(i),PHYEMAC0RXD_ipd(i),tisd_PHYEMAC0RXD_PHYEMAC0GTXCLK(i));
        VitalSignalDelay (PHYEMAC0RXD_PHYEMAC0RXCLK_dly(i),PHYEMAC0RXD_ipd(i),tisd_PHYEMAC0RXD_PHYEMAC0RXCLK(i));
	end generate PHYEMAC0RXD_DELAY;
	VitalSignalDelay (PHYEMAC0RXDISPERR_PHYEMAC0GTXCLK_dly,PHYEMAC0RXDISPERR_ipd,tisd_PHYEMAC0RXDISPERR_PHYEMAC0GTXCLK);
       	VitalSignalDelay (PHYEMAC0RXDISPERR_PHYEMAC0RXCLK_dly,PHYEMAC0RXDISPERR_ipd,tisd_PHYEMAC0RXDISPERR_PHYEMAC0RXCLK);
	VitalSignalDelay (PHYEMAC0RXDV_PHYEMAC0GTXCLK_dly,PHYEMAC0RXDV_ipd,tisd_PHYEMAC0RXDV_PHYEMAC0GTXCLK);
        VitalSignalDelay (PHYEMAC0RXDV_PHYEMAC0RXCLK_dly,PHYEMAC0RXDV_ipd,tisd_PHYEMAC0RXDV_PHYEMAC0RXCLK);
	VitalSignalDelay (PHYEMAC0RXER_PHYEMAC0GTXCLK_dly,PHYEMAC0RXER_ipd,tisd_PHYEMAC0RXER_PHYEMAC0GTXCLK);
        VitalSignalDelay (PHYEMAC0RXER_PHYEMAC0RXCLK_dly,PHYEMAC0RXER_ipd,tisd_PHYEMAC0RXER_PHYEMAC0RXCLK);
	PHYEMAC0RXLOSSOFSYNC_DELAY : for i in 1 downto 0 generate
	VitalSignalDelay (PHYEMAC0RXLOSSOFSYNC_PHYEMAC0GTXCLK_dly(i),PHYEMAC0RXLOSSOFSYNC_ipd(i),tisd_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0GTXCLK(i));
        VitalSignalDelay (PHYEMAC0RXLOSSOFSYNC_PHYEMAC0RXCLK_dly(i),PHYEMAC0RXLOSSOFSYNC_ipd(i),tisd_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0RXCLK(i));
	end generate PHYEMAC0RXLOSSOFSYNC_DELAY;
	VitalSignalDelay (PHYEMAC0RXNOTINTABLE_PHYEMAC0GTXCLK_dly,PHYEMAC0RXNOTINTABLE_ipd,tisd_PHYEMAC0RXNOTINTABLE_PHYEMAC0GTXCLK);
        VitalSignalDelay (PHYEMAC0RXNOTINTABLE_PHYEMAC0RXCLK_dly,PHYEMAC0RXNOTINTABLE_ipd,tisd_PHYEMAC0RXNOTINTABLE_PHYEMAC0RXCLK);
	VitalSignalDelay (PHYEMAC0RXRUNDISP_PHYEMAC0GTXCLK_dly,PHYEMAC0RXRUNDISP_ipd,tisd_PHYEMAC0RXRUNDISP_PHYEMAC0GTXCLK);
        VitalSignalDelay (PHYEMAC0RXRUNDISP_PHYEMAC0RXCLK_dly,PHYEMAC0RXRUNDISP_ipd,tisd_PHYEMAC0RXRUNDISP_PHYEMAC0RXCLK);
        VitalSignalDelay (PHYEMAC0SIGNALDET_PHYEMAC0GTXCLK_dly,PHYEMAC0SIGNALDET_ipd,tisd_PHYEMAC0SIGNALDET_PHYEMAC0GTXCLK);
        VitalSignalDelay (PHYEMAC0SIGNALDET_PHYEMAC0RXCLK_dly,PHYEMAC0SIGNALDET_ipd,tisd_PHYEMAC0SIGNALDET_PHYEMAC0RXCLK);
       	VitalSignalDelay (PHYEMAC0TXBUFERR_PHYEMAC0GTXCLK_dly,PHYEMAC0TXBUFERR_ipd,tisd_PHYEMAC0TXBUFERR_PHYEMAC0GTXCLK);
        VitalSignalDelay (PHYEMAC0TXBUFERR_PHYEMAC0TXGMIIMIICLKIN_dly,PHYEMAC0TXBUFERR_ipd,tisd_PHYEMAC0TXBUFERR_PHYEMAC0TXGMIIMIICLKIN);
        VitalSignalDelay (PHYEMAC1COL_PHYEMAC1GTXCLK_dly,PHYEMAC1COL_ipd,tisd_PHYEMAC1COL_PHYEMAC1GTXCLK);
        VitalSignalDelay (PHYEMAC1COL_PHYEMAC1RXCLK_dly,PHYEMAC1COL_ipd,tisd_PHYEMAC1COL_PHYEMAC1RXCLK);
	VitalSignalDelay (PHYEMAC1CRS_PHYEMAC1GTXCLK_dly,PHYEMAC1CRS_ipd,tisd_PHYEMAC1CRS_PHYEMAC1GTXCLK);
        VitalSignalDelay (PHYEMAC1CRS_PHYEMAC1RXCLK_dly,PHYEMAC1CRS_ipd,tisd_PHYEMAC1CRS_PHYEMAC1RXCLK);
	VitalSignalDelay (PHYEMAC1MDIN_HOSTCLK_dly,PHYEMAC1MDIN_ipd,tisd_PHYEMAC1MDIN_HOSTCLK);
       	VitalSignalDelay (PHYEMAC1MDIN_PHYEMAC1MCLKIN_dly,PHYEMAC1MDIN_ipd,tisd_PHYEMAC1MDIN_PHYEMAC1MCLKIN);
	PHYEMAC1PHYAD_DELAY : for i in 4 downto 0 generate
	VitalSignalDelay (PHYEMAC1PHYAD_HOSTCLK_dly(i),PHYEMAC1PHYAD_ipd(i),tisd_PHYEMAC1PHYAD_HOSTCLK(i));
	end generate PHYEMAC1PHYAD_DELAY;
	VitalSignalDelay (PHYEMAC1RXBUFERR_PHYEMAC1GTXCLK_dly,PHYEMAC1RXBUFERR_ipd,tisd_PHYEMAC1RXBUFERR_PHYEMAC1GTXCLK);
        VitalSignalDelay (PHYEMAC1RXBUFERR_PHYEMAC1RXCLK_dly,PHYEMAC1RXBUFERR_ipd,tisd_PHYEMAC1RXBUFERR_PHYEMAC1RXCLK);
	PHYEMAC1RXBUFSTATUS_DELAY : for i in 1 downto 0 generate
	VitalSignalDelay (PHYEMAC1RXBUFSTATUS_PHYEMAC1GTXCLK_dly(i),PHYEMAC1RXBUFSTATUS_ipd(i),tisd_PHYEMAC1RXBUFSTATUS_PHYEMAC1GTXCLK(i));
        VitalSignalDelay (PHYEMAC1RXBUFSTATUS_PHYEMAC1RXCLK_dly(i),PHYEMAC1RXBUFSTATUS_ipd(i),tisd_PHYEMAC1RXBUFSTATUS_PHYEMAC1RXCLK(i));
	end generate PHYEMAC1RXBUFSTATUS_DELAY;
	VitalSignalDelay (PHYEMAC1RXCHARISCOMMA_PHYEMAC1GTXCLK_dly,PHYEMAC1RXCHARISCOMMA_ipd,tisd_PHYEMAC1RXCHARISCOMMA_PHYEMAC1GTXCLK);
        VitalSignalDelay (PHYEMAC1RXCHARISCOMMA_PHYEMAC1RXCLK_dly,PHYEMAC1RXCHARISCOMMA_ipd,tisd_PHYEMAC1RXCHARISCOMMA_PHYEMAC1RXCLK);
        VitalSignalDelay (PHYEMAC1RXCHARISK_PHYEMAC1GTXCLK_dly,PHYEMAC1RXCHARISK_ipd,tisd_PHYEMAC1RXCHARISK_PHYEMAC1GTXCLK);
        VitalSignalDelay (PHYEMAC1RXCHARISK_PHYEMAC1RXCLK_dly,PHYEMAC1RXCHARISK_ipd,tisd_PHYEMAC1RXCHARISK_PHYEMAC1RXCLK);
	VitalSignalDelay (PHYEMAC1RXCHECKINGCRC_PHYEMAC1GTXCLK_dly,PHYEMAC1RXCHECKINGCRC_ipd,tisd_PHYEMAC1RXCHECKINGCRC_PHYEMAC1GTXCLK);
        VitalSignalDelay (PHYEMAC1RXCHECKINGCRC_PHYEMAC1RXCLK_dly,PHYEMAC1RXCHECKINGCRC_ipd,tisd_PHYEMAC1RXCHECKINGCRC_PHYEMAC1RXCLK);
	PHYEMAC1RXCLKCORCNT_DELAY : for i in 2 downto 0 generate
	VitalSignalDelay (PHYEMAC1RXCLKCORCNT_PHYEMAC1GTXCLK_dly(i),PHYEMAC1RXCLKCORCNT_ipd(i),tisd_PHYEMAC1RXCLKCORCNT_PHYEMAC1GTXCLK(i));
        VitalSignalDelay (PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK_dly(i),PHYEMAC1RXCLKCORCNT_ipd(i),tisd_PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK(i));
	end generate PHYEMAC1RXCLKCORCNT_DELAY;
	VitalSignalDelay (PHYEMAC1RXCOMMADET_PHYEMAC1GTXCLK_dly,PHYEMAC1RXCOMMADET_ipd,tisd_PHYEMAC1RXCOMMADET_PHYEMAC1GTXCLK);
        VitalSignalDelay (PHYEMAC1RXCOMMADET_PHYEMAC1RXCLK_dly,PHYEMAC1RXCOMMADET_ipd,tisd_PHYEMAC1RXCOMMADET_PHYEMAC1RXCLK);
	PHYEMAC1RXD_DELAY : for i in 7 downto 0 generate
	VitalSignalDelay (PHYEMAC1RXD_PHYEMAC1GTXCLK_dly(i),PHYEMAC1RXD_ipd(i),tisd_PHYEMAC1RXD_PHYEMAC1GTXCLK(i));
        VitalSignalDelay (PHYEMAC1RXD_PHYEMAC1RXCLK_dly(i),PHYEMAC1RXD_ipd(i),tisd_PHYEMAC1RXD_PHYEMAC1RXCLK(i));
	end generate PHYEMAC1RXD_DELAY;
	VitalSignalDelay (PHYEMAC1RXDISPERR_PHYEMAC1GTXCLK_dly,PHYEMAC1RXDISPERR_ipd,tisd_PHYEMAC1RXDISPERR_PHYEMAC1GTXCLK);
        VitalSignalDelay (PHYEMAC1RXDISPERR_PHYEMAC1RXCLK_dly,PHYEMAC1RXDISPERR_ipd,tisd_PHYEMAC1RXDISPERR_PHYEMAC1RXCLK);
	VitalSignalDelay (PHYEMAC1RXDV_PHYEMAC1GTXCLK_dly,PHYEMAC1RXDV_ipd,tisd_PHYEMAC1RXDV_PHYEMAC1GTXCLK);
        VitalSignalDelay (PHYEMAC1RXDV_PHYEMAC1RXCLK_dly,PHYEMAC1RXDV_ipd,tisd_PHYEMAC1RXDV_PHYEMAC1RXCLK);
	VitalSignalDelay (PHYEMAC1RXER_PHYEMAC1GTXCLK_dly,PHYEMAC1RXER_ipd,tisd_PHYEMAC1RXER_PHYEMAC1GTXCLK);
        VitalSignalDelay (PHYEMAC1RXER_PHYEMAC1RXCLK_dly,PHYEMAC1RXER_ipd,tisd_PHYEMAC1RXER_PHYEMAC1RXCLK);
	PHYEMAC1RXLOSSOFSYNC_DELAY : for i in 1 downto 0 generate
	VitalSignalDelay (PHYEMAC1RXLOSSOFSYNC_PHYEMAC1GTXCLK_dly(i),PHYEMAC1RXLOSSOFSYNC_ipd(i),tisd_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1GTXCLK(i));
        VitalSignalDelay (PHYEMAC1RXLOSSOFSYNC_PHYEMAC1RXCLK_dly(i),PHYEMAC1RXLOSSOFSYNC_ipd(i),tisd_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1RXCLK(i));
	end generate PHYEMAC1RXLOSSOFSYNC_DELAY;
	VitalSignalDelay (PHYEMAC1RXNOTINTABLE_PHYEMAC1GTXCLK_dly,PHYEMAC1RXNOTINTABLE_ipd,tisd_PHYEMAC1RXNOTINTABLE_PHYEMAC1GTXCLK);
        VitalSignalDelay (PHYEMAC1RXNOTINTABLE_PHYEMAC1RXCLK_dly,PHYEMAC1RXNOTINTABLE_ipd,tisd_PHYEMAC1RXNOTINTABLE_PHYEMAC1RXCLK);
	VitalSignalDelay (PHYEMAC1RXRUNDISP_PHYEMAC1GTXCLK_dly,PHYEMAC1RXRUNDISP_ipd,tisd_PHYEMAC1RXRUNDISP_PHYEMAC1GTXCLK);
        VitalSignalDelay (PHYEMAC1RXRUNDISP_PHYEMAC1RXCLK_dly,PHYEMAC1RXRUNDISP_ipd,tisd_PHYEMAC1RXRUNDISP_PHYEMAC1RXCLK);
	VitalSignalDelay (PHYEMAC1SIGNALDET_PHYEMAC1GTXCLK_dly,PHYEMAC1SIGNALDET_ipd,tisd_PHYEMAC1SIGNALDET_PHYEMAC1GTXCLK);
       	VitalSignalDelay (PHYEMAC1SIGNALDET_PHYEMAC1RXCLK_dly,PHYEMAC1SIGNALDET_ipd,tisd_PHYEMAC1SIGNALDET_PHYEMAC1RXCLK);
	VitalSignalDelay (PHYEMAC1TXBUFERR_PHYEMAC1GTXCLK_dly,PHYEMAC1TXBUFERR_ipd,tisd_PHYEMAC1TXBUFERR_PHYEMAC1GTXCLK);
       	VitalSignalDelay (PHYEMAC1TXBUFERR_PHYEMAC1TXGMIIMIICLKIN_dly,PHYEMAC1TXBUFERR_ipd,tisd_PHYEMAC1TXBUFERR_PHYEMAC1TXGMIIMIICLKIN);
        
        VitalSignalDelay (RESET_HOSTCLK_dly,RESET_ipd,tisd_RESET_HOSTCLK);
        VitalSignalDelay (RESET_CLIENTEMAC0TXCLIENTCLKIN_dly,RESET_ipd,tisd_RESET_CLIENTEMAC0TXCLIENTCLKIN);
        VitalSignalDelay (RESET_CLIENTEMAC1TXCLIENTCLKIN_dly,RESET_ipd,tisd_RESET_CLIENTEMAC1TXCLIENTCLKIN);
        VitalSignalDelay (RESET_PHYEMAC0TXGMIIMIICLKIN_dly,RESET_ipd,tisd_RESET_PHYEMAC0TXGMIIMIICLKIN);
        VitalSignalDelay (RESET_PHYEMAC1TXGMIIMIICLKIN_dly,RESET_ipd,tisd_RESET_PHYEMAC1TXGMIIMIICLKIN);
        VitalSignalDelay (RESET_PHYEMAC0GTXCLK_dly,RESET_ipd,tisd_RESET_PHYEMAC0GTXCLK);
        VitalSignalDelay (RESET_PHYEMAC1GTXCLK_dly,RESET_ipd,tisd_RESET_PHYEMAC1GTXCLK);
        
	VitalSignalDelay (CLIENTEMAC0TXCLIENTCLKIN_dly,CLIENTEMAC0TXCLIENTCLKIN_ipd,ticd_CLIENTEMAC0TXCLIENTCLKIN);
	VitalSignalDelay (CLIENTEMAC1TXCLIENTCLKIN_dly,CLIENTEMAC1TXCLIENTCLKIN_ipd,ticd_CLIENTEMAC1TXCLIENTCLKIN);
	VitalSignalDelay (DCREMACCLK_dly,DCREMACCLK_ipd,ticd_DCREMACCLK);
	VitalSignalDelay (HOSTCLK_dly,HOSTCLK_ipd,ticd_HOSTCLK);
	VitalSignalDelay (PHYEMAC0GTXCLK_dly,PHYEMAC0GTXCLK_ipd,ticd_PHYEMAC0GTXCLK);
	VitalSignalDelay (PHYEMAC1GTXCLK_dly,PHYEMAC1GTXCLK_ipd,ticd_PHYEMAC1GTXCLK);
        VitalSignalDelay (PHYEMAC0RXCLK_dly,PHYEMAC0RXCLK_ipd,ticd_PHYEMAC0RXCLK);
	VitalSignalDelay (PHYEMAC1RXCLK_dly,PHYEMAC1RXCLK_ipd,ticd_PHYEMAC1RXCLK);
        VitalSignalDelay (PHYEMAC0TXGMIIMIICLKIN_dly,PHYEMAC0TXGMIIMIICLKIN_ipd,ticd_PHYEMAC0TXGMIIMIICLKIN);
	VitalSignalDelay (PHYEMAC1TXGMIIMIICLKIN_dly,PHYEMAC1TXGMIIMIICLKIN_ipd,ticd_PHYEMAC1TXGMIIMIICLKIN);
        VitalSignalDelay (PHYEMAC0MCLKIN_dly,PHYEMAC0MCLKIN_ipd,ticd_PHYEMAC0MCLKIN);
	VitalSignalDelay (PHYEMAC1MCLKIN_dly,PHYEMAC1MCLKIN_ipd,ticd_PHYEMAC1MCLKIN);
        
	end block;

        SELECTPROC: process (CLIENTEMAC0DCMLOCKED_CLIENTEMAC0TXCLIENTCLKIN_dly,CLIENTEMAC0DCMLOCKED_PHYEMAC0TXGMIIMIICLKIN_dly,CLIENTEMAC0PAUSEREQ_CLIENTEMAC0TXCLIENTCLKIN_dly,CLIENTEMAC0PAUSEREQ_PHYEMAC0TXGMIIMIICLKIN_dly,CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_dly,CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_dly,CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_dly,CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_dly,CLIENTEMAC0TXDVLD_CLIENTEMAC0TXCLIENTCLKIN_dly,CLIENTEMAC0TXDVLD_PHYEMAC0TXGMIIMIICLKIN_dly,CLIENTEMAC0TXDVLDMSW_CLIENTEMAC0TXCLIENTCLKIN_dly,CLIENTEMAC0TXDVLDMSW_PHYEMAC0TXGMIIMIICLKIN_dly,CLIENTEMAC0TXFIRSTBYTE_CLIENTEMAC0TXCLIENTCLKIN_dly,CLIENTEMAC0TXFIRSTBYTE_PHYEMAC0TXGMIIMIICLKIN_dly,CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_dly,CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_dly,CLIENTEMAC0TXUNDERRUN_CLIENTEMAC0TXCLIENTCLKIN_dly,CLIENTEMAC0TXUNDERRUN_PHYEMAC0TXGMIIMIICLKIN_dly,CLIENTEMAC1DCMLOCKED_CLIENTEMAC1TXCLIENTCLKIN_dly,CLIENTEMAC1DCMLOCKED_PHYEMAC1TXGMIIMIICLKIN_dly,CLIENTEMAC1PAUSEREQ_CLIENTEMAC1TXCLIENTCLKIN_dly,CLIENTEMAC1PAUSEREQ_PHYEMAC1TXGMIIMIICLKIN_dly,CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_dly,CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_dly,CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_dly,CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_dly,CLIENTEMAC1TXDVLD_CLIENTEMAC1TXCLIENTCLKIN_dly,CLIENTEMAC1TXDVLD_PHYEMAC1TXGMIIMIICLKIN_dly,CLIENTEMAC1TXDVLDMSW_CLIENTEMAC1TXCLIENTCLKIN_dly,CLIENTEMAC1TXDVLDMSW_PHYEMAC1TXGMIIMIICLKIN_dly,CLIENTEMAC1TXFIRSTBYTE_CLIENTEMAC1TXCLIENTCLKIN_dly,CLIENTEMAC1TXFIRSTBYTE_PHYEMAC1TXGMIIMIICLKIN_dly,CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_dly,CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_dly,CLIENTEMAC1TXUNDERRUN_CLIENTEMAC1TXCLIENTCLKIN_dly,CLIENTEMAC1TXUNDERRUN_PHYEMAC1TXGMIIMIICLKIN_dly,PHYEMAC0COL_PHYEMAC0GTXCLK_dly,PHYEMAC0COL_PHYEMAC0RXCLK_dly,PHYEMAC0CRS_PHYEMAC0GTXCLK_dly,PHYEMAC0CRS_PHYEMAC0RXCLK_dly,PHYEMAC0MDIN_HOSTCLK_dly,PHYEMAC0MDIN_PHYEMAC0MCLKIN_dly,PHYEMAC0RXBUFERR_PHYEMAC0GTXCLK_dly,PHYEMAC0RXBUFERR_PHYEMAC0RXCLK_dly,PHYEMAC0RXBUFSTATUS_PHYEMAC0GTXCLK_dly,PHYEMAC0RXBUFSTATUS_PHYEMAC0RXCLK_dly,PHYEMAC0RXCHARISCOMMA_PHYEMAC0GTXCLK_dly,PHYEMAC0RXCHARISCOMMA_PHYEMAC0RXCLK_dly,PHYEMAC0RXCHARISK_PHYEMAC0GTXCLK_dly,PHYEMAC0RXCHARISK_PHYEMAC0RXCLK_dly,PHYEMAC0RXCHECKINGCRC_PHYEMAC0GTXCLK_dly,PHYEMAC0RXCHECKINGCRC_PHYEMAC0RXCLK_dly,PHYEMAC0RXCLKCORCNT_PHYEMAC0GTXCLK_dly,PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK_dly,PHYEMAC0RXCOMMADET_PHYEMAC0GTXCLK_dly,PHYEMAC0RXCOMMADET_PHYEMAC0RXCLK_dly,PHYEMAC0RXD_PHYEMAC0GTXCLK_dly,PHYEMAC0RXD_PHYEMAC0RXCLK_dly,PHYEMAC0RXDISPERR_PHYEMAC0GTXCLK_dly,PHYEMAC0RXDISPERR_PHYEMAC0RXCLK_dly,PHYEMAC0RXDV_PHYEMAC0GTXCLK_dly,PHYEMAC0RXDV_PHYEMAC0RXCLK_dly,PHYEMAC0RXER_PHYEMAC0GTXCLK_dly,PHYEMAC0RXER_PHYEMAC0RXCLK_dly,PHYEMAC0RXLOSSOFSYNC_PHYEMAC0GTXCLK_dly,PHYEMAC0RXLOSSOFSYNC_PHYEMAC0RXCLK_dly,PHYEMAC0RXNOTINTABLE_PHYEMAC0GTXCLK_dly,PHYEMAC0RXNOTINTABLE_PHYEMAC0RXCLK_dly,PHYEMAC0RXRUNDISP_PHYEMAC0GTXCLK_dly,PHYEMAC0RXRUNDISP_PHYEMAC0RXCLK_dly,PHYEMAC0TXBUFERR_PHYEMAC0GTXCLK_dly,PHYEMAC0TXBUFERR_PHYEMAC0TXGMIIMIICLKIN_dly,PHYEMAC1COL_PHYEMAC1GTXCLK_dly,PHYEMAC1COL_PHYEMAC1RXCLK_dly,PHYEMAC1CRS_PHYEMAC1GTXCLK_dly,PHYEMAC1CRS_PHYEMAC1RXCLK_dly,PHYEMAC1MDIN_HOSTCLK_dly,PHYEMAC1MDIN_PHYEMAC1MCLKIN_dly,PHYEMAC1RXBUFERR_PHYEMAC1GTXCLK_dly,PHYEMAC1RXBUFERR_PHYEMAC1RXCLK_dly,PHYEMAC1RXBUFSTATUS_PHYEMAC1GTXCLK_dly,PHYEMAC1RXBUFSTATUS_PHYEMAC1RXCLK_dly,PHYEMAC1RXCHARISCOMMA_PHYEMAC1GTXCLK_dly,PHYEMAC1RXCHARISCOMMA_PHYEMAC1RXCLK_dly,PHYEMAC1RXCHARISK_PHYEMAC1GTXCLK_dly,PHYEMAC1RXCHARISK_PHYEMAC1RXCLK_dly,PHYEMAC1RXCHECKINGCRC_PHYEMAC1GTXCLK_dly,PHYEMAC1RXCHECKINGCRC_PHYEMAC1RXCLK_dly,PHYEMAC1RXCLKCORCNT_PHYEMAC1GTXCLK_dly,PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK_dly,PHYEMAC1RXCOMMADET_PHYEMAC1GTXCLK_dly,PHYEMAC1RXCOMMADET_PHYEMAC1RXCLK_dly,PHYEMAC1RXD_PHYEMAC1GTXCLK_dly,PHYEMAC1RXD_PHYEMAC1RXCLK_dly,PHYEMAC1RXDISPERR_PHYEMAC1GTXCLK_dly,PHYEMAC1RXDISPERR_PHYEMAC1RXCLK_dly,PHYEMAC1RXDV_PHYEMAC1GTXCLK_dly,PHYEMAC1RXDV_PHYEMAC1RXCLK_dly,PHYEMAC1RXER_PHYEMAC1GTXCLK_dly,PHYEMAC1RXER_PHYEMAC1RXCLK_dly,PHYEMAC1RXLOSSOFSYNC_PHYEMAC1GTXCLK_dly,PHYEMAC1RXLOSSOFSYNC_PHYEMAC1RXCLK_dly,PHYEMAC1RXNOTINTABLE_PHYEMAC1GTXCLK_dly,PHYEMAC1RXNOTINTABLE_PHYEMAC1RXCLK_dly,PHYEMAC1RXRUNDISP_PHYEMAC1GTXCLK_dly,PHYEMAC1RXRUNDISP_PHYEMAC1RXCLK_dly,PHYEMAC1SIGNALDET_PHYEMAC1GTXCLK_dly,PHYEMAC1SIGNALDET_PHYEMAC1RXCLK_dly,PHYEMAC1TXBUFERR_PHYEMAC1GTXCLK_dly,PHYEMAC1TXBUFERR_PHYEMAC1TXGMIIMIICLKIN_dly)
          
              begin
                
              if(abs(tisd_CLIENTEMAC0DCMLOCKED_CLIENTEMAC0TXCLIENTCLKIN) > abs(tisd_CLIENTEMAC0DCMLOCKED_PHYEMAC0TXGMIIMIICLKIN)) then
                CLIENTEMAC0DCMLOCKED_indelay <= CLIENTEMAC0DCMLOCKED_CLIENTEMAC0TXCLIENTCLKIN_dly;
               else
                CLIENTEMAC0DCMLOCKED_indelay <= CLIENTEMAC0DCMLOCKED_PHYEMAC0TXGMIIMIICLKIN_dly;
              end if;
              if(abs(tisd_CLIENTEMAC0PAUSEREQ_CLIENTEMAC0TXCLIENTCLKIN)> abs(tisd_CLIENTEMAC0PAUSEREQ_PHYEMAC0TXGMIIMIICLKIN)) then
                CLIENTEMAC0PAUSEREQ_indelay <= CLIENTEMAC0PAUSEREQ_CLIENTEMAC0TXCLIENTCLKIN_dly;
              else
                CLIENTEMAC0PAUSEREQ_indelay <= CLIENTEMAC0PAUSEREQ_PHYEMAC0TXGMIIMIICLKIN_dly;
              end if;

             CLIENTEMAC0PAUSEVAL_FOR: for i in 15 downto 0 loop
             CLIENTEMAC0PAUSEVAL_IF : if(abs(tisd_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN(i))> abs(tisd_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN(i))) then
                CLIENTEMAC0PAUSEVAL_indelay(i) <= CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_dly(i);
              else
                CLIENTEMAC0PAUSEVAL_indelay(i) <= CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_dly(i);
              end if;
              end loop;
              
              CLIENTEMAC0TXD_FOR: for i in 15 downto 0 loop
              CLIENTEMAC0TXD_IF : if(abs(tisd_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN(i))> abs(tisd_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN(i))) then
                CLIENTEMAC0TXD_indelay(i) <= CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_dly(i);
              else
                CLIENTEMAC0TXD_indelay(i) <= CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_dly(i);
              end if;
             end loop;
              
              if(abs(tisd_CLIENTEMAC0TXDVLD_CLIENTEMAC0TXCLIENTCLKIN)> abs(tisd_CLIENTEMAC0TXDVLD_PHYEMAC0TXGMIIMIICLKIN)) then
                CLIENTEMAC0TXDVLD_indelay <= CLIENTEMAC0TXDVLD_CLIENTEMAC0TXCLIENTCLKIN_dly;
              else
                CLIENTEMAC0TXDVLD_indelay <= CLIENTEMAC0TXDVLD_PHYEMAC0TXGMIIMIICLKIN_dly;
              end if;
              if(abs(tisd_CLIENTEMAC0TXDVLDMSW_CLIENTEMAC0TXCLIENTCLKIN) > abs(tisd_CLIENTEMAC0TXDVLDMSW_PHYEMAC0TXGMIIMIICLKIN)) then
                CLIENTEMAC0TXDVLDMSW_indelay <= CLIENTEMAC0TXDVLDMSW_CLIENTEMAC0TXCLIENTCLKIN_dly;
              else
                CLIENTEMAC0TXDVLDMSW_indelay <= CLIENTEMAC0TXDVLDMSW_PHYEMAC0TXGMIIMIICLKIN_dly;
              end if;
              if(abs(tisd_CLIENTEMAC0TXFIRSTBYTE_CLIENTEMAC0TXCLIENTCLKIN)> abs(tisd_CLIENTEMAC0TXFIRSTBYTE_PHYEMAC0TXGMIIMIICLKIN)) then
                CLIENTEMAC0TXFIRSTBYTE_indelay <= CLIENTEMAC0TXFIRSTBYTE_CLIENTEMAC0TXCLIENTCLKIN_dly;
              else
                CLIENTEMAC0TXFIRSTBYTE_indelay <= CLIENTEMAC0TXFIRSTBYTE_PHYEMAC0TXGMIIMIICLKIN_dly;
              end if;

              CLIENTEMAC0TXIFGDELAY_FOR: for i in 7 downto 0 loop
              CLIENTEMAC0TXIFGDELAY_IF :  if(abs(tisd_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN(i))> abs(tisd_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN(i))) then
                CLIENTEMAC0TXIFGDELAY_indelay(i) <= CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_dly(i);
              else
                CLIENTEMAC0TXIFGDELAY_indelay(i) <= CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_dly(i);
              end if;
              end loop;
              
              if(abs(tisd_CLIENTEMAC0TXUNDERRUN_CLIENTEMAC0TXCLIENTCLKIN)> abs(tisd_CLIENTEMAC0TXUNDERRUN_PHYEMAC0TXGMIIMIICLKIN)) then
                CLIENTEMAC0TXUNDERRUN_indelay <= CLIENTEMAC0TXUNDERRUN_CLIENTEMAC0TXCLIENTCLKIN_dly;
              else
                CLIENTEMAC0TXUNDERRUN_indelay <= CLIENTEMAC0TXUNDERRUN_PHYEMAC0TXGMIIMIICLKIN_dly;
              end if;
              if(abs(tisd_CLIENTEMAC1DCMLOCKED_CLIENTEMAC1TXCLIENTCLKIN)> abs(tisd_CLIENTEMAC1DCMLOCKED_PHYEMAC1TXGMIIMIICLKIN)) then
                CLIENTEMAC1DCMLOCKED_indelay <= CLIENTEMAC1DCMLOCKED_CLIENTEMAC1TXCLIENTCLKIN_dly;
              else
                CLIENTEMAC1DCMLOCKED_indelay <= CLIENTEMAC1DCMLOCKED_PHYEMAC1TXGMIIMIICLKIN_dly;
              end if;
              if(abs(tisd_CLIENTEMAC1PAUSEREQ_CLIENTEMAC1TXCLIENTCLKIN)> abs(tisd_CLIENTEMAC1PAUSEREQ_PHYEMAC1TXGMIIMIICLKIN)) then
                CLIENTEMAC1PAUSEREQ_indelay <= CLIENTEMAC1PAUSEREQ_CLIENTEMAC1TXCLIENTCLKIN_dly;
              else
                CLIENTEMAC1PAUSEREQ_indelay <= CLIENTEMAC1PAUSEREQ_PHYEMAC1TXGMIIMIICLKIN_dly;
              end if;

             CLIENTEMAC1PAUSEVAL_FOR: for i in 15 downto 0 loop
             CLIENTEMAC1PAUSEVAL_IF : 
              if(abs(tisd_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN(i))> abs(tisd_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN(i))) then
                CLIENTEMAC1PAUSEVAL_indelay(i) <= CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_dly(i);
              else
                CLIENTEMAC1PAUSEVAL_indelay(i) <= CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_dly(i);
              end if;
             end loop;

              CLIENTEMAC1TXD_FOR: for i in 15 downto 0 loop
              CLIENTEMAC1TXD_IF :if(abs(tisd_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN(i))> abs(tisd_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN(i))) then
                CLIENTEMAC1TXD_indelay(i) <= CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_dly(i);
              else
                CLIENTEMAC1TXD_indelay(i) <= CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_dly(i);
              end if;
              end loop;
        
              if(abs(tisd_CLIENTEMAC1TXDVLD_CLIENTEMAC1TXCLIENTCLKIN)> abs(tisd_CLIENTEMAC1TXDVLD_PHYEMAC1TXGMIIMIICLKIN)) then
                CLIENTEMAC1TXDVLD_indelay <= CLIENTEMAC1TXDVLD_CLIENTEMAC1TXCLIENTCLKIN_dly;
              else
                CLIENTEMAC1TXDVLD_indelay <= CLIENTEMAC1TXDVLD_PHYEMAC1TXGMIIMIICLKIN_dly;
              end if;
              if(abs(tisd_CLIENTEMAC1TXDVLDMSW_CLIENTEMAC1TXCLIENTCLKIN)> abs(tisd_CLIENTEMAC1TXDVLDMSW_PHYEMAC1TXGMIIMIICLKIN)) then
                CLIENTEMAC1TXDVLDMSW_indelay <= CLIENTEMAC1TXDVLDMSW_CLIENTEMAC1TXCLIENTCLKIN_dly;
              else
                CLIENTEMAC1TXDVLDMSW_indelay <= CLIENTEMAC1TXDVLDMSW_PHYEMAC1TXGMIIMIICLKIN_dly;
              end if;
              if(abs(tisd_CLIENTEMAC1TXFIRSTBYTE_CLIENTEMAC1TXCLIENTCLKIN)> abs(tisd_CLIENTEMAC1TXFIRSTBYTE_PHYEMAC1TXGMIIMIICLKIN)) then
                CLIENTEMAC1TXFIRSTBYTE_indelay <= CLIENTEMAC1TXFIRSTBYTE_CLIENTEMAC1TXCLIENTCLKIN_dly;
              else
                CLIENTEMAC1TXFIRSTBYTE_indelay <= CLIENTEMAC1TXFIRSTBYTE_PHYEMAC1TXGMIIMIICLKIN_dly;
              end if;

              CLIENTEMAC1TXIFGDELAY_FOR: for i in 7 downto 0 loop
              CLIENTEMAC1TXIFGDELAY_IF :
              if(abs(tisd_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN(i))> abs(tisd_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN(i))) then
                CLIENTEMAC1TXIFGDELAY_indelay(i) <= CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_dly(i);
              else
                CLIENTEMAC1TXIFGDELAY_indelay(i) <= CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_dly(i);
              end if;
              end loop;
        
              if(abs(tisd_CLIENTEMAC1TXUNDERRUN_CLIENTEMAC1TXCLIENTCLKIN)> abs(tisd_CLIENTEMAC1TXUNDERRUN_PHYEMAC1TXGMIIMIICLKIN)) then
                CLIENTEMAC1TXUNDERRUN_indelay <= CLIENTEMAC1TXUNDERRUN_CLIENTEMAC1TXCLIENTCLKIN_dly;
              else
                CLIENTEMAC1TXUNDERRUN_indelay <= CLIENTEMAC1TXUNDERRUN_PHYEMAC1TXGMIIMIICLKIN_dly;
              end if;
              
              

              if(abs(tisd_PHYEMAC0COL_PHYEMAC0GTXCLK)> abs(tisd_PHYEMAC0COL_PHYEMAC0RXCLK)) then
                PHYEMAC0COL_indelay <= PHYEMAC0COL_PHYEMAC0GTXCLK_dly;
              else
                PHYEMAC0COL_indelay <= PHYEMAC0COL_PHYEMAC0RXCLK_dly;
              end if;
              if(abs(tisd_PHYEMAC0CRS_PHYEMAC0GTXCLK)> abs(tisd_PHYEMAC0CRS_PHYEMAC0RXCLK)) then
                PHYEMAC0CRS_indelay <= PHYEMAC0CRS_PHYEMAC0GTXCLK_dly;
              else
                PHYEMAC0CRS_indelay <= PHYEMAC0CRS_PHYEMAC0RXCLK_dly;
              end if;
              if(abs(tisd_PHYEMAC0MDIN_HOSTCLK)> abs(tisd_PHYEMAC0MDIN_PHYEMAC0MCLKIN)) then
                PHYEMAC0MDIN_indelay <= PHYEMAC0MDIN_HOSTCLK_dly;
              else
                PHYEMAC0MDIN_indelay <= PHYEMAC0MDIN_PHYEMAC0MCLKIN_dly;
              end if;

              if(abs(tisd_PHYEMAC0RXBUFERR_PHYEMAC0GTXCLK)> abs(tisd_PHYEMAC0RXBUFERR_PHYEMAC0RXCLK)) then
                PHYEMAC0RXBUFERR_indelay <= PHYEMAC0RXBUFERR_PHYEMAC0GTXCLK_dly;
              else
                PHYEMAC0RXBUFERR_indelay <= PHYEMAC0RXBUFERR_PHYEMAC0RXCLK_dly;
              end if;

              PHYEMAC0RXBUFSTATUS_FOR: for i in 1 downto 0 loop
              PHYEMAC0RXBUFSTATUS_IF :
              if(abs(tisd_PHYEMAC0RXBUFSTATUS_PHYEMAC0GTXCLK(i))> abs(tisd_PHYEMAC0RXBUFSTATUS_PHYEMAC0RXCLK(i))) then
                 PHYEMAC0RXBUFSTATUS_indelay(i) <= PHYEMAC0RXBUFSTATUS_PHYEMAC0GTXCLK_dly(i);
              else
                PHYEMAC0RXBUFSTATUS_indelay(i) <= PHYEMAC0RXBUFSTATUS_PHYEMAC0RXCLK_dly(i);
              end if;
              end loop;

              if(abs(tisd_PHYEMAC0RXCHARISCOMMA_PHYEMAC0GTXCLK)> abs(tisd_PHYEMAC0RXCHARISCOMMA_PHYEMAC0RXCLK)) then
                PHYEMAC0RXCHARISCOMMA_indelay <= PHYEMAC0RXCHARISCOMMA_PHYEMAC0GTXCLK_dly;
              else
                PHYEMAC0RXCHARISCOMMA_indelay <= PHYEMAC0RXCHARISCOMMA_PHYEMAC0RXCLK_dly;
              end if;
              if(abs(tisd_PHYEMAC0RXCHARISK_PHYEMAC0GTXCLK)> abs(tisd_PHYEMAC0RXCHARISK_PHYEMAC0RXCLK)) then
                PHYEMAC0RXCHARISK_indelay <= PHYEMAC0RXCHARISK_PHYEMAC0GTXCLK_dly;
              else
                PHYEMAC0RXCHARISK_indelay <= PHYEMAC0RXCHARISK_PHYEMAC0RXCLK_dly;
              end if;
              if(abs(tisd_PHYEMAC0RXCHECKINGCRC_PHYEMAC0GTXCLK)> abs(tisd_PHYEMAC0RXCHECKINGCRC_PHYEMAC0RXCLK)) then
                PHYEMAC0RXCHECKINGCRC_indelay <= PHYEMAC0RXCHECKINGCRC_PHYEMAC0GTXCLK_dly;
              else
                PHYEMAC0RXCHECKINGCRC_indelay <= PHYEMAC0RXCHECKINGCRC_PHYEMAC0RXCLK_dly;
              end if;
              PHYEMAC0RXCLKCORCNT_FOR: for i in 2 downto 0 loop
              PHYEMAC0RXCLKCORCNT_IF :
              if(abs(tisd_PHYEMAC0RXCLKCORCNT_PHYEMAC0GTXCLK(i))> abs(tisd_PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK(i))) then
                PHYEMAC0RXCLKCORCNT_indelay(i) <= PHYEMAC0RXCLKCORCNT_PHYEMAC0GTXCLK_dly(i);
              else
                PHYEMAC0RXCLKCORCNT_indelay(i) <= PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK_dly(i);
              end if;
              end loop;
              if(abs(tisd_PHYEMAC0RXCOMMADET_PHYEMAC0GTXCLK)> abs(tisd_PHYEMAC0RXCOMMADET_PHYEMAC0RXCLK)) then
                PHYEMAC0RXCOMMADET_indelay <= PHYEMAC0RXCOMMADET_PHYEMAC0GTXCLK_dly;
              else
                PHYEMAC0RXCOMMADET_indelay <= PHYEMAC0RXCOMMADET_PHYEMAC0RXCLK_dly;
              end if;
              PHYEMAC0RXD_FOR: for i in 7 downto 0 loop
              PHYEMAC0RXD_IF :
              if(abs(tisd_PHYEMAC0RXD_PHYEMAC0GTXCLK(i))> abs(tisd_PHYEMAC0RXD_PHYEMAC0RXCLK(i))) then
                PHYEMAC0RXD_indelay(i) <= PHYEMAC0RXD_PHYEMAC0GTXCLK_dly(i);
              else
                PHYEMAC0RXD_indelay(i) <= PHYEMAC0RXD_PHYEMAC0RXCLK_dly(i);
              end if;
              end loop;
              if(abs(tisd_PHYEMAC0RXDISPERR_PHYEMAC0GTXCLK)> abs(tisd_PHYEMAC0RXDISPERR_PHYEMAC0RXCLK)) then
                PHYEMAC0RXDISPERR_indelay <= PHYEMAC0RXDISPERR_PHYEMAC0GTXCLK_dly;
              else
                PHYEMAC0RXDISPERR_indelay <= PHYEMAC0RXDISPERR_PHYEMAC0RXCLK_dly;
              end if;
              if(abs(tisd_PHYEMAC0RXDV_PHYEMAC0GTXCLK)> abs(tisd_PHYEMAC0RXDV_PHYEMAC0RXCLK)) then
                PHYEMAC0RXDV_indelay <= PHYEMAC0RXDV_PHYEMAC0GTXCLK_dly;
              else
                PHYEMAC0RXDV_indelay <= PHYEMAC0RXDV_PHYEMAC0RXCLK_dly;
              end if;
              if(abs(tisd_PHYEMAC0RXER_PHYEMAC0GTXCLK)> abs(tisd_PHYEMAC0RXER_PHYEMAC0RXCLK)) then
                PHYEMAC0RXER_indelay <= PHYEMAC0RXER_PHYEMAC0GTXCLK_dly;
              else
                PHYEMAC0RXER_indelay <= PHYEMAC0RXER_PHYEMAC0RXCLK_dly;
              end if;
              PHYEMAC0RXLOSSOFSYNC_FOR: for i in 1 downto 0 loop
              PHYEMAC0RXLOSSOFSYNC_IF :
              if(abs(tisd_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0GTXCLK(i))> abs(tisd_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0RXCLK(i))) then
                PHYEMAC0RXLOSSOFSYNC_indelay(i) <= PHYEMAC0RXLOSSOFSYNC_PHYEMAC0GTXCLK_dly(i);
              else
                PHYEMAC0RXLOSSOFSYNC_indelay(i) <= PHYEMAC0RXLOSSOFSYNC_PHYEMAC0RXCLK_dly(i);
              end if;
              end loop;
              if(abs(tisd_PHYEMAC0RXNOTINTABLE_PHYEMAC0GTXCLK)> abs(tisd_PHYEMAC0RXNOTINTABLE_PHYEMAC0RXCLK)) then
                PHYEMAC0RXNOTINTABLE_indelay <= PHYEMAC0RXNOTINTABLE_PHYEMAC0GTXCLK_dly;
              else
                PHYEMAC0RXNOTINTABLE_indelay <= PHYEMAC0RXNOTINTABLE_PHYEMAC0RXCLK_dly;
              end if;
              if(abs(tisd_PHYEMAC0RXRUNDISP_PHYEMAC0GTXCLK)> abs(tisd_PHYEMAC0RXRUNDISP_PHYEMAC0RXCLK)) then
                PHYEMAC0RXRUNDISP_indelay <= PHYEMAC0RXRUNDISP_PHYEMAC0GTXCLK_dly;
              else
                PHYEMAC0RXRUNDISP_indelay <= PHYEMAC0RXRUNDISP_PHYEMAC0RXCLK_dly;
              end if;
              if(abs(tisd_PHYEMAC0SIGNALDET_PHYEMAC0GTXCLK)> abs(tisd_PHYEMAC0SIGNALDET_PHYEMAC0RXCLK)) then
                PHYEMAC0SIGNALDET_indelay <= PHYEMAC0SIGNALDET_PHYEMAC0GTXCLK_dly;
              else
                PHYEMAC0SIGNALDET_indelay <= PHYEMAC0SIGNALDET_PHYEMAC0RXCLK_dly;
              end if;
              if(abs(tisd_PHYEMAC0TXBUFERR_PHYEMAC0GTXCLK)> abs(tisd_PHYEMAC0TXBUFERR_PHYEMAC0TXGMIIMIICLKIN)) then
                PHYEMAC0TXBUFERR_indelay <= PHYEMAC0TXBUFERR_PHYEMAC0GTXCLK_dly;
              else
                PHYEMAC0TXBUFERR_indelay <= PHYEMAC0TXBUFERR_PHYEMAC0TXGMIIMIICLKIN_dly;
              end if;
              if(abs(tisd_PHYEMAC1COL_PHYEMAC1GTXCLK)> abs(tisd_PHYEMAC1COL_PHYEMAC1RXCLK)) then
                PHYEMAC1COL_indelay <= PHYEMAC1COL_PHYEMAC1GTXCLK_dly;
              else
                PHYEMAC1COL_indelay <= PHYEMAC1COL_PHYEMAC1RXCLK_dly;
              end if;
              if(abs(tisd_PHYEMAC1CRS_PHYEMAC1GTXCLK)> abs(tisd_PHYEMAC1CRS_PHYEMAC1RXCLK)) then
                PHYEMAC1CRS_indelay <= PHYEMAC1CRS_PHYEMAC1GTXCLK_dly;
              else
                PHYEMAC1CRS_indelay <= PHYEMAC1CRS_PHYEMAC1RXCLK_dly;
              end if;
              if(abs(tisd_PHYEMAC1MDIN_HOSTCLK)> abs(tisd_PHYEMAC1MDIN_PHYEMAC1MCLKIN)) then
                PHYEMAC1MDIN_indelay <= PHYEMAC1MDIN_HOSTCLK_dly;
              else
                PHYEMAC1MDIN_indelay <= PHYEMAC1MDIN_PHYEMAC1MCLKIN_dly;
              end if;

              

              if(abs(tisd_PHYEMAC1RXBUFERR_PHYEMAC1GTXCLK)> abs(tisd_PHYEMAC1RXBUFERR_PHYEMAC1RXCLK)) then
                PHYEMAC1RXBUFERR_indelay <= PHYEMAC1RXBUFERR_PHYEMAC1GTXCLK_dly;
              else
                PHYEMAC1RXBUFERR_indelay <= PHYEMAC1RXBUFERR_PHYEMAC1RXCLK_dly;
              end if;
              PHYEMAC1RXBUFSTATUS_FOR: for i in 1 downto 0 loop
              PHYEMAC1RXBUFSTATUS_IF :
              if(abs(tisd_PHYEMAC1RXBUFSTATUS_PHYEMAC1GTXCLK(i)) > abs(tisd_PHYEMAC1RXBUFSTATUS_PHYEMAC1RXCLK(i))) then
                PHYEMAC1RXBUFSTATUS_indelay(i) <= PHYEMAC1RXBUFSTATUS_PHYEMAC1GTXCLK_dly(i);
              else
                PHYEMAC1RXBUFSTATUS_indelay(i) <= PHYEMAC1RXBUFSTATUS_PHYEMAC1RXCLK_dly(i);
              end if;
              end loop;
              if(abs(tisd_PHYEMAC1RXCHARISCOMMA_PHYEMAC1GTXCLK) > abs(tisd_PHYEMAC1RXCHARISCOMMA_PHYEMAC1RXCLK)) then
                PHYEMAC1RXCHARISCOMMA_indelay <= PHYEMAC1RXCHARISCOMMA_PHYEMAC1GTXCLK_dly;
              else
                PHYEMAC1RXCHARISCOMMA_indelay <= PHYEMAC1RXCHARISCOMMA_PHYEMAC1RXCLK_dly;
              end if;
              if(abs(tisd_PHYEMAC1RXCHARISK_PHYEMAC1GTXCLK) > abs(tisd_PHYEMAC1RXCHARISK_PHYEMAC1RXCLK)) then
                PHYEMAC1RXCHARISK_indelay <= PHYEMAC1RXCHARISK_PHYEMAC1GTXCLK_dly;
              else
                PHYEMAC1RXCHARISK_indelay <= PHYEMAC1RXCHARISK_PHYEMAC1RXCLK_dly;
              end if;
              if(abs(tisd_PHYEMAC1RXCHECKINGCRC_PHYEMAC1GTXCLK) > abs(tisd_PHYEMAC1RXCHECKINGCRC_PHYEMAC1RXCLK)) then
                PHYEMAC1RXCHECKINGCRC_indelay <= PHYEMAC1RXCHECKINGCRC_PHYEMAC1GTXCLK_dly;
              else
                PHYEMAC1RXCHECKINGCRC_indelay <= PHYEMAC1RXCHECKINGCRC_PHYEMAC1RXCLK_dly;
              end if;
              PHYEMAC1RXCLKCORCNT_FOR: for i in 2 downto 0 loop
              PHYEMAC1RXCLKCORCNT_IF :
              if(abs(tisd_PHYEMAC1RXCLKCORCNT_PHYEMAC1GTXCLK(i)) > abs(tisd_PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK(i))) then
                PHYEMAC1RXCLKCORCNT_indelay(i) <= PHYEMAC1RXCLKCORCNT_PHYEMAC1GTXCLK_dly(i);
              else
                PHYEMAC1RXCLKCORCNT_indelay(i) <= PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK_dly(i);
              end if;
              end loop;
              if(abs(tisd_PHYEMAC1RXCOMMADET_PHYEMAC1GTXCLK) > abs(tisd_PHYEMAC1RXCOMMADET_PHYEMAC1RXCLK)) then
                PHYEMAC1RXCOMMADET_indelay <= PHYEMAC1RXCOMMADET_PHYEMAC1GTXCLK_dly;
              else
                PHYEMAC1RXCOMMADET_indelay <= PHYEMAC1RXCOMMADET_PHYEMAC1RXCLK_dly;
              end if;

              PHYEMAC1RXD_FOR: for i in 7 downto 0 loop
              PHYEMAC1RXD_IF :
              if(abs(tisd_PHYEMAC1RXD_PHYEMAC1GTXCLK(i)) > abs(tisd_PHYEMAC1RXD_PHYEMAC1RXCLK(i)))then
                PHYEMAC1RXD_indelay(i) <= PHYEMAC1RXD_PHYEMAC1GTXCLK_dly(i);
              else
                PHYEMAC1RXD_indelay(i) <= PHYEMAC1RXD_PHYEMAC1RXCLK_dly(i);
              end if;
              end loop;
              if(abs(tisd_PHYEMAC1RXDISPERR_PHYEMAC1GTXCLK) > abs(tisd_PHYEMAC1RXDISPERR_PHYEMAC1RXCLK)) then
                PHYEMAC1RXDISPERR_indelay <= PHYEMAC1RXDISPERR_PHYEMAC1GTXCLK_dly;
              else
                PHYEMAC1RXDISPERR_indelay <= PHYEMAC1RXDISPERR_PHYEMAC1RXCLK_dly;
              end if;
              if(abs(tisd_PHYEMAC1RXDV_PHYEMAC1GTXCLK) > abs(tisd_PHYEMAC1RXDV_PHYEMAC1RXCLK)) then
                PHYEMAC1RXDV_indelay <= PHYEMAC1RXDV_PHYEMAC1GTXCLK_dly;
              else
                PHYEMAC1RXDV_indelay <= PHYEMAC1RXDV_PHYEMAC1RXCLK_dly;
              end if;
              if(abs(tisd_PHYEMAC1RXER_PHYEMAC1GTXCLK) > abs(tisd_PHYEMAC1RXER_PHYEMAC1RXCLK)) then
                PHYEMAC1RXER_indelay <= PHYEMAC1RXER_PHYEMAC1GTXCLK_dly;
              else
                PHYEMAC1RXER_indelay <= PHYEMAC1RXER_PHYEMAC1RXCLK_dly;
              end if;
              PHYEMAC1RXLOSSOFSYNC_FOR: for i in 1 downto 0 loop
              PHYEMAC1RXLOSSOFSYNC_IF :
              if(abs(tisd_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1GTXCLK(i)) > abs(tisd_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1RXCLK(i))) then
                PHYEMAC1RXLOSSOFSYNC_indelay(i) <= PHYEMAC1RXLOSSOFSYNC_PHYEMAC1GTXCLK_dly(i);
              else
                PHYEMAC1RXLOSSOFSYNC_indelay(i) <= PHYEMAC1RXLOSSOFSYNC_PHYEMAC1RXCLK_dly(i);
              end if;
              end loop;
              if(abs(tisd_PHYEMAC1RXNOTINTABLE_PHYEMAC1GTXCLK) > abs(tisd_PHYEMAC1RXNOTINTABLE_PHYEMAC1RXCLK)) then
                PHYEMAC1RXNOTINTABLE_indelay <= PHYEMAC1RXNOTINTABLE_PHYEMAC1GTXCLK_dly;
              else
                PHYEMAC1RXNOTINTABLE_indelay <= PHYEMAC1RXNOTINTABLE_PHYEMAC1RXCLK_dly;
              end if;
              if(abs(tisd_PHYEMAC1RXRUNDISP_PHYEMAC1GTXCLK) > abs(tisd_PHYEMAC1RXRUNDISP_PHYEMAC1RXCLK))then
                PHYEMAC1RXRUNDISP_indelay <= PHYEMAC1RXRUNDISP_PHYEMAC1GTXCLK_dly;
              else
                PHYEMAC1RXRUNDISP_indelay <= PHYEMAC1RXRUNDISP_PHYEMAC1RXCLK_dly;
              end if;
              if(abs(tisd_PHYEMAC1SIGNALDET_PHYEMAC1GTXCLK) > abs(tisd_PHYEMAC1SIGNALDET_PHYEMAC1RXCLK))then
                PHYEMAC1SIGNALDET_indelay <= PHYEMAC1SIGNALDET_PHYEMAC1GTXCLK_dly;
              else
                PHYEMAC1SIGNALDET_indelay <= PHYEMAC1SIGNALDET_PHYEMAC1RXCLK_dly;
              end if;
              if(abs(tisd_PHYEMAC1TXBUFERR_PHYEMAC1GTXCLK)> abs(tisd_PHYEMAC1TXBUFERR_PHYEMAC1TXGMIIMIICLKIN)) then
                PHYEMAC1TXBUFERR_indelay <= PHYEMAC1TXBUFERR_PHYEMAC1GTXCLK_dly;
              else
                PHYEMAC1TXBUFERR_indelay <= PHYEMAC1TXBUFERR_PHYEMAC1TXGMIIMIICLKIN_dly;
              end if;

              
        end process SELECTPROC;
       
        PHYEMAC0MIITXCLK_dly <= PHYEMAC0MIITXCLK_ipd;
        PHYEMAC1MIITXCLK_dly <= PHYEMAC1MIITXCLK_ipd;

        --Input ports sensitive to single clock
        DCREMACABUS_indelay <= DCREMACABUS_DCREMACCLK_dly;
        DCREMACDBUS_indelay <= DCREMACDBUS_DCREMACCLK_dly;
        DCREMACENABLE_indelay <= DCREMACENABLE_DCREMACCLK_dly;
        DCREMACREAD_indelay <= DCREMACREAD_DCREMACCLK_dly;
        DCREMACWRITE_indelay <= DCREMACWRITE_DCREMACCLK_dly;
        HOSTADDR_indelay <= HOSTADDR_HOSTCLK_dly;
        HOSTEMAC1SEL_indelay <= HOSTEMAC1SEL_HOSTCLK_dly;
        HOSTMIIMSEL_indelay <= HOSTMIIMSEL_HOSTCLK_dly;
        HOSTOPCODE_indelay <= HOSTOPCODE_HOSTCLK_dly;
        HOSTREQ_indelay <= HOSTREQ_HOSTCLK_dly;
        HOSTWRDATA_indelay <= HOSTWRDATA_HOSTCLK_dly;
        PHYEMAC0PHYAD_indelay <= PHYEMAC0PHYAD_HOSTCLK_dly;
        PHYEMAC1PHYAD_indelay <= PHYEMAC1PHYAD_HOSTCLK_dly;

        RESET_indelay <= RESET_ipd;

--        RESET_indelay <= RESET_HOSTCLK_dly;
--        RESET_indelay <= RESET_CLIENTEMAC0TXCLIENTCLKIN_dly;
--        RESET_indelay <= RESET_CLIENTEMAC1TXCLIENTCLKIN_dly;
--        RESET_indelay <= RESET_PHYEMAC0TXGMIIMIICLKIN_dly;
--        RESET_indelay <= RESET_PHYEMAC1TXGMIIMIICLKIN_dly;
--        RESET_indelay <= RESET_PHYEMAC0GTXCLK_dly;
--        RESET_indelay <= RESET_PHYEMAC1GTXCLK_dly;
        


      CLIENTEMAC0RXCLIENTCLKIN_dly <= CLIENTEMAC0RXCLIENTCLKIN_ipd;
      CLIENTEMAC1RXCLIENTCLKIN_dly <= CLIENTEMAC1RXCLIENTCLKIN_ipd;
  --    PHYEMAC0MCLKIN_dly <= PHYEMAC0MCLKIN_ipd;
  --    PHYEMAC0RXCLK_dly <= PHYEMAC0RXCLK_ipd;
  --    PHYEMAC0TXGMIIMIICLKIN_dly <= PHYEMAC0TXGMIIMIICLKIN_ipd;
  --    PHYEMAC1MCLKIN_dly <= PHYEMAC1MCLKIN_ipd;
  --    PHYEMAC1RXCLK_dly <= PHYEMAC1RXCLK_ipd;
  --    PHYEMAC1TXGMIIMIICLKIN_dly <= PHYEMAC1TXGMIIMIICLKIN_ipd;

        
        EMAC0CLIENTRXCLIENTCLKOUT_out <= EMAC0CLIENTRXCLIENTCLKOUT_outdelay after CLK_DELAY;
        EMAC0CLIENTTXCLIENTCLKOUT_out <= EMAC0CLIENTTXCLIENTCLKOUT_outdelay after CLK_DELAY;
        EMAC0PHYMCLKOUT_out <= EMAC0PHYMCLKOUT_outdelay after CLK_DELAY;
        EMAC0PHYTXCLK_out <= EMAC0PHYTXCLK_outdelay after CLK_DELAY;
        EMAC0PHYTXGMIIMIICLKOUT_out <= EMAC0PHYTXGMIIMIICLKOUT_outdelay after CLK_DELAY;
        EMAC1CLIENTRXCLIENTCLKOUT_out <= EMAC1CLIENTRXCLIENTCLKOUT_outdelay after CLK_DELAY;
        EMAC1CLIENTTXCLIENTCLKOUT_out <= EMAC1CLIENTTXCLIENTCLKOUT_outdelay after CLK_DELAY;
        EMAC1PHYMCLKOUT_out <= EMAC1PHYMCLKOUT_outdelay after CLK_DELAY;
        EMAC1PHYTXCLK_out <= EMAC1PHYTXCLK_outdelay after CLK_DELAY;
        EMAC1PHYTXGMIIMIICLKOUT_out <= EMAC1PHYTXGMIIMIICLKOUT_outdelay after CLK_DELAY;
        
        DCRHOSTDONEIR_out <= DCRHOSTDONEIR_outdelay after OUT_DELAY;
        EMAC0CLIENTANINTERRUPT_out <= EMAC0CLIENTANINTERRUPT_outdelay after OUT_DELAY;
        EMAC0CLIENTRXBADFRAME_out <= EMAC0CLIENTRXBADFRAME_outdelay after OUT_DELAY;
        EMAC0CLIENTRXDVLDMSW_out <= EMAC0CLIENTRXDVLDMSW_outdelay after OUT_DELAY;
        EMAC0CLIENTRXDVLD_out <= EMAC0CLIENTRXDVLD_outdelay after OUT_DELAY;
        EMAC0CLIENTRXD_out <= EMAC0CLIENTRXD_outdelay after OUT_DELAY;
        EMAC0CLIENTRXFRAMEDROP_out <= EMAC0CLIENTRXFRAMEDROP_outdelay after OUT_DELAY;
        EMAC0CLIENTRXGOODFRAME_out <= EMAC0CLIENTRXGOODFRAME_outdelay after OUT_DELAY;
        EMAC0CLIENTRXSTATSBYTEVLD_out <= EMAC0CLIENTRXSTATSBYTEVLD_outdelay after OUT_DELAY;
        EMAC0CLIENTRXSTATSVLD_out <= EMAC0CLIENTRXSTATSVLD_outdelay after OUT_DELAY;
        EMAC0CLIENTRXSTATS_out <= EMAC0CLIENTRXSTATS_outdelay after OUT_DELAY;
        EMAC0CLIENTTXACK_out <= EMAC0CLIENTTXACK_outdelay after OUT_DELAY;
        EMAC0CLIENTTXCOLLISION_out <= EMAC0CLIENTTXCOLLISION_outdelay after OUT_DELAY;
        EMAC0CLIENTTXRETRANSMIT_out <= EMAC0CLIENTTXRETRANSMIT_outdelay after OUT_DELAY;
        EMAC0CLIENTTXSTATSBYTEVLD_out <= EMAC0CLIENTTXSTATSBYTEVLD_outdelay after OUT_DELAY;
        EMAC0CLIENTTXSTATSVLD_out <= EMAC0CLIENTTXSTATSVLD_outdelay after OUT_DELAY;
        EMAC0CLIENTTXSTATS_out <= EMAC0CLIENTTXSTATS_outdelay after OUT_DELAY;
        EMAC0PHYENCOMMAALIGN_out <= EMAC0PHYENCOMMAALIGN_outdelay after OUT_DELAY;
        EMAC0PHYLOOPBACKMSB_out <= EMAC0PHYLOOPBACKMSB_outdelay after OUT_DELAY;
        EMAC0PHYMDOUT_out <= EMAC0PHYMDOUT_outdelay after OUT_DELAY;
        EMAC0PHYMDTRI_out <= EMAC0PHYMDTRI_outdelay after OUT_DELAY;
        EMAC0PHYMGTRXRESET_out <= EMAC0PHYMGTRXRESET_outdelay after OUT_DELAY;
        EMAC0PHYMGTTXRESET_out <= EMAC0PHYMGTTXRESET_outdelay after OUT_DELAY;
        EMAC0PHYPOWERDOWN_out <= EMAC0PHYPOWERDOWN_outdelay after OUT_DELAY;
        EMAC0PHYSYNCACQSTATUS_out <= EMAC0PHYSYNCACQSTATUS_outdelay after OUT_DELAY;
        EMAC0PHYTXCHARDISPMODE_out <= EMAC0PHYTXCHARDISPMODE_outdelay after OUT_DELAY;
        EMAC0PHYTXCHARDISPVAL_out <= EMAC0PHYTXCHARDISPVAL_outdelay after OUT_DELAY;
        EMAC0PHYTXCHARISK_out <= EMAC0PHYTXCHARISK_outdelay after OUT_DELAY;
        EMAC0PHYTXD_out <= EMAC0PHYTXD_outdelay after OUT_DELAY;
        EMAC0PHYTXEN_out <= EMAC0PHYTXEN_outdelay after OUT_DELAY;
        EMAC0PHYTXER_out <= EMAC0PHYTXER_outdelay after OUT_DELAY;
        EMAC0SPEEDIS10100_out <= EMAC0SPEEDIS10100_outdelay after OUT_DELAY;
        EMAC1CLIENTANINTERRUPT_out <= EMAC1CLIENTANINTERRUPT_outdelay after OUT_DELAY;
        EMAC1CLIENTRXBADFRAME_out <= EMAC1CLIENTRXBADFRAME_outdelay after OUT_DELAY;
        EMAC1CLIENTRXDVLDMSW_out <= EMAC1CLIENTRXDVLDMSW_outdelay after OUT_DELAY;
        EMAC1CLIENTRXDVLD_out <= EMAC1CLIENTRXDVLD_outdelay after OUT_DELAY;
        EMAC1CLIENTRXD_out <= EMAC1CLIENTRXD_outdelay after OUT_DELAY;
        EMAC1CLIENTRXFRAMEDROP_out <= EMAC1CLIENTRXFRAMEDROP_outdelay after OUT_DELAY;
        EMAC1CLIENTRXGOODFRAME_out <= EMAC1CLIENTRXGOODFRAME_outdelay after OUT_DELAY;
        EMAC1CLIENTRXSTATSBYTEVLD_out <= EMAC1CLIENTRXSTATSBYTEVLD_outdelay after OUT_DELAY;
        EMAC1CLIENTRXSTATSVLD_out <= EMAC1CLIENTRXSTATSVLD_outdelay after OUT_DELAY;
        EMAC1CLIENTRXSTATS_out <= EMAC1CLIENTRXSTATS_outdelay after OUT_DELAY;
        EMAC1CLIENTTXACK_out <= EMAC1CLIENTTXACK_outdelay after OUT_DELAY;
        EMAC1CLIENTTXCOLLISION_out <= EMAC1CLIENTTXCOLLISION_outdelay after OUT_DELAY;
        EMAC1CLIENTTXRETRANSMIT_out <= EMAC1CLIENTTXRETRANSMIT_outdelay after OUT_DELAY;
        EMAC1CLIENTTXSTATSBYTEVLD_out <= EMAC1CLIENTTXSTATSBYTEVLD_outdelay after OUT_DELAY;
        EMAC1CLIENTTXSTATSVLD_out <= EMAC1CLIENTTXSTATSVLD_outdelay after OUT_DELAY;
        EMAC1CLIENTTXSTATS_out <= EMAC1CLIENTTXSTATS_outdelay after OUT_DELAY;
        EMAC1PHYENCOMMAALIGN_out <= EMAC1PHYENCOMMAALIGN_outdelay after OUT_DELAY;
        EMAC1PHYLOOPBACKMSB_out <= EMAC1PHYLOOPBACKMSB_outdelay after OUT_DELAY;
        EMAC1PHYMDOUT_out <= EMAC1PHYMDOUT_outdelay after OUT_DELAY;
        EMAC1PHYMDTRI_out <= EMAC1PHYMDTRI_outdelay after OUT_DELAY;
        EMAC1PHYMGTRXRESET_out <= EMAC1PHYMGTRXRESET_outdelay after OUT_DELAY;
        EMAC1PHYMGTTXRESET_out <= EMAC1PHYMGTTXRESET_outdelay after OUT_DELAY;
        EMAC1PHYPOWERDOWN_out <= EMAC1PHYPOWERDOWN_outdelay after OUT_DELAY;
        EMAC1PHYSYNCACQSTATUS_out <= EMAC1PHYSYNCACQSTATUS_outdelay after OUT_DELAY;
        EMAC1PHYTXCHARDISPMODE_out <= EMAC1PHYTXCHARDISPMODE_outdelay after OUT_DELAY;
        EMAC1PHYTXCHARDISPVAL_out <= EMAC1PHYTXCHARDISPVAL_outdelay after OUT_DELAY;
        EMAC1PHYTXCHARISK_out <= EMAC1PHYTXCHARISK_outdelay after OUT_DELAY;
        EMAC1PHYTXD_out <= EMAC1PHYTXD_outdelay after OUT_DELAY;
        EMAC1PHYTXEN_out <= EMAC1PHYTXEN_outdelay after OUT_DELAY;
        EMAC1PHYTXER_out <= EMAC1PHYTXER_outdelay after OUT_DELAY;
        EMAC1SPEEDIS10100_out <= EMAC1SPEEDIS10100_outdelay after OUT_DELAY;
        EMACDCRACK_out <= EMACDCRACK_outdelay after OUT_DELAY;
        EMACDCRDBUS_out <= EMACDCRDBUS_outdelay after OUT_DELAY;
        HOSTMIIMRDY_out <= HOSTMIIMRDY_outdelay after OUT_DELAY;
        HOSTRDDATA_out <= HOSTRDDATA_outdelay after OUT_DELAY;
        
        CLIENTEMAC0RXCLIENTCLKIN_indly <= CLIENTEMAC0RXCLIENTCLKIN_dly after CLK_DELAY;
        CLIENTEMAC0TXCLIENTCLKIN_indly <= CLIENTEMAC0TXCLIENTCLKIN_dly after CLK_DELAY;
        CLIENTEMAC1RXCLIENTCLKIN_indly <= CLIENTEMAC1RXCLIENTCLKIN_dly after CLK_DELAY;
        CLIENTEMAC1TXCLIENTCLKIN_indly <= CLIENTEMAC1TXCLIENTCLKIN_dly after CLK_DELAY;
        DCREMACCLK_indly <= DCREMACCLK_dly after CLK_DELAY;
        HOSTCLK_indly <= HOSTCLK_dly after CLK_DELAY;
        PHYEMAC0GTXCLK_indly <= PHYEMAC0GTXCLK_dly after CLK_DELAY;
        PHYEMAC0MCLKIN_indly <= PHYEMAC0MCLKIN_dly after CLK_DELAY;
        PHYEMAC0MIITXCLK_indly <= PHYEMAC0MIITXCLK_dly after EMAC0MIITXCLK_DELAY;
        PHYEMAC0RXCLK_indly <= PHYEMAC0RXCLK_dly after CLK_DELAY;
        PHYEMAC0TXGMIIMIICLKIN_indly <= PHYEMAC0TXGMIIMIICLKIN_dly after CLK_DELAY;
        PHYEMAC1GTXCLK_indly <= PHYEMAC1GTXCLK_dly after CLK_DELAY;
        PHYEMAC1MCLKIN_indly <= PHYEMAC1MCLKIN_dly after CLK_DELAY;
        PHYEMAC1MIITXCLK_indly <= PHYEMAC1MIITXCLK_dly after EMAC1MIITXCLK_DELAY;
        PHYEMAC1RXCLK_indly <= PHYEMAC1RXCLK_dly after CLK_DELAY;
        PHYEMAC1TXGMIIMIICLKIN_indly <= PHYEMAC1TXGMIIMIICLKIN_dly after CLK_DELAY;
        
        CLIENTEMAC0DCMLOCKED_indly <= CLIENTEMAC0DCMLOCKED_indelay after IN_DELAY;
        CLIENTEMAC0PAUSEREQ_indly <= CLIENTEMAC0PAUSEREQ_indelay after IN_DELAY;
        CLIENTEMAC0PAUSEVAL_indly <= CLIENTEMAC0PAUSEVAL_indelay after IN_DELAY;
        CLIENTEMAC0TXDVLDMSW_indly <= CLIENTEMAC0TXDVLDMSW_indelay after IN_DELAY;
        CLIENTEMAC0TXDVLD_indly <= CLIENTEMAC0TXDVLD_indelay after IN_DELAY;
        CLIENTEMAC0TXD_indly <= CLIENTEMAC0TXD_indelay after IN_DELAY;
        CLIENTEMAC0TXFIRSTBYTE_indly <= CLIENTEMAC0TXFIRSTBYTE_indelay after IN_DELAY;
        CLIENTEMAC0TXIFGDELAY_indly <= CLIENTEMAC0TXIFGDELAY_indelay after IN_DELAY;
        CLIENTEMAC0TXUNDERRUN_indly <= CLIENTEMAC0TXUNDERRUN_indelay after IN_DELAY;
        CLIENTEMAC1DCMLOCKED_indly <= CLIENTEMAC1DCMLOCKED_indelay after IN_DELAY;
        CLIENTEMAC1PAUSEREQ_indly <= CLIENTEMAC1PAUSEREQ_indelay after IN_DELAY;
        CLIENTEMAC1PAUSEVAL_indly <= CLIENTEMAC1PAUSEVAL_indelay after IN_DELAY;
        CLIENTEMAC1TXDVLDMSW_indly <= CLIENTEMAC1TXDVLDMSW_indelay after IN_DELAY;
        CLIENTEMAC1TXDVLD_indly <= CLIENTEMAC1TXDVLD_indelay after IN_DELAY;
        CLIENTEMAC1TXD_indly <= CLIENTEMAC1TXD_indelay after IN_DELAY;
        CLIENTEMAC1TXFIRSTBYTE_indly <= CLIENTEMAC1TXFIRSTBYTE_indelay after IN_DELAY;
        CLIENTEMAC1TXIFGDELAY_indly <= CLIENTEMAC1TXIFGDELAY_indelay after IN_DELAY;
        CLIENTEMAC1TXUNDERRUN_indly <= CLIENTEMAC1TXUNDERRUN_indelay after IN_DELAY;
        DCREMACABUS_indly <= DCREMACABUS_indelay after IN_DELAY;
        DCREMACDBUS_indly <= DCREMACDBUS_indelay after IN_DELAY;
        DCREMACENABLE_indly <= DCREMACENABLE_indelay after IN_DELAY;
        DCREMACREAD_indly <= DCREMACREAD_indelay after IN_DELAY;
        DCREMACWRITE_indly <= DCREMACWRITE_indelay after IN_DELAY;
        HOSTADDR_indly <= HOSTADDR_indelay after IN_DELAY;
        HOSTEMAC1SEL_indly <= HOSTEMAC1SEL_indelay after IN_DELAY;
        HOSTMIIMSEL_indly <= HOSTMIIMSEL_indelay after IN_DELAY;
        HOSTOPCODE_indly <= HOSTOPCODE_indelay after IN_DELAY;
        HOSTREQ_indly <= HOSTREQ_indelay after IN_DELAY;
        HOSTWRDATA_indly <= HOSTWRDATA_indelay after IN_DELAY;
        PHYEMAC0COL_indly <= PHYEMAC0COL_indelay after IN_DELAY;
        PHYEMAC0CRS_indly <= PHYEMAC0CRS_indelay after IN_DELAY;
        PHYEMAC0MDIN_indly <= PHYEMAC0MDIN_indelay after IN_DELAY;
        PHYEMAC0PHYAD_indly <= PHYEMAC0PHYAD_indelay after IN_DELAY;
        PHYEMAC0RXBUFERR_indly <= PHYEMAC0RXBUFERR_indelay after IN_DELAY;
        PHYEMAC0RXBUFSTATUS_indly <= PHYEMAC0RXBUFSTATUS_indelay after IN_DELAY;
        PHYEMAC0RXCHARISCOMMA_indly <= PHYEMAC0RXCHARISCOMMA_indelay after IN_DELAY;
        PHYEMAC0RXCHARISK_indly <= PHYEMAC0RXCHARISK_indelay after IN_DELAY;
        PHYEMAC0RXCHECKINGCRC_indly <= PHYEMAC0RXCHECKINGCRC_indelay after IN_DELAY;
        PHYEMAC0RXCLKCORCNT_indly <= PHYEMAC0RXCLKCORCNT_indelay after IN_DELAY;
        PHYEMAC0RXCOMMADET_indly <= PHYEMAC0RXCOMMADET_indelay after IN_DELAY;
        PHYEMAC0RXDISPERR_indly <= PHYEMAC0RXDISPERR_indelay after IN_DELAY;
        PHYEMAC0RXDV_indly <= PHYEMAC0RXDV_indelay after IN_DELAY;
        PHYEMAC0RXD_indly <= PHYEMAC0RXD_indelay after IN_DELAY;
        PHYEMAC0RXER_indly <= PHYEMAC0RXER_indelay after IN_DELAY;
        PHYEMAC0RXLOSSOFSYNC_indly <= PHYEMAC0RXLOSSOFSYNC_indelay after IN_DELAY;
        PHYEMAC0RXNOTINTABLE_indly <= PHYEMAC0RXNOTINTABLE_indelay after IN_DELAY;
        PHYEMAC0RXRUNDISP_indly <= PHYEMAC0RXRUNDISP_indelay after IN_DELAY;
        PHYEMAC0SIGNALDET_indly <= PHYEMAC0SIGNALDET_indelay after IN_DELAY;
        PHYEMAC0TXBUFERR_indly <= PHYEMAC0TXBUFERR_indelay after IN_DELAY;
        PHYEMAC1COL_indly <= PHYEMAC1COL_indelay after IN_DELAY;
        PHYEMAC1CRS_indly <= PHYEMAC1CRS_indelay after IN_DELAY;
        PHYEMAC1MDIN_indly <= PHYEMAC1MDIN_indelay after IN_DELAY;
        PHYEMAC1PHYAD_indly <= PHYEMAC1PHYAD_indelay after IN_DELAY;
        PHYEMAC1RXBUFERR_indly <= PHYEMAC1RXBUFERR_indelay after IN_DELAY;
        PHYEMAC1RXBUFSTATUS_indly <= PHYEMAC1RXBUFSTATUS_indelay after IN_DELAY;
        PHYEMAC1RXCHARISCOMMA_indly <= PHYEMAC1RXCHARISCOMMA_indelay after IN_DELAY;
        PHYEMAC1RXCHARISK_indly <= PHYEMAC1RXCHARISK_indelay after IN_DELAY;
        PHYEMAC1RXCHECKINGCRC_indly <= PHYEMAC1RXCHECKINGCRC_indelay after IN_DELAY;
        PHYEMAC1RXCLKCORCNT_indly <= PHYEMAC1RXCLKCORCNT_indelay after IN_DELAY;
        PHYEMAC1RXCOMMADET_indly <= PHYEMAC1RXCOMMADET_indelay after IN_DELAY;
        PHYEMAC1RXDISPERR_indly <= PHYEMAC1RXDISPERR_indelay after IN_DELAY;
        PHYEMAC1RXDV_indly <= PHYEMAC1RXDV_indelay after IN_DELAY;
        PHYEMAC1RXD_indly <= PHYEMAC1RXD_indelay after IN_DELAY;
        PHYEMAC1RXER_indly <= PHYEMAC1RXER_indelay after IN_DELAY;
        PHYEMAC1RXLOSSOFSYNC_indly <= PHYEMAC1RXLOSSOFSYNC_indelay after IN_DELAY;
        PHYEMAC1RXNOTINTABLE_indly <= PHYEMAC1RXNOTINTABLE_indelay after IN_DELAY;
        PHYEMAC1RXRUNDISP_indly <= PHYEMAC1RXRUNDISP_indelay after IN_DELAY;
        PHYEMAC1SIGNALDET_indly <= PHYEMAC1SIGNALDET_indelay after IN_DELAY;
        PHYEMAC1TXBUFERR_indly <= PHYEMAC1TXBUFERR_indelay after IN_DELAY;
        RESET_indly <= RESET_indelay after IN_DELAY;

	temac_swift_bw_1 : TEMAC_SWIFT
	port map (
	EMAC0_1000BASEX_ENABLE  =>  EMAC0_1000BASEX_ENABLE_BINARY,
	EMAC0_ADDRFILTER_ENABLE  =>  EMAC0_ADDRFILTER_ENABLE_BINARY,
	EMAC0_BYTEPHY  =>  EMAC0_BYTEPHY_BINARY,
	EMAC0_CONFIGVEC_79  =>  EMAC0_CONFIGVEC_79_BINARY,
	EMAC0_DCRBASEADDR  =>  EMAC0_DCRBASEADDR_BINARY,
	EMAC0_GTLOOPBACK  =>  EMAC0_GTLOOPBACK_BINARY,
	EMAC0_HOST_ENABLE  =>  EMAC0_HOST_ENABLE_BINARY,
	EMAC0_LINKTIMERVAL  =>  EMAC0_LINKTIMERVAL_BINARY,
	EMAC0_LTCHECK_DISABLE  =>  EMAC0_LTCHECK_DISABLE_BINARY,
	EMAC0_MDIO_ENABLE  =>  EMAC0_MDIO_ENABLE_BINARY,
	EMAC0_PAUSEADDR  =>  EMAC0_PAUSEADDR_BINARY,
	EMAC0_PHYINITAUTONEG_ENABLE  =>  EMAC0_PHYINITAUTONEG_ENABLE_BINARY,
	EMAC0_PHYISOLATE  =>  EMAC0_PHYISOLATE_BINARY,
	EMAC0_PHYLOOPBACKMSB  =>  EMAC0_PHYLOOPBACKMSB_BINARY,
	EMAC0_PHYPOWERDOWN  =>  EMAC0_PHYPOWERDOWN_BINARY,
	EMAC0_PHYRESET  =>  EMAC0_PHYRESET_BINARY,
	EMAC0_RGMII_ENABLE  =>  EMAC0_RGMII_ENABLE_BINARY,
	EMAC0_RX16BITCLIENT_ENABLE  =>  EMAC0_RX16BITCLIENT_ENABLE_BINARY,
	EMAC0_RXFLOWCTRL_ENABLE  =>  EMAC0_RXFLOWCTRL_ENABLE_BINARY,
	EMAC0_RXHALFDUPLEX  =>  EMAC0_RXHALFDUPLEX_BINARY,
	EMAC0_RXINBANDFCS_ENABLE  =>  EMAC0_RXINBANDFCS_ENABLE_BINARY,
	EMAC0_RXJUMBOFRAME_ENABLE  =>  EMAC0_RXJUMBOFRAME_ENABLE_BINARY,
	EMAC0_RXRESET  =>  EMAC0_RXRESET_BINARY,
	EMAC0_RXVLAN_ENABLE  =>  EMAC0_RXVLAN_ENABLE_BINARY,
	EMAC0_RX_ENABLE  =>  EMAC0_RX_ENABLE_BINARY,
	EMAC0_SGMII_ENABLE  =>  EMAC0_SGMII_ENABLE_BINARY,
	EMAC0_SPEED_LSB  =>  EMAC0_SPEED_LSB_BINARY,
	EMAC0_SPEED_MSB  =>  EMAC0_SPEED_MSB_BINARY,
	EMAC0_TX16BITCLIENT_ENABLE  =>  EMAC0_TX16BITCLIENT_ENABLE_BINARY,
	EMAC0_TXFLOWCTRL_ENABLE  =>  EMAC0_TXFLOWCTRL_ENABLE_BINARY,
	EMAC0_TXHALFDUPLEX  =>  EMAC0_TXHALFDUPLEX_BINARY,
	EMAC0_TXIFGADJUST_ENABLE  =>  EMAC0_TXIFGADJUST_ENABLE_BINARY,
	EMAC0_TXINBANDFCS_ENABLE  =>  EMAC0_TXINBANDFCS_ENABLE_BINARY,
	EMAC0_TXJUMBOFRAME_ENABLE  =>  EMAC0_TXJUMBOFRAME_ENABLE_BINARY,
	EMAC0_TXRESET  =>  EMAC0_TXRESET_BINARY,
	EMAC0_TXVLAN_ENABLE  =>  EMAC0_TXVLAN_ENABLE_BINARY,
	EMAC0_TX_ENABLE  =>  EMAC0_TX_ENABLE_BINARY,
	EMAC0_UNICASTADDR  =>  EMAC0_UNICASTADDR_BINARY,
	EMAC0_UNIDIRECTION_ENABLE  =>  EMAC0_UNIDIRECTION_ENABLE_BINARY,
	EMAC0_USECLKEN  =>  EMAC0_USECLKEN_BINARY,
	EMAC1_1000BASEX_ENABLE  =>  EMAC1_1000BASEX_ENABLE_BINARY,
	EMAC1_ADDRFILTER_ENABLE  =>  EMAC1_ADDRFILTER_ENABLE_BINARY,
	EMAC1_BYTEPHY  =>  EMAC1_BYTEPHY_BINARY,
	EMAC1_CONFIGVEC_79  =>  EMAC1_CONFIGVEC_79_BINARY,
	EMAC1_DCRBASEADDR  =>  EMAC1_DCRBASEADDR_BINARY,
	EMAC1_GTLOOPBACK  =>  EMAC1_GTLOOPBACK_BINARY,
	EMAC1_HOST_ENABLE  =>  EMAC1_HOST_ENABLE_BINARY,
	EMAC1_LINKTIMERVAL  =>  EMAC1_LINKTIMERVAL_BINARY,
	EMAC1_LTCHECK_DISABLE  =>  EMAC1_LTCHECK_DISABLE_BINARY,
	EMAC1_MDIO_ENABLE  =>  EMAC1_MDIO_ENABLE_BINARY,
	EMAC1_PAUSEADDR  =>  EMAC1_PAUSEADDR_BINARY,
	EMAC1_PHYINITAUTONEG_ENABLE  =>  EMAC1_PHYINITAUTONEG_ENABLE_BINARY,
	EMAC1_PHYISOLATE  =>  EMAC1_PHYISOLATE_BINARY,
	EMAC1_PHYLOOPBACKMSB  =>  EMAC1_PHYLOOPBACKMSB_BINARY,
	EMAC1_PHYPOWERDOWN  =>  EMAC1_PHYPOWERDOWN_BINARY,
	EMAC1_PHYRESET  =>  EMAC1_PHYRESET_BINARY,
	EMAC1_RGMII_ENABLE  =>  EMAC1_RGMII_ENABLE_BINARY,
	EMAC1_RX16BITCLIENT_ENABLE  =>  EMAC1_RX16BITCLIENT_ENABLE_BINARY,
	EMAC1_RXFLOWCTRL_ENABLE  =>  EMAC1_RXFLOWCTRL_ENABLE_BINARY,
	EMAC1_RXHALFDUPLEX  =>  EMAC1_RXHALFDUPLEX_BINARY,
	EMAC1_RXINBANDFCS_ENABLE  =>  EMAC1_RXINBANDFCS_ENABLE_BINARY,
	EMAC1_RXJUMBOFRAME_ENABLE  =>  EMAC1_RXJUMBOFRAME_ENABLE_BINARY,
	EMAC1_RXRESET  =>  EMAC1_RXRESET_BINARY,
	EMAC1_RXVLAN_ENABLE  =>  EMAC1_RXVLAN_ENABLE_BINARY,
	EMAC1_RX_ENABLE  =>  EMAC1_RX_ENABLE_BINARY,
	EMAC1_SGMII_ENABLE  =>  EMAC1_SGMII_ENABLE_BINARY,
	EMAC1_SPEED_LSB  =>  EMAC1_SPEED_LSB_BINARY,
	EMAC1_SPEED_MSB  =>  EMAC1_SPEED_MSB_BINARY,
	EMAC1_TX16BITCLIENT_ENABLE  =>  EMAC1_TX16BITCLIENT_ENABLE_BINARY,
	EMAC1_TXFLOWCTRL_ENABLE  =>  EMAC1_TXFLOWCTRL_ENABLE_BINARY,
	EMAC1_TXHALFDUPLEX  =>  EMAC1_TXHALFDUPLEX_BINARY,
	EMAC1_TXIFGADJUST_ENABLE  =>  EMAC1_TXIFGADJUST_ENABLE_BINARY,
	EMAC1_TXINBANDFCS_ENABLE  =>  EMAC1_TXINBANDFCS_ENABLE_BINARY,
	EMAC1_TXJUMBOFRAME_ENABLE  =>  EMAC1_TXJUMBOFRAME_ENABLE_BINARY,
	EMAC1_TXRESET  =>  EMAC1_TXRESET_BINARY,
	EMAC1_TXVLAN_ENABLE  =>  EMAC1_TXVLAN_ENABLE_BINARY,
	EMAC1_TX_ENABLE  =>  EMAC1_TX_ENABLE_BINARY,
	EMAC1_UNICASTADDR  =>  EMAC1_UNICASTADDR_BINARY,
	EMAC1_UNIDIRECTION_ENABLE  =>  EMAC1_UNIDIRECTION_ENABLE_BINARY,
	EMAC1_USECLKEN  =>  EMAC1_USECLKEN_BINARY,
	DCRHOSTDONEIR  =>  DCRHOSTDONEIR_outdelay,
	EMAC0CLIENTANINTERRUPT  =>  EMAC0CLIENTANINTERRUPT_outdelay,
	EMAC0CLIENTRXBADFRAME  =>  EMAC0CLIENTRXBADFRAME_outdelay,
	EMAC0CLIENTRXCLIENTCLKOUT  =>  EMAC0CLIENTRXCLIENTCLKOUT_outdelay,
	EMAC0CLIENTRXD  =>  EMAC0CLIENTRXD_outdelay,
	EMAC0CLIENTRXDVLD  =>  EMAC0CLIENTRXDVLD_outdelay,
	EMAC0CLIENTRXDVLDMSW  =>  EMAC0CLIENTRXDVLDMSW_outdelay,
	EMAC0CLIENTRXFRAMEDROP  =>  EMAC0CLIENTRXFRAMEDROP_outdelay,
	EMAC0CLIENTRXGOODFRAME  =>  EMAC0CLIENTRXGOODFRAME_outdelay,
	EMAC0CLIENTRXSTATS  =>  EMAC0CLIENTRXSTATS_outdelay,
	EMAC0CLIENTRXSTATSBYTEVLD  =>  EMAC0CLIENTRXSTATSBYTEVLD_outdelay,
	EMAC0CLIENTRXSTATSVLD  =>  EMAC0CLIENTRXSTATSVLD_outdelay,
	EMAC0CLIENTTXACK  =>  EMAC0CLIENTTXACK_outdelay,
	EMAC0CLIENTTXCLIENTCLKOUT  =>  EMAC0CLIENTTXCLIENTCLKOUT_outdelay,
	EMAC0CLIENTTXCOLLISION  =>  EMAC0CLIENTTXCOLLISION_outdelay,
	EMAC0CLIENTTXRETRANSMIT  =>  EMAC0CLIENTTXRETRANSMIT_outdelay,
	EMAC0CLIENTTXSTATS  =>  EMAC0CLIENTTXSTATS_outdelay,
	EMAC0CLIENTTXSTATSBYTEVLD  =>  EMAC0CLIENTTXSTATSBYTEVLD_outdelay,
	EMAC0CLIENTTXSTATSVLD  =>  EMAC0CLIENTTXSTATSVLD_outdelay,
	EMAC0PHYENCOMMAALIGN  =>  EMAC0PHYENCOMMAALIGN_outdelay,
	EMAC0PHYLOOPBACKMSB  =>  EMAC0PHYLOOPBACKMSB_outdelay,
	EMAC0PHYMCLKOUT  =>  EMAC0PHYMCLKOUT_outdelay,
	EMAC0PHYMDOUT  =>  EMAC0PHYMDOUT_outdelay,
	EMAC0PHYMDTRI  =>  EMAC0PHYMDTRI_outdelay,
	EMAC0PHYMGTRXRESET  =>  EMAC0PHYMGTRXRESET_outdelay,
	EMAC0PHYMGTTXRESET  =>  EMAC0PHYMGTTXRESET_outdelay,
	EMAC0PHYPOWERDOWN  =>  EMAC0PHYPOWERDOWN_outdelay,
	EMAC0PHYSYNCACQSTATUS  =>  EMAC0PHYSYNCACQSTATUS_outdelay,
	EMAC0PHYTXCHARDISPMODE  =>  EMAC0PHYTXCHARDISPMODE_outdelay,
	EMAC0PHYTXCHARDISPVAL  =>  EMAC0PHYTXCHARDISPVAL_outdelay,
	EMAC0PHYTXCHARISK  =>  EMAC0PHYTXCHARISK_outdelay,
	EMAC0PHYTXCLK  =>  EMAC0PHYTXCLK_outdelay,
	EMAC0PHYTXD  =>  EMAC0PHYTXD_outdelay,
	EMAC0PHYTXEN  =>  EMAC0PHYTXEN_outdelay,
	EMAC0PHYTXER  =>  EMAC0PHYTXER_outdelay,
	EMAC0PHYTXGMIIMIICLKOUT  =>  EMAC0PHYTXGMIIMIICLKOUT_outdelay,
	EMAC0SPEEDIS10100  =>  EMAC0SPEEDIS10100_outdelay,
	EMAC1CLIENTANINTERRUPT  =>  EMAC1CLIENTANINTERRUPT_outdelay,
	EMAC1CLIENTRXBADFRAME  =>  EMAC1CLIENTRXBADFRAME_outdelay,
	EMAC1CLIENTRXCLIENTCLKOUT  =>  EMAC1CLIENTRXCLIENTCLKOUT_outdelay,
	EMAC1CLIENTRXD  =>  EMAC1CLIENTRXD_outdelay,
	EMAC1CLIENTRXDVLD  =>  EMAC1CLIENTRXDVLD_outdelay,
	EMAC1CLIENTRXDVLDMSW  =>  EMAC1CLIENTRXDVLDMSW_outdelay,
	EMAC1CLIENTRXFRAMEDROP  =>  EMAC1CLIENTRXFRAMEDROP_outdelay,
	EMAC1CLIENTRXGOODFRAME  =>  EMAC1CLIENTRXGOODFRAME_outdelay,
	EMAC1CLIENTRXSTATS  =>  EMAC1CLIENTRXSTATS_outdelay,
	EMAC1CLIENTRXSTATSBYTEVLD  =>  EMAC1CLIENTRXSTATSBYTEVLD_outdelay,
	EMAC1CLIENTRXSTATSVLD  =>  EMAC1CLIENTRXSTATSVLD_outdelay,
	EMAC1CLIENTTXACK  =>  EMAC1CLIENTTXACK_outdelay,
	EMAC1CLIENTTXCLIENTCLKOUT  =>  EMAC1CLIENTTXCLIENTCLKOUT_outdelay,
	EMAC1CLIENTTXCOLLISION  =>  EMAC1CLIENTTXCOLLISION_outdelay,
	EMAC1CLIENTTXRETRANSMIT  =>  EMAC1CLIENTTXRETRANSMIT_outdelay,
	EMAC1CLIENTTXSTATS  =>  EMAC1CLIENTTXSTATS_outdelay,
	EMAC1CLIENTTXSTATSBYTEVLD  =>  EMAC1CLIENTTXSTATSBYTEVLD_outdelay,
	EMAC1CLIENTTXSTATSVLD  =>  EMAC1CLIENTTXSTATSVLD_outdelay,
	EMAC1PHYENCOMMAALIGN  =>  EMAC1PHYENCOMMAALIGN_outdelay,
	EMAC1PHYLOOPBACKMSB  =>  EMAC1PHYLOOPBACKMSB_outdelay,
	EMAC1PHYMCLKOUT  =>  EMAC1PHYMCLKOUT_outdelay,
	EMAC1PHYMDOUT  =>  EMAC1PHYMDOUT_outdelay,
	EMAC1PHYMDTRI  =>  EMAC1PHYMDTRI_outdelay,
	EMAC1PHYMGTRXRESET  =>  EMAC1PHYMGTRXRESET_outdelay,
	EMAC1PHYMGTTXRESET  =>  EMAC1PHYMGTTXRESET_outdelay,
	EMAC1PHYPOWERDOWN  =>  EMAC1PHYPOWERDOWN_outdelay,
	EMAC1PHYSYNCACQSTATUS  =>  EMAC1PHYSYNCACQSTATUS_outdelay,
	EMAC1PHYTXCHARDISPMODE  =>  EMAC1PHYTXCHARDISPMODE_outdelay,
	EMAC1PHYTXCHARDISPVAL  =>  EMAC1PHYTXCHARDISPVAL_outdelay,
	EMAC1PHYTXCHARISK  =>  EMAC1PHYTXCHARISK_outdelay,
	EMAC1PHYTXCLK  =>  EMAC1PHYTXCLK_outdelay,
	EMAC1PHYTXD  =>  EMAC1PHYTXD_outdelay,
	EMAC1PHYTXEN  =>  EMAC1PHYTXEN_outdelay,
	EMAC1PHYTXER  =>  EMAC1PHYTXER_outdelay,
	EMAC1PHYTXGMIIMIICLKOUT  =>  EMAC1PHYTXGMIIMIICLKOUT_outdelay,
	EMAC1SPEEDIS10100  =>  EMAC1SPEEDIS10100_outdelay,
	EMACDCRACK  =>  EMACDCRACK_outdelay,
	EMACDCRDBUS  =>  EMACDCRDBUS_outdelay,
	HOSTMIIMRDY  =>  HOSTMIIMRDY_outdelay,
	HOSTRDDATA  =>  HOSTRDDATA_outdelay,
	CLIENTEMAC0DCMLOCKED  =>  CLIENTEMAC0DCMLOCKED_indly,
	CLIENTEMAC0PAUSEREQ  =>  CLIENTEMAC0PAUSEREQ_indly,
	CLIENTEMAC0PAUSEVAL  =>  CLIENTEMAC0PAUSEVAL_indly,
	CLIENTEMAC0RXCLIENTCLKIN  =>  CLIENTEMAC0RXCLIENTCLKIN_indly,
	CLIENTEMAC0TXCLIENTCLKIN  =>  CLIENTEMAC0TXCLIENTCLKIN_indly,
	CLIENTEMAC0TXD  =>  CLIENTEMAC0TXD_indly,
	CLIENTEMAC0TXDVLD  =>  CLIENTEMAC0TXDVLD_indly,
	CLIENTEMAC0TXDVLDMSW  =>  CLIENTEMAC0TXDVLDMSW_indly,
	CLIENTEMAC0TXFIRSTBYTE  =>  CLIENTEMAC0TXFIRSTBYTE_indly,
	CLIENTEMAC0TXIFGDELAY  =>  CLIENTEMAC0TXIFGDELAY_indly,
	CLIENTEMAC0TXUNDERRUN  =>  CLIENTEMAC0TXUNDERRUN_indly,
	CLIENTEMAC1DCMLOCKED  =>  CLIENTEMAC1DCMLOCKED_indly,
	CLIENTEMAC1PAUSEREQ  =>  CLIENTEMAC1PAUSEREQ_indly,
	CLIENTEMAC1PAUSEVAL  =>  CLIENTEMAC1PAUSEVAL_indly,
	CLIENTEMAC1RXCLIENTCLKIN  =>  CLIENTEMAC1RXCLIENTCLKIN_indly,
	CLIENTEMAC1TXCLIENTCLKIN  =>  CLIENTEMAC1TXCLIENTCLKIN_indly,
	CLIENTEMAC1TXD  =>  CLIENTEMAC1TXD_indly,
	CLIENTEMAC1TXDVLD  =>  CLIENTEMAC1TXDVLD_indly,
	CLIENTEMAC1TXDVLDMSW  =>  CLIENTEMAC1TXDVLDMSW_indly,
	CLIENTEMAC1TXFIRSTBYTE  =>  CLIENTEMAC1TXFIRSTBYTE_indly,
	CLIENTEMAC1TXIFGDELAY  =>  CLIENTEMAC1TXIFGDELAY_indly,
	CLIENTEMAC1TXUNDERRUN  =>  CLIENTEMAC1TXUNDERRUN_indly,
	DCREMACABUS  =>  DCREMACABUS_indly,
	DCREMACCLK  =>  DCREMACCLK_indly,
	DCREMACDBUS  =>  DCREMACDBUS_indly,
	DCREMACENABLE  =>  DCREMACENABLE_indly,
	DCREMACREAD  =>  DCREMACREAD_indly,
	DCREMACWRITE  =>  DCREMACWRITE_indly,
	HOSTADDR  =>  HOSTADDR_indly,
	HOSTCLK  =>  HOSTCLK_indly,
	HOSTEMAC1SEL  =>  HOSTEMAC1SEL_indly,
	HOSTMIIMSEL  =>  HOSTMIIMSEL_indly,
	HOSTOPCODE  =>  HOSTOPCODE_indly,
	HOSTREQ  =>  HOSTREQ_indly,
	HOSTWRDATA  =>  HOSTWRDATA_indly,
	PHYEMAC0COL  =>  PHYEMAC0COL_indly,
	PHYEMAC0CRS  =>  PHYEMAC0CRS_indly,
	PHYEMAC0GTXCLK  =>  PHYEMAC0GTXCLK_indly,
	PHYEMAC0MCLKIN  =>  PHYEMAC0MCLKIN_indly,
	PHYEMAC0MDIN  =>  PHYEMAC0MDIN_indly,
	PHYEMAC0MIITXCLK  =>  PHYEMAC0MIITXCLK_indly,
	PHYEMAC0PHYAD  =>  PHYEMAC0PHYAD_indly,
	PHYEMAC0RXBUFERR  =>  PHYEMAC0RXBUFERR_indly,
	PHYEMAC0RXBUFSTATUS  =>  PHYEMAC0RXBUFSTATUS_indly,
	PHYEMAC0RXCHARISCOMMA  =>  PHYEMAC0RXCHARISCOMMA_indly,
	PHYEMAC0RXCHARISK  =>  PHYEMAC0RXCHARISK_indly,
	PHYEMAC0RXCHECKINGCRC  =>  PHYEMAC0RXCHECKINGCRC_indly,
	PHYEMAC0RXCLK  =>  PHYEMAC0RXCLK_indly,
	PHYEMAC0RXCLKCORCNT  =>  PHYEMAC0RXCLKCORCNT_indly,
	PHYEMAC0RXCOMMADET  =>  PHYEMAC0RXCOMMADET_indly,
	PHYEMAC0RXD  =>  PHYEMAC0RXD_indly,
	PHYEMAC0RXDISPERR  =>  PHYEMAC0RXDISPERR_indly,
	PHYEMAC0RXDV  =>  PHYEMAC0RXDV_indly,
	PHYEMAC0RXER  =>  PHYEMAC0RXER_indly,
	PHYEMAC0RXLOSSOFSYNC  =>  PHYEMAC0RXLOSSOFSYNC_indly,
	PHYEMAC0RXNOTINTABLE  =>  PHYEMAC0RXNOTINTABLE_indly,
	PHYEMAC0RXRUNDISP  =>  PHYEMAC0RXRUNDISP_indly,
	PHYEMAC0SIGNALDET  =>  PHYEMAC0SIGNALDET_indly,
	PHYEMAC0TXBUFERR  =>  PHYEMAC0TXBUFERR_indly,
	PHYEMAC0TXGMIIMIICLKIN  =>  PHYEMAC0TXGMIIMIICLKIN_indly,
	PHYEMAC1COL  =>  PHYEMAC1COL_indly,
	PHYEMAC1CRS  =>  PHYEMAC1CRS_indly,
	PHYEMAC1GTXCLK  =>  PHYEMAC1GTXCLK_indly,
	PHYEMAC1MCLKIN  =>  PHYEMAC1MCLKIN_indly,
	PHYEMAC1MDIN  =>  PHYEMAC1MDIN_indly,
	PHYEMAC1MIITXCLK  =>  PHYEMAC1MIITXCLK_indly,
	PHYEMAC1PHYAD  =>  PHYEMAC1PHYAD_indly,
	PHYEMAC1RXBUFERR  =>  PHYEMAC1RXBUFERR_indly,
	PHYEMAC1RXBUFSTATUS  =>  PHYEMAC1RXBUFSTATUS_indly,
	PHYEMAC1RXCHARISCOMMA  =>  PHYEMAC1RXCHARISCOMMA_indly,
	PHYEMAC1RXCHARISK  =>  PHYEMAC1RXCHARISK_indly,
	PHYEMAC1RXCHECKINGCRC  =>  PHYEMAC1RXCHECKINGCRC_indly,
	PHYEMAC1RXCLK  =>  PHYEMAC1RXCLK_indly,
	PHYEMAC1RXCLKCORCNT  =>  PHYEMAC1RXCLKCORCNT_indly,
	PHYEMAC1RXCOMMADET  =>  PHYEMAC1RXCOMMADET_indly,
	PHYEMAC1RXD  =>  PHYEMAC1RXD_indly,
	PHYEMAC1RXDISPERR  =>  PHYEMAC1RXDISPERR_indly,
	PHYEMAC1RXDV  =>  PHYEMAC1RXDV_indly,
	PHYEMAC1RXER  =>  PHYEMAC1RXER_indly,
	PHYEMAC1RXLOSSOFSYNC  =>  PHYEMAC1RXLOSSOFSYNC_indly,
	PHYEMAC1RXNOTINTABLE  =>  PHYEMAC1RXNOTINTABLE_indly,
	PHYEMAC1RXRUNDISP  =>  PHYEMAC1RXRUNDISP_indly,
	PHYEMAC1SIGNALDET  =>  PHYEMAC1SIGNALDET_indly,
	PHYEMAC1TXBUFERR  =>  PHYEMAC1TXBUFERR_indly,
	PHYEMAC1TXGMIIMIICLKIN  =>  PHYEMAC1TXGMIIMIICLKIN_indly,
	RESET  =>  RESET_indly
	);

	INIPROC : process
	begin
       case EMAC0_RXHALFDUPLEX is
           when FALSE   =>  EMAC0_RXHALFDUPLEX_BINARY <= '0';
           when TRUE    =>  EMAC0_RXHALFDUPLEX_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC0_RXHALFDUPLEX is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC0_RXVLAN_ENABLE is
           when FALSE   =>  EMAC0_RXVLAN_ENABLE_BINARY <= '0';
           when TRUE    =>  EMAC0_RXVLAN_ENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC0_RXVLAN_ENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC0_RX_ENABLE is
           when FALSE   =>  EMAC0_RX_ENABLE_BINARY <= '0';
           when TRUE    =>  EMAC0_RX_ENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC0_RX_ENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC0_RXINBANDFCS_ENABLE is
           when FALSE   =>  EMAC0_RXINBANDFCS_ENABLE_BINARY <= '0';
           when TRUE    =>  EMAC0_RXINBANDFCS_ENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC0_RXINBANDFCS_ENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC0_RXJUMBOFRAME_ENABLE is
           when FALSE   =>  EMAC0_RXJUMBOFRAME_ENABLE_BINARY <= '0';
           when TRUE    =>  EMAC0_RXJUMBOFRAME_ENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC0_RXJUMBOFRAME_ENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC0_RXRESET is
           when FALSE   =>  EMAC0_RXRESET_BINARY <= '0';
           when TRUE    =>  EMAC0_RXRESET_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC0_RXRESET is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC0_TXIFGADJUST_ENABLE is
           when FALSE   =>  EMAC0_TXIFGADJUST_ENABLE_BINARY <= '0';
           when TRUE    =>  EMAC0_TXIFGADJUST_ENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC0_TXIFGADJUST_ENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC0_TXHALFDUPLEX is
           when FALSE   =>  EMAC0_TXHALFDUPLEX_BINARY <= '0';
           when TRUE    =>  EMAC0_TXHALFDUPLEX_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC0_TXHALFDUPLEX is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC0_TXVLAN_ENABLE is
           when FALSE   =>  EMAC0_TXVLAN_ENABLE_BINARY <= '0';
           when TRUE    =>  EMAC0_TXVLAN_ENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC0_TXVLAN_ENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC0_TX_ENABLE is
           when FALSE   =>  EMAC0_TX_ENABLE_BINARY <= '0';
           when TRUE    =>  EMAC0_TX_ENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC0_TX_ENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC0_TXINBANDFCS_ENABLE is
           when FALSE   =>  EMAC0_TXINBANDFCS_ENABLE_BINARY <= '0';
           when TRUE    =>  EMAC0_TXINBANDFCS_ENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC0_TXINBANDFCS_ENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC0_TXJUMBOFRAME_ENABLE is
           when FALSE   =>  EMAC0_TXJUMBOFRAME_ENABLE_BINARY <= '0';
           when TRUE    =>  EMAC0_TXJUMBOFRAME_ENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC0_TXJUMBOFRAME_ENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC0_TXRESET is
           when FALSE   =>  EMAC0_TXRESET_BINARY <= '0';
           when TRUE    =>  EMAC0_TXRESET_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC0_TXRESET is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC0_TXFLOWCTRL_ENABLE is
           when FALSE   =>  EMAC0_TXFLOWCTRL_ENABLE_BINARY <= '0';
           when TRUE    =>  EMAC0_TXFLOWCTRL_ENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC0_TXFLOWCTRL_ENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC0_RXFLOWCTRL_ENABLE is
           when FALSE   =>  EMAC0_RXFLOWCTRL_ENABLE_BINARY <= '0';
           when TRUE    =>  EMAC0_RXFLOWCTRL_ENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC0_RXFLOWCTRL_ENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC0_LTCHECK_DISABLE is
           when FALSE   =>  EMAC0_LTCHECK_DISABLE_BINARY <= '0';
           when TRUE    =>  EMAC0_LTCHECK_DISABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC0_LTCHECK_DISABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC0_ADDRFILTER_ENABLE is
           when FALSE   =>  EMAC0_ADDRFILTER_ENABLE_BINARY <= '0';
           when TRUE    =>  EMAC0_ADDRFILTER_ENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC0_ADDRFILTER_ENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC0_RX16BITCLIENT_ENABLE is
           when FALSE   =>  EMAC0_RX16BITCLIENT_ENABLE_BINARY <= '0';
           when TRUE    =>  EMAC0_RX16BITCLIENT_ENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC0_RX16BITCLIENT_ENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC0_TX16BITCLIENT_ENABLE is
           when FALSE   =>  EMAC0_TX16BITCLIENT_ENABLE_BINARY <= '0';
           when TRUE    =>  EMAC0_TX16BITCLIENT_ENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC0_TX16BITCLIENT_ENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC0_HOST_ENABLE is
           when FALSE   =>  EMAC0_HOST_ENABLE_BINARY <= '0';
           when TRUE    =>  EMAC0_HOST_ENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC0_HOST_ENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC0_1000BASEX_ENABLE is
           when FALSE   =>  EMAC0_1000BASEX_ENABLE_BINARY <= '0';
           when TRUE    =>  EMAC0_1000BASEX_ENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC0_1000BASEX_ENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC0_SGMII_ENABLE is
           when FALSE   =>  EMAC0_SGMII_ENABLE_BINARY <= '0';
           when TRUE    =>  EMAC0_SGMII_ENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC0_SGMII_ENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC0_RGMII_ENABLE is
           when FALSE   =>  EMAC0_RGMII_ENABLE_BINARY <= '0';
           when TRUE    =>  EMAC0_RGMII_ENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC0_RGMII_ENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC0_SPEED_LSB is
           when FALSE   =>  EMAC0_SPEED_LSB_BINARY <= '0';
           when TRUE    =>  EMAC0_SPEED_LSB_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC0_SPEED_LSB is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC0_SPEED_MSB is
           when FALSE   =>  EMAC0_SPEED_MSB_BINARY <= '0';
           when TRUE    =>  EMAC0_SPEED_MSB_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC0_SPEED_MSB is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC0_MDIO_ENABLE is
           when FALSE   =>  EMAC0_MDIO_ENABLE_BINARY <= '0';
           when TRUE    =>  EMAC0_MDIO_ENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC0_MDIO_ENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC0_PHYLOOPBACKMSB is
           when FALSE   =>  EMAC0_PHYLOOPBACKMSB_BINARY <= '0';
           when TRUE    =>  EMAC0_PHYLOOPBACKMSB_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC0_PHYLOOPBACKMSB is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC0_PHYPOWERDOWN is
           when FALSE   =>  EMAC0_PHYPOWERDOWN_BINARY <= '0';
           when TRUE    =>  EMAC0_PHYPOWERDOWN_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC0_PHYPOWERDOWN is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC0_PHYISOLATE is
           when FALSE   =>  EMAC0_PHYISOLATE_BINARY <= '0';
           when TRUE    =>  EMAC0_PHYISOLATE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC0_PHYISOLATE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC0_PHYINITAUTONEG_ENABLE is
           when FALSE   =>  EMAC0_PHYINITAUTONEG_ENABLE_BINARY <= '0';
           when TRUE    =>  EMAC0_PHYINITAUTONEG_ENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC0_PHYINITAUTONEG_ENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC0_PHYRESET is
           when FALSE   =>  EMAC0_PHYRESET_BINARY <= '0';
           when TRUE    =>  EMAC0_PHYRESET_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC0_PHYRESET is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC0_CONFIGVEC_79 is
           when FALSE   =>  EMAC0_CONFIGVEC_79_BINARY <= '0';
           when TRUE    =>  EMAC0_CONFIGVEC_79_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC0_CONFIGVEC_79 is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC0_UNIDIRECTION_ENABLE is
           when FALSE   =>  EMAC0_UNIDIRECTION_ENABLE_BINARY <= '0';
           when TRUE    =>  EMAC0_UNIDIRECTION_ENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC0_UNIDIRECTION_ENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC0_GTLOOPBACK is
           when FALSE   =>  EMAC0_GTLOOPBACK_BINARY <= '0';
           when TRUE    =>  EMAC0_GTLOOPBACK_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC0_GTLOOPBACK is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC0_BYTEPHY is
           when FALSE   =>  EMAC0_BYTEPHY_BINARY <= '0';
           when TRUE    =>  EMAC0_BYTEPHY_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC0_BYTEPHY is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC0_USECLKEN is
           when FALSE   =>  EMAC0_USECLKEN_BINARY <= '0';
           when TRUE    =>  EMAC0_USECLKEN_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC0_USECLKEN is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC1_RXHALFDUPLEX is
           when FALSE   =>  EMAC1_RXHALFDUPLEX_BINARY <= '0';
           when TRUE    =>  EMAC1_RXHALFDUPLEX_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC1_RXHALFDUPLEX is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC1_RXVLAN_ENABLE is
           when FALSE   =>  EMAC1_RXVLAN_ENABLE_BINARY <= '0';
           when TRUE    =>  EMAC1_RXVLAN_ENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC1_RXVLAN_ENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC1_RX_ENABLE is
           when FALSE   =>  EMAC1_RX_ENABLE_BINARY <= '0';
           when TRUE    =>  EMAC1_RX_ENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC1_RX_ENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC1_RXINBANDFCS_ENABLE is
           when FALSE   =>  EMAC1_RXINBANDFCS_ENABLE_BINARY <= '0';
           when TRUE    =>  EMAC1_RXINBANDFCS_ENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC1_RXINBANDFCS_ENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC1_RXJUMBOFRAME_ENABLE is
           when FALSE   =>  EMAC1_RXJUMBOFRAME_ENABLE_BINARY <= '0';
           when TRUE    =>  EMAC1_RXJUMBOFRAME_ENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC1_RXJUMBOFRAME_ENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC1_RXRESET is
           when FALSE   =>  EMAC1_RXRESET_BINARY <= '0';
           when TRUE    =>  EMAC1_RXRESET_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC1_RXRESET is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC1_TXIFGADJUST_ENABLE is
           when FALSE   =>  EMAC1_TXIFGADJUST_ENABLE_BINARY <= '0';
           when TRUE    =>  EMAC1_TXIFGADJUST_ENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC1_TXIFGADJUST_ENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC1_TXHALFDUPLEX is
           when FALSE   =>  EMAC1_TXHALFDUPLEX_BINARY <= '0';
           when TRUE    =>  EMAC1_TXHALFDUPLEX_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC1_TXHALFDUPLEX is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC1_TXVLAN_ENABLE is
           when FALSE   =>  EMAC1_TXVLAN_ENABLE_BINARY <= '0';
           when TRUE    =>  EMAC1_TXVLAN_ENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC1_TXVLAN_ENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC1_TX_ENABLE is
           when FALSE   =>  EMAC1_TX_ENABLE_BINARY <= '0';
           when TRUE    =>  EMAC1_TX_ENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC1_TX_ENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC1_TXINBANDFCS_ENABLE is
           when FALSE   =>  EMAC1_TXINBANDFCS_ENABLE_BINARY <= '0';
           when TRUE    =>  EMAC1_TXINBANDFCS_ENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC1_TXINBANDFCS_ENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC1_TXJUMBOFRAME_ENABLE is
           when FALSE   =>  EMAC1_TXJUMBOFRAME_ENABLE_BINARY <= '0';
           when TRUE    =>  EMAC1_TXJUMBOFRAME_ENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC1_TXJUMBOFRAME_ENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC1_TXRESET is
           when FALSE   =>  EMAC1_TXRESET_BINARY <= '0';
           when TRUE    =>  EMAC1_TXRESET_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC1_TXRESET is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC1_TXFLOWCTRL_ENABLE is
           when FALSE   =>  EMAC1_TXFLOWCTRL_ENABLE_BINARY <= '0';
           when TRUE    =>  EMAC1_TXFLOWCTRL_ENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC1_TXFLOWCTRL_ENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC1_RXFLOWCTRL_ENABLE is
           when FALSE   =>  EMAC1_RXFLOWCTRL_ENABLE_BINARY <= '0';
           when TRUE    =>  EMAC1_RXFLOWCTRL_ENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC1_RXFLOWCTRL_ENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC1_LTCHECK_DISABLE is
           when FALSE   =>  EMAC1_LTCHECK_DISABLE_BINARY <= '0';
           when TRUE    =>  EMAC1_LTCHECK_DISABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC1_LTCHECK_DISABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC1_ADDRFILTER_ENABLE is
           when FALSE   =>  EMAC1_ADDRFILTER_ENABLE_BINARY <= '0';
           when TRUE    =>  EMAC1_ADDRFILTER_ENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC1_ADDRFILTER_ENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC1_RX16BITCLIENT_ENABLE is
           when FALSE   =>  EMAC1_RX16BITCLIENT_ENABLE_BINARY <= '0';
           when TRUE    =>  EMAC1_RX16BITCLIENT_ENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC1_RX16BITCLIENT_ENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC1_TX16BITCLIENT_ENABLE is
           when FALSE   =>  EMAC1_TX16BITCLIENT_ENABLE_BINARY <= '0';
           when TRUE    =>  EMAC1_TX16BITCLIENT_ENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC1_TX16BITCLIENT_ENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC1_HOST_ENABLE is
           when FALSE   =>  EMAC1_HOST_ENABLE_BINARY <= '0';
           when TRUE    =>  EMAC1_HOST_ENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC1_HOST_ENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC1_1000BASEX_ENABLE is
           when FALSE   =>  EMAC1_1000BASEX_ENABLE_BINARY <= '0';
           when TRUE    =>  EMAC1_1000BASEX_ENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC1_1000BASEX_ENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC1_SGMII_ENABLE is
           when FALSE   =>  EMAC1_SGMII_ENABLE_BINARY <= '0';
           when TRUE    =>  EMAC1_SGMII_ENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC1_SGMII_ENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC1_RGMII_ENABLE is
           when FALSE   =>  EMAC1_RGMII_ENABLE_BINARY <= '0';
           when TRUE    =>  EMAC1_RGMII_ENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC1_RGMII_ENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC1_SPEED_LSB is
           when FALSE   =>  EMAC1_SPEED_LSB_BINARY <= '0';
           when TRUE    =>  EMAC1_SPEED_LSB_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC1_SPEED_LSB is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC1_SPEED_MSB is
           when FALSE   =>  EMAC1_SPEED_MSB_BINARY <= '0';
           when TRUE    =>  EMAC1_SPEED_MSB_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC1_SPEED_MSB is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC1_MDIO_ENABLE is
           when FALSE   =>  EMAC1_MDIO_ENABLE_BINARY <= '0';
           when TRUE    =>  EMAC1_MDIO_ENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC1_MDIO_ENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC1_PHYLOOPBACKMSB is
           when FALSE   =>  EMAC1_PHYLOOPBACKMSB_BINARY <= '0';
           when TRUE    =>  EMAC1_PHYLOOPBACKMSB_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC1_PHYLOOPBACKMSB is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC1_PHYPOWERDOWN is
           when FALSE   =>  EMAC1_PHYPOWERDOWN_BINARY <= '0';
           when TRUE    =>  EMAC1_PHYPOWERDOWN_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC1_PHYPOWERDOWN is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC1_PHYISOLATE is
           when FALSE   =>  EMAC1_PHYISOLATE_BINARY <= '0';
           when TRUE    =>  EMAC1_PHYISOLATE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC1_PHYISOLATE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC1_PHYINITAUTONEG_ENABLE is
           when FALSE   =>  EMAC1_PHYINITAUTONEG_ENABLE_BINARY <= '0';
           when TRUE    =>  EMAC1_PHYINITAUTONEG_ENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC1_PHYINITAUTONEG_ENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC1_PHYRESET is
           when FALSE   =>  EMAC1_PHYRESET_BINARY <= '0';
           when TRUE    =>  EMAC1_PHYRESET_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC1_PHYRESET is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC1_CONFIGVEC_79 is
           when FALSE   =>  EMAC1_CONFIGVEC_79_BINARY <= '0';
           when TRUE    =>  EMAC1_CONFIGVEC_79_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC1_CONFIGVEC_79 is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC1_UNIDIRECTION_ENABLE is
           when FALSE   =>  EMAC1_UNIDIRECTION_ENABLE_BINARY <= '0';
           when TRUE    =>  EMAC1_UNIDIRECTION_ENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC1_UNIDIRECTION_ENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC1_GTLOOPBACK is
           when FALSE   =>  EMAC1_GTLOOPBACK_BINARY <= '0';
           when TRUE    =>  EMAC1_GTLOOPBACK_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC1_GTLOOPBACK is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC1_BYTEPHY is
           when FALSE   =>  EMAC1_BYTEPHY_BINARY <= '0';
           when TRUE    =>  EMAC1_BYTEPHY_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC1_BYTEPHY is neither TRUE nor FALSE." severity error;
       end case;
       case EMAC1_USECLKEN is
           when FALSE   =>  EMAC1_USECLKEN_BINARY <= '0';
           when TRUE    =>  EMAC1_USECLKEN_BINARY <= '1';
           when others  =>  assert FALSE report "Error : EMAC1_USECLKEN is neither TRUE nor FALSE." severity error;
       end case;
	wait;
	end process INIPROC;

	TIMING : process
       	variable Tmkr_CLIENTEMAC0DCMLOCKED_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0DCMLOCKED_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0PAUSEREQ_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0PAUSEREQ_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0PAUSEVAL0_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0PAUSEVAL0_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0PAUSEVAL10_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0PAUSEVAL10_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0PAUSEVAL11_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0PAUSEVAL11_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0PAUSEVAL12_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0PAUSEVAL12_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0PAUSEVAL13_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0PAUSEVAL13_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0PAUSEVAL14_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0PAUSEVAL14_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0PAUSEVAL15_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0PAUSEVAL15_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0PAUSEVAL1_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0PAUSEVAL1_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0PAUSEVAL2_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0PAUSEVAL2_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0PAUSEVAL3_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0PAUSEVAL3_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0PAUSEVAL4_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0PAUSEVAL4_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0PAUSEVAL5_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0PAUSEVAL5_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0PAUSEVAL6_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0PAUSEVAL6_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0PAUSEVAL7_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0PAUSEVAL7_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0PAUSEVAL8_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0PAUSEVAL8_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0PAUSEVAL9_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0PAUSEVAL9_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXD0_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXD0_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXD10_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXD10_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXD11_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXD11_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXD12_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXD12_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXD13_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXD13_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXD14_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXD14_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXD15_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXD15_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXD1_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXD1_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXD2_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXD2_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXD3_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXD3_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXD4_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXD4_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXD5_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXD5_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXD6_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXD6_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXD7_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXD7_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXD8_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXD8_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXD9_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXD9_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXDVLDMSW_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXDVLDMSW_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXDVLD_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXDVLD_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXFIRSTBYTE_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXFIRSTBYTE_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXIFGDELAY0_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXIFGDELAY0_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXIFGDELAY1_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXIFGDELAY1_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXIFGDELAY2_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXIFGDELAY2_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXIFGDELAY3_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXIFGDELAY3_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXIFGDELAY4_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXIFGDELAY4_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXIFGDELAY5_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXIFGDELAY5_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXIFGDELAY6_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXIFGDELAY6_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXIFGDELAY7_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXIFGDELAY7_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXUNDERRUN_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC0TXUNDERRUN_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1DCMLOCKED_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1DCMLOCKED_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1PAUSEREQ_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1PAUSEREQ_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1PAUSEVAL0_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1PAUSEVAL0_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1PAUSEVAL10_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1PAUSEVAL10_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1PAUSEVAL11_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1PAUSEVAL11_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1PAUSEVAL12_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1PAUSEVAL12_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1PAUSEVAL13_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1PAUSEVAL13_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1PAUSEVAL14_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1PAUSEVAL14_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1PAUSEVAL15_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1PAUSEVAL15_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1PAUSEVAL1_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1PAUSEVAL1_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1PAUSEVAL2_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1PAUSEVAL2_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1PAUSEVAL3_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1PAUSEVAL3_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1PAUSEVAL4_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1PAUSEVAL4_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1PAUSEVAL5_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1PAUSEVAL5_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1PAUSEVAL6_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1PAUSEVAL6_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1PAUSEVAL7_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1PAUSEVAL7_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1PAUSEVAL8_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1PAUSEVAL8_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1PAUSEVAL9_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1PAUSEVAL9_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXD0_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXD0_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXD10_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXD10_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXD11_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXD11_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXD12_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXD12_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXD13_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXD13_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXD14_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXD14_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXD15_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXD15_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXD1_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXD1_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXD2_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXD2_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXD3_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXD3_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXD4_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXD4_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXD5_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXD5_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXD6_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXD6_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXD7_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXD7_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXD8_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXD8_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXD9_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXD9_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXDVLDMSW_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXDVLDMSW_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXDVLD_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXDVLD_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXFIRSTBYTE_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXFIRSTBYTE_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXIFGDELAY0_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXIFGDELAY0_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXIFGDELAY1_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXIFGDELAY1_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXIFGDELAY2_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXIFGDELAY2_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXIFGDELAY3_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXIFGDELAY3_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXIFGDELAY4_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXIFGDELAY4_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXIFGDELAY5_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXIFGDELAY5_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXIFGDELAY6_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXIFGDELAY6_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXIFGDELAY7_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXIFGDELAY7_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXUNDERRUN_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CLIENTEMAC1TXUNDERRUN_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACABUS0_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACABUS1_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACABUS2_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACABUS3_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACABUS4_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACABUS5_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACABUS6_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACABUS7_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACABUS8_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACABUS9_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACDBUS0_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACDBUS10_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACDBUS11_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACDBUS12_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACDBUS13_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACDBUS14_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACDBUS15_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACDBUS16_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACDBUS17_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACDBUS18_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACDBUS19_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACDBUS1_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACDBUS20_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACDBUS21_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACDBUS22_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACDBUS23_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACDBUS24_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACDBUS25_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACDBUS26_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACDBUS27_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACDBUS28_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACDBUS29_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACDBUS2_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACDBUS30_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACDBUS31_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACDBUS3_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACDBUS4_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACDBUS5_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACDBUS6_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACDBUS7_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACDBUS8_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACDBUS9_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACENABLE_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACREAD_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_DCREMACWRITE_DCREMACCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTADDR0_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTADDR1_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTADDR2_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTADDR3_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTADDR4_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTADDR5_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTADDR6_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTADDR7_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTADDR8_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTADDR9_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTEMAC1SEL_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTMIIMSEL_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTOPCODE0_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTOPCODE1_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTREQ_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTWRDATA0_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTWRDATA10_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTWRDATA11_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTWRDATA12_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTWRDATA13_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTWRDATA14_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTWRDATA15_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTWRDATA16_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTWRDATA17_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTWRDATA18_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTWRDATA19_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTWRDATA1_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTWRDATA20_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTWRDATA21_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTWRDATA22_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTWRDATA23_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTWRDATA24_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTWRDATA25_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTWRDATA26_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTWRDATA27_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTWRDATA28_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTWRDATA29_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTWRDATA2_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTWRDATA30_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTWRDATA31_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTWRDATA3_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTWRDATA4_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTWRDATA5_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTWRDATA6_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTWRDATA7_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTWRDATA8_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_HOSTWRDATA9_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0COL_PHYEMAC0GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0COL_PHYEMAC0RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0CRS_PHYEMAC0GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0CRS_PHYEMAC0RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0MDIN_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0MDIN_PHYEMAC0MCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0PHYAD0_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0PHYAD1_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0PHYAD2_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0PHYAD3_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0PHYAD4_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXBUFERR_PHYEMAC0GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXBUFERR_PHYEMAC0RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXBUFSTATUS0_PHYEMAC0GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXBUFSTATUS0_PHYEMAC0RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXBUFSTATUS1_PHYEMAC0GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXBUFSTATUS1_PHYEMAC0RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXCHARISCOMMA_PHYEMAC0GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXCHARISCOMMA_PHYEMAC0RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXCHARISK_PHYEMAC0GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXCHARISK_PHYEMAC0RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXCHECKINGCRC_PHYEMAC0GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXCHECKINGCRC_PHYEMAC0RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXCLKCORCNT0_PHYEMAC0GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXCLKCORCNT0_PHYEMAC0RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXCLKCORCNT1_PHYEMAC0GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXCLKCORCNT1_PHYEMAC0RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXCLKCORCNT2_PHYEMAC0GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXCLKCORCNT2_PHYEMAC0RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXCOMMADET_PHYEMAC0GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXCOMMADET_PHYEMAC0RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXD0_PHYEMAC0GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXD0_PHYEMAC0RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXD1_PHYEMAC0GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXD1_PHYEMAC0RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXD2_PHYEMAC0GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXD2_PHYEMAC0RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXD3_PHYEMAC0GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXD3_PHYEMAC0RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXD4_PHYEMAC0GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXD4_PHYEMAC0RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXD5_PHYEMAC0GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXD5_PHYEMAC0RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXD6_PHYEMAC0GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXD6_PHYEMAC0RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXD7_PHYEMAC0GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXD7_PHYEMAC0RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXDISPERR_PHYEMAC0GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXDISPERR_PHYEMAC0RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXDV_PHYEMAC0GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXDV_PHYEMAC0RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXER_PHYEMAC0GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXER_PHYEMAC0RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXLOSSOFSYNC0_PHYEMAC0GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXLOSSOFSYNC0_PHYEMAC0RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXLOSSOFSYNC1_PHYEMAC0GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXLOSSOFSYNC1_PHYEMAC0RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXNOTINTABLE_PHYEMAC0GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXNOTINTABLE_PHYEMAC0RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXRUNDISP_PHYEMAC0GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0RXRUNDISP_PHYEMAC0RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0SIGNALDET_PHYEMAC0GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0SIGNALDET_PHYEMAC0RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0TXBUFERR_PHYEMAC0GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC0TXBUFERR_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1COL_PHYEMAC1GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1COL_PHYEMAC1RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1CRS_PHYEMAC1GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1CRS_PHYEMAC1RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1MDIN_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1MDIN_PHYEMAC1MCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1PHYAD0_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1PHYAD1_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1PHYAD2_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1PHYAD3_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1PHYAD4_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXBUFERR_PHYEMAC1GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXBUFERR_PHYEMAC1RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXBUFSTATUS0_PHYEMAC1GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXBUFSTATUS0_PHYEMAC1RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXBUFSTATUS1_PHYEMAC1GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXBUFSTATUS1_PHYEMAC1RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXCHARISCOMMA_PHYEMAC1GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXCHARISCOMMA_PHYEMAC1RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXCHARISK_PHYEMAC1GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXCHARISK_PHYEMAC1RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXCHECKINGCRC_PHYEMAC1GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXCHECKINGCRC_PHYEMAC1RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXCLKCORCNT0_PHYEMAC1GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXCLKCORCNT0_PHYEMAC1RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXCLKCORCNT1_PHYEMAC1GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXCLKCORCNT1_PHYEMAC1RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXCLKCORCNT2_PHYEMAC1GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXCLKCORCNT2_PHYEMAC1RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXCOMMADET_PHYEMAC1GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXCOMMADET_PHYEMAC1RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXD0_PHYEMAC1GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXD0_PHYEMAC1RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXD1_PHYEMAC1GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXD1_PHYEMAC1RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXD2_PHYEMAC1GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXD2_PHYEMAC1RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXD3_PHYEMAC1GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXD3_PHYEMAC1RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXD4_PHYEMAC1GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXD4_PHYEMAC1RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXD5_PHYEMAC1GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXD5_PHYEMAC1RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXD6_PHYEMAC1GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXD6_PHYEMAC1RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXD7_PHYEMAC1GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXD7_PHYEMAC1RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXDISPERR_PHYEMAC1GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXDISPERR_PHYEMAC1RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXDV_PHYEMAC1GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXDV_PHYEMAC1RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXER_PHYEMAC1GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXER_PHYEMAC1RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXLOSSOFSYNC0_PHYEMAC1GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXLOSSOFSYNC0_PHYEMAC1RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXLOSSOFSYNC1_PHYEMAC1GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXLOSSOFSYNC1_PHYEMAC1RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXNOTINTABLE_PHYEMAC1GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXNOTINTABLE_PHYEMAC1RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXRUNDISP_PHYEMAC1GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1RXRUNDISP_PHYEMAC1RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1SIGNALDET_PHYEMAC1GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1SIGNALDET_PHYEMAC1RXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1TXBUFERR_PHYEMAC1GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PHYEMAC1TXBUFERR_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tviol_CLIENTEMAC0DCMLOCKED_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0DCMLOCKED_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0PAUSEREQ_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0PAUSEREQ_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0PAUSEVAL0_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0PAUSEVAL0_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0PAUSEVAL10_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0PAUSEVAL10_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0PAUSEVAL11_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0PAUSEVAL11_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0PAUSEVAL12_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0PAUSEVAL12_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0PAUSEVAL13_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0PAUSEVAL13_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0PAUSEVAL14_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0PAUSEVAL14_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0PAUSEVAL15_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0PAUSEVAL15_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0PAUSEVAL1_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0PAUSEVAL1_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0PAUSEVAL2_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0PAUSEVAL2_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0PAUSEVAL3_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0PAUSEVAL3_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0PAUSEVAL4_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0PAUSEVAL4_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0PAUSEVAL5_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0PAUSEVAL5_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0PAUSEVAL6_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0PAUSEVAL6_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0PAUSEVAL7_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0PAUSEVAL7_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0PAUSEVAL8_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0PAUSEVAL8_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0PAUSEVAL9_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0PAUSEVAL9_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXD0_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXD0_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXD10_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXD10_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXD11_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXD11_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXD12_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXD12_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXD13_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXD13_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXD14_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXD14_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXD15_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXD15_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXD1_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXD1_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXD2_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXD2_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXD3_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXD3_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXD4_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXD4_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXD5_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXD5_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXD6_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXD6_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXD7_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXD7_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXD8_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXD8_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXD9_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXD9_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXDVLDMSW_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXDVLDMSW_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXDVLD_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXDVLD_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXFIRSTBYTE_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXFIRSTBYTE_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXIFGDELAY0_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXIFGDELAY0_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXIFGDELAY1_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXIFGDELAY1_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXIFGDELAY2_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXIFGDELAY2_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXIFGDELAY3_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXIFGDELAY3_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXIFGDELAY4_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXIFGDELAY4_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXIFGDELAY5_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXIFGDELAY5_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXIFGDELAY6_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXIFGDELAY6_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXIFGDELAY7_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXIFGDELAY7_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXUNDERRUN_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC0TXUNDERRUN_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1DCMLOCKED_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1DCMLOCKED_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1PAUSEREQ_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1PAUSEREQ_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1PAUSEVAL0_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1PAUSEVAL0_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1PAUSEVAL10_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1PAUSEVAL10_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1PAUSEVAL11_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1PAUSEVAL11_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1PAUSEVAL12_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1PAUSEVAL12_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1PAUSEVAL13_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1PAUSEVAL13_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1PAUSEVAL14_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1PAUSEVAL14_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1PAUSEVAL15_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1PAUSEVAL15_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1PAUSEVAL1_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1PAUSEVAL1_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1PAUSEVAL2_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1PAUSEVAL2_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1PAUSEVAL3_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1PAUSEVAL3_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1PAUSEVAL4_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1PAUSEVAL4_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1PAUSEVAL5_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1PAUSEVAL5_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1PAUSEVAL6_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1PAUSEVAL6_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1PAUSEVAL7_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1PAUSEVAL7_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1PAUSEVAL8_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1PAUSEVAL8_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1PAUSEVAL9_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1PAUSEVAL9_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXD0_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXD0_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXD10_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXD10_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXD11_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXD11_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXD12_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXD12_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXD13_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXD13_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXD14_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXD14_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXD15_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXD15_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXD1_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXD1_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXD2_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXD2_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXD3_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXD3_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXD4_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXD4_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXD5_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXD5_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXD6_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXD6_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXD7_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXD7_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXD8_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXD8_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXD9_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXD9_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXDVLDMSW_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXDVLDMSW_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXDVLD_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXDVLD_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXFIRSTBYTE_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXFIRSTBYTE_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXIFGDELAY0_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXIFGDELAY0_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXIFGDELAY1_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXIFGDELAY1_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXIFGDELAY2_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXIFGDELAY2_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXIFGDELAY3_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXIFGDELAY3_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXIFGDELAY4_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXIFGDELAY4_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXIFGDELAY5_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXIFGDELAY5_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXIFGDELAY6_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXIFGDELAY6_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXIFGDELAY7_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXIFGDELAY7_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXUNDERRUN_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_CLIENTEMAC1TXUNDERRUN_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACABUS0_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACABUS1_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACABUS2_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACABUS3_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACABUS4_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACABUS5_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACABUS6_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACABUS7_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACABUS8_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACABUS9_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACDBUS0_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACDBUS10_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACDBUS11_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACDBUS12_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACDBUS13_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACDBUS14_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACDBUS15_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACDBUS16_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACDBUS17_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACDBUS18_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACDBUS19_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACDBUS1_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACDBUS20_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACDBUS21_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACDBUS22_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACDBUS23_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACDBUS24_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACDBUS25_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACDBUS26_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACDBUS27_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACDBUS28_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACDBUS29_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACDBUS2_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACDBUS30_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACDBUS31_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACDBUS3_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACDBUS4_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACDBUS5_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACDBUS6_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACDBUS7_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACDBUS8_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACDBUS9_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACENABLE_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACREAD_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_DCREMACWRITE_DCREMACCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTADDR0_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTADDR1_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTADDR2_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTADDR3_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTADDR4_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTADDR5_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTADDR6_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTADDR7_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTADDR8_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTADDR9_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTEMAC1SEL_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTMIIMSEL_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTOPCODE0_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTOPCODE1_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTREQ_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTWRDATA0_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTWRDATA10_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTWRDATA11_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTWRDATA12_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTWRDATA13_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTWRDATA14_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTWRDATA15_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTWRDATA16_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTWRDATA17_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTWRDATA18_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTWRDATA19_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTWRDATA1_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTWRDATA20_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTWRDATA21_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTWRDATA22_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTWRDATA23_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTWRDATA24_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTWRDATA25_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTWRDATA26_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTWRDATA27_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTWRDATA28_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTWRDATA29_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTWRDATA2_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTWRDATA30_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTWRDATA31_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTWRDATA3_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTWRDATA4_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTWRDATA5_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTWRDATA6_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTWRDATA7_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTWRDATA8_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_HOSTWRDATA9_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0COL_PHYEMAC0GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0COL_PHYEMAC0RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0CRS_PHYEMAC0GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0CRS_PHYEMAC0RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0MDIN_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0MDIN_PHYEMAC0MCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0PHYAD0_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0PHYAD1_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0PHYAD2_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0PHYAD3_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0PHYAD4_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXBUFERR_PHYEMAC0GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXBUFERR_PHYEMAC0RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXBUFSTATUS0_PHYEMAC0GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXBUFSTATUS0_PHYEMAC0RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXBUFSTATUS1_PHYEMAC0GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXBUFSTATUS1_PHYEMAC0RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXCHARISCOMMA_PHYEMAC0GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXCHARISCOMMA_PHYEMAC0RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXCHARISK_PHYEMAC0GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXCHARISK_PHYEMAC0RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXCHECKINGCRC_PHYEMAC0GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXCHECKINGCRC_PHYEMAC0RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXCLKCORCNT0_PHYEMAC0GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXCLKCORCNT0_PHYEMAC0RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXCLKCORCNT1_PHYEMAC0GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXCLKCORCNT1_PHYEMAC0RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXCLKCORCNT2_PHYEMAC0GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXCLKCORCNT2_PHYEMAC0RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXCOMMADET_PHYEMAC0GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXCOMMADET_PHYEMAC0RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXD0_PHYEMAC0GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXD0_PHYEMAC0RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXD1_PHYEMAC0GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXD1_PHYEMAC0RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXD2_PHYEMAC0GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXD2_PHYEMAC0RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXD3_PHYEMAC0GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXD3_PHYEMAC0RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXD4_PHYEMAC0GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXD4_PHYEMAC0RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXD5_PHYEMAC0GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXD5_PHYEMAC0RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXD6_PHYEMAC0GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXD6_PHYEMAC0RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXD7_PHYEMAC0GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXD7_PHYEMAC0RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXDISPERR_PHYEMAC0GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXDISPERR_PHYEMAC0RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXDV_PHYEMAC0GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXDV_PHYEMAC0RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXER_PHYEMAC0GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXER_PHYEMAC0RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXLOSSOFSYNC0_PHYEMAC0GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXLOSSOFSYNC0_PHYEMAC0RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXLOSSOFSYNC1_PHYEMAC0GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXLOSSOFSYNC1_PHYEMAC0RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXNOTINTABLE_PHYEMAC0GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXNOTINTABLE_PHYEMAC0RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXRUNDISP_PHYEMAC0GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0RXRUNDISP_PHYEMAC0RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0SIGNALDET_PHYEMAC0GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0SIGNALDET_PHYEMAC0RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0TXBUFERR_PHYEMAC0GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC0TXBUFERR_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1COL_PHYEMAC1GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1COL_PHYEMAC1RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1CRS_PHYEMAC1GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1CRS_PHYEMAC1RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1MDIN_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1MDIN_PHYEMAC1MCLKIN_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1PHYAD0_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1PHYAD1_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1PHYAD2_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1PHYAD3_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1PHYAD4_HOSTCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXBUFERR_PHYEMAC1GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXBUFERR_PHYEMAC1RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXBUFSTATUS0_PHYEMAC1GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXBUFSTATUS0_PHYEMAC1RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXBUFSTATUS1_PHYEMAC1GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXBUFSTATUS1_PHYEMAC1RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXCHARISCOMMA_PHYEMAC1GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXCHARISCOMMA_PHYEMAC1RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXCHARISK_PHYEMAC1GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXCHARISK_PHYEMAC1RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXCHECKINGCRC_PHYEMAC1GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXCHECKINGCRC_PHYEMAC1RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXCLKCORCNT0_PHYEMAC1GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXCLKCORCNT0_PHYEMAC1RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXCLKCORCNT1_PHYEMAC1GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXCLKCORCNT1_PHYEMAC1RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXCLKCORCNT2_PHYEMAC1GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXCLKCORCNT2_PHYEMAC1RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXCOMMADET_PHYEMAC1GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXCOMMADET_PHYEMAC1RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXD0_PHYEMAC1GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXD0_PHYEMAC1RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXD1_PHYEMAC1GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXD1_PHYEMAC1RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXD2_PHYEMAC1GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXD2_PHYEMAC1RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXD3_PHYEMAC1GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXD3_PHYEMAC1RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXD4_PHYEMAC1GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXD4_PHYEMAC1RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXD5_PHYEMAC1GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXD5_PHYEMAC1RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXD6_PHYEMAC1GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXD6_PHYEMAC1RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXD7_PHYEMAC1GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXD7_PHYEMAC1RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXDISPERR_PHYEMAC1GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXDISPERR_PHYEMAC1RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXDV_PHYEMAC1GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXDV_PHYEMAC1RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXER_PHYEMAC1GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXER_PHYEMAC1RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXLOSSOFSYNC0_PHYEMAC1GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXLOSSOFSYNC0_PHYEMAC1RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXLOSSOFSYNC1_PHYEMAC1GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXLOSSOFSYNC1_PHYEMAC1RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXNOTINTABLE_PHYEMAC1GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXNOTINTABLE_PHYEMAC1RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXRUNDISP_PHYEMAC1GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1RXRUNDISP_PHYEMAC1RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1SIGNALDET_PHYEMAC1GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1SIGNALDET_PHYEMAC1RXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1TXBUFERR_PHYEMAC1GTXCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PHYEMAC1TXBUFERR_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';

	variable Tmkr_RESET_HOSTCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
        variable Tviol_RESET_HOSTCLK_posedge : STD_ULOGIC := '0';

       	variable Tmkr_RESET_CLIENTEMAC0TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
        variable Tviol_RESET_CLIENTEMAC0TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';

        variable Tmkr_RESET_CLIENTEMAC1TXCLIENTCLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
        variable Tviol_RESET_CLIENTEMAC1TXCLIENTCLKIN_posedge : STD_ULOGIC := '0';

        variable Tmkr_RESET_PHYEMAC0TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
        variable Tviol_RESET_PHYEMAC0TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';

        variable Tmkr_RESET_PHYEMAC1TXGMIIMIICLKIN_posedge : VitalTimingDataType := VitalTimingDataInit;
        variable Tviol_RESET_PHYEMAC1TXGMIIMIICLKIN_posedge : STD_ULOGIC := '0';

        variable Tmkr_RESET_PHYEMAC0GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
        variable Tviol_RESET_PHYEMAC0GTXCLK_posedge : STD_ULOGIC := '0';
        
        variable Tmkr_RESET_PHYEMAC1GTXCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
        variable Tviol_RESET_PHYEMAC1GTXCLK_posedge : STD_ULOGIC := '0';
        
        
        variable  DCRHOSTDONEIR_GlitchData : VitalGlitchDataType;
	variable  EMAC0CLIENTANINTERRUPT_GlitchData : VitalGlitchDataType;
	variable  EMAC0CLIENTRXBADFRAME_GlitchData : VitalGlitchDataType;
	variable  EMAC0CLIENTRXCLIENTCLKOUT_GlitchData : VitalGlitchDataType;
	variable  EMAC0CLIENTRXD0_GlitchData : VitalGlitchDataType;
	variable  EMAC0CLIENTRXD1_GlitchData : VitalGlitchDataType;
	variable  EMAC0CLIENTRXD2_GlitchData : VitalGlitchDataType;
	variable  EMAC0CLIENTRXD3_GlitchData : VitalGlitchDataType;
	variable  EMAC0CLIENTRXD4_GlitchData : VitalGlitchDataType;
	variable  EMAC0CLIENTRXD5_GlitchData : VitalGlitchDataType;
	variable  EMAC0CLIENTRXD6_GlitchData : VitalGlitchDataType;
	variable  EMAC0CLIENTRXD7_GlitchData : VitalGlitchDataType;
	variable  EMAC0CLIENTRXD8_GlitchData : VitalGlitchDataType;
	variable  EMAC0CLIENTRXD9_GlitchData : VitalGlitchDataType;
	variable  EMAC0CLIENTRXD10_GlitchData : VitalGlitchDataType;
	variable  EMAC0CLIENTRXD11_GlitchData : VitalGlitchDataType;
	variable  EMAC0CLIENTRXD12_GlitchData : VitalGlitchDataType;
	variable  EMAC0CLIENTRXD13_GlitchData : VitalGlitchDataType;
	variable  EMAC0CLIENTRXD14_GlitchData : VitalGlitchDataType;
	variable  EMAC0CLIENTRXD15_GlitchData : VitalGlitchDataType;
	variable  EMAC0CLIENTRXDVLD_GlitchData : VitalGlitchDataType;
	variable  EMAC0CLIENTRXDVLDMSW_GlitchData : VitalGlitchDataType;
	variable  EMAC0CLIENTRXFRAMEDROP_GlitchData : VitalGlitchDataType;
	variable  EMAC0CLIENTRXGOODFRAME_GlitchData : VitalGlitchDataType;
	variable  EMAC0CLIENTRXSTATS0_GlitchData : VitalGlitchDataType;
	variable  EMAC0CLIENTRXSTATS1_GlitchData : VitalGlitchDataType;
	variable  EMAC0CLIENTRXSTATS2_GlitchData : VitalGlitchDataType;
	variable  EMAC0CLIENTRXSTATS3_GlitchData : VitalGlitchDataType;
	variable  EMAC0CLIENTRXSTATS4_GlitchData : VitalGlitchDataType;
	variable  EMAC0CLIENTRXSTATS5_GlitchData : VitalGlitchDataType;
	variable  EMAC0CLIENTRXSTATS6_GlitchData : VitalGlitchDataType;
	variable  EMAC0CLIENTRXSTATSBYTEVLD_GlitchData : VitalGlitchDataType;
	variable  EMAC0CLIENTRXSTATSVLD_GlitchData : VitalGlitchDataType;
	variable  EMAC0CLIENTTXACK_GlitchData : VitalGlitchDataType;
	variable  EMAC0CLIENTTXCLIENTCLKOUT_GlitchData : VitalGlitchDataType;
	variable  EMAC0CLIENTTXCOLLISION_GlitchData : VitalGlitchDataType;
	variable  EMAC0PHYTXGMIIMIICLKOUT_GlitchData : VitalGlitchDataType;
	variable  EMAC0CLIENTTXRETRANSMIT_GlitchData : VitalGlitchDataType;
	variable  EMAC0CLIENTTXSTATS_GlitchData : VitalGlitchDataType;
	variable  EMAC0CLIENTTXSTATSBYTEVLD_GlitchData : VitalGlitchDataType;
	variable  EMAC0CLIENTTXSTATSVLD_GlitchData : VitalGlitchDataType;
	variable  EMAC0PHYENCOMMAALIGN_GlitchData : VitalGlitchDataType;
	variable  EMAC0PHYLOOPBACKMSB_GlitchData : VitalGlitchDataType;
	variable  EMAC0PHYMCLKOUT_GlitchData : VitalGlitchDataType;
	variable  EMAC0PHYMDOUT_GlitchData : VitalGlitchDataType;
	variable  EMAC0PHYMDTRI_GlitchData : VitalGlitchDataType;
	variable  EMAC0PHYMGTRXRESET_GlitchData : VitalGlitchDataType;
	variable  EMAC0PHYMGTTXRESET_GlitchData : VitalGlitchDataType;
	variable  EMAC0PHYPOWERDOWN_GlitchData : VitalGlitchDataType;
	variable  EMAC0PHYSYNCACQSTATUS_GlitchData : VitalGlitchDataType;
	variable  EMAC0PHYTXCHARDISPMODE_GlitchData : VitalGlitchDataType;
	variable  EMAC0PHYTXCHARDISPVAL_GlitchData : VitalGlitchDataType;
	variable  EMAC0PHYTXCHARISK_GlitchData : VitalGlitchDataType;
	variable  EMAC0PHYTXCLK_GlitchData : VitalGlitchDataType;
	variable  EMAC0PHYTXD0_GlitchData : VitalGlitchDataType;
	variable  EMAC0PHYTXD1_GlitchData : VitalGlitchDataType;
	variable  EMAC0PHYTXD2_GlitchData : VitalGlitchDataType;
	variable  EMAC0PHYTXD3_GlitchData : VitalGlitchDataType;
	variable  EMAC0PHYTXD4_GlitchData : VitalGlitchDataType;
	variable  EMAC0PHYTXD5_GlitchData : VitalGlitchDataType;
	variable  EMAC0PHYTXD6_GlitchData : VitalGlitchDataType;
	variable  EMAC0PHYTXD7_GlitchData : VitalGlitchDataType;
	variable  EMAC0PHYTXEN_GlitchData : VitalGlitchDataType;
	variable  EMAC0PHYTXER_GlitchData : VitalGlitchDataType;
	variable  EMAC0SPEEDIS10100_GlitchData : VitalGlitchDataType;
	variable  EMAC1CLIENTANINTERRUPT_GlitchData : VitalGlitchDataType;
	variable  EMAC1CLIENTRXBADFRAME_GlitchData : VitalGlitchDataType;
	variable  EMAC1CLIENTRXCLIENTCLKOUT_GlitchData : VitalGlitchDataType;
	variable  EMAC1CLIENTRXD0_GlitchData : VitalGlitchDataType;
	variable  EMAC1CLIENTRXD1_GlitchData : VitalGlitchDataType;
	variable  EMAC1CLIENTRXD2_GlitchData : VitalGlitchDataType;
	variable  EMAC1CLIENTRXD3_GlitchData : VitalGlitchDataType;
	variable  EMAC1CLIENTRXD4_GlitchData : VitalGlitchDataType;
	variable  EMAC1CLIENTRXD5_GlitchData : VitalGlitchDataType;
	variable  EMAC1CLIENTRXD6_GlitchData : VitalGlitchDataType;
	variable  EMAC1CLIENTRXD7_GlitchData : VitalGlitchDataType;
	variable  EMAC1CLIENTRXD8_GlitchData : VitalGlitchDataType;
	variable  EMAC1CLIENTRXD9_GlitchData : VitalGlitchDataType;
	variable  EMAC1CLIENTRXD10_GlitchData : VitalGlitchDataType;
	variable  EMAC1CLIENTRXD11_GlitchData : VitalGlitchDataType;
	variable  EMAC1CLIENTRXD12_GlitchData : VitalGlitchDataType;
	variable  EMAC1CLIENTRXD13_GlitchData : VitalGlitchDataType;
	variable  EMAC1CLIENTRXD14_GlitchData : VitalGlitchDataType;
	variable  EMAC1CLIENTRXD15_GlitchData : VitalGlitchDataType;
	variable  EMAC1CLIENTRXDVLD_GlitchData : VitalGlitchDataType;
	variable  EMAC1CLIENTRXDVLDMSW_GlitchData : VitalGlitchDataType;
	variable  EMAC1CLIENTRXFRAMEDROP_GlitchData : VitalGlitchDataType;
	variable  EMAC1CLIENTRXGOODFRAME_GlitchData : VitalGlitchDataType;
	variable  EMAC1CLIENTRXSTATS0_GlitchData : VitalGlitchDataType;
	variable  EMAC1CLIENTRXSTATS1_GlitchData : VitalGlitchDataType;
	variable  EMAC1CLIENTRXSTATS2_GlitchData : VitalGlitchDataType;
	variable  EMAC1CLIENTRXSTATS3_GlitchData : VitalGlitchDataType;
	variable  EMAC1CLIENTRXSTATS4_GlitchData : VitalGlitchDataType;
	variable  EMAC1CLIENTRXSTATS5_GlitchData : VitalGlitchDataType;
	variable  EMAC1CLIENTRXSTATS6_GlitchData : VitalGlitchDataType;
	variable  EMAC1CLIENTRXSTATSBYTEVLD_GlitchData : VitalGlitchDataType;
	variable  EMAC1CLIENTRXSTATSVLD_GlitchData : VitalGlitchDataType;
	variable  EMAC1CLIENTTXACK_GlitchData : VitalGlitchDataType;
	variable  EMAC1CLIENTTXCLIENTCLKOUT_GlitchData : VitalGlitchDataType;
	variable  EMAC1CLIENTTXCOLLISION_GlitchData : VitalGlitchDataType;
	variable  EMAC1PHYTXGMIIMIICLKOUT_GlitchData : VitalGlitchDataType;
	variable  EMAC1CLIENTTXRETRANSMIT_GlitchData : VitalGlitchDataType;
	variable  EMAC1CLIENTTXSTATS_GlitchData : VitalGlitchDataType;
	variable  EMAC1CLIENTTXSTATSBYTEVLD_GlitchData : VitalGlitchDataType;
	variable  EMAC1CLIENTTXSTATSVLD_GlitchData : VitalGlitchDataType;
	variable  EMAC1PHYENCOMMAALIGN_GlitchData : VitalGlitchDataType;
	variable  EMAC1PHYLOOPBACKMSB_GlitchData : VitalGlitchDataType;
	variable  EMAC1PHYMCLKOUT_GlitchData : VitalGlitchDataType;
	variable  EMAC1PHYMDOUT_GlitchData : VitalGlitchDataType;
	variable  EMAC1PHYMDTRI_GlitchData : VitalGlitchDataType;
	variable  EMAC1PHYMGTRXRESET_GlitchData : VitalGlitchDataType;
	variable  EMAC1PHYMGTTXRESET_GlitchData : VitalGlitchDataType;
	variable  EMAC1PHYPOWERDOWN_GlitchData : VitalGlitchDataType;
	variable  EMAC1PHYSYNCACQSTATUS_GlitchData : VitalGlitchDataType;
	variable  EMAC1PHYTXCHARDISPMODE_GlitchData : VitalGlitchDataType;
	variable  EMAC1PHYTXCHARDISPVAL_GlitchData : VitalGlitchDataType;
	variable  EMAC1PHYTXCHARISK_GlitchData : VitalGlitchDataType;
	variable  EMAC1PHYTXCLK_GlitchData : VitalGlitchDataType;
	variable  EMAC1PHYTXD0_GlitchData : VitalGlitchDataType;
	variable  EMAC1PHYTXD1_GlitchData : VitalGlitchDataType;
	variable  EMAC1PHYTXD2_GlitchData : VitalGlitchDataType;
	variable  EMAC1PHYTXD3_GlitchData : VitalGlitchDataType;
	variable  EMAC1PHYTXD4_GlitchData : VitalGlitchDataType;
	variable  EMAC1PHYTXD5_GlitchData : VitalGlitchDataType;
	variable  EMAC1PHYTXD6_GlitchData : VitalGlitchDataType;
	variable  EMAC1PHYTXD7_GlitchData : VitalGlitchDataType;
	variable  EMAC1PHYTXEN_GlitchData : VitalGlitchDataType;
	variable  EMAC1PHYTXER_GlitchData : VitalGlitchDataType;
	variable  EMAC1SPEEDIS10100_GlitchData : VitalGlitchDataType;
	variable  EMACDCRACK_GlitchData : VitalGlitchDataType;
	variable  EMACDCRDBUS0_GlitchData : VitalGlitchDataType;
	variable  EMACDCRDBUS1_GlitchData : VitalGlitchDataType;
	variable  EMACDCRDBUS2_GlitchData : VitalGlitchDataType;
	variable  EMACDCRDBUS3_GlitchData : VitalGlitchDataType;
	variable  EMACDCRDBUS4_GlitchData : VitalGlitchDataType;
	variable  EMACDCRDBUS5_GlitchData : VitalGlitchDataType;
	variable  EMACDCRDBUS6_GlitchData : VitalGlitchDataType;
	variable  EMACDCRDBUS7_GlitchData : VitalGlitchDataType;
	variable  EMACDCRDBUS8_GlitchData : VitalGlitchDataType;
	variable  EMACDCRDBUS9_GlitchData : VitalGlitchDataType;
	variable  EMACDCRDBUS10_GlitchData : VitalGlitchDataType;
	variable  EMACDCRDBUS11_GlitchData : VitalGlitchDataType;
	variable  EMACDCRDBUS12_GlitchData : VitalGlitchDataType;
	variable  EMACDCRDBUS13_GlitchData : VitalGlitchDataType;
	variable  EMACDCRDBUS14_GlitchData : VitalGlitchDataType;
	variable  EMACDCRDBUS15_GlitchData : VitalGlitchDataType;
	variable  EMACDCRDBUS16_GlitchData : VitalGlitchDataType;
	variable  EMACDCRDBUS17_GlitchData : VitalGlitchDataType;
	variable  EMACDCRDBUS18_GlitchData : VitalGlitchDataType;
	variable  EMACDCRDBUS19_GlitchData : VitalGlitchDataType;
	variable  EMACDCRDBUS20_GlitchData : VitalGlitchDataType;
	variable  EMACDCRDBUS21_GlitchData : VitalGlitchDataType;
	variable  EMACDCRDBUS22_GlitchData : VitalGlitchDataType;
	variable  EMACDCRDBUS23_GlitchData : VitalGlitchDataType;
	variable  EMACDCRDBUS24_GlitchData : VitalGlitchDataType;
	variable  EMACDCRDBUS25_GlitchData : VitalGlitchDataType;
	variable  EMACDCRDBUS26_GlitchData : VitalGlitchDataType;
	variable  EMACDCRDBUS27_GlitchData : VitalGlitchDataType;
	variable  EMACDCRDBUS28_GlitchData : VitalGlitchDataType;
	variable  EMACDCRDBUS29_GlitchData : VitalGlitchDataType;
	variable  EMACDCRDBUS30_GlitchData : VitalGlitchDataType;
	variable  EMACDCRDBUS31_GlitchData : VitalGlitchDataType;
	variable  HOSTMIIMRDY_GlitchData : VitalGlitchDataType;
	variable  HOSTRDDATA0_GlitchData : VitalGlitchDataType;
	variable  HOSTRDDATA1_GlitchData : VitalGlitchDataType;
	variable  HOSTRDDATA2_GlitchData : VitalGlitchDataType;
	variable  HOSTRDDATA3_GlitchData : VitalGlitchDataType;
	variable  HOSTRDDATA4_GlitchData : VitalGlitchDataType;
	variable  HOSTRDDATA5_GlitchData : VitalGlitchDataType;
	variable  HOSTRDDATA6_GlitchData : VitalGlitchDataType;
	variable  HOSTRDDATA7_GlitchData : VitalGlitchDataType;
	variable  HOSTRDDATA8_GlitchData : VitalGlitchDataType;
	variable  HOSTRDDATA9_GlitchData : VitalGlitchDataType;
	variable  HOSTRDDATA10_GlitchData : VitalGlitchDataType;
	variable  HOSTRDDATA11_GlitchData : VitalGlitchDataType;
	variable  HOSTRDDATA12_GlitchData : VitalGlitchDataType;
	variable  HOSTRDDATA13_GlitchData : VitalGlitchDataType;
	variable  HOSTRDDATA14_GlitchData : VitalGlitchDataType;
	variable  HOSTRDDATA15_GlitchData : VitalGlitchDataType;
	variable  HOSTRDDATA16_GlitchData : VitalGlitchDataType;
	variable  HOSTRDDATA17_GlitchData : VitalGlitchDataType;
	variable  HOSTRDDATA18_GlitchData : VitalGlitchDataType;
	variable  HOSTRDDATA19_GlitchData : VitalGlitchDataType;
	variable  HOSTRDDATA20_GlitchData : VitalGlitchDataType;
	variable  HOSTRDDATA21_GlitchData : VitalGlitchDataType;
	variable  HOSTRDDATA22_GlitchData : VitalGlitchDataType;
	variable  HOSTRDDATA23_GlitchData : VitalGlitchDataType;
	variable  HOSTRDDATA24_GlitchData : VitalGlitchDataType;
	variable  HOSTRDDATA25_GlitchData : VitalGlitchDataType;
	variable  HOSTRDDATA26_GlitchData : VitalGlitchDataType;
	variable  HOSTRDDATA27_GlitchData : VitalGlitchDataType;
	variable  HOSTRDDATA28_GlitchData : VitalGlitchDataType;
	variable  HOSTRDDATA29_GlitchData : VitalGlitchDataType;
	variable  HOSTRDDATA30_GlitchData : VitalGlitchDataType;
	variable  HOSTRDDATA31_GlitchData : VitalGlitchDataType;
begin

     if (TimingChecksOn) then

       VitalRecoveryRemovalCheck (
              Violation            => Tviol_RESET_HOSTCLK_posedge,
              TimingData           => Tmkr_RESET_HOSTCLK_posedge,
              TestSignal           => RESET_dly,
              TestSignalName       => "RESET",
              TestDelay            => tisd_RESET_HOSTCLK,
              RefSignal            => HOSTCLK_dly,
              RefSignalName        => "HOSTCLK",
              RefDelay             => ticd_HOSTCLK,
              Recovery             => trecovery_RESET_HOSTCLK_negedge_posedge,
              Removal              => tremoval_RESET_HOSTCLK_negedge_posedge,
              ActiveLow            => false,
              CheckEnabled         => TRUE,
              RefTransition        => 'R',
              HeaderMsg            => InstancePath & "/X_TEMAC",
              Xon                  => Xon,
	      MsgOn                => MsgOn,
              MsgSeverity          => WARNING
	);

       VitalRecoveryRemovalCheck (
              Violation            => Tviol_RESET_CLIENTEMAC0TXCLIENTCLKIN_posedge,
              TimingData           => Tmkr_RESET_CLIENTEMAC0TXCLIENTCLKIN_posedge,
              TestSignal           => RESET_dly,
              TestSignalName       => "RESET",
              TestDelay            => tisd_RESET_CLIENTEMAC0TXCLIENTCLKIN,
              RefSignal            => CLIENTEMAC0TXCLIENTCLKIN_dly,
              RefSignalName        => "CLIENTEMAC0TXCLIENTCLKIN",
              RefDelay             => ticd_CLIENTEMAC0TXCLIENTCLKIN,
              Recovery             => trecovery_RESET_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge,
              Removal              => tremoval_RESET_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge,
              ActiveLow            => false,
              CheckEnabled         => TRUE,
              RefTransition        => 'R',
              HeaderMsg            => InstancePath & "/X_TEMAC",
              Xon                  => Xon,
	      MsgOn                => MsgOn,
              MsgSeverity          => WARNING
	);
       
       VitalRecoveryRemovalCheck (
              Violation            => Tviol_RESET_CLIENTEMAC1TXCLIENTCLKIN_posedge,
              TimingData           => Tmkr_RESET_CLIENTEMAC1TXCLIENTCLKIN_posedge,
              TestSignal           => RESET_dly,
              TestSignalName       => "RESET",
              TestDelay            => tisd_RESET_CLIENTEMAC1TXCLIENTCLKIN,
              RefSignal            => CLIENTEMAC1TXCLIENTCLKIN_dly,
              RefSignalName        => "CLIENTEMAC1TXCLIENTCLKIN",
              RefDelay             => ticd_CLIENTEMAC1TXCLIENTCLKIN,
              Recovery             => trecovery_RESET_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge,
              Removal              => tremoval_RESET_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge,
              ActiveLow            => false,
              CheckEnabled         => TRUE,
              RefTransition        => 'R',
              HeaderMsg            => InstancePath & "/X_TEMAC",
              Xon                  => Xon,
	      MsgOn                => MsgOn,
              MsgSeverity          => WARNING
	);

        VitalRecoveryRemovalCheck (
              Violation            => Tviol_RESET_PHYEMAC0TXGMIIMIICLKIN_posedge,
              TimingData           => Tmkr_RESET_PHYEMAC0TXGMIIMIICLKIN_posedge,
              TestSignal           => RESET_dly,
              TestSignalName       => "RESET",
              TestDelay            => tisd_RESET_PHYEMAC0TXGMIIMIICLKIN,
              RefSignal            => PHYEMAC0TXGMIIMIICLKIN_dly,
              RefSignalName        => "PHYEMAC0TXGMIIMIICLKIN",
              RefDelay             => ticd_PHYEMAC0TXGMIIMIICLKIN,
              Recovery             => trecovery_RESET_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge,
              Removal              => tremoval_RESET_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge,
              ActiveLow            => false,
              CheckEnabled         => TRUE,
              RefTransition        => 'R',
              HeaderMsg            => InstancePath & "/X_TEMAC",
              Xon                  => Xon,
	      MsgOn                => MsgOn,
              MsgSeverity          => WARNING
	);

       VitalRecoveryRemovalCheck (
              Violation            => Tviol_RESET_PHYEMAC1TXGMIIMIICLKIN_posedge,
              TimingData           => Tmkr_RESET_PHYEMAC1TXGMIIMIICLKIN_posedge,
              TestSignal           => RESET_dly,
              TestSignalName       => "RESET",
              TestDelay            => tisd_RESET_PHYEMAC1TXGMIIMIICLKIN,
              RefSignal            => PHYEMAC1TXGMIIMIICLKIN_dly,
              RefSignalName        => "PHYEMAC0TXGMIIMIICLKIN",
              RefDelay             => ticd_PHYEMAC1TXGMIIMIICLKIN,
              Recovery             => trecovery_RESET_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge,
              Removal              => tremoval_RESET_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge,
              ActiveLow            => false,
              CheckEnabled         => TRUE,
              RefTransition        => 'R',
              HeaderMsg            => InstancePath & "/X_TEMAC",
              Xon                  => Xon,
	      MsgOn                => MsgOn,
              MsgSeverity          => WARNING
	);

       VitalRecoveryRemovalCheck (
              Violation            => Tviol_RESET_PHYEMAC0GTXCLK_posedge,
              TimingData           => Tmkr_RESET_PHYEMAC0GTXCLK_posedge,
              TestSignal           => RESET_dly,
              TestSignalName       => "RESET",
              TestDelay            => tisd_RESET_PHYEMAC0GTXCLK,
              RefSignal            => PHYEMAC0GTXCLK_dly,
              RefSignalName        => "PHYEMAC0GTXCLK",
              RefDelay             => ticd_PHYEMAC0GTXCLK,
              Recovery             => trecovery_RESET_PHYEMAC0GTXCLK_negedge_posedge,
              Removal              => tremoval_RESET_PHYEMAC0GTXCLK_negedge_posedge,
              ActiveLow            => false,
              CheckEnabled         => TRUE,
              RefTransition        => 'R',
              HeaderMsg            => InstancePath & "/X_TEMAC",
              Xon                  => Xon,
	      MsgOn                => MsgOn,
              MsgSeverity          => WARNING
	);
       
        VitalRecoveryRemovalCheck (
              Violation            => Tviol_RESET_PHYEMAC1GTXCLK_posedge,
              TimingData           => Tmkr_RESET_PHYEMAC1GTXCLK_posedge,
              TestSignal           => RESET_dly,
              TestSignalName       => "RESET",
              TestDelay            => tisd_RESET_PHYEMAC1GTXCLK,
              RefSignal            => PHYEMAC1GTXCLK_dly,
              RefSignalName        => "PHYEMAC1GTXCLK",
              RefDelay             => ticd_PHYEMAC1GTXCLK,
              Recovery             => trecovery_RESET_PHYEMAC1GTXCLK_negedge_posedge,
              Removal              => tremoval_RESET_PHYEMAC1GTXCLK_negedge_posedge,
              ActiveLow            => false,
              CheckEnabled         => TRUE,
              RefTransition        => 'R',
              HeaderMsg            => InstancePath & "/X_TEMAC",
              Xon                  => Xon,
	      MsgOn                => MsgOn,
              MsgSeverity          => WARNING
	);
       
       VitalSetupHoldCheck
	(
	Violation      => Tviol_CLIENTEMAC0DCMLOCKED_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData     => Tmkr_CLIENTEMAC0DCMLOCKED_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal     => CLIENTEMAC0DCMLOCKED,
	TestSignalName => "CLIENTEMAC0DCMLOCKED",
	TestDelay      => 0 ps,
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName  => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_CLIENTEMAC0DCMLOCKED_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge,
	SetupLow       => tsetup_CLIENTEMAC0DCMLOCKED_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge,
	HoldLow        => thold_CLIENTEMAC0DCMLOCKED_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge,
	HoldHigh       => thold_CLIENTEMAC0DCMLOCKED_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_CLIENTEMAC0DCMLOCKED_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData     => Tmkr_CLIENTEMAC0DCMLOCKED_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal     => CLIENTEMAC0DCMLOCKED,
	TestSignalName => "CLIENTEMAC0DCMLOCKED",
	TestDelay      => 0 ps,
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName  => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_CLIENTEMAC0DCMLOCKED_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge,
	SetupLow       => tsetup_CLIENTEMAC0DCMLOCKED_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge,
	HoldLow        => thold_CLIENTEMAC0DCMLOCKED_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge,
	HoldHigh       => thold_CLIENTEMAC0DCMLOCKED_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_CLIENTEMAC0DCMLOCKED_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData     => Tmkr_CLIENTEMAC0DCMLOCKED_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal     => CLIENTEMAC0DCMLOCKED,
	TestSignalName => "CLIENTEMAC0DCMLOCKED",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName  => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_CLIENTEMAC0DCMLOCKED_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge,
	SetupLow       => tsetup_CLIENTEMAC0DCMLOCKED_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge,
	HoldLow        => thold_CLIENTEMAC0DCMLOCKED_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge,
	HoldHigh       => thold_CLIENTEMAC0DCMLOCKED_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_CLIENTEMAC0PAUSEREQ_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData     => Tmkr_CLIENTEMAC0PAUSEREQ_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal     => CLIENTEMAC0PAUSEREQ,
	TestSignalName => "CLIENTEMAC0PAUSEREQ",
	TestDelay      => 0 ps,
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName  => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_CLIENTEMAC0PAUSEREQ_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge,
	SetupLow       => tsetup_CLIENTEMAC0PAUSEREQ_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge,
	HoldLow        => thold_CLIENTEMAC0PAUSEREQ_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge,
	HoldHigh       => thold_CLIENTEMAC0PAUSEREQ_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_CLIENTEMAC0PAUSEREQ_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData     => Tmkr_CLIENTEMAC0PAUSEREQ_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal     => CLIENTEMAC0PAUSEREQ,
	TestSignalName => "CLIENTEMAC0PAUSEREQ",
	TestDelay      => 0 ps,
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName  => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_CLIENTEMAC0PAUSEREQ_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge,
	SetupLow       => tsetup_CLIENTEMAC0PAUSEREQ_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge,
	HoldLow        => thold_CLIENTEMAC0PAUSEREQ_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge,
	HoldHigh       => thold_CLIENTEMAC0PAUSEREQ_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_CLIENTEMAC0PAUSEREQ_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData     => Tmkr_CLIENTEMAC0PAUSEREQ_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal     => CLIENTEMAC0PAUSEREQ,
	TestSignalName => "CLIENTEMAC0PAUSEREQ",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName  => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_CLIENTEMAC0PAUSEREQ_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge,
	SetupLow       => tsetup_CLIENTEMAC0PAUSEREQ_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge,
	HoldLow        => thold_CLIENTEMAC0PAUSEREQ_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge,
	HoldHigh       => thold_CLIENTEMAC0PAUSEREQ_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL0_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL0_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_dly(0),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(0)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN(0),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(0),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(0),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(0),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL0_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL0_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_dly(0),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(0)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN(0),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(0),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(0),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(0),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL0_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL0_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_dly(0),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(0)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN(0),
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC0TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(0),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(0),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(0),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL1_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL1_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_dly(1),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(1)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN(1),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(1),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(1),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(1),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL1_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL1_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_dly(1),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(1)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN(1),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(1),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(1),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(1),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL1_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL1_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_dly(1),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(1)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN(1),
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC0TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(1),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(1),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(1),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL2_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL2_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_dly(2),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(2)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN(2),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(2),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(2),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(2),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL2_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL2_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_dly(2),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(2)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN(2),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(2),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(2),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(2),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL2_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL2_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_dly(2),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(2)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN(2),
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC0TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(2),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(2),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(2),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL3_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL3_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_dly(3),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(3)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN(3),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(3),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(3),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(3),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(3),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL3_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL3_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_dly(3),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(3)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN(3),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(3),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(3),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(3),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(3),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL3_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL3_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_dly(3),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(3)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN(3),
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC0TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(3),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(3),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(3),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(3),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL4_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL4_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_dly(4),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(4)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN(4),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(4),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(4),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(4),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(4),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL4_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL4_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_dly(4),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(4)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN(4),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(4),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(4),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(4),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(4),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL4_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL4_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_dly(4),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(4)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN(4),
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC0TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(4),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(4),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(4),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(4),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL5_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL5_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_dly(5),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(5)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN(5),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(5),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(5),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(5),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(5),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL5_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL5_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_dly(5),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(5)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN(5),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(5),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(5),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(5),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(5),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL5_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL5_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_dly(5),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(5)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN(5),
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC0TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(5),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(5),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(5),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(5),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL6_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL6_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_dly(6),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(6)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN(6),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(6),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(6),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(6),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(6),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL6_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL6_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_dly(6),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(6)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN(6),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(6),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(6),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(6),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(6),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL6_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL6_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_dly(6),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(6)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN(6),
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC0TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(6),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(6),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(6),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(6),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL7_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL7_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_dly(7),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(7)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN(7),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(7),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(7),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(7),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(7),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL7_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL7_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_dly(7),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(7)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN(7),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(7),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(7),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(7),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(7),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL7_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL7_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_dly(7),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(7)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN(7),
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC0TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(7),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(7),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(7),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(7),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL8_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL8_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_dly(8),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(8)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN(8),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(8),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(8),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(8),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(8),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL8_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL8_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_dly(8),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(8)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN(8),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(8),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(8),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(8),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(8),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL8_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL8_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_dly(8),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(8)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN(8),
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC0TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(8),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(8),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(8),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(8),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL9_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL9_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_dly(9),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(9)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN(9),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(9),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(9),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(9),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(9),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL9_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL9_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_dly(9),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(9)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN(9),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(9),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(9),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(9),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(9),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL9_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL9_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_dly(9),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(9)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN(9),
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC0TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(9),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(9),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(9),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(9),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL10_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL10_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_dly(10),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(10)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN(10),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(10),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(10),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(10),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(10),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL10_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL10_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_dly(10),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(10)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN(10),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(10),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(10),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(10),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(10),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL10_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL10_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_dly(10),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(10)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN(10),
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC0TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(10),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(10),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(10),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(10),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL11_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL11_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_dly(11),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(11)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN(11),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(11),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(11),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(11),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(11),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL11_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL11_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_dly(11),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(11)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN(11),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(11),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(11),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(11),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(11),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL11_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL11_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_dly(11),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(11)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN(11),
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC0TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(11),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(11),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(11),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(11),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL12_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL12_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_dly(12),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(12)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN(12),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(12),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(12),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(12),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(12),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL12_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL12_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_dly(12),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(12)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN(12),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(12),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(12),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(12),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(12),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL12_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL12_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_dly(12),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(12)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN(12),
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC0TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(12),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(12),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(12),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(12),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL13_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL13_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_dly(13),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(13)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN(13),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(13),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(13),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(13),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(13),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL13_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL13_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_dly(13),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(13)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN(13),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(13),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(13),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(13),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(13),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL13_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL13_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_dly(13),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(13)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN(13),
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC0TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(13),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(13),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(13),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(13),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL14_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL14_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_dly(14),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(14)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN(14),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(14),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(14),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(14),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(14),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL14_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL14_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_dly(14),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(14)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN(14),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(14),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(14),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(14),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(14),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL14_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL14_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_dly(14),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(14)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN(14),
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC0TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(14),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(14),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(14),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(14),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL15_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL15_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_dly(15),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(15)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN(15),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(15),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(15),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(15),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(15),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL15_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL15_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_dly(15),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(15)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN(15),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(15),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(15),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(15),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(15),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0PAUSEVAL15_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0PAUSEVAL15_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_dly(15),
	TestSignalName => "CLIENTEMAC0PAUSEVAL(15)",
	TestDelay => tisd_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN(15),
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC0TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(15),
	SetupLow => tsetup_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(15),
	HoldLow => thold_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(15),
	HoldHigh => thold_CLIENTEMAC0PAUSEVAL_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(15),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD0_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD0_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_dly(0),
	TestSignalName => "CLIENTEMAC0TXD(0)",
	TestDelay => tisd_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN(0),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(0),
	SetupLow => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(0),
	HoldLow => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(0),
	HoldHigh => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD0_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD0_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_dly(0),
	TestSignalName => "CLIENTEMAC0TXD(0)",
	TestDelay => tisd_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN(0),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(0),
	SetupLow => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(0),
	HoldLow => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(0),
	HoldHigh => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD0_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD0_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_dly(0),
	TestSignalName => "CLIENTEMAC0TXD(0)",
	TestDelay => tisd_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN(0),
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC0TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(0),
	SetupLow => tsetup_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(0),
	HoldLow => thold_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(0),
	HoldHigh => thold_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD1_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD1_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_dly(1),
	TestSignalName => "CLIENTEMAC0TXD(1)",
	TestDelay => tisd_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN(1),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(1),
	SetupLow => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(1),
	HoldLow => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(1),
	HoldHigh => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD1_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD1_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_dly(1),
	TestSignalName => "CLIENTEMAC0TXD(1)",
	TestDelay => tisd_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN(1),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(1),
	SetupLow => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(1),
	HoldLow => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(1),
	HoldHigh => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD1_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD1_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_dly(1),
	TestSignalName => "CLIENTEMAC0TXD(1)",
	TestDelay => tisd_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN(1),
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC0TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(1),
	SetupLow => tsetup_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(1),
	HoldLow => thold_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(1),
	HoldHigh => thold_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD2_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD2_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_dly(2),
	TestSignalName => "CLIENTEMAC0TXD(2)",
	TestDelay => tisd_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN(2),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(2),
	SetupLow => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(2),
	HoldLow => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(2),
	HoldHigh => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD2_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD2_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_dly(2),
	TestSignalName => "CLIENTEMAC0TXD(2)",
	TestDelay => tisd_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN(2),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(2),
	SetupLow => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(2),
	HoldLow => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(2),
	HoldHigh => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD2_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD2_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_dly(2),
	TestSignalName => "CLIENTEMAC0TXD(2)",
	TestDelay => tisd_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN(2),
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC0TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(2),
	SetupLow => tsetup_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(2),
	HoldLow => thold_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(2),
	HoldHigh => thold_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD3_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD3_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_dly(3),
	TestSignalName => "CLIENTEMAC0TXD(3)",
	TestDelay => tisd_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN(3),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(3),
	SetupLow => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(3),
	HoldLow => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(3),
	HoldHigh => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(3),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD3_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD3_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_dly(3),
	TestSignalName => "CLIENTEMAC0TXD(3)",
	TestDelay => tisd_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN(3),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(3),
	SetupLow => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(3),
	HoldLow => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(3),
	HoldHigh => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(3),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD3_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD3_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_dly(3),
	TestSignalName => "CLIENTEMAC0TXD(3)",
	TestDelay => tisd_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN(3),
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC0TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(3),
	SetupLow => tsetup_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(3),
	HoldLow => thold_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(3),
	HoldHigh => thold_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(3),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD4_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD4_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_dly(4),
	TestSignalName => "CLIENTEMAC0TXD(4)",
	TestDelay => tisd_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN(4),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(4),
	SetupLow => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(4),
	HoldLow => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(4),
	HoldHigh => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(4),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD4_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD4_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_dly(4),
	TestSignalName => "CLIENTEMAC0TXD(4)",
	TestDelay => tisd_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN(4),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(4),
	SetupLow => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(4),
	HoldLow => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(4),
	HoldHigh => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(4),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD4_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD4_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_dly(4),
	TestSignalName => "CLIENTEMAC0TXD(4)",
	TestDelay => tisd_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN(4),
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC0TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(4),
	SetupLow => tsetup_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(4),
	HoldLow => thold_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(4),
	HoldHigh => thold_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(4),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD5_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD5_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_dly(5),
	TestSignalName => "CLIENTEMAC0TXD(5)",
	TestDelay => tisd_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN(5),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(5),
	SetupLow => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(5),
	HoldLow => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(5),
	HoldHigh => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(5),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD5_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD5_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_dly(5),
	TestSignalName => "CLIENTEMAC0TXD(5)",
	TestDelay => tisd_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN(5),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(5),
	SetupLow => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(5),
	HoldLow => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(5),
	HoldHigh => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(5),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD5_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD5_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_dly(5),
	TestSignalName => "CLIENTEMAC0TXD(5)",
	TestDelay => tisd_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN(5),
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC0TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(5),
	SetupLow => tsetup_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(5),
	HoldLow => thold_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(5),
	HoldHigh => thold_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(5),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD6_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD6_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_dly(6),
	TestSignalName => "CLIENTEMAC0TXD(6)",
	TestDelay => tisd_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN(6),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(6),
	SetupLow => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(6),
	HoldLow => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(6),
	HoldHigh => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(6),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD6_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD6_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_dly(6),
	TestSignalName => "CLIENTEMAC0TXD(6)",
	TestDelay => tisd_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN(6),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(6),
	SetupLow => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(6),
	HoldLow => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(6),
	HoldHigh => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(6),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD6_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD6_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_dly(6),
	TestSignalName => "CLIENTEMAC0TXD(6)",
	TestDelay => tisd_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN(6),
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC0TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(6),
	SetupLow => tsetup_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(6),
	HoldLow => thold_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(6),
	HoldHigh => thold_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(6),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD7_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD7_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_dly(7),
	TestSignalName => "CLIENTEMAC0TXD(7)",
	TestDelay => tisd_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN(7),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(7),
	SetupLow => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(7),
	HoldLow => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(7),
	HoldHigh => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(7),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD7_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD7_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_dly(7),
	TestSignalName => "CLIENTEMAC0TXD(7)",
	TestDelay => tisd_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN(7),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(7),
	SetupLow => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(7),
	HoldLow => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(7),
	HoldHigh => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(7),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD7_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD7_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_dly(7),
	TestSignalName => "CLIENTEMAC0TXD(7)",
	TestDelay => tisd_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN(7),
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC0TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(7),
	SetupLow => tsetup_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(7),
	HoldLow => thold_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(7),
	HoldHigh => thold_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(7),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD8_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD8_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_dly(8),
	TestSignalName => "CLIENTEMAC0TXD(8)",
	TestDelay => tisd_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN(8),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(8),
	SetupLow => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(8),
	HoldLow => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(8),
	HoldHigh => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(8),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD8_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD8_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_dly(8),
	TestSignalName => "CLIENTEMAC0TXD(8)",
	TestDelay => tisd_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN(8),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(8),
	SetupLow => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(8),
	HoldLow => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(8),
	HoldHigh => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(8),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD8_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD8_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_dly(8),
	TestSignalName => "CLIENTEMAC0TXD(8)",
	TestDelay => tisd_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN(8),
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC0TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(8),
	SetupLow => tsetup_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(8),
	HoldLow => thold_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(8),
	HoldHigh => thold_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(8),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD9_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD9_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_dly(9),
	TestSignalName => "CLIENTEMAC0TXD(9)",
	TestDelay => tisd_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN(9),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(9),
	SetupLow => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(9),
	HoldLow => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(9),
	HoldHigh => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(9),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD9_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD9_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_dly(9),
	TestSignalName => "CLIENTEMAC0TXD(9)",
	TestDelay => tisd_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN(9),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(9),
	SetupLow => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(9),
	HoldLow => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(9),
	HoldHigh => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(9),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD9_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD9_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_dly(9),
	TestSignalName => "CLIENTEMAC0TXD(9)",
	TestDelay => tisd_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN(9),
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC0TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(9),
	SetupLow => tsetup_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(9),
	HoldLow => thold_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(9),
	HoldHigh => thold_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(9),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD10_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD10_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_dly(10),
	TestSignalName => "CLIENTEMAC0TXD(10)",
	TestDelay => tisd_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN(10),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(10),
	SetupLow => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(10),
	HoldLow => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(10),
	HoldHigh => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(10),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD10_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD10_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_dly(10),
	TestSignalName => "CLIENTEMAC0TXD(10)",
	TestDelay => tisd_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN(10),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(10),
	SetupLow => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(10),
	HoldLow => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(10),
	HoldHigh => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(10),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD10_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD10_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_dly(10),
	TestSignalName => "CLIENTEMAC0TXD(10)",
	TestDelay => tisd_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN(10),
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC0TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(10),
	SetupLow => tsetup_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(10),
	HoldLow => thold_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(10),
	HoldHigh => thold_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(10),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD11_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD11_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_dly(11),
	TestSignalName => "CLIENTEMAC0TXD(11)",
	TestDelay => tisd_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN(11),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(11),
	SetupLow => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(11),
	HoldLow => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(11),
	HoldHigh => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(11),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD11_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD11_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_dly(11),
	TestSignalName => "CLIENTEMAC0TXD(11)",
	TestDelay => tisd_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN(11),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(11),
	SetupLow => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(11),
	HoldLow => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(11),
	HoldHigh => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(11),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD11_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD11_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_dly(11),
	TestSignalName => "CLIENTEMAC0TXD(11)",
	TestDelay => tisd_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN(11),
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC0TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(11),
	SetupLow => tsetup_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(11),
	HoldLow => thold_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(11),
	HoldHigh => thold_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(11),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD12_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD12_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_dly(12),
	TestSignalName => "CLIENTEMAC0TXD(12)",
	TestDelay => tisd_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN(12),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(12),
	SetupLow => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(12),
	HoldLow => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(12),
	HoldHigh => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(12),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD12_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD12_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_dly(12),
	TestSignalName => "CLIENTEMAC0TXD(12)",
	TestDelay => tisd_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN(12),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(12),
	SetupLow => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(12),
	HoldLow => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(12),
	HoldHigh => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(12),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD12_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD12_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_dly(12),
	TestSignalName => "CLIENTEMAC0TXD(12)",
	TestDelay => tisd_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN(12),
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC0TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(12),
	SetupLow => tsetup_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(12),
	HoldLow => thold_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(12),
	HoldHigh => thold_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(12),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD13_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD13_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_dly(13),
	TestSignalName => "CLIENTEMAC0TXD(13)",
	TestDelay => tisd_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN(13),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(13),
	SetupLow => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(13),
	HoldLow => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(13),
	HoldHigh => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(13),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD13_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD13_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_dly(13),
	TestSignalName => "CLIENTEMAC0TXD(13)",
	TestDelay => tisd_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN(13),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(13),
	SetupLow => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(13),
	HoldLow => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(13),
	HoldHigh => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(13),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD13_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD13_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_dly(13),
	TestSignalName => "CLIENTEMAC0TXD(13)",
	TestDelay => tisd_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN(13),
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC0TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(13),
	SetupLow => tsetup_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(13),
	HoldLow => thold_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(13),
	HoldHigh => thold_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(13),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD14_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD14_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_dly(14),
	TestSignalName => "CLIENTEMAC0TXD(14)",
	TestDelay => tisd_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN(14),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(14),
	SetupLow => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(14),
	HoldLow => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(14),
	HoldHigh => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(14),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD14_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD14_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_dly(14),
	TestSignalName => "CLIENTEMAC0TXD(14)",
	TestDelay => tisd_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN(14),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(14),
	SetupLow => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(14),
	HoldLow => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(14),
	HoldHigh => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(14),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD14_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD14_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_dly(14),
	TestSignalName => "CLIENTEMAC0TXD(14)",
	TestDelay => tisd_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN(14),
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC0TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(14),
	SetupLow => tsetup_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(14),
	HoldLow => thold_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(14),
	HoldHigh => thold_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(14),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD15_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD15_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_dly(15),
	TestSignalName => "CLIENTEMAC0TXD(15)",
	TestDelay => tisd_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN(15),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(15),
	SetupLow => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(15),
	HoldLow => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(15),
	HoldHigh => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(15),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD15_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD15_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_dly(15),
	TestSignalName => "CLIENTEMAC0TXD(15)",
	TestDelay => tisd_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN(15),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(15),
	SetupLow => tsetup_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(15),
	HoldLow => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(15),
	HoldHigh => thold_CLIENTEMAC0TXD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(15),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXD15_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXD15_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_dly(15),
	TestSignalName => "CLIENTEMAC0TXD(15)",
	TestDelay => tisd_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN(15),
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC0TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(15),
	SetupLow => tsetup_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(15),
	HoldLow => thold_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(15),
	HoldHigh => thold_CLIENTEMAC0TXD_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(15),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_CLIENTEMAC0TXDVLD_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData     => Tmkr_CLIENTEMAC0TXDVLD_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal     => CLIENTEMAC0TXDVLD,
	TestSignalName => "CLIENTEMAC0TXDVLD",
	TestDelay      => 0 ps,
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName  => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_CLIENTEMAC0TXDVLD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge,
	SetupLow       => tsetup_CLIENTEMAC0TXDVLD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge,
	HoldLow        => thold_CLIENTEMAC0TXDVLD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge,
	HoldHigh       => thold_CLIENTEMAC0TXDVLD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_CLIENTEMAC0TXDVLD_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData     => Tmkr_CLIENTEMAC0TXDVLD_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal     => CLIENTEMAC0TXDVLD,
	TestSignalName => "CLIENTEMAC0TXDVLD",
	TestDelay      => 0 ps,
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName  => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_CLIENTEMAC0TXDVLD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge,
	SetupLow       => tsetup_CLIENTEMAC0TXDVLD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge,
	HoldLow        => thold_CLIENTEMAC0TXDVLD_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge,
	HoldHigh       => thold_CLIENTEMAC0TXDVLD_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_CLIENTEMAC0TXDVLD_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData     => Tmkr_CLIENTEMAC0TXDVLD_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal     => CLIENTEMAC0TXDVLD,
	TestSignalName => "CLIENTEMAC0TXDVLD",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName  => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_CLIENTEMAC0TXDVLD_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge,
	SetupLow       => tsetup_CLIENTEMAC0TXDVLD_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge,
	HoldLow        => thold_CLIENTEMAC0TXDVLD_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge,
	HoldHigh       => thold_CLIENTEMAC0TXDVLD_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_CLIENTEMAC0TXDVLDMSW_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData     => Tmkr_CLIENTEMAC0TXDVLDMSW_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal     => CLIENTEMAC0TXDVLDMSW,
	TestSignalName => "CLIENTEMAC0TXDVLDMSW",
	TestDelay      => 0 ps,
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName  => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_CLIENTEMAC0TXDVLDMSW_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge,
	SetupLow       => tsetup_CLIENTEMAC0TXDVLDMSW_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge,
	HoldLow        => thold_CLIENTEMAC0TXDVLDMSW_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge,
	HoldHigh       => thold_CLIENTEMAC0TXDVLDMSW_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_CLIENTEMAC0TXDVLDMSW_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData     => Tmkr_CLIENTEMAC0TXDVLDMSW_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal     => CLIENTEMAC0TXDVLDMSW,
	TestSignalName => "CLIENTEMAC0TXDVLDMSW",
	TestDelay      => 0 ps,
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName  => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_CLIENTEMAC0TXDVLDMSW_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge,
	SetupLow       => tsetup_CLIENTEMAC0TXDVLDMSW_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge,
	HoldLow        => thold_CLIENTEMAC0TXDVLDMSW_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge,
	HoldHigh       => thold_CLIENTEMAC0TXDVLDMSW_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_CLIENTEMAC0TXDVLDMSW_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData     => Tmkr_CLIENTEMAC0TXDVLDMSW_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal     => CLIENTEMAC0TXDVLDMSW,
	TestSignalName => "CLIENTEMAC0TXDVLDMSW",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName  => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_CLIENTEMAC0TXDVLDMSW_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge,
	SetupLow       => tsetup_CLIENTEMAC0TXDVLDMSW_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge,
	HoldLow        => thold_CLIENTEMAC0TXDVLDMSW_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge,
	HoldHigh       => thold_CLIENTEMAC0TXDVLDMSW_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_CLIENTEMAC0TXFIRSTBYTE_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData     => Tmkr_CLIENTEMAC0TXFIRSTBYTE_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal     => CLIENTEMAC0TXFIRSTBYTE,
	TestSignalName => "CLIENTEMAC0TXFIRSTBYTE",
	TestDelay      => 0 ps,
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName  => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_CLIENTEMAC0TXFIRSTBYTE_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge,
	SetupLow       => tsetup_CLIENTEMAC0TXFIRSTBYTE_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge,
	HoldLow        => thold_CLIENTEMAC0TXFIRSTBYTE_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge,
	HoldHigh       => thold_CLIENTEMAC0TXFIRSTBYTE_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_CLIENTEMAC0TXFIRSTBYTE_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData     => Tmkr_CLIENTEMAC0TXFIRSTBYTE_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal     => CLIENTEMAC0TXFIRSTBYTE,
	TestSignalName => "CLIENTEMAC0TXFIRSTBYTE",
	TestDelay      => 0 ps,
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName  => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_CLIENTEMAC0TXFIRSTBYTE_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge,
	SetupLow       => tsetup_CLIENTEMAC0TXFIRSTBYTE_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge,
	HoldLow        => thold_CLIENTEMAC0TXFIRSTBYTE_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge,
	HoldHigh       => thold_CLIENTEMAC0TXFIRSTBYTE_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_CLIENTEMAC0TXFIRSTBYTE_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData     => Tmkr_CLIENTEMAC0TXFIRSTBYTE_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal     => CLIENTEMAC0TXFIRSTBYTE,
	TestSignalName => "CLIENTEMAC0TXFIRSTBYTE",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName  => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_CLIENTEMAC0TXFIRSTBYTE_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge,
	SetupLow       => tsetup_CLIENTEMAC0TXFIRSTBYTE_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge,
	HoldLow        => thold_CLIENTEMAC0TXFIRSTBYTE_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge,
	HoldHigh       => thold_CLIENTEMAC0TXFIRSTBYTE_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXIFGDELAY0_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXIFGDELAY0_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_dly(0),
	TestSignalName => "CLIENTEMAC0TXIFGDELAY(0)",
	TestDelay => tisd_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN(0),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(0),
	SetupLow => tsetup_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(0),
	HoldLow => thold_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(0),
	HoldHigh => thold_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXIFGDELAY0_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXIFGDELAY0_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_dly(0),
	TestSignalName => "CLIENTEMAC0TXIFGDELAY(0)",
	TestDelay => tisd_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN(0),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(0),
	SetupLow => tsetup_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(0),
	HoldLow => thold_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(0),
	HoldHigh => thold_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXIFGDELAY0_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXIFGDELAY0_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_dly(0),
	TestSignalName => "CLIENTEMAC0TXIFGDELAY(0)",
	TestDelay => tisd_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN(0),
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC0TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(0),
	SetupLow => tsetup_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(0),
	HoldLow => thold_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(0),
	HoldHigh => thold_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXIFGDELAY1_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXIFGDELAY1_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_dly(1),
	TestSignalName => "CLIENTEMAC0TXIFGDELAY(1)",
	TestDelay => tisd_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN(1),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(1),
	SetupLow => tsetup_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(1),
	HoldLow => thold_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(1),
	HoldHigh => thold_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXIFGDELAY1_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXIFGDELAY1_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_dly(1),
	TestSignalName => "CLIENTEMAC0TXIFGDELAY(1)",
	TestDelay => tisd_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN(1),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(1),
	SetupLow => tsetup_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(1),
	HoldLow => thold_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(1),
	HoldHigh => thold_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXIFGDELAY1_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXIFGDELAY1_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_dly(1),
	TestSignalName => "CLIENTEMAC0TXIFGDELAY(1)",
	TestDelay => tisd_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN(1),
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC0TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(1),
	SetupLow => tsetup_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(1),
	HoldLow => thold_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(1),
	HoldHigh => thold_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXIFGDELAY2_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXIFGDELAY2_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_dly(2),
	TestSignalName => "CLIENTEMAC0TXIFGDELAY(2)",
	TestDelay => tisd_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN(2),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(2),
	SetupLow => tsetup_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(2),
	HoldLow => thold_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(2),
	HoldHigh => thold_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXIFGDELAY2_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXIFGDELAY2_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_dly(2),
	TestSignalName => "CLIENTEMAC0TXIFGDELAY(2)",
	TestDelay => tisd_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN(2),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(2),
	SetupLow => tsetup_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(2),
	HoldLow => thold_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(2),
	HoldHigh => thold_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXIFGDELAY2_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXIFGDELAY2_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_dly(2),
	TestSignalName => "CLIENTEMAC0TXIFGDELAY(2)",
	TestDelay => tisd_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN(2),
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC0TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(2),
	SetupLow => tsetup_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(2),
	HoldLow => thold_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(2),
	HoldHigh => thold_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXIFGDELAY3_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXIFGDELAY3_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_dly(3),
	TestSignalName => "CLIENTEMAC0TXIFGDELAY(3)",
	TestDelay => tisd_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN(3),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(3),
	SetupLow => tsetup_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(3),
	HoldLow => thold_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(3),
	HoldHigh => thold_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(3),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXIFGDELAY3_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXIFGDELAY3_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_dly(3),
	TestSignalName => "CLIENTEMAC0TXIFGDELAY(3)",
	TestDelay => tisd_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN(3),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(3),
	SetupLow => tsetup_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(3),
	HoldLow => thold_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(3),
	HoldHigh => thold_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(3),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXIFGDELAY3_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXIFGDELAY3_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_dly(3),
	TestSignalName => "CLIENTEMAC0TXIFGDELAY(3)",
	TestDelay => tisd_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN(3),
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC0TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(3),
	SetupLow => tsetup_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(3),
	HoldLow => thold_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(3),
	HoldHigh => thold_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(3),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXIFGDELAY4_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXIFGDELAY4_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_dly(4),
	TestSignalName => "CLIENTEMAC0TXIFGDELAY(4)",
	TestDelay => tisd_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN(4),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(4),
	SetupLow => tsetup_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(4),
	HoldLow => thold_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(4),
	HoldHigh => thold_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(4),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXIFGDELAY4_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXIFGDELAY4_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_dly(4),
	TestSignalName => "CLIENTEMAC0TXIFGDELAY(4)",
	TestDelay => tisd_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN(4),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(4),
	SetupLow => tsetup_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(4),
	HoldLow => thold_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(4),
	HoldHigh => thold_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(4),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXIFGDELAY4_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXIFGDELAY4_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_dly(4),
	TestSignalName => "CLIENTEMAC0TXIFGDELAY(4)",
	TestDelay => tisd_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN(4),
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC0TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(4),
	SetupLow => tsetup_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(4),
	HoldLow => thold_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(4),
	HoldHigh => thold_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(4),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXIFGDELAY5_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXIFGDELAY5_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_dly(5),
	TestSignalName => "CLIENTEMAC0TXIFGDELAY(5)",
	TestDelay => tisd_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN(5),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(5),
	SetupLow => tsetup_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(5),
	HoldLow => thold_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(5),
	HoldHigh => thold_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(5),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXIFGDELAY5_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXIFGDELAY5_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_dly(5),
	TestSignalName => "CLIENTEMAC0TXIFGDELAY(5)",
	TestDelay => tisd_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN(5),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(5),
	SetupLow => tsetup_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(5),
	HoldLow => thold_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(5),
	HoldHigh => thold_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(5),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXIFGDELAY5_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXIFGDELAY5_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_dly(5),
	TestSignalName => "CLIENTEMAC0TXIFGDELAY(5)",
	TestDelay => tisd_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN(5),
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC0TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(5),
	SetupLow => tsetup_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(5),
	HoldLow => thold_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(5),
	HoldHigh => thold_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(5),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXIFGDELAY6_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXIFGDELAY6_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_dly(6),
	TestSignalName => "CLIENTEMAC0TXIFGDELAY(6)",
	TestDelay => tisd_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN(6),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(6),
	SetupLow => tsetup_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(6),
	HoldLow => thold_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(6),
	HoldHigh => thold_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(6),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXIFGDELAY6_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXIFGDELAY6_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_dly(6),
	TestSignalName => "CLIENTEMAC0TXIFGDELAY(6)",
	TestDelay => tisd_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN(6),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(6),
	SetupLow => tsetup_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(6),
	HoldLow => thold_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(6),
	HoldHigh => thold_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(6),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXIFGDELAY6_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXIFGDELAY6_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_dly(6),
	TestSignalName => "CLIENTEMAC0TXIFGDELAY(6)",
	TestDelay => tisd_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN(6),
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC0TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(6),
	SetupLow => tsetup_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(6),
	HoldLow => thold_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(6),
	HoldHigh => thold_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(6),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXIFGDELAY7_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXIFGDELAY7_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_dly(7),
	TestSignalName => "CLIENTEMAC0TXIFGDELAY(7)",
	TestDelay => tisd_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN(7),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(7),
	SetupLow => tsetup_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(7),
	HoldLow => thold_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(7),
	HoldHigh => thold_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(7),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXIFGDELAY7_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXIFGDELAY7_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_dly(7),
	TestSignalName => "CLIENTEMAC0TXIFGDELAY(7)",
	TestDelay => tisd_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN(7),
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC0TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(7),
	SetupLow => tsetup_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(7),
	HoldLow => thold_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge(7),
	HoldHigh => thold_CLIENTEMAC0TXIFGDELAY_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge(7),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC0TXIFGDELAY7_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC0TXIFGDELAY7_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_dly(7),
	TestSignalName => "CLIENTEMAC0TXIFGDELAY(7)",
	TestDelay => tisd_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN(7),
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC0TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(7),
	SetupLow => tsetup_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(7),
	HoldLow => thold_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge(7),
	HoldHigh => thold_CLIENTEMAC0TXIFGDELAY_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge(7),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_CLIENTEMAC0TXUNDERRUN_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData     => Tmkr_CLIENTEMAC0TXUNDERRUN_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal     => CLIENTEMAC0TXUNDERRUN,
	TestSignalName => "CLIENTEMAC0TXUNDERRUN",
	TestDelay      => 0 ps,
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName  => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_CLIENTEMAC0TXUNDERRUN_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge,
	SetupLow       => tsetup_CLIENTEMAC0TXUNDERRUN_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge,
	HoldLow        => thold_CLIENTEMAC0TXUNDERRUN_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge,
	HoldHigh       => thold_CLIENTEMAC0TXUNDERRUN_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_CLIENTEMAC0TXUNDERRUN_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TimingData     => Tmkr_CLIENTEMAC0TXUNDERRUN_CLIENTEMAC0TXCLIENTCLKIN_posedge,
	TestSignal     => CLIENTEMAC0TXUNDERRUN,
	TestSignalName => "CLIENTEMAC0TXUNDERRUN",
	TestDelay      => 0 ps,
	RefSignal => CLIENTEMAC0TXCLIENTCLKIN_dly,
	RefSignalName  => "CLIENTEMAC0TXCLIENTCLKIN",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_CLIENTEMAC0TXUNDERRUN_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge,
	SetupLow       => tsetup_CLIENTEMAC0TXUNDERRUN_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge,
	HoldLow        => thold_CLIENTEMAC0TXUNDERRUN_CLIENTEMAC0TXCLIENTCLKIN_posedge_posedge,
	HoldHigh       => thold_CLIENTEMAC0TXUNDERRUN_CLIENTEMAC0TXCLIENTCLKIN_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_CLIENTEMAC0TXUNDERRUN_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData     => Tmkr_CLIENTEMAC0TXUNDERRUN_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal     => CLIENTEMAC0TXUNDERRUN,
	TestSignalName => "CLIENTEMAC0TXUNDERRUN",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName  => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_CLIENTEMAC0TXUNDERRUN_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge,
	SetupLow       => tsetup_CLIENTEMAC0TXUNDERRUN_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge,
	HoldLow        => thold_CLIENTEMAC0TXUNDERRUN_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge,
	HoldHigh       => thold_CLIENTEMAC0TXUNDERRUN_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_CLIENTEMAC1DCMLOCKED_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData     => Tmkr_CLIENTEMAC1DCMLOCKED_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal     => CLIENTEMAC1DCMLOCKED,
	TestSignalName => "CLIENTEMAC1DCMLOCKED",
	TestDelay      => 0 ps,
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName  => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_CLIENTEMAC1DCMLOCKED_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge,
	SetupLow       => tsetup_CLIENTEMAC1DCMLOCKED_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge,
	HoldLow        => thold_CLIENTEMAC1DCMLOCKED_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge,
	HoldHigh       => thold_CLIENTEMAC1DCMLOCKED_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_CLIENTEMAC1DCMLOCKED_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData     => Tmkr_CLIENTEMAC1DCMLOCKED_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal     => CLIENTEMAC1DCMLOCKED,
	TestSignalName => "CLIENTEMAC1DCMLOCKED",
	TestDelay      => 0 ps,
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName  => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_CLIENTEMAC1DCMLOCKED_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge,
	SetupLow       => tsetup_CLIENTEMAC1DCMLOCKED_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge,
	HoldLow        => thold_CLIENTEMAC1DCMLOCKED_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge,
	HoldHigh       => thold_CLIENTEMAC1DCMLOCKED_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_CLIENTEMAC1DCMLOCKED_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData     => Tmkr_CLIENTEMAC1DCMLOCKED_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal     => CLIENTEMAC1DCMLOCKED,
	TestSignalName => "CLIENTEMAC1DCMLOCKED",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName  => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_CLIENTEMAC1DCMLOCKED_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge,
	SetupLow       => tsetup_CLIENTEMAC1DCMLOCKED_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge,
	HoldLow        => thold_CLIENTEMAC1DCMLOCKED_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge,
	HoldHigh       => thold_CLIENTEMAC1DCMLOCKED_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_CLIENTEMAC1PAUSEREQ_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData     => Tmkr_CLIENTEMAC1PAUSEREQ_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal     => CLIENTEMAC1PAUSEREQ,
	TestSignalName => "CLIENTEMAC1PAUSEREQ",
	TestDelay      => 0 ps,
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName  => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_CLIENTEMAC1PAUSEREQ_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge,
	SetupLow       => tsetup_CLIENTEMAC1PAUSEREQ_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge,
	HoldLow        => thold_CLIENTEMAC1PAUSEREQ_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge,
	HoldHigh       => thold_CLIENTEMAC1PAUSEREQ_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_CLIENTEMAC1PAUSEREQ_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData     => Tmkr_CLIENTEMAC1PAUSEREQ_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal     => CLIENTEMAC1PAUSEREQ,
	TestSignalName => "CLIENTEMAC1PAUSEREQ",
	TestDelay      => 0 ps,
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName  => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_CLIENTEMAC1PAUSEREQ_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge,
	SetupLow       => tsetup_CLIENTEMAC1PAUSEREQ_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge,
	HoldLow        => thold_CLIENTEMAC1PAUSEREQ_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge,
	HoldHigh       => thold_CLIENTEMAC1PAUSEREQ_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_CLIENTEMAC1PAUSEREQ_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData     => Tmkr_CLIENTEMAC1PAUSEREQ_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal     => CLIENTEMAC1PAUSEREQ,
	TestSignalName => "CLIENTEMAC1PAUSEREQ",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName  => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_CLIENTEMAC1PAUSEREQ_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge,
	SetupLow       => tsetup_CLIENTEMAC1PAUSEREQ_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge,
	HoldLow        => thold_CLIENTEMAC1PAUSEREQ_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge,
	HoldHigh       => thold_CLIENTEMAC1PAUSEREQ_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL0_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL0_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_dly(0),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(0)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN(0),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(0),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(0),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(0),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL0_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL0_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_dly(0),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(0)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN(0),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(0),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(0),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(0),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL0_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL0_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_dly(0),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(0)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN(0),
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC1TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(0),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(0),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(0),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL1_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL1_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_dly(1),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(1)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN(1),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(1),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(1),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(1),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL1_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL1_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_dly(1),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(1)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN(1),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(1),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(1),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(1),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL1_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL1_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_dly(1),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(1)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN(1),
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC1TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(1),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(1),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(1),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL2_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL2_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_dly(2),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(2)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN(2),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(2),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(2),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(2),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL2_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL2_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_dly(2),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(2)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN(2),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(2),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(2),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(2),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL2_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL2_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_dly(2),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(2)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN(2),
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC1TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(2),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(2),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(2),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL3_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL3_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_dly(3),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(3)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN(3),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(3),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(3),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(3),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(3),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL3_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL3_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_dly(3),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(3)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN(3),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(3),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(3),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(3),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(3),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL3_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL3_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_dly(3),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(3)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN(3),
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC1TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(3),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(3),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(3),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(3),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL4_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL4_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_dly(4),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(4)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN(4),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(4),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(4),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(4),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(4),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL4_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL4_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_dly(4),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(4)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN(4),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(4),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(4),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(4),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(4),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL4_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL4_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_dly(4),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(4)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN(4),
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC1TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(4),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(4),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(4),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(4),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL5_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL5_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_dly(5),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(5)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN(5),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(5),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(5),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(5),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(5),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL5_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL5_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_dly(5),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(5)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN(5),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(5),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(5),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(5),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(5),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL5_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL5_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_dly(5),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(5)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN(5),
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC1TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(5),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(5),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(5),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(5),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL6_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL6_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_dly(6),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(6)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN(6),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(6),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(6),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(6),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(6),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL6_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL6_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_dly(6),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(6)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN(6),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(6),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(6),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(6),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(6),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL6_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL6_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_dly(6),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(6)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN(6),
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC1TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(6),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(6),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(6),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(6),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL7_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL7_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_dly(7),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(7)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN(7),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(7),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(7),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(7),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(7),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL7_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL7_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_dly(7),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(7)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN(7),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(7),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(7),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(7),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(7),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL7_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL7_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_dly(7),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(7)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN(7),
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC1TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(7),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(7),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(7),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(7),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL8_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL8_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_dly(8),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(8)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN(8),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(8),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(8),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(8),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(8),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL8_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL8_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_dly(8),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(8)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN(8),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(8),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(8),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(8),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(8),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL8_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL8_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_dly(8),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(8)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN(8),
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC1TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(8),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(8),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(8),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(8),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL9_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL9_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_dly(9),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(9)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN(9),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(9),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(9),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(9),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(9),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL9_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL9_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_dly(9),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(9)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN(9),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(9),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(9),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(9),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(9),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL9_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL9_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_dly(9),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(9)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN(9),
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC1TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(9),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(9),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(9),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(9),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL10_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL10_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_dly(10),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(10)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN(10),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(10),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(10),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(10),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(10),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL10_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL10_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_dly(10),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(10)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN(10),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(10),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(10),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(10),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(10),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL10_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL10_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_dly(10),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(10)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN(10),
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC1TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(10),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(10),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(10),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(10),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL11_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL11_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_dly(11),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(11)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN(11),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(11),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(11),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(11),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(11),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL11_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL11_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_dly(11),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(11)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN(11),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(11),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(11),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(11),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(11),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL11_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL11_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_dly(11),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(11)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN(11),
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC1TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(11),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(11),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(11),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(11),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL12_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL12_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_dly(12),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(12)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN(12),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(12),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(12),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(12),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(12),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL12_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL12_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_dly(12),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(12)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN(12),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(12),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(12),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(12),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(12),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL12_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL12_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_dly(12),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(12)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN(12),
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC1TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(12),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(12),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(12),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(12),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL13_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL13_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_dly(13),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(13)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN(13),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(13),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(13),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(13),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(13),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL13_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL13_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_dly(13),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(13)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN(13),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(13),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(13),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(13),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(13),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL13_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL13_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_dly(13),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(13)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN(13),
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC1TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(13),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(13),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(13),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(13),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL14_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL14_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_dly(14),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(14)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN(14),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(14),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(14),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(14),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(14),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL14_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL14_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_dly(14),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(14)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN(14),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(14),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(14),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(14),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(14),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL14_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL14_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_dly(14),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(14)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN(14),
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC1TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(14),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(14),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(14),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(14),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL15_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL15_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_dly(15),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(15)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN(15),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(15),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(15),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(15),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(15),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL15_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL15_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_dly(15),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(15)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN(15),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(15),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(15),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(15),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(15),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1PAUSEVAL15_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1PAUSEVAL15_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC1PAUSEVAL_dly(15),
	TestSignalName => "CLIENTEMAC1PAUSEVAL(15)",
	TestDelay => tisd_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN(15),
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC1TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(15),
	SetupLow => tsetup_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(15),
	HoldLow => thold_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(15),
	HoldHigh => thold_CLIENTEMAC1PAUSEVAL_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(15),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD0_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD0_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_dly(0),
	TestSignalName => "CLIENTEMAC1TXD(0)",
	TestDelay => tisd_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN(0),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(0),
	SetupLow => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(0),
	HoldLow => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(0),
	HoldHigh => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD0_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD0_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_dly(0),
	TestSignalName => "CLIENTEMAC1TXD(0)",
	TestDelay => tisd_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN(0),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(0),
	SetupLow => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(0),
	HoldLow => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(0),
	HoldHigh => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD0_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD0_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_dly(0),
	TestSignalName => "CLIENTEMAC1TXD(0)",
	TestDelay => tisd_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN(0),
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC1TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(0),
	SetupLow => tsetup_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(0),
	HoldLow => thold_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(0),
	HoldHigh => thold_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD1_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD1_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_dly(1),
	TestSignalName => "CLIENTEMAC1TXD(1)",
	TestDelay => tisd_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN(1),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(1),
	SetupLow => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(1),
	HoldLow => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(1),
	HoldHigh => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD1_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD1_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_dly(1),
	TestSignalName => "CLIENTEMAC1TXD(1)",
	TestDelay => tisd_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN(1),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(1),
	SetupLow => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(1),
	HoldLow => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(1),
	HoldHigh => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD1_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD1_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_dly(1),
	TestSignalName => "CLIENTEMAC1TXD(1)",
	TestDelay => tisd_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN(1),
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC1TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(1),
	SetupLow => tsetup_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(1),
	HoldLow => thold_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(1),
	HoldHigh => thold_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD2_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD2_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_dly(2),
	TestSignalName => "CLIENTEMAC1TXD(2)",
	TestDelay => tisd_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN(2),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(2),
	SetupLow => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(2),
	HoldLow => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(2),
	HoldHigh => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD2_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD2_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_dly(2),
	TestSignalName => "CLIENTEMAC1TXD(2)",
	TestDelay => tisd_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN(2),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(2),
	SetupLow => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(2),
	HoldLow => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(2),
	HoldHigh => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD2_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD2_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_dly(2),
	TestSignalName => "CLIENTEMAC1TXD(2)",
	TestDelay => tisd_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN(2),
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC1TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(2),
	SetupLow => tsetup_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(2),
	HoldLow => thold_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(2),
	HoldHigh => thold_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD3_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD3_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_dly(3),
	TestSignalName => "CLIENTEMAC1TXD(3)",
	TestDelay => tisd_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN(3),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(3),
	SetupLow => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(3),
	HoldLow => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(3),
	HoldHigh => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(3),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD3_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD3_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_dly(3),
	TestSignalName => "CLIENTEMAC1TXD(3)",
	TestDelay => tisd_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN(3),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(3),
	SetupLow => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(3),
	HoldLow => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(3),
	HoldHigh => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(3),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD3_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD3_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_dly(3),
	TestSignalName => "CLIENTEMAC1TXD(3)",
	TestDelay => tisd_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN(3),
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC1TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(3),
	SetupLow => tsetup_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(3),
	HoldLow => thold_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(3),
	HoldHigh => thold_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(3),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD4_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD4_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_dly(4),
	TestSignalName => "CLIENTEMAC1TXD(4)",
	TestDelay => tisd_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN(4),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(4),
	SetupLow => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(4),
	HoldLow => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(4),
	HoldHigh => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(4),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD4_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD4_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_dly(4),
	TestSignalName => "CLIENTEMAC1TXD(4)",
	TestDelay => tisd_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN(4),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(4),
	SetupLow => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(4),
	HoldLow => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(4),
	HoldHigh => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(4),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD4_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD4_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_dly(4),
	TestSignalName => "CLIENTEMAC1TXD(4)",
	TestDelay => tisd_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN(4),
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC1TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(4),
	SetupLow => tsetup_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(4),
	HoldLow => thold_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(4),
	HoldHigh => thold_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(4),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD5_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD5_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_dly(5),
	TestSignalName => "CLIENTEMAC1TXD(5)",
	TestDelay => tisd_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN(5),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(5),
	SetupLow => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(5),
	HoldLow => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(5),
	HoldHigh => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(5),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD5_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD5_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_dly(5),
	TestSignalName => "CLIENTEMAC1TXD(5)",
	TestDelay => tisd_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN(5),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(5),
	SetupLow => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(5),
	HoldLow => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(5),
	HoldHigh => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(5),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD5_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD5_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_dly(5),
	TestSignalName => "CLIENTEMAC1TXD(5)",
	TestDelay => tisd_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN(5),
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC1TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(5),
	SetupLow => tsetup_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(5),
	HoldLow => thold_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(5),
	HoldHigh => thold_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(5),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD6_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD6_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_dly(6),
	TestSignalName => "CLIENTEMAC1TXD(6)",
	TestDelay => tisd_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN(6),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(6),
	SetupLow => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(6),
	HoldLow => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(6),
	HoldHigh => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(6),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD6_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD6_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_dly(6),
	TestSignalName => "CLIENTEMAC1TXD(6)",
	TestDelay => tisd_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN(6),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(6),
	SetupLow => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(6),
	HoldLow => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(6),
	HoldHigh => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(6),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD6_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD6_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_dly(6),
	TestSignalName => "CLIENTEMAC1TXD(6)",
	TestDelay => tisd_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN(6),
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC1TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(6),
	SetupLow => tsetup_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(6),
	HoldLow => thold_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(6),
	HoldHigh => thold_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(6),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD7_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD7_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_dly(7),
	TestSignalName => "CLIENTEMAC1TXD(7)",
	TestDelay => tisd_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN(7),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(7),
	SetupLow => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(7),
	HoldLow => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(7),
	HoldHigh => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(7),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD7_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD7_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_dly(7),
	TestSignalName => "CLIENTEMAC1TXD(7)",
	TestDelay => tisd_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN(7),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(7),
	SetupLow => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(7),
	HoldLow => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(7),
	HoldHigh => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(7),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD7_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD7_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_dly(7),
	TestSignalName => "CLIENTEMAC1TXD(7)",
	TestDelay => tisd_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN(7),
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC1TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(7),
	SetupLow => tsetup_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(7),
	HoldLow => thold_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(7),
	HoldHigh => thold_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(7),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD8_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD8_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_dly(8),
	TestSignalName => "CLIENTEMAC1TXD(8)",
	TestDelay => tisd_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN(8),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(8),
	SetupLow => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(8),
	HoldLow => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(8),
	HoldHigh => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(8),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD8_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD8_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_dly(8),
	TestSignalName => "CLIENTEMAC1TXD(8)",
	TestDelay => tisd_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN(8),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(8),
	SetupLow => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(8),
	HoldLow => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(8),
	HoldHigh => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(8),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD8_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD8_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_dly(8),
	TestSignalName => "CLIENTEMAC1TXD(8)",
	TestDelay => tisd_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN(8),
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC1TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(8),
	SetupLow => tsetup_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(8),
	HoldLow => thold_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(8),
	HoldHigh => thold_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(8),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD9_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD9_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_dly(9),
	TestSignalName => "CLIENTEMAC1TXD(9)",
	TestDelay => tisd_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN(9),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(9),
	SetupLow => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(9),
	HoldLow => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(9),
	HoldHigh => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(9),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD9_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD9_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_dly(9),
	TestSignalName => "CLIENTEMAC1TXD(9)",
	TestDelay => tisd_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN(9),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(9),
	SetupLow => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(9),
	HoldLow => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(9),
	HoldHigh => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(9),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD9_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD9_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_dly(9),
	TestSignalName => "CLIENTEMAC1TXD(9)",
	TestDelay => tisd_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN(9),
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC1TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(9),
	SetupLow => tsetup_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(9),
	HoldLow => thold_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(9),
	HoldHigh => thold_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(9),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD10_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD10_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_dly(10),
	TestSignalName => "CLIENTEMAC1TXD(10)",
	TestDelay => tisd_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN(10),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(10),
	SetupLow => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(10),
	HoldLow => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(10),
	HoldHigh => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(10),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD10_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD10_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_dly(10),
	TestSignalName => "CLIENTEMAC1TXD(10)",
	TestDelay => tisd_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN(10),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(10),
	SetupLow => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(10),
	HoldLow => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(10),
	HoldHigh => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(10),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD10_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD10_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_dly(10),
	TestSignalName => "CLIENTEMAC1TXD(10)",
	TestDelay => tisd_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN(10),
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC1TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(10),
	SetupLow => tsetup_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(10),
	HoldLow => thold_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(10),
	HoldHigh => thold_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(10),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD11_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD11_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_dly(11),
	TestSignalName => "CLIENTEMAC1TXD(11)",
	TestDelay => tisd_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN(11),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(11),
	SetupLow => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(11),
	HoldLow => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(11),
	HoldHigh => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(11),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD11_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD11_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_dly(11),
	TestSignalName => "CLIENTEMAC1TXD(11)",
	TestDelay => tisd_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN(11),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(11),
	SetupLow => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(11),
	HoldLow => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(11),
	HoldHigh => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(11),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD11_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD11_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_dly(11),
	TestSignalName => "CLIENTEMAC1TXD(11)",
	TestDelay => tisd_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN(11),
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC1TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(11),
	SetupLow => tsetup_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(11),
	HoldLow => thold_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(11),
	HoldHigh => thold_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(11),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD12_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD12_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_dly(12),
	TestSignalName => "CLIENTEMAC1TXD(12)",
	TestDelay => tisd_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN(12),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(12),
	SetupLow => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(12),
	HoldLow => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(12),
	HoldHigh => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(12),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD12_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD12_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_dly(12),
	TestSignalName => "CLIENTEMAC1TXD(12)",
	TestDelay => tisd_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN(12),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(12),
	SetupLow => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(12),
	HoldLow => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(12),
	HoldHigh => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(12),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD12_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD12_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_dly(12),
	TestSignalName => "CLIENTEMAC1TXD(12)",
	TestDelay => tisd_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN(12),
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC1TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(12),
	SetupLow => tsetup_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(12),
	HoldLow => thold_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(12),
	HoldHigh => thold_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(12),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD13_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD13_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_dly(13),
	TestSignalName => "CLIENTEMAC1TXD(13)",
	TestDelay => tisd_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN(13),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(13),
	SetupLow => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(13),
	HoldLow => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(13),
	HoldHigh => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(13),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD13_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD13_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_dly(13),
	TestSignalName => "CLIENTEMAC1TXD(13)",
	TestDelay => tisd_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN(13),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(13),
	SetupLow => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(13),
	HoldLow => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(13),
	HoldHigh => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(13),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD13_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD13_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_dly(13),
	TestSignalName => "CLIENTEMAC1TXD(13)",
	TestDelay => tisd_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN(13),
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC1TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(13),
	SetupLow => tsetup_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(13),
	HoldLow => thold_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(13),
	HoldHigh => thold_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(13),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD14_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD14_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_dly(14),
	TestSignalName => "CLIENTEMAC1TXD(14)",
	TestDelay => tisd_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN(14),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(14),
	SetupLow => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(14),
	HoldLow => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(14),
	HoldHigh => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(14),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD14_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD14_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_dly(14),
	TestSignalName => "CLIENTEMAC1TXD(14)",
	TestDelay => tisd_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN(14),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(14),
	SetupLow => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(14),
	HoldLow => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(14),
	HoldHigh => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(14),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD14_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD14_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_dly(14),
	TestSignalName => "CLIENTEMAC1TXD(14)",
	TestDelay => tisd_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN(14),
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC1TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(14),
	SetupLow => tsetup_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(14),
	HoldLow => thold_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(14),
	HoldHigh => thold_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(14),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD15_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD15_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_dly(15),
	TestSignalName => "CLIENTEMAC1TXD(15)",
	TestDelay => tisd_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN(15),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(15),
	SetupLow => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(15),
	HoldLow => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(15),
	HoldHigh => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(15),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD15_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD15_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_dly(15),
	TestSignalName => "CLIENTEMAC1TXD(15)",
	TestDelay => tisd_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN(15),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(15),
	SetupLow => tsetup_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(15),
	HoldLow => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(15),
	HoldHigh => thold_CLIENTEMAC1TXD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(15),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXD15_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXD15_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_dly(15),
	TestSignalName => "CLIENTEMAC1TXD(15)",
	TestDelay => tisd_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN(15),
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC1TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(15),
	SetupLow => tsetup_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(15),
	HoldLow => thold_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(15),
	HoldHigh => thold_CLIENTEMAC1TXD_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(15),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_CLIENTEMAC1TXDVLD_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData     => Tmkr_CLIENTEMAC1TXDVLD_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal     => CLIENTEMAC1TXDVLD,
	TestSignalName => "CLIENTEMAC1TXDVLD",
	TestDelay      => 0 ps,
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName  => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_CLIENTEMAC1TXDVLD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge,
	SetupLow       => tsetup_CLIENTEMAC1TXDVLD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge,
	HoldLow        => thold_CLIENTEMAC1TXDVLD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge,
	HoldHigh       => thold_CLIENTEMAC1TXDVLD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_CLIENTEMAC1TXDVLD_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData     => Tmkr_CLIENTEMAC1TXDVLD_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal     => CLIENTEMAC1TXDVLD,
	TestSignalName => "CLIENTEMAC1TXDVLD",
	TestDelay      => 0 ps,
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName  => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_CLIENTEMAC1TXDVLD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge,
	SetupLow       => tsetup_CLIENTEMAC1TXDVLD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge,
	HoldLow        => thold_CLIENTEMAC1TXDVLD_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge,
	HoldHigh       => thold_CLIENTEMAC1TXDVLD_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_CLIENTEMAC1TXDVLD_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData     => Tmkr_CLIENTEMAC1TXDVLD_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal     => CLIENTEMAC1TXDVLD,
	TestSignalName => "CLIENTEMAC1TXDVLD",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName  => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_CLIENTEMAC1TXDVLD_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge,
	SetupLow       => tsetup_CLIENTEMAC1TXDVLD_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge,
	HoldLow        => thold_CLIENTEMAC1TXDVLD_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge,
	HoldHigh       => thold_CLIENTEMAC1TXDVLD_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_CLIENTEMAC1TXDVLDMSW_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData     => Tmkr_CLIENTEMAC1TXDVLDMSW_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal     => CLIENTEMAC1TXDVLDMSW,
	TestSignalName => "CLIENTEMAC1TXDVLDMSW",
	TestDelay      => 0 ps,
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName  => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_CLIENTEMAC1TXDVLDMSW_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge,
	SetupLow       => tsetup_CLIENTEMAC1TXDVLDMSW_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge,
	HoldLow        => thold_CLIENTEMAC1TXDVLDMSW_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge,
	HoldHigh       => thold_CLIENTEMAC1TXDVLDMSW_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_CLIENTEMAC1TXDVLDMSW_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData     => Tmkr_CLIENTEMAC1TXDVLDMSW_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal     => CLIENTEMAC1TXDVLDMSW,
	TestSignalName => "CLIENTEMAC1TXDVLDMSW",
	TestDelay      => 0 ps,
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName  => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_CLIENTEMAC1TXDVLDMSW_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge,
	SetupLow       => tsetup_CLIENTEMAC1TXDVLDMSW_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge,
	HoldLow        => thold_CLIENTEMAC1TXDVLDMSW_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge,
	HoldHigh       => thold_CLIENTEMAC1TXDVLDMSW_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_CLIENTEMAC1TXDVLDMSW_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData     => Tmkr_CLIENTEMAC1TXDVLDMSW_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal     => CLIENTEMAC1TXDVLDMSW,
	TestSignalName => "CLIENTEMAC1TXDVLDMSW",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName  => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_CLIENTEMAC1TXDVLDMSW_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge,
	SetupLow       => tsetup_CLIENTEMAC1TXDVLDMSW_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge,
	HoldLow        => thold_CLIENTEMAC1TXDVLDMSW_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge,
	HoldHigh       => thold_CLIENTEMAC1TXDVLDMSW_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_CLIENTEMAC1TXFIRSTBYTE_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData     => Tmkr_CLIENTEMAC1TXFIRSTBYTE_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal     => CLIENTEMAC1TXFIRSTBYTE,
	TestSignalName => "CLIENTEMAC1TXFIRSTBYTE",
	TestDelay      => 0 ps,
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName  => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_CLIENTEMAC1TXFIRSTBYTE_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge,
	SetupLow       => tsetup_CLIENTEMAC1TXFIRSTBYTE_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge,
	HoldLow        => thold_CLIENTEMAC1TXFIRSTBYTE_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge,
	HoldHigh       => thold_CLIENTEMAC1TXFIRSTBYTE_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_CLIENTEMAC1TXFIRSTBYTE_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData     => Tmkr_CLIENTEMAC1TXFIRSTBYTE_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal     => CLIENTEMAC1TXFIRSTBYTE,
	TestSignalName => "CLIENTEMAC1TXFIRSTBYTE",
	TestDelay      => 0 ps,
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName  => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_CLIENTEMAC1TXFIRSTBYTE_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge,
	SetupLow       => tsetup_CLIENTEMAC1TXFIRSTBYTE_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge,
	HoldLow        => thold_CLIENTEMAC1TXFIRSTBYTE_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge,
	HoldHigh       => thold_CLIENTEMAC1TXFIRSTBYTE_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_CLIENTEMAC1TXFIRSTBYTE_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData     => Tmkr_CLIENTEMAC1TXFIRSTBYTE_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal     => CLIENTEMAC1TXFIRSTBYTE,
	TestSignalName => "CLIENTEMAC1TXFIRSTBYTE",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName  => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_CLIENTEMAC1TXFIRSTBYTE_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge,
	SetupLow       => tsetup_CLIENTEMAC1TXFIRSTBYTE_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge,
	HoldLow        => thold_CLIENTEMAC1TXFIRSTBYTE_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge,
	HoldHigh       => thold_CLIENTEMAC1TXFIRSTBYTE_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXIFGDELAY0_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXIFGDELAY0_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_dly(0),
	TestSignalName => "CLIENTEMAC1TXIFGDELAY(0)",
	TestDelay => tisd_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN(0),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(0),
	SetupLow => tsetup_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(0),
	HoldLow => thold_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(0),
	HoldHigh => thold_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXIFGDELAY0_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXIFGDELAY0_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_dly(0),
	TestSignalName => "CLIENTEMAC1TXIFGDELAY(0)",
	TestDelay => tisd_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN(0),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(0),
	SetupLow => tsetup_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(0),
	HoldLow => thold_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(0),
	HoldHigh => thold_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXIFGDELAY0_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXIFGDELAY0_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_dly(0),
	TestSignalName => "CLIENTEMAC1TXIFGDELAY(0)",
	TestDelay => tisd_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN(0),
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC1TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(0),
	SetupLow => tsetup_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(0),
	HoldLow => thold_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(0),
	HoldHigh => thold_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXIFGDELAY1_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXIFGDELAY1_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_dly(1),
	TestSignalName => "CLIENTEMAC1TXIFGDELAY(1)",
	TestDelay => tisd_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN(1),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(1),
	SetupLow => tsetup_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(1),
	HoldLow => thold_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(1),
	HoldHigh => thold_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXIFGDELAY1_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXIFGDELAY1_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_dly(1),
	TestSignalName => "CLIENTEMAC1TXIFGDELAY(1)",
	TestDelay => tisd_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN(1),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(1),
	SetupLow => tsetup_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(1),
	HoldLow => thold_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(1),
	HoldHigh => thold_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXIFGDELAY1_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXIFGDELAY1_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_dly(1),
	TestSignalName => "CLIENTEMAC1TXIFGDELAY(1)",
	TestDelay => tisd_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN(1),
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC1TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(1),
	SetupLow => tsetup_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(1),
	HoldLow => thold_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(1),
	HoldHigh => thold_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXIFGDELAY2_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXIFGDELAY2_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_dly(2),
	TestSignalName => "CLIENTEMAC1TXIFGDELAY(2)",
	TestDelay => tisd_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN(2),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(2),
	SetupLow => tsetup_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(2),
	HoldLow => thold_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(2),
	HoldHigh => thold_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXIFGDELAY2_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXIFGDELAY2_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_dly(2),
	TestSignalName => "CLIENTEMAC1TXIFGDELAY(2)",
	TestDelay => tisd_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN(2),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(2),
	SetupLow => tsetup_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(2),
	HoldLow => thold_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(2),
	HoldHigh => thold_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXIFGDELAY2_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXIFGDELAY2_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_dly(2),
	TestSignalName => "CLIENTEMAC1TXIFGDELAY(2)",
	TestDelay => tisd_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN(2),
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC1TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(2),
	SetupLow => tsetup_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(2),
	HoldLow => thold_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(2),
	HoldHigh => thold_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXIFGDELAY3_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXIFGDELAY3_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_dly(3),
	TestSignalName => "CLIENTEMAC1TXIFGDELAY(3)",
	TestDelay => tisd_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN(3),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(3),
	SetupLow => tsetup_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(3),
	HoldLow => thold_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(3),
	HoldHigh => thold_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(3),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXIFGDELAY3_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXIFGDELAY3_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_dly(3),
	TestSignalName => "CLIENTEMAC1TXIFGDELAY(3)",
	TestDelay => tisd_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN(3),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(3),
	SetupLow => tsetup_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(3),
	HoldLow => thold_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(3),
	HoldHigh => thold_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(3),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXIFGDELAY3_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXIFGDELAY3_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_dly(3),
	TestSignalName => "CLIENTEMAC1TXIFGDELAY(3)",
	TestDelay => tisd_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN(3),
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC1TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(3),
	SetupLow => tsetup_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(3),
	HoldLow => thold_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(3),
	HoldHigh => thold_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(3),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXIFGDELAY4_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXIFGDELAY4_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_dly(4),
	TestSignalName => "CLIENTEMAC1TXIFGDELAY(4)",
	TestDelay => tisd_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN(4),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(4),
	SetupLow => tsetup_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(4),
	HoldLow => thold_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(4),
	HoldHigh => thold_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(4),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXIFGDELAY4_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXIFGDELAY4_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_dly(4),
	TestSignalName => "CLIENTEMAC1TXIFGDELAY(4)",
	TestDelay => tisd_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN(4),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(4),
	SetupLow => tsetup_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(4),
	HoldLow => thold_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(4),
	HoldHigh => thold_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(4),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXIFGDELAY4_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXIFGDELAY4_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_dly(4),
	TestSignalName => "CLIENTEMAC1TXIFGDELAY(4)",
	TestDelay => tisd_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN(4),
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC1TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(4),
	SetupLow => tsetup_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(4),
	HoldLow => thold_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(4),
	HoldHigh => thold_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(4),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXIFGDELAY5_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXIFGDELAY5_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_dly(5),
	TestSignalName => "CLIENTEMAC1TXIFGDELAY(5)",
	TestDelay => tisd_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN(5),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(5),
	SetupLow => tsetup_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(5),
	HoldLow => thold_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(5),
	HoldHigh => thold_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(5),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXIFGDELAY5_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXIFGDELAY5_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_dly(5),
	TestSignalName => "CLIENTEMAC1TXIFGDELAY(5)",
	TestDelay => tisd_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN(5),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(5),
	SetupLow => tsetup_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(5),
	HoldLow => thold_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(5),
	HoldHigh => thold_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(5),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXIFGDELAY5_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXIFGDELAY5_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_dly(5),
	TestSignalName => "CLIENTEMAC1TXIFGDELAY(5)",
	TestDelay => tisd_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN(5),
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC1TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(5),
	SetupLow => tsetup_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(5),
	HoldLow => thold_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(5),
	HoldHigh => thold_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(5),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXIFGDELAY6_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXIFGDELAY6_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_dly(6),
	TestSignalName => "CLIENTEMAC1TXIFGDELAY(6)",
	TestDelay => tisd_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN(6),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(6),
	SetupLow => tsetup_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(6),
	HoldLow => thold_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(6),
	HoldHigh => thold_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(6),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXIFGDELAY6_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXIFGDELAY6_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_dly(6),
	TestSignalName => "CLIENTEMAC1TXIFGDELAY(6)",
	TestDelay => tisd_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN(6),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(6),
	SetupLow => tsetup_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(6),
	HoldLow => thold_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(6),
	HoldHigh => thold_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(6),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXIFGDELAY6_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXIFGDELAY6_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_dly(6),
	TestSignalName => "CLIENTEMAC1TXIFGDELAY(6)",
	TestDelay => tisd_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN(6),
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC1TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(6),
	SetupLow => tsetup_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(6),
	HoldLow => thold_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(6),
	HoldHigh => thold_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(6),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXIFGDELAY7_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXIFGDELAY7_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_dly(7),
	TestSignalName => "CLIENTEMAC1TXIFGDELAY(7)",
	TestDelay => tisd_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN(7),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(7),
	SetupLow => tsetup_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(7),
	HoldLow => thold_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(7),
	HoldHigh => thold_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(7),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXIFGDELAY7_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXIFGDELAY7_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal => CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_dly(7),
	TestSignalName => "CLIENTEMAC1TXIFGDELAY(7)",
	TestDelay => tisd_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN(7),
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay => ticd_CLIENTEMAC1TXCLIENTCLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(7),
	SetupLow => tsetup_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(7),
	HoldLow => thold_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge(7),
	HoldHigh => thold_CLIENTEMAC1TXIFGDELAY_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge(7),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_CLIENTEMAC1TXIFGDELAY7_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData => Tmkr_CLIENTEMAC1TXIFGDELAY7_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal => CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_dly(7),
	TestSignalName => "CLIENTEMAC1TXIFGDELAY(7)",
	TestDelay => tisd_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN(7),
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay => ticd_PHYEMAC1TXGMIIMIICLKIN,
	SetupHigh => tsetup_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(7),
	SetupLow => tsetup_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(7),
	HoldLow => thold_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge(7),
	HoldHigh => thold_CLIENTEMAC1TXIFGDELAY_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge(7),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_CLIENTEMAC1TXUNDERRUN_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData     => Tmkr_CLIENTEMAC1TXUNDERRUN_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal     => CLIENTEMAC1TXUNDERRUN,
	TestSignalName => "CLIENTEMAC1TXUNDERRUN",
	TestDelay      => 0 ps,
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName  => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_CLIENTEMAC1TXUNDERRUN_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge,
	SetupLow       => tsetup_CLIENTEMAC1TXUNDERRUN_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge,
	HoldLow        => thold_CLIENTEMAC1TXUNDERRUN_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge,
	HoldHigh       => thold_CLIENTEMAC1TXUNDERRUN_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_CLIENTEMAC1TXUNDERRUN_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TimingData     => Tmkr_CLIENTEMAC1TXUNDERRUN_CLIENTEMAC1TXCLIENTCLKIN_posedge,
	TestSignal     => CLIENTEMAC1TXUNDERRUN,
	TestSignalName => "CLIENTEMAC1TXUNDERRUN",
	TestDelay      => 0 ps,
	RefSignal => CLIENTEMAC1TXCLIENTCLKIN_dly,
	RefSignalName  => "CLIENTEMAC1TXCLIENTCLKIN",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_CLIENTEMAC1TXUNDERRUN_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge,
	SetupLow       => tsetup_CLIENTEMAC1TXUNDERRUN_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge,
	HoldLow        => thold_CLIENTEMAC1TXUNDERRUN_CLIENTEMAC1TXCLIENTCLKIN_posedge_posedge,
	HoldHigh       => thold_CLIENTEMAC1TXUNDERRUN_CLIENTEMAC1TXCLIENTCLKIN_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_CLIENTEMAC1TXUNDERRUN_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData     => Tmkr_CLIENTEMAC1TXUNDERRUN_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal     => CLIENTEMAC1TXUNDERRUN,
	TestSignalName => "CLIENTEMAC1TXUNDERRUN",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName  => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_CLIENTEMAC1TXUNDERRUN_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge,
	SetupLow       => tsetup_CLIENTEMAC1TXUNDERRUN_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge,
	HoldLow        => thold_CLIENTEMAC1TXUNDERRUN_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge,
	HoldHigh       => thold_CLIENTEMAC1TXUNDERRUN_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_DCREMACABUS0_DCREMACCLK_posedge,
	TimingData => Tmkr_DCREMACABUS0_DCREMACCLK_posedge,
	TestSignal => DCREMACABUS_DCREMACCLK_dly(0),
	TestSignalName => "DCREMACABUS(0)",
	TestDelay => tisd_DCREMACABUS_DCREMACCLK(0),
	RefSignal => DCREMACCLK_dly,
	RefSignalName => "DCREMACCLK",
	RefDelay => ticd_DCREMACCLK,
	SetupHigh => tsetup_DCREMACABUS_DCREMACCLK_posedge_posedge(0),
	SetupLow => tsetup_DCREMACABUS_DCREMACCLK_negedge_posedge(0),
	HoldLow => thold_DCREMACABUS_DCREMACCLK_posedge_posedge(0),
	HoldHigh => thold_DCREMACABUS_DCREMACCLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_DCREMACABUS1_DCREMACCLK_posedge,
	TimingData => Tmkr_DCREMACABUS1_DCREMACCLK_posedge,
	TestSignal => DCREMACABUS_DCREMACCLK_dly(1),
	TestSignalName => "DCREMACABUS(1)",
	TestDelay => tisd_DCREMACABUS_DCREMACCLK(1),
	RefSignal => DCREMACCLK_dly,
	RefSignalName => "DCREMACCLK",
	RefDelay => ticd_DCREMACCLK,
	SetupHigh => tsetup_DCREMACABUS_DCREMACCLK_posedge_posedge(1),
	SetupLow => tsetup_DCREMACABUS_DCREMACCLK_negedge_posedge(1),
	HoldLow => thold_DCREMACABUS_DCREMACCLK_posedge_posedge(1),
	HoldHigh => thold_DCREMACABUS_DCREMACCLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_DCREMACABUS2_DCREMACCLK_posedge,
	TimingData => Tmkr_DCREMACABUS2_DCREMACCLK_posedge,
	TestSignal => DCREMACABUS_DCREMACCLK_dly(2),
	TestSignalName => "DCREMACABUS(2)",
	TestDelay => tisd_DCREMACABUS_DCREMACCLK(2),
	RefSignal => DCREMACCLK_dly,
	RefSignalName => "DCREMACCLK",
	RefDelay => ticd_DCREMACCLK,
	SetupHigh => tsetup_DCREMACABUS_DCREMACCLK_posedge_posedge(2),
	SetupLow => tsetup_DCREMACABUS_DCREMACCLK_negedge_posedge(2),
	HoldLow => thold_DCREMACABUS_DCREMACCLK_posedge_posedge(2),
	HoldHigh => thold_DCREMACABUS_DCREMACCLK_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_DCREMACABUS3_DCREMACCLK_posedge,
	TimingData => Tmkr_DCREMACABUS3_DCREMACCLK_posedge,
	TestSignal => DCREMACABUS_DCREMACCLK_dly(3),
	TestSignalName => "DCREMACABUS(3)",
	TestDelay => tisd_DCREMACABUS_DCREMACCLK(3),
	RefSignal => DCREMACCLK_dly,
	RefSignalName => "DCREMACCLK",
	RefDelay => ticd_DCREMACCLK,
	SetupHigh => tsetup_DCREMACABUS_DCREMACCLK_posedge_posedge(3),
	SetupLow => tsetup_DCREMACABUS_DCREMACCLK_negedge_posedge(3),
	HoldLow => thold_DCREMACABUS_DCREMACCLK_posedge_posedge(3),
	HoldHigh => thold_DCREMACABUS_DCREMACCLK_negedge_posedge(3),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_DCREMACABUS4_DCREMACCLK_posedge,
	TimingData => Tmkr_DCREMACABUS4_DCREMACCLK_posedge,
	TestSignal => DCREMACABUS_DCREMACCLK_dly(4),
	TestSignalName => "DCREMACABUS(4)",
	TestDelay => tisd_DCREMACABUS_DCREMACCLK(4),
	RefSignal => DCREMACCLK_dly,
	RefSignalName => "DCREMACCLK",
	RefDelay => ticd_DCREMACCLK,
	SetupHigh => tsetup_DCREMACABUS_DCREMACCLK_posedge_posedge(4),
	SetupLow => tsetup_DCREMACABUS_DCREMACCLK_negedge_posedge(4),
	HoldLow => thold_DCREMACABUS_DCREMACCLK_posedge_posedge(4),
	HoldHigh => thold_DCREMACABUS_DCREMACCLK_negedge_posedge(4),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_DCREMACABUS5_DCREMACCLK_posedge,
	TimingData => Tmkr_DCREMACABUS5_DCREMACCLK_posedge,
	TestSignal => DCREMACABUS_DCREMACCLK_dly(5),
	TestSignalName => "DCREMACABUS(5)",
	TestDelay => tisd_DCREMACABUS_DCREMACCLK(5),
	RefSignal => DCREMACCLK_dly,
	RefSignalName => "DCREMACCLK",
	RefDelay => ticd_DCREMACCLK,
	SetupHigh => tsetup_DCREMACABUS_DCREMACCLK_posedge_posedge(5),
	SetupLow => tsetup_DCREMACABUS_DCREMACCLK_negedge_posedge(5),
	HoldLow => thold_DCREMACABUS_DCREMACCLK_posedge_posedge(5),
	HoldHigh => thold_DCREMACABUS_DCREMACCLK_negedge_posedge(5),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_DCREMACABUS6_DCREMACCLK_posedge,
	TimingData => Tmkr_DCREMACABUS6_DCREMACCLK_posedge,
	TestSignal => DCREMACABUS_DCREMACCLK_dly(6),
	TestSignalName => "DCREMACABUS(6)",
	TestDelay => tisd_DCREMACABUS_DCREMACCLK(6),
	RefSignal => DCREMACCLK_dly,
	RefSignalName => "DCREMACCLK",
	RefDelay => ticd_DCREMACCLK,
	SetupHigh => tsetup_DCREMACABUS_DCREMACCLK_posedge_posedge(6),
	SetupLow => tsetup_DCREMACABUS_DCREMACCLK_negedge_posedge(6),
	HoldLow => thold_DCREMACABUS_DCREMACCLK_posedge_posedge(6),
	HoldHigh => thold_DCREMACABUS_DCREMACCLK_negedge_posedge(6),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_DCREMACABUS7_DCREMACCLK_posedge,
	TimingData => Tmkr_DCREMACABUS7_DCREMACCLK_posedge,
	TestSignal => DCREMACABUS_DCREMACCLK_dly(7),
	TestSignalName => "DCREMACABUS(7)",
	TestDelay => tisd_DCREMACABUS_DCREMACCLK(7),
	RefSignal => DCREMACCLK_dly,
	RefSignalName => "DCREMACCLK",
	RefDelay => ticd_DCREMACCLK,
	SetupHigh => tsetup_DCREMACABUS_DCREMACCLK_posedge_posedge(7),
	SetupLow => tsetup_DCREMACABUS_DCREMACCLK_negedge_posedge(7),
	HoldLow => thold_DCREMACABUS_DCREMACCLK_posedge_posedge(7),
	HoldHigh => thold_DCREMACABUS_DCREMACCLK_negedge_posedge(7),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_DCREMACABUS8_DCREMACCLK_posedge,
	TimingData => Tmkr_DCREMACABUS8_DCREMACCLK_posedge,
	TestSignal => DCREMACABUS_DCREMACCLK_dly(8),
	TestSignalName => "DCREMACABUS(8)",
	TestDelay => tisd_DCREMACABUS_DCREMACCLK(8),
	RefSignal => DCREMACCLK_dly,
	RefSignalName => "DCREMACCLK",
	RefDelay => ticd_DCREMACCLK,
	SetupHigh => tsetup_DCREMACABUS_DCREMACCLK_posedge_posedge(8),
	SetupLow => tsetup_DCREMACABUS_DCREMACCLK_negedge_posedge(8),
	HoldLow => thold_DCREMACABUS_DCREMACCLK_posedge_posedge(8),
	HoldHigh => thold_DCREMACABUS_DCREMACCLK_negedge_posedge(8),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_DCREMACABUS9_DCREMACCLK_posedge,
	TimingData => Tmkr_DCREMACABUS9_DCREMACCLK_posedge,
	TestSignal => DCREMACABUS_DCREMACCLK_dly(9),
	TestSignalName => "DCREMACABUS(9)",
	TestDelay => tisd_DCREMACABUS_DCREMACCLK(9),
	RefSignal => DCREMACCLK_dly,
	RefSignalName => "DCREMACCLK",
	RefDelay => ticd_DCREMACCLK,
	SetupHigh => tsetup_DCREMACABUS_DCREMACCLK_posedge_posedge(9),
	SetupLow => tsetup_DCREMACABUS_DCREMACCLK_negedge_posedge(9),
	HoldLow => thold_DCREMACABUS_DCREMACCLK_posedge_posedge(9),
	HoldHigh => thold_DCREMACABUS_DCREMACCLK_negedge_posedge(9),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_DCREMACDBUS0_DCREMACCLK_posedge,
	TimingData => Tmkr_DCREMACDBUS0_DCREMACCLK_posedge,
	TestSignal => DCREMACDBUS_DCREMACCLK_dly(0),
	TestSignalName => "DCREMACDBUS(0)",
	TestDelay => tisd_DCREMACDBUS_DCREMACCLK(0),
	RefSignal => DCREMACCLK_dly,
	RefSignalName => "DCREMACCLK",
	RefDelay => ticd_DCREMACCLK,
	SetupHigh => tsetup_DCREMACDBUS_DCREMACCLK_posedge_posedge(0),
	SetupLow => tsetup_DCREMACDBUS_DCREMACCLK_negedge_posedge(0),
	HoldLow => thold_DCREMACDBUS_DCREMACCLK_posedge_posedge(0),
	HoldHigh => thold_DCREMACDBUS_DCREMACCLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_DCREMACDBUS1_DCREMACCLK_posedge,
	TimingData => Tmkr_DCREMACDBUS1_DCREMACCLK_posedge,
	TestSignal => DCREMACDBUS_DCREMACCLK_dly(1),
	TestSignalName => "DCREMACDBUS(1)",
	TestDelay => tisd_DCREMACDBUS_DCREMACCLK(1),
	RefSignal => DCREMACCLK_dly,
	RefSignalName => "DCREMACCLK",
	RefDelay => ticd_DCREMACCLK,
	SetupHigh => tsetup_DCREMACDBUS_DCREMACCLK_posedge_posedge(1),
	SetupLow => tsetup_DCREMACDBUS_DCREMACCLK_negedge_posedge(1),
	HoldLow => thold_DCREMACDBUS_DCREMACCLK_posedge_posedge(1),
	HoldHigh => thold_DCREMACDBUS_DCREMACCLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_DCREMACDBUS2_DCREMACCLK_posedge,
	TimingData => Tmkr_DCREMACDBUS2_DCREMACCLK_posedge,
	TestSignal => DCREMACDBUS_DCREMACCLK_dly(2),
	TestSignalName => "DCREMACDBUS(2)",
	TestDelay => tisd_DCREMACDBUS_DCREMACCLK(2),
	RefSignal => DCREMACCLK_dly,
	RefSignalName => "DCREMACCLK",
	RefDelay => ticd_DCREMACCLK,
	SetupHigh => tsetup_DCREMACDBUS_DCREMACCLK_posedge_posedge(2),
	SetupLow => tsetup_DCREMACDBUS_DCREMACCLK_negedge_posedge(2),
	HoldLow => thold_DCREMACDBUS_DCREMACCLK_posedge_posedge(2),
	HoldHigh => thold_DCREMACDBUS_DCREMACCLK_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_DCREMACDBUS3_DCREMACCLK_posedge,
	TimingData => Tmkr_DCREMACDBUS3_DCREMACCLK_posedge,
	TestSignal => DCREMACDBUS_DCREMACCLK_dly(3),
	TestSignalName => "DCREMACDBUS(3)",
	TestDelay => tisd_DCREMACDBUS_DCREMACCLK(3),
	RefSignal => DCREMACCLK_dly,
	RefSignalName => "DCREMACCLK",
	RefDelay => ticd_DCREMACCLK,
	SetupHigh => tsetup_DCREMACDBUS_DCREMACCLK_posedge_posedge(3),
	SetupLow => tsetup_DCREMACDBUS_DCREMACCLK_negedge_posedge(3),
	HoldLow => thold_DCREMACDBUS_DCREMACCLK_posedge_posedge(3),
	HoldHigh => thold_DCREMACDBUS_DCREMACCLK_negedge_posedge(3),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_DCREMACDBUS4_DCREMACCLK_posedge,
	TimingData => Tmkr_DCREMACDBUS4_DCREMACCLK_posedge,
	TestSignal => DCREMACDBUS_DCREMACCLK_dly(4),
	TestSignalName => "DCREMACDBUS(4)",
	TestDelay => tisd_DCREMACDBUS_DCREMACCLK(4),
	RefSignal => DCREMACCLK_dly,
	RefSignalName => "DCREMACCLK",
	RefDelay => ticd_DCREMACCLK,
	SetupHigh => tsetup_DCREMACDBUS_DCREMACCLK_posedge_posedge(4),
	SetupLow => tsetup_DCREMACDBUS_DCREMACCLK_negedge_posedge(4),
	HoldLow => thold_DCREMACDBUS_DCREMACCLK_posedge_posedge(4),
	HoldHigh => thold_DCREMACDBUS_DCREMACCLK_negedge_posedge(4),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_DCREMACDBUS5_DCREMACCLK_posedge,
	TimingData => Tmkr_DCREMACDBUS5_DCREMACCLK_posedge,
	TestSignal => DCREMACDBUS_DCREMACCLK_dly(5),
	TestSignalName => "DCREMACDBUS(5)",
	TestDelay => tisd_DCREMACDBUS_DCREMACCLK(5),
	RefSignal => DCREMACCLK_dly,
	RefSignalName => "DCREMACCLK",
	RefDelay => ticd_DCREMACCLK,
	SetupHigh => tsetup_DCREMACDBUS_DCREMACCLK_posedge_posedge(5),
	SetupLow => tsetup_DCREMACDBUS_DCREMACCLK_negedge_posedge(5),
	HoldLow => thold_DCREMACDBUS_DCREMACCLK_posedge_posedge(5),
	HoldHigh => thold_DCREMACDBUS_DCREMACCLK_negedge_posedge(5),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_DCREMACDBUS6_DCREMACCLK_posedge,
	TimingData => Tmkr_DCREMACDBUS6_DCREMACCLK_posedge,
	TestSignal => DCREMACDBUS_DCREMACCLK_dly(6),
	TestSignalName => "DCREMACDBUS(6)",
	TestDelay => tisd_DCREMACDBUS_DCREMACCLK(6),
	RefSignal => DCREMACCLK_dly,
	RefSignalName => "DCREMACCLK",
	RefDelay => ticd_DCREMACCLK,
	SetupHigh => tsetup_DCREMACDBUS_DCREMACCLK_posedge_posedge(6),
	SetupLow => tsetup_DCREMACDBUS_DCREMACCLK_negedge_posedge(6),
	HoldLow => thold_DCREMACDBUS_DCREMACCLK_posedge_posedge(6),
	HoldHigh => thold_DCREMACDBUS_DCREMACCLK_negedge_posedge(6),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_DCREMACDBUS7_DCREMACCLK_posedge,
	TimingData => Tmkr_DCREMACDBUS7_DCREMACCLK_posedge,
	TestSignal => DCREMACDBUS_DCREMACCLK_dly(7),
	TestSignalName => "DCREMACDBUS(7)",
	TestDelay => tisd_DCREMACDBUS_DCREMACCLK(7),
	RefSignal => DCREMACCLK_dly,
	RefSignalName => "DCREMACCLK",
	RefDelay => ticd_DCREMACCLK,
	SetupHigh => tsetup_DCREMACDBUS_DCREMACCLK_posedge_posedge(7),
	SetupLow => tsetup_DCREMACDBUS_DCREMACCLK_negedge_posedge(7),
	HoldLow => thold_DCREMACDBUS_DCREMACCLK_posedge_posedge(7),
	HoldHigh => thold_DCREMACDBUS_DCREMACCLK_negedge_posedge(7),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_DCREMACDBUS8_DCREMACCLK_posedge,
	TimingData => Tmkr_DCREMACDBUS8_DCREMACCLK_posedge,
	TestSignal => DCREMACDBUS_DCREMACCLK_dly(8),
	TestSignalName => "DCREMACDBUS(8)",
	TestDelay => tisd_DCREMACDBUS_DCREMACCLK(8),
	RefSignal => DCREMACCLK_dly,
	RefSignalName => "DCREMACCLK",
	RefDelay => ticd_DCREMACCLK,
	SetupHigh => tsetup_DCREMACDBUS_DCREMACCLK_posedge_posedge(8),
	SetupLow => tsetup_DCREMACDBUS_DCREMACCLK_negedge_posedge(8),
	HoldLow => thold_DCREMACDBUS_DCREMACCLK_posedge_posedge(8),
	HoldHigh => thold_DCREMACDBUS_DCREMACCLK_negedge_posedge(8),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_DCREMACDBUS9_DCREMACCLK_posedge,
	TimingData => Tmkr_DCREMACDBUS9_DCREMACCLK_posedge,
	TestSignal => DCREMACDBUS_DCREMACCLK_dly(9),
	TestSignalName => "DCREMACDBUS(9)",
	TestDelay => tisd_DCREMACDBUS_DCREMACCLK(9),
	RefSignal => DCREMACCLK_dly,
	RefSignalName => "DCREMACCLK",
	RefDelay => ticd_DCREMACCLK,
	SetupHigh => tsetup_DCREMACDBUS_DCREMACCLK_posedge_posedge(9),
	SetupLow => tsetup_DCREMACDBUS_DCREMACCLK_negedge_posedge(9),
	HoldLow => thold_DCREMACDBUS_DCREMACCLK_posedge_posedge(9),
	HoldHigh => thold_DCREMACDBUS_DCREMACCLK_negedge_posedge(9),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_DCREMACDBUS10_DCREMACCLK_posedge,
	TimingData => Tmkr_DCREMACDBUS10_DCREMACCLK_posedge,
	TestSignal => DCREMACDBUS_DCREMACCLK_dly(10),
	TestSignalName => "DCREMACDBUS(10)",
	TestDelay => tisd_DCREMACDBUS_DCREMACCLK(10),
	RefSignal => DCREMACCLK_dly,
	RefSignalName => "DCREMACCLK",
	RefDelay => ticd_DCREMACCLK,
	SetupHigh => tsetup_DCREMACDBUS_DCREMACCLK_posedge_posedge(10),
	SetupLow => tsetup_DCREMACDBUS_DCREMACCLK_negedge_posedge(10),
	HoldLow => thold_DCREMACDBUS_DCREMACCLK_posedge_posedge(10),
	HoldHigh => thold_DCREMACDBUS_DCREMACCLK_negedge_posedge(10),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_DCREMACDBUS11_DCREMACCLK_posedge,
	TimingData => Tmkr_DCREMACDBUS11_DCREMACCLK_posedge,
	TestSignal => DCREMACDBUS_DCREMACCLK_dly(11),
	TestSignalName => "DCREMACDBUS(11)",
	TestDelay => tisd_DCREMACDBUS_DCREMACCLK(11),
	RefSignal => DCREMACCLK_dly,
	RefSignalName => "DCREMACCLK",
	RefDelay => ticd_DCREMACCLK,
	SetupHigh => tsetup_DCREMACDBUS_DCREMACCLK_posedge_posedge(11),
	SetupLow => tsetup_DCREMACDBUS_DCREMACCLK_negedge_posedge(11),
	HoldLow => thold_DCREMACDBUS_DCREMACCLK_posedge_posedge(11),
	HoldHigh => thold_DCREMACDBUS_DCREMACCLK_negedge_posedge(11),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_DCREMACDBUS12_DCREMACCLK_posedge,
	TimingData => Tmkr_DCREMACDBUS12_DCREMACCLK_posedge,
	TestSignal => DCREMACDBUS_DCREMACCLK_dly(12),
	TestSignalName => "DCREMACDBUS(12)",
	TestDelay => tisd_DCREMACDBUS_DCREMACCLK(12),
	RefSignal => DCREMACCLK_dly,
	RefSignalName => "DCREMACCLK",
	RefDelay => ticd_DCREMACCLK,
	SetupHigh => tsetup_DCREMACDBUS_DCREMACCLK_posedge_posedge(12),
	SetupLow => tsetup_DCREMACDBUS_DCREMACCLK_negedge_posedge(12),
	HoldLow => thold_DCREMACDBUS_DCREMACCLK_posedge_posedge(12),
	HoldHigh => thold_DCREMACDBUS_DCREMACCLK_negedge_posedge(12),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_DCREMACDBUS13_DCREMACCLK_posedge,
	TimingData => Tmkr_DCREMACDBUS13_DCREMACCLK_posedge,
	TestSignal => DCREMACDBUS_DCREMACCLK_dly(13),
	TestSignalName => "DCREMACDBUS(13)",
	TestDelay => tisd_DCREMACDBUS_DCREMACCLK(13),
	RefSignal => DCREMACCLK_dly,
	RefSignalName => "DCREMACCLK",
	RefDelay => ticd_DCREMACCLK,
	SetupHigh => tsetup_DCREMACDBUS_DCREMACCLK_posedge_posedge(13),
	SetupLow => tsetup_DCREMACDBUS_DCREMACCLK_negedge_posedge(13),
	HoldLow => thold_DCREMACDBUS_DCREMACCLK_posedge_posedge(13),
	HoldHigh => thold_DCREMACDBUS_DCREMACCLK_negedge_posedge(13),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_DCREMACDBUS14_DCREMACCLK_posedge,
	TimingData => Tmkr_DCREMACDBUS14_DCREMACCLK_posedge,
	TestSignal => DCREMACDBUS_DCREMACCLK_dly(14),
	TestSignalName => "DCREMACDBUS(14)",
	TestDelay => tisd_DCREMACDBUS_DCREMACCLK(14),
	RefSignal => DCREMACCLK_dly,
	RefSignalName => "DCREMACCLK",
	RefDelay => ticd_DCREMACCLK,
	SetupHigh => tsetup_DCREMACDBUS_DCREMACCLK_posedge_posedge(14),
	SetupLow => tsetup_DCREMACDBUS_DCREMACCLK_negedge_posedge(14),
	HoldLow => thold_DCREMACDBUS_DCREMACCLK_posedge_posedge(14),
	HoldHigh => thold_DCREMACDBUS_DCREMACCLK_negedge_posedge(14),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_DCREMACDBUS15_DCREMACCLK_posedge,
	TimingData => Tmkr_DCREMACDBUS15_DCREMACCLK_posedge,
	TestSignal => DCREMACDBUS_DCREMACCLK_dly(15),
	TestSignalName => "DCREMACDBUS(15)",
	TestDelay => tisd_DCREMACDBUS_DCREMACCLK(15),
	RefSignal => DCREMACCLK_dly,
	RefSignalName => "DCREMACCLK",
	RefDelay => ticd_DCREMACCLK,
	SetupHigh => tsetup_DCREMACDBUS_DCREMACCLK_posedge_posedge(15),
	SetupLow => tsetup_DCREMACDBUS_DCREMACCLK_negedge_posedge(15),
	HoldLow => thold_DCREMACDBUS_DCREMACCLK_posedge_posedge(15),
	HoldHigh => thold_DCREMACDBUS_DCREMACCLK_negedge_posedge(15),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_DCREMACDBUS16_DCREMACCLK_posedge,
	TimingData => Tmkr_DCREMACDBUS16_DCREMACCLK_posedge,
	TestSignal => DCREMACDBUS_DCREMACCLK_dly(16),
	TestSignalName => "DCREMACDBUS(16)",
	TestDelay => tisd_DCREMACDBUS_DCREMACCLK(16),
	RefSignal => DCREMACCLK_dly,
	RefSignalName => "DCREMACCLK",
	RefDelay => ticd_DCREMACCLK,
	SetupHigh => tsetup_DCREMACDBUS_DCREMACCLK_posedge_posedge(16),
	SetupLow => tsetup_DCREMACDBUS_DCREMACCLK_negedge_posedge(16),
	HoldLow => thold_DCREMACDBUS_DCREMACCLK_posedge_posedge(16),
	HoldHigh => thold_DCREMACDBUS_DCREMACCLK_negedge_posedge(16),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_DCREMACDBUS17_DCREMACCLK_posedge,
	TimingData => Tmkr_DCREMACDBUS17_DCREMACCLK_posedge,
	TestSignal => DCREMACDBUS_DCREMACCLK_dly(17),
	TestSignalName => "DCREMACDBUS(17)",
	TestDelay => tisd_DCREMACDBUS_DCREMACCLK(17),
	RefSignal => DCREMACCLK_dly,
	RefSignalName => "DCREMACCLK",
	RefDelay => ticd_DCREMACCLK,
	SetupHigh => tsetup_DCREMACDBUS_DCREMACCLK_posedge_posedge(17),
	SetupLow => tsetup_DCREMACDBUS_DCREMACCLK_negedge_posedge(17),
	HoldLow => thold_DCREMACDBUS_DCREMACCLK_posedge_posedge(17),
	HoldHigh => thold_DCREMACDBUS_DCREMACCLK_negedge_posedge(17),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_DCREMACDBUS18_DCREMACCLK_posedge,
	TimingData => Tmkr_DCREMACDBUS18_DCREMACCLK_posedge,
	TestSignal => DCREMACDBUS_DCREMACCLK_dly(18),
	TestSignalName => "DCREMACDBUS(18)",
	TestDelay => tisd_DCREMACDBUS_DCREMACCLK(18),
	RefSignal => DCREMACCLK_dly,
	RefSignalName => "DCREMACCLK",
	RefDelay => ticd_DCREMACCLK,
	SetupHigh => tsetup_DCREMACDBUS_DCREMACCLK_posedge_posedge(18),
	SetupLow => tsetup_DCREMACDBUS_DCREMACCLK_negedge_posedge(18),
	HoldLow => thold_DCREMACDBUS_DCREMACCLK_posedge_posedge(18),
	HoldHigh => thold_DCREMACDBUS_DCREMACCLK_negedge_posedge(18),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_DCREMACDBUS19_DCREMACCLK_posedge,
	TimingData => Tmkr_DCREMACDBUS19_DCREMACCLK_posedge,
	TestSignal => DCREMACDBUS_DCREMACCLK_dly(19),
	TestSignalName => "DCREMACDBUS(19)",
	TestDelay => tisd_DCREMACDBUS_DCREMACCLK(19),
	RefSignal => DCREMACCLK_dly,
	RefSignalName => "DCREMACCLK",
	RefDelay => ticd_DCREMACCLK,
	SetupHigh => tsetup_DCREMACDBUS_DCREMACCLK_posedge_posedge(19),
	SetupLow => tsetup_DCREMACDBUS_DCREMACCLK_negedge_posedge(19),
	HoldLow => thold_DCREMACDBUS_DCREMACCLK_posedge_posedge(19),
	HoldHigh => thold_DCREMACDBUS_DCREMACCLK_negedge_posedge(19),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_DCREMACDBUS20_DCREMACCLK_posedge,
	TimingData => Tmkr_DCREMACDBUS20_DCREMACCLK_posedge,
	TestSignal => DCREMACDBUS_DCREMACCLK_dly(20),
	TestSignalName => "DCREMACDBUS(20)",
	TestDelay => tisd_DCREMACDBUS_DCREMACCLK(20),
	RefSignal => DCREMACCLK_dly,
	RefSignalName => "DCREMACCLK",
	RefDelay => ticd_DCREMACCLK,
	SetupHigh => tsetup_DCREMACDBUS_DCREMACCLK_posedge_posedge(20),
	SetupLow => tsetup_DCREMACDBUS_DCREMACCLK_negedge_posedge(20),
	HoldLow => thold_DCREMACDBUS_DCREMACCLK_posedge_posedge(20),
	HoldHigh => thold_DCREMACDBUS_DCREMACCLK_negedge_posedge(20),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_DCREMACDBUS21_DCREMACCLK_posedge,
	TimingData => Tmkr_DCREMACDBUS21_DCREMACCLK_posedge,
	TestSignal => DCREMACDBUS_DCREMACCLK_dly(21),
	TestSignalName => "DCREMACDBUS(21)",
	TestDelay => tisd_DCREMACDBUS_DCREMACCLK(21),
	RefSignal => DCREMACCLK_dly,
	RefSignalName => "DCREMACCLK",
	RefDelay => ticd_DCREMACCLK,
	SetupHigh => tsetup_DCREMACDBUS_DCREMACCLK_posedge_posedge(21),
	SetupLow => tsetup_DCREMACDBUS_DCREMACCLK_negedge_posedge(21),
	HoldLow => thold_DCREMACDBUS_DCREMACCLK_posedge_posedge(21),
	HoldHigh => thold_DCREMACDBUS_DCREMACCLK_negedge_posedge(21),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_DCREMACDBUS22_DCREMACCLK_posedge,
	TimingData => Tmkr_DCREMACDBUS22_DCREMACCLK_posedge,
	TestSignal => DCREMACDBUS_DCREMACCLK_dly(22),
	TestSignalName => "DCREMACDBUS(22)",
	TestDelay => tisd_DCREMACDBUS_DCREMACCLK(22),
	RefSignal => DCREMACCLK_dly,
	RefSignalName => "DCREMACCLK",
	RefDelay => ticd_DCREMACCLK,
	SetupHigh => tsetup_DCREMACDBUS_DCREMACCLK_posedge_posedge(22),
	SetupLow => tsetup_DCREMACDBUS_DCREMACCLK_negedge_posedge(22),
	HoldLow => thold_DCREMACDBUS_DCREMACCLK_posedge_posedge(22),
	HoldHigh => thold_DCREMACDBUS_DCREMACCLK_negedge_posedge(22),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_DCREMACDBUS23_DCREMACCLK_posedge,
	TimingData => Tmkr_DCREMACDBUS23_DCREMACCLK_posedge,
	TestSignal => DCREMACDBUS_DCREMACCLK_dly(23),
	TestSignalName => "DCREMACDBUS(23)",
	TestDelay => tisd_DCREMACDBUS_DCREMACCLK(23),
	RefSignal => DCREMACCLK_dly,
	RefSignalName => "DCREMACCLK",
	RefDelay => ticd_DCREMACCLK,
	SetupHigh => tsetup_DCREMACDBUS_DCREMACCLK_posedge_posedge(23),
	SetupLow => tsetup_DCREMACDBUS_DCREMACCLK_negedge_posedge(23),
	HoldLow => thold_DCREMACDBUS_DCREMACCLK_posedge_posedge(23),
	HoldHigh => thold_DCREMACDBUS_DCREMACCLK_negedge_posedge(23),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_DCREMACDBUS24_DCREMACCLK_posedge,
	TimingData => Tmkr_DCREMACDBUS24_DCREMACCLK_posedge,
	TestSignal => DCREMACDBUS_DCREMACCLK_dly(24),
	TestSignalName => "DCREMACDBUS(24)",
	TestDelay => tisd_DCREMACDBUS_DCREMACCLK(24),
	RefSignal => DCREMACCLK_dly,
	RefSignalName => "DCREMACCLK",
	RefDelay => ticd_DCREMACCLK,
	SetupHigh => tsetup_DCREMACDBUS_DCREMACCLK_posedge_posedge(24),
	SetupLow => tsetup_DCREMACDBUS_DCREMACCLK_negedge_posedge(24),
	HoldLow => thold_DCREMACDBUS_DCREMACCLK_posedge_posedge(24),
	HoldHigh => thold_DCREMACDBUS_DCREMACCLK_negedge_posedge(24),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_DCREMACDBUS25_DCREMACCLK_posedge,
	TimingData => Tmkr_DCREMACDBUS25_DCREMACCLK_posedge,
	TestSignal => DCREMACDBUS_DCREMACCLK_dly(25),
	TestSignalName => "DCREMACDBUS(25)",
	TestDelay => tisd_DCREMACDBUS_DCREMACCLK(25),
	RefSignal => DCREMACCLK_dly,
	RefSignalName => "DCREMACCLK",
	RefDelay => ticd_DCREMACCLK,
	SetupHigh => tsetup_DCREMACDBUS_DCREMACCLK_posedge_posedge(25),
	SetupLow => tsetup_DCREMACDBUS_DCREMACCLK_negedge_posedge(25),
	HoldLow => thold_DCREMACDBUS_DCREMACCLK_posedge_posedge(25),
	HoldHigh => thold_DCREMACDBUS_DCREMACCLK_negedge_posedge(25),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_DCREMACDBUS26_DCREMACCLK_posedge,
	TimingData => Tmkr_DCREMACDBUS26_DCREMACCLK_posedge,
	TestSignal => DCREMACDBUS_DCREMACCLK_dly(26),
	TestSignalName => "DCREMACDBUS(26)",
	TestDelay => tisd_DCREMACDBUS_DCREMACCLK(26),
	RefSignal => DCREMACCLK_dly,
	RefSignalName => "DCREMACCLK",
	RefDelay => ticd_DCREMACCLK,
	SetupHigh => tsetup_DCREMACDBUS_DCREMACCLK_posedge_posedge(26),
	SetupLow => tsetup_DCREMACDBUS_DCREMACCLK_negedge_posedge(26),
	HoldLow => thold_DCREMACDBUS_DCREMACCLK_posedge_posedge(26),
	HoldHigh => thold_DCREMACDBUS_DCREMACCLK_negedge_posedge(26),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_DCREMACDBUS27_DCREMACCLK_posedge,
	TimingData => Tmkr_DCREMACDBUS27_DCREMACCLK_posedge,
	TestSignal => DCREMACDBUS_DCREMACCLK_dly(27),
	TestSignalName => "DCREMACDBUS(27)",
	TestDelay => tisd_DCREMACDBUS_DCREMACCLK(27),
	RefSignal => DCREMACCLK_dly,
	RefSignalName => "DCREMACCLK",
	RefDelay => ticd_DCREMACCLK,
	SetupHigh => tsetup_DCREMACDBUS_DCREMACCLK_posedge_posedge(27),
	SetupLow => tsetup_DCREMACDBUS_DCREMACCLK_negedge_posedge(27),
	HoldLow => thold_DCREMACDBUS_DCREMACCLK_posedge_posedge(27),
	HoldHigh => thold_DCREMACDBUS_DCREMACCLK_negedge_posedge(27),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_DCREMACDBUS28_DCREMACCLK_posedge,
	TimingData => Tmkr_DCREMACDBUS28_DCREMACCLK_posedge,
	TestSignal => DCREMACDBUS_DCREMACCLK_dly(28),
	TestSignalName => "DCREMACDBUS(28)",
	TestDelay => tisd_DCREMACDBUS_DCREMACCLK(28),
	RefSignal => DCREMACCLK_dly,
	RefSignalName => "DCREMACCLK",
	RefDelay => ticd_DCREMACCLK,
	SetupHigh => tsetup_DCREMACDBUS_DCREMACCLK_posedge_posedge(28),
	SetupLow => tsetup_DCREMACDBUS_DCREMACCLK_negedge_posedge(28),
	HoldLow => thold_DCREMACDBUS_DCREMACCLK_posedge_posedge(28),
	HoldHigh => thold_DCREMACDBUS_DCREMACCLK_negedge_posedge(28),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_DCREMACDBUS29_DCREMACCLK_posedge,
	TimingData => Tmkr_DCREMACDBUS29_DCREMACCLK_posedge,
	TestSignal => DCREMACDBUS_DCREMACCLK_dly(29),
	TestSignalName => "DCREMACDBUS(29)",
	TestDelay => tisd_DCREMACDBUS_DCREMACCLK(29),
	RefSignal => DCREMACCLK_dly,
	RefSignalName => "DCREMACCLK",
	RefDelay => ticd_DCREMACCLK,
	SetupHigh => tsetup_DCREMACDBUS_DCREMACCLK_posedge_posedge(29),
	SetupLow => tsetup_DCREMACDBUS_DCREMACCLK_negedge_posedge(29),
	HoldLow => thold_DCREMACDBUS_DCREMACCLK_posedge_posedge(29),
	HoldHigh => thold_DCREMACDBUS_DCREMACCLK_negedge_posedge(29),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_DCREMACDBUS30_DCREMACCLK_posedge,
	TimingData => Tmkr_DCREMACDBUS30_DCREMACCLK_posedge,
	TestSignal => DCREMACDBUS_DCREMACCLK_dly(30),
	TestSignalName => "DCREMACDBUS(30)",
	TestDelay => tisd_DCREMACDBUS_DCREMACCLK(30),
	RefSignal => DCREMACCLK_dly,
	RefSignalName => "DCREMACCLK",
	RefDelay => ticd_DCREMACCLK,
	SetupHigh => tsetup_DCREMACDBUS_DCREMACCLK_posedge_posedge(30),
	SetupLow => tsetup_DCREMACDBUS_DCREMACCLK_negedge_posedge(30),
	HoldLow => thold_DCREMACDBUS_DCREMACCLK_posedge_posedge(30),
	HoldHigh => thold_DCREMACDBUS_DCREMACCLK_negedge_posedge(30),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_DCREMACDBUS31_DCREMACCLK_posedge,
	TimingData => Tmkr_DCREMACDBUS31_DCREMACCLK_posedge,
	TestSignal => DCREMACDBUS_DCREMACCLK_dly(31),
	TestSignalName => "DCREMACDBUS(31)",
	TestDelay => tisd_DCREMACDBUS_DCREMACCLK(31),
	RefSignal => DCREMACCLK_dly,
	RefSignalName => "DCREMACCLK",
	RefDelay => ticd_DCREMACCLK,
	SetupHigh => tsetup_DCREMACDBUS_DCREMACCLK_posedge_posedge(31),
	SetupLow => tsetup_DCREMACDBUS_DCREMACCLK_negedge_posedge(31),
	HoldLow => thold_DCREMACDBUS_DCREMACCLK_posedge_posedge(31),
	HoldHigh => thold_DCREMACDBUS_DCREMACCLK_negedge_posedge(31),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_DCREMACENABLE_DCREMACCLK_posedge,
	TimingData     => Tmkr_DCREMACENABLE_DCREMACCLK_posedge,
	TestSignal     => DCREMACENABLE,
	TestSignalName => "DCREMACENABLE",
	TestDelay      => 0 ps,
	RefSignal => DCREMACCLK_dly,
	RefSignalName  => "DCREMACCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_DCREMACENABLE_DCREMACCLK_posedge_posedge,
	SetupLow       => tsetup_DCREMACENABLE_DCREMACCLK_negedge_posedge,
	HoldLow        => thold_DCREMACENABLE_DCREMACCLK_posedge_posedge,
	HoldHigh       => thold_DCREMACENABLE_DCREMACCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_DCREMACREAD_DCREMACCLK_posedge,
	TimingData     => Tmkr_DCREMACREAD_DCREMACCLK_posedge,
	TestSignal     => DCREMACREAD,
	TestSignalName => "DCREMACREAD",
	TestDelay      => 0 ps,
	RefSignal => DCREMACCLK_dly,
	RefSignalName  => "DCREMACCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_DCREMACREAD_DCREMACCLK_posedge_posedge,
	SetupLow       => tsetup_DCREMACREAD_DCREMACCLK_negedge_posedge,
	HoldLow        => thold_DCREMACREAD_DCREMACCLK_posedge_posedge,
	HoldHigh       => thold_DCREMACREAD_DCREMACCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_DCREMACWRITE_DCREMACCLK_posedge,
	TimingData     => Tmkr_DCREMACWRITE_DCREMACCLK_posedge,
	TestSignal     => DCREMACWRITE,
	TestSignalName => "DCREMACWRITE",
	TestDelay      => 0 ps,
	RefSignal => DCREMACCLK_dly,
	RefSignalName  => "DCREMACCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_DCREMACWRITE_DCREMACCLK_posedge_posedge,
	SetupLow       => tsetup_DCREMACWRITE_DCREMACCLK_negedge_posedge,
	HoldLow        => thold_DCREMACWRITE_DCREMACCLK_posedge_posedge,
	HoldHigh       => thold_DCREMACWRITE_DCREMACCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTADDR0_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTADDR0_HOSTCLK_posedge,
	TestSignal => HOSTADDR_HOSTCLK_dly(0),
	TestSignalName => "HOSTADDR(0)",
	TestDelay => tisd_HOSTADDR_HOSTCLK(0),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTADDR_HOSTCLK_posedge_posedge(0),
	SetupLow => tsetup_HOSTADDR_HOSTCLK_negedge_posedge(0),
	HoldLow => thold_HOSTADDR_HOSTCLK_posedge_posedge(0),
	HoldHigh => thold_HOSTADDR_HOSTCLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTADDR1_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTADDR1_HOSTCLK_posedge,
	TestSignal => HOSTADDR_HOSTCLK_dly(1),
	TestSignalName => "HOSTADDR(1)",
	TestDelay => tisd_HOSTADDR_HOSTCLK(1),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTADDR_HOSTCLK_posedge_posedge(1),
	SetupLow => tsetup_HOSTADDR_HOSTCLK_negedge_posedge(1),
	HoldLow => thold_HOSTADDR_HOSTCLK_posedge_posedge(1),
	HoldHigh => thold_HOSTADDR_HOSTCLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTADDR2_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTADDR2_HOSTCLK_posedge,
	TestSignal => HOSTADDR_HOSTCLK_dly(2),
	TestSignalName => "HOSTADDR(2)",
	TestDelay => tisd_HOSTADDR_HOSTCLK(2),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTADDR_HOSTCLK_posedge_posedge(2),
	SetupLow => tsetup_HOSTADDR_HOSTCLK_negedge_posedge(2),
	HoldLow => thold_HOSTADDR_HOSTCLK_posedge_posedge(2),
	HoldHigh => thold_HOSTADDR_HOSTCLK_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTADDR3_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTADDR3_HOSTCLK_posedge,
	TestSignal => HOSTADDR_HOSTCLK_dly(3),
	TestSignalName => "HOSTADDR(3)",
	TestDelay => tisd_HOSTADDR_HOSTCLK(3),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTADDR_HOSTCLK_posedge_posedge(3),
	SetupLow => tsetup_HOSTADDR_HOSTCLK_negedge_posedge(3),
	HoldLow => thold_HOSTADDR_HOSTCLK_posedge_posedge(3),
	HoldHigh => thold_HOSTADDR_HOSTCLK_negedge_posedge(3),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTADDR4_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTADDR4_HOSTCLK_posedge,
	TestSignal => HOSTADDR_HOSTCLK_dly(4),
	TestSignalName => "HOSTADDR(4)",
	TestDelay => tisd_HOSTADDR_HOSTCLK(4),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTADDR_HOSTCLK_posedge_posedge(4),
	SetupLow => tsetup_HOSTADDR_HOSTCLK_negedge_posedge(4),
	HoldLow => thold_HOSTADDR_HOSTCLK_posedge_posedge(4),
	HoldHigh => thold_HOSTADDR_HOSTCLK_negedge_posedge(4),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTADDR5_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTADDR5_HOSTCLK_posedge,
	TestSignal => HOSTADDR_HOSTCLK_dly(5),
	TestSignalName => "HOSTADDR(5)",
	TestDelay => tisd_HOSTADDR_HOSTCLK(5),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTADDR_HOSTCLK_posedge_posedge(5),
	SetupLow => tsetup_HOSTADDR_HOSTCLK_negedge_posedge(5),
	HoldLow => thold_HOSTADDR_HOSTCLK_posedge_posedge(5),
	HoldHigh => thold_HOSTADDR_HOSTCLK_negedge_posedge(5),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTADDR6_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTADDR6_HOSTCLK_posedge,
	TestSignal => HOSTADDR_HOSTCLK_dly(6),
	TestSignalName => "HOSTADDR(6)",
	TestDelay => tisd_HOSTADDR_HOSTCLK(6),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTADDR_HOSTCLK_posedge_posedge(6),
	SetupLow => tsetup_HOSTADDR_HOSTCLK_negedge_posedge(6),
	HoldLow => thold_HOSTADDR_HOSTCLK_posedge_posedge(6),
	HoldHigh => thold_HOSTADDR_HOSTCLK_negedge_posedge(6),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTADDR7_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTADDR7_HOSTCLK_posedge,
	TestSignal => HOSTADDR_HOSTCLK_dly(7),
	TestSignalName => "HOSTADDR(7)",
	TestDelay => tisd_HOSTADDR_HOSTCLK(7),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTADDR_HOSTCLK_posedge_posedge(7),
	SetupLow => tsetup_HOSTADDR_HOSTCLK_negedge_posedge(7),
	HoldLow => thold_HOSTADDR_HOSTCLK_posedge_posedge(7),
	HoldHigh => thold_HOSTADDR_HOSTCLK_negedge_posedge(7),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTADDR8_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTADDR8_HOSTCLK_posedge,
	TestSignal => HOSTADDR_HOSTCLK_dly(8),
	TestSignalName => "HOSTADDR(8)",
	TestDelay => tisd_HOSTADDR_HOSTCLK(8),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTADDR_HOSTCLK_posedge_posedge(8),
	SetupLow => tsetup_HOSTADDR_HOSTCLK_negedge_posedge(8),
	HoldLow => thold_HOSTADDR_HOSTCLK_posedge_posedge(8),
	HoldHigh => thold_HOSTADDR_HOSTCLK_negedge_posedge(8),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTADDR9_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTADDR9_HOSTCLK_posedge,
	TestSignal => HOSTADDR_HOSTCLK_dly(9),
	TestSignalName => "HOSTADDR(9)",
	TestDelay => tisd_HOSTADDR_HOSTCLK(9),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTADDR_HOSTCLK_posedge_posedge(9),
	SetupLow => tsetup_HOSTADDR_HOSTCLK_negedge_posedge(9),
	HoldLow => thold_HOSTADDR_HOSTCLK_posedge_posedge(9),
	HoldHigh => thold_HOSTADDR_HOSTCLK_negedge_posedge(9),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_HOSTEMAC1SEL_HOSTCLK_posedge,
	TimingData     => Tmkr_HOSTEMAC1SEL_HOSTCLK_posedge,
	TestSignal     => HOSTEMAC1SEL,
	TestSignalName => "HOSTEMAC1SEL",
	TestDelay      => 0 ps,
	RefSignal => HOSTCLK_dly,
	RefSignalName  => "HOSTCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_HOSTEMAC1SEL_HOSTCLK_posedge_posedge,
	SetupLow       => tsetup_HOSTEMAC1SEL_HOSTCLK_negedge_posedge,
	HoldLow        => thold_HOSTEMAC1SEL_HOSTCLK_posedge_posedge,
	HoldHigh       => thold_HOSTEMAC1SEL_HOSTCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_HOSTMIIMSEL_HOSTCLK_posedge,
	TimingData     => Tmkr_HOSTMIIMSEL_HOSTCLK_posedge,
	TestSignal     => HOSTMIIMSEL,
	TestSignalName => "HOSTMIIMSEL",
	TestDelay      => 0 ps,
	RefSignal => HOSTCLK_dly,
	RefSignalName  => "HOSTCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_HOSTMIIMSEL_HOSTCLK_posedge_posedge,
	SetupLow       => tsetup_HOSTMIIMSEL_HOSTCLK_negedge_posedge,
	HoldLow        => thold_HOSTMIIMSEL_HOSTCLK_posedge_posedge,
	HoldHigh       => thold_HOSTMIIMSEL_HOSTCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTOPCODE0_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTOPCODE0_HOSTCLK_posedge,
	TestSignal => HOSTOPCODE_HOSTCLK_dly(0),
	TestSignalName => "HOSTOPCODE(0)",
	TestDelay => tisd_HOSTOPCODE_HOSTCLK(0),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTOPCODE_HOSTCLK_posedge_posedge(0),
	SetupLow => tsetup_HOSTOPCODE_HOSTCLK_negedge_posedge(0),
	HoldLow => thold_HOSTOPCODE_HOSTCLK_posedge_posedge(0),
	HoldHigh => thold_HOSTOPCODE_HOSTCLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTOPCODE1_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTOPCODE1_HOSTCLK_posedge,
	TestSignal => HOSTOPCODE_HOSTCLK_dly(1),
	TestSignalName => "HOSTOPCODE(1)",
	TestDelay => tisd_HOSTOPCODE_HOSTCLK(1),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTOPCODE_HOSTCLK_posedge_posedge(1),
	SetupLow => tsetup_HOSTOPCODE_HOSTCLK_negedge_posedge(1),
	HoldLow => thold_HOSTOPCODE_HOSTCLK_posedge_posedge(1),
	HoldHigh => thold_HOSTOPCODE_HOSTCLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_HOSTREQ_HOSTCLK_posedge,
	TimingData     => Tmkr_HOSTREQ_HOSTCLK_posedge,
	TestSignal     => HOSTREQ,
	TestSignalName => "HOSTREQ",
	TestDelay      => 0 ps,
	RefSignal => HOSTCLK_dly,
	RefSignalName  => "HOSTCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_HOSTREQ_HOSTCLK_posedge_posedge,
	SetupLow       => tsetup_HOSTREQ_HOSTCLK_negedge_posedge,
	HoldLow        => thold_HOSTREQ_HOSTCLK_posedge_posedge,
	HoldHigh       => thold_HOSTREQ_HOSTCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTWRDATA0_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTWRDATA0_HOSTCLK_posedge,
	TestSignal => HOSTWRDATA_HOSTCLK_dly(0),
	TestSignalName => "HOSTWRDATA(0)",
	TestDelay => tisd_HOSTWRDATA_HOSTCLK(0),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTWRDATA_HOSTCLK_posedge_posedge(0),
	SetupLow => tsetup_HOSTWRDATA_HOSTCLK_negedge_posedge(0),
	HoldLow => thold_HOSTWRDATA_HOSTCLK_posedge_posedge(0),
	HoldHigh => thold_HOSTWRDATA_HOSTCLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTWRDATA1_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTWRDATA1_HOSTCLK_posedge,
	TestSignal => HOSTWRDATA_HOSTCLK_dly(1),
	TestSignalName => "HOSTWRDATA(1)",
	TestDelay => tisd_HOSTWRDATA_HOSTCLK(1),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTWRDATA_HOSTCLK_posedge_posedge(1),
	SetupLow => tsetup_HOSTWRDATA_HOSTCLK_negedge_posedge(1),
	HoldLow => thold_HOSTWRDATA_HOSTCLK_posedge_posedge(1),
	HoldHigh => thold_HOSTWRDATA_HOSTCLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTWRDATA2_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTWRDATA2_HOSTCLK_posedge,
	TestSignal => HOSTWRDATA_HOSTCLK_dly(2),
	TestSignalName => "HOSTWRDATA(2)",
	TestDelay => tisd_HOSTWRDATA_HOSTCLK(2),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTWRDATA_HOSTCLK_posedge_posedge(2),
	SetupLow => tsetup_HOSTWRDATA_HOSTCLK_negedge_posedge(2),
	HoldLow => thold_HOSTWRDATA_HOSTCLK_posedge_posedge(2),
	HoldHigh => thold_HOSTWRDATA_HOSTCLK_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTWRDATA3_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTWRDATA3_HOSTCLK_posedge,
	TestSignal => HOSTWRDATA_HOSTCLK_dly(3),
	TestSignalName => "HOSTWRDATA(3)",
	TestDelay => tisd_HOSTWRDATA_HOSTCLK(3),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTWRDATA_HOSTCLK_posedge_posedge(3),
	SetupLow => tsetup_HOSTWRDATA_HOSTCLK_negedge_posedge(3),
	HoldLow => thold_HOSTWRDATA_HOSTCLK_posedge_posedge(3),
	HoldHigh => thold_HOSTWRDATA_HOSTCLK_negedge_posedge(3),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTWRDATA4_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTWRDATA4_HOSTCLK_posedge,
	TestSignal => HOSTWRDATA_HOSTCLK_dly(4),
	TestSignalName => "HOSTWRDATA(4)",
	TestDelay => tisd_HOSTWRDATA_HOSTCLK(4),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTWRDATA_HOSTCLK_posedge_posedge(4),
	SetupLow => tsetup_HOSTWRDATA_HOSTCLK_negedge_posedge(4),
	HoldLow => thold_HOSTWRDATA_HOSTCLK_posedge_posedge(4),
	HoldHigh => thold_HOSTWRDATA_HOSTCLK_negedge_posedge(4),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTWRDATA5_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTWRDATA5_HOSTCLK_posedge,
	TestSignal => HOSTWRDATA_HOSTCLK_dly(5),
	TestSignalName => "HOSTWRDATA(5)",
	TestDelay => tisd_HOSTWRDATA_HOSTCLK(5),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTWRDATA_HOSTCLK_posedge_posedge(5),
	SetupLow => tsetup_HOSTWRDATA_HOSTCLK_negedge_posedge(5),
	HoldLow => thold_HOSTWRDATA_HOSTCLK_posedge_posedge(5),
	HoldHigh => thold_HOSTWRDATA_HOSTCLK_negedge_posedge(5),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTWRDATA6_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTWRDATA6_HOSTCLK_posedge,
	TestSignal => HOSTWRDATA_HOSTCLK_dly(6),
	TestSignalName => "HOSTWRDATA(6)",
	TestDelay => tisd_HOSTWRDATA_HOSTCLK(6),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTWRDATA_HOSTCLK_posedge_posedge(6),
	SetupLow => tsetup_HOSTWRDATA_HOSTCLK_negedge_posedge(6),
	HoldLow => thold_HOSTWRDATA_HOSTCLK_posedge_posedge(6),
	HoldHigh => thold_HOSTWRDATA_HOSTCLK_negedge_posedge(6),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTWRDATA7_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTWRDATA7_HOSTCLK_posedge,
	TestSignal => HOSTWRDATA_HOSTCLK_dly(7),
	TestSignalName => "HOSTWRDATA(7)",
	TestDelay => tisd_HOSTWRDATA_HOSTCLK(7),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTWRDATA_HOSTCLK_posedge_posedge(7),
	SetupLow => tsetup_HOSTWRDATA_HOSTCLK_negedge_posedge(7),
	HoldLow => thold_HOSTWRDATA_HOSTCLK_posedge_posedge(7),
	HoldHigh => thold_HOSTWRDATA_HOSTCLK_negedge_posedge(7),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTWRDATA8_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTWRDATA8_HOSTCLK_posedge,
	TestSignal => HOSTWRDATA_HOSTCLK_dly(8),
	TestSignalName => "HOSTWRDATA(8)",
	TestDelay => tisd_HOSTWRDATA_HOSTCLK(8),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTWRDATA_HOSTCLK_posedge_posedge(8),
	SetupLow => tsetup_HOSTWRDATA_HOSTCLK_negedge_posedge(8),
	HoldLow => thold_HOSTWRDATA_HOSTCLK_posedge_posedge(8),
	HoldHigh => thold_HOSTWRDATA_HOSTCLK_negedge_posedge(8),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTWRDATA9_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTWRDATA9_HOSTCLK_posedge,
	TestSignal => HOSTWRDATA_HOSTCLK_dly(9),
	TestSignalName => "HOSTWRDATA(9)",
	TestDelay => tisd_HOSTWRDATA_HOSTCLK(9),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTWRDATA_HOSTCLK_posedge_posedge(9),
	SetupLow => tsetup_HOSTWRDATA_HOSTCLK_negedge_posedge(9),
	HoldLow => thold_HOSTWRDATA_HOSTCLK_posedge_posedge(9),
	HoldHigh => thold_HOSTWRDATA_HOSTCLK_negedge_posedge(9),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTWRDATA10_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTWRDATA10_HOSTCLK_posedge,
	TestSignal => HOSTWRDATA_HOSTCLK_dly(10),
	TestSignalName => "HOSTWRDATA(10)",
	TestDelay => tisd_HOSTWRDATA_HOSTCLK(10),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTWRDATA_HOSTCLK_posedge_posedge(10),
	SetupLow => tsetup_HOSTWRDATA_HOSTCLK_negedge_posedge(10),
	HoldLow => thold_HOSTWRDATA_HOSTCLK_posedge_posedge(10),
	HoldHigh => thold_HOSTWRDATA_HOSTCLK_negedge_posedge(10),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTWRDATA11_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTWRDATA11_HOSTCLK_posedge,
	TestSignal => HOSTWRDATA_HOSTCLK_dly(11),
	TestSignalName => "HOSTWRDATA(11)",
	TestDelay => tisd_HOSTWRDATA_HOSTCLK(11),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTWRDATA_HOSTCLK_posedge_posedge(11),
	SetupLow => tsetup_HOSTWRDATA_HOSTCLK_negedge_posedge(11),
	HoldLow => thold_HOSTWRDATA_HOSTCLK_posedge_posedge(11),
	HoldHigh => thold_HOSTWRDATA_HOSTCLK_negedge_posedge(11),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTWRDATA12_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTWRDATA12_HOSTCLK_posedge,
	TestSignal => HOSTWRDATA_HOSTCLK_dly(12),
	TestSignalName => "HOSTWRDATA(12)",
	TestDelay => tisd_HOSTWRDATA_HOSTCLK(12),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTWRDATA_HOSTCLK_posedge_posedge(12),
	SetupLow => tsetup_HOSTWRDATA_HOSTCLK_negedge_posedge(12),
	HoldLow => thold_HOSTWRDATA_HOSTCLK_posedge_posedge(12),
	HoldHigh => thold_HOSTWRDATA_HOSTCLK_negedge_posedge(12),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTWRDATA13_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTWRDATA13_HOSTCLK_posedge,
	TestSignal => HOSTWRDATA_HOSTCLK_dly(13),
	TestSignalName => "HOSTWRDATA(13)",
	TestDelay => tisd_HOSTWRDATA_HOSTCLK(13),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTWRDATA_HOSTCLK_posedge_posedge(13),
	SetupLow => tsetup_HOSTWRDATA_HOSTCLK_negedge_posedge(13),
	HoldLow => thold_HOSTWRDATA_HOSTCLK_posedge_posedge(13),
	HoldHigh => thold_HOSTWRDATA_HOSTCLK_negedge_posedge(13),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTWRDATA14_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTWRDATA14_HOSTCLK_posedge,
	TestSignal => HOSTWRDATA_HOSTCLK_dly(14),
	TestSignalName => "HOSTWRDATA(14)",
	TestDelay => tisd_HOSTWRDATA_HOSTCLK(14),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTWRDATA_HOSTCLK_posedge_posedge(14),
	SetupLow => tsetup_HOSTWRDATA_HOSTCLK_negedge_posedge(14),
	HoldLow => thold_HOSTWRDATA_HOSTCLK_posedge_posedge(14),
	HoldHigh => thold_HOSTWRDATA_HOSTCLK_negedge_posedge(14),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTWRDATA15_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTWRDATA15_HOSTCLK_posedge,
	TestSignal => HOSTWRDATA_HOSTCLK_dly(15),
	TestSignalName => "HOSTWRDATA(15)",
	TestDelay => tisd_HOSTWRDATA_HOSTCLK(15),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTWRDATA_HOSTCLK_posedge_posedge(15),
	SetupLow => tsetup_HOSTWRDATA_HOSTCLK_negedge_posedge(15),
	HoldLow => thold_HOSTWRDATA_HOSTCLK_posedge_posedge(15),
	HoldHigh => thold_HOSTWRDATA_HOSTCLK_negedge_posedge(15),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTWRDATA16_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTWRDATA16_HOSTCLK_posedge,
	TestSignal => HOSTWRDATA_HOSTCLK_dly(16),
	TestSignalName => "HOSTWRDATA(16)",
	TestDelay => tisd_HOSTWRDATA_HOSTCLK(16),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTWRDATA_HOSTCLK_posedge_posedge(16),
	SetupLow => tsetup_HOSTWRDATA_HOSTCLK_negedge_posedge(16),
	HoldLow => thold_HOSTWRDATA_HOSTCLK_posedge_posedge(16),
	HoldHigh => thold_HOSTWRDATA_HOSTCLK_negedge_posedge(16),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTWRDATA17_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTWRDATA17_HOSTCLK_posedge,
	TestSignal => HOSTWRDATA_HOSTCLK_dly(17),
	TestSignalName => "HOSTWRDATA(17)",
	TestDelay => tisd_HOSTWRDATA_HOSTCLK(17),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTWRDATA_HOSTCLK_posedge_posedge(17),
	SetupLow => tsetup_HOSTWRDATA_HOSTCLK_negedge_posedge(17),
	HoldLow => thold_HOSTWRDATA_HOSTCLK_posedge_posedge(17),
	HoldHigh => thold_HOSTWRDATA_HOSTCLK_negedge_posedge(17),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTWRDATA18_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTWRDATA18_HOSTCLK_posedge,
	TestSignal => HOSTWRDATA_HOSTCLK_dly(18),
	TestSignalName => "HOSTWRDATA(18)",
	TestDelay => tisd_HOSTWRDATA_HOSTCLK(18),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTWRDATA_HOSTCLK_posedge_posedge(18),
	SetupLow => tsetup_HOSTWRDATA_HOSTCLK_negedge_posedge(18),
	HoldLow => thold_HOSTWRDATA_HOSTCLK_posedge_posedge(18),
	HoldHigh => thold_HOSTWRDATA_HOSTCLK_negedge_posedge(18),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTWRDATA19_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTWRDATA19_HOSTCLK_posedge,
	TestSignal => HOSTWRDATA_HOSTCLK_dly(19),
	TestSignalName => "HOSTWRDATA(19)",
	TestDelay => tisd_HOSTWRDATA_HOSTCLK(19),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTWRDATA_HOSTCLK_posedge_posedge(19),
	SetupLow => tsetup_HOSTWRDATA_HOSTCLK_negedge_posedge(19),
	HoldLow => thold_HOSTWRDATA_HOSTCLK_posedge_posedge(19),
	HoldHigh => thold_HOSTWRDATA_HOSTCLK_negedge_posedge(19),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTWRDATA20_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTWRDATA20_HOSTCLK_posedge,
	TestSignal => HOSTWRDATA_HOSTCLK_dly(20),
	TestSignalName => "HOSTWRDATA(20)",
	TestDelay => tisd_HOSTWRDATA_HOSTCLK(20),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTWRDATA_HOSTCLK_posedge_posedge(20),
	SetupLow => tsetup_HOSTWRDATA_HOSTCLK_negedge_posedge(20),
	HoldLow => thold_HOSTWRDATA_HOSTCLK_posedge_posedge(20),
	HoldHigh => thold_HOSTWRDATA_HOSTCLK_negedge_posedge(20),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTWRDATA21_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTWRDATA21_HOSTCLK_posedge,
	TestSignal => HOSTWRDATA_HOSTCLK_dly(21),
	TestSignalName => "HOSTWRDATA(21)",
	TestDelay => tisd_HOSTWRDATA_HOSTCLK(21),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTWRDATA_HOSTCLK_posedge_posedge(21),
	SetupLow => tsetup_HOSTWRDATA_HOSTCLK_negedge_posedge(21),
	HoldLow => thold_HOSTWRDATA_HOSTCLK_posedge_posedge(21),
	HoldHigh => thold_HOSTWRDATA_HOSTCLK_negedge_posedge(21),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTWRDATA22_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTWRDATA22_HOSTCLK_posedge,
	TestSignal => HOSTWRDATA_HOSTCLK_dly(22),
	TestSignalName => "HOSTWRDATA(22)",
	TestDelay => tisd_HOSTWRDATA_HOSTCLK(22),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTWRDATA_HOSTCLK_posedge_posedge(22),
	SetupLow => tsetup_HOSTWRDATA_HOSTCLK_negedge_posedge(22),
	HoldLow => thold_HOSTWRDATA_HOSTCLK_posedge_posedge(22),
	HoldHigh => thold_HOSTWRDATA_HOSTCLK_negedge_posedge(22),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTWRDATA23_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTWRDATA23_HOSTCLK_posedge,
	TestSignal => HOSTWRDATA_HOSTCLK_dly(23),
	TestSignalName => "HOSTWRDATA(23)",
	TestDelay => tisd_HOSTWRDATA_HOSTCLK(23),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTWRDATA_HOSTCLK_posedge_posedge(23),
	SetupLow => tsetup_HOSTWRDATA_HOSTCLK_negedge_posedge(23),
	HoldLow => thold_HOSTWRDATA_HOSTCLK_posedge_posedge(23),
	HoldHigh => thold_HOSTWRDATA_HOSTCLK_negedge_posedge(23),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTWRDATA24_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTWRDATA24_HOSTCLK_posedge,
	TestSignal => HOSTWRDATA_HOSTCLK_dly(24),
	TestSignalName => "HOSTWRDATA(24)",
	TestDelay => tisd_HOSTWRDATA_HOSTCLK(24),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTWRDATA_HOSTCLK_posedge_posedge(24),
	SetupLow => tsetup_HOSTWRDATA_HOSTCLK_negedge_posedge(24),
	HoldLow => thold_HOSTWRDATA_HOSTCLK_posedge_posedge(24),
	HoldHigh => thold_HOSTWRDATA_HOSTCLK_negedge_posedge(24),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTWRDATA25_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTWRDATA25_HOSTCLK_posedge,
	TestSignal => HOSTWRDATA_HOSTCLK_dly(25),
	TestSignalName => "HOSTWRDATA(25)",
	TestDelay => tisd_HOSTWRDATA_HOSTCLK(25),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTWRDATA_HOSTCLK_posedge_posedge(25),
	SetupLow => tsetup_HOSTWRDATA_HOSTCLK_negedge_posedge(25),
	HoldLow => thold_HOSTWRDATA_HOSTCLK_posedge_posedge(25),
	HoldHigh => thold_HOSTWRDATA_HOSTCLK_negedge_posedge(25),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTWRDATA26_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTWRDATA26_HOSTCLK_posedge,
	TestSignal => HOSTWRDATA_HOSTCLK_dly(26),
	TestSignalName => "HOSTWRDATA(26)",
	TestDelay => tisd_HOSTWRDATA_HOSTCLK(26),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTWRDATA_HOSTCLK_posedge_posedge(26),
	SetupLow => tsetup_HOSTWRDATA_HOSTCLK_negedge_posedge(26),
	HoldLow => thold_HOSTWRDATA_HOSTCLK_posedge_posedge(26),
	HoldHigh => thold_HOSTWRDATA_HOSTCLK_negedge_posedge(26),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTWRDATA27_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTWRDATA27_HOSTCLK_posedge,
	TestSignal => HOSTWRDATA_HOSTCLK_dly(27),
	TestSignalName => "HOSTWRDATA(27)",
	TestDelay => tisd_HOSTWRDATA_HOSTCLK(27),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTWRDATA_HOSTCLK_posedge_posedge(27),
	SetupLow => tsetup_HOSTWRDATA_HOSTCLK_negedge_posedge(27),
	HoldLow => thold_HOSTWRDATA_HOSTCLK_posedge_posedge(27),
	HoldHigh => thold_HOSTWRDATA_HOSTCLK_negedge_posedge(27),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTWRDATA28_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTWRDATA28_HOSTCLK_posedge,
	TestSignal => HOSTWRDATA_HOSTCLK_dly(28),
	TestSignalName => "HOSTWRDATA(28)",
	TestDelay => tisd_HOSTWRDATA_HOSTCLK(28),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTWRDATA_HOSTCLK_posedge_posedge(28),
	SetupLow => tsetup_HOSTWRDATA_HOSTCLK_negedge_posedge(28),
	HoldLow => thold_HOSTWRDATA_HOSTCLK_posedge_posedge(28),
	HoldHigh => thold_HOSTWRDATA_HOSTCLK_negedge_posedge(28),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTWRDATA29_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTWRDATA29_HOSTCLK_posedge,
	TestSignal => HOSTWRDATA_HOSTCLK_dly(29),
	TestSignalName => "HOSTWRDATA(29)",
	TestDelay => tisd_HOSTWRDATA_HOSTCLK(29),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTWRDATA_HOSTCLK_posedge_posedge(29),
	SetupLow => tsetup_HOSTWRDATA_HOSTCLK_negedge_posedge(29),
	HoldLow => thold_HOSTWRDATA_HOSTCLK_posedge_posedge(29),
	HoldHigh => thold_HOSTWRDATA_HOSTCLK_negedge_posedge(29),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTWRDATA30_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTWRDATA30_HOSTCLK_posedge,
	TestSignal => HOSTWRDATA_HOSTCLK_dly(30),
	TestSignalName => "HOSTWRDATA(30)",
	TestDelay => tisd_HOSTWRDATA_HOSTCLK(30),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTWRDATA_HOSTCLK_posedge_posedge(30),
	SetupLow => tsetup_HOSTWRDATA_HOSTCLK_negedge_posedge(30),
	HoldLow => thold_HOSTWRDATA_HOSTCLK_posedge_posedge(30),
	HoldHigh => thold_HOSTWRDATA_HOSTCLK_negedge_posedge(30),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_HOSTWRDATA31_HOSTCLK_posedge,
	TimingData => Tmkr_HOSTWRDATA31_HOSTCLK_posedge,
	TestSignal => HOSTWRDATA_HOSTCLK_dly(31),
	TestSignalName => "HOSTWRDATA(31)",
	TestDelay => tisd_HOSTWRDATA_HOSTCLK(31),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_HOSTWRDATA_HOSTCLK_posedge_posedge(31),
	SetupLow => tsetup_HOSTWRDATA_HOSTCLK_negedge_posedge(31),
	HoldLow => thold_HOSTWRDATA_HOSTCLK_posedge_posedge(31),
	HoldHigh => thold_HOSTWRDATA_HOSTCLK_negedge_posedge(31),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0COL_PHYEMAC0GTXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC0COL_PHYEMAC0GTXCLK_posedge,
	TestSignal     => PHYEMAC0COL,
	TestSignalName => "PHYEMAC0COL",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0GTXCLK_dly,
	RefSignalName  => "PHYEMAC0GTXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0COL_PHYEMAC0GTXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0COL_PHYEMAC0GTXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC0COL_PHYEMAC0GTXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0COL_PHYEMAC0GTXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0COL_PHYEMAC0RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC0COL_PHYEMAC0RXCLK_posedge,
	TestSignal     => PHYEMAC0COL,
	TestSignalName => "PHYEMAC0COL",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName  => "PHYEMAC0RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0COL_PHYEMAC0RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0COL_PHYEMAC0RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC0COL_PHYEMAC0RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0COL_PHYEMAC0RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0COL_PHYEMAC0RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC0COL_PHYEMAC0RXCLK_posedge,
	TestSignal     => PHYEMAC0COL,
	TestSignalName => "PHYEMAC0COL",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName  => "PHYEMAC0RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0COL_PHYEMAC0RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0COL_PHYEMAC0RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC0COL_PHYEMAC0RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0COL_PHYEMAC0RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0CRS_PHYEMAC0GTXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC0CRS_PHYEMAC0GTXCLK_posedge,
	TestSignal     => PHYEMAC0CRS,
	TestSignalName => "PHYEMAC0CRS",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0GTXCLK_dly,
	RefSignalName  => "PHYEMAC0GTXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0CRS_PHYEMAC0GTXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0CRS_PHYEMAC0GTXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC0CRS_PHYEMAC0GTXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0CRS_PHYEMAC0GTXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0CRS_PHYEMAC0RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC0CRS_PHYEMAC0RXCLK_posedge,
	TestSignal     => PHYEMAC0CRS,
	TestSignalName => "PHYEMAC0CRS",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName  => "PHYEMAC0RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0CRS_PHYEMAC0RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0CRS_PHYEMAC0RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC0CRS_PHYEMAC0RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0CRS_PHYEMAC0RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0CRS_PHYEMAC0RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC0CRS_PHYEMAC0RXCLK_posedge,
	TestSignal     => PHYEMAC0CRS,
	TestSignalName => "PHYEMAC0CRS",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName  => "PHYEMAC0RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0CRS_PHYEMAC0RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0CRS_PHYEMAC0RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC0CRS_PHYEMAC0RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0CRS_PHYEMAC0RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0MDIN_HOSTCLK_posedge,
	TimingData     => Tmkr_PHYEMAC0MDIN_HOSTCLK_posedge,
	TestSignal     => PHYEMAC0MDIN,
	TestSignalName => "PHYEMAC0MDIN",
	TestDelay      => 0 ps,
	RefSignal => HOSTCLK_dly,
	RefSignalName  => "HOSTCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0MDIN_HOSTCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0MDIN_HOSTCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC0MDIN_HOSTCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0MDIN_HOSTCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0MDIN_PHYEMAC0MCLKIN_posedge,
	TimingData     => Tmkr_PHYEMAC0MDIN_PHYEMAC0MCLKIN_posedge,
	TestSignal     => PHYEMAC0MDIN,
	TestSignalName => "PHYEMAC0MDIN",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0MCLKIN_dly,
	RefSignalName  => "PHYEMAC0MCLKIN",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0MDIN_PHYEMAC0MCLKIN_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0MDIN_PHYEMAC0MCLKIN_negedge_posedge,
	HoldLow        => thold_PHYEMAC0MDIN_PHYEMAC0MCLKIN_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0MDIN_PHYEMAC0MCLKIN_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0PHYAD0_HOSTCLK_posedge,
	TimingData => Tmkr_PHYEMAC0PHYAD0_HOSTCLK_posedge,
	TestSignal => PHYEMAC0PHYAD_HOSTCLK_dly(0),
	TestSignalName => "PHYEMAC0PHYAD(0)",
	TestDelay => tisd_PHYEMAC0PHYAD_HOSTCLK(0),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_PHYEMAC0PHYAD_HOSTCLK_posedge_posedge(0),
	SetupLow => tsetup_PHYEMAC0PHYAD_HOSTCLK_negedge_posedge(0),
	HoldLow => thold_PHYEMAC0PHYAD_HOSTCLK_posedge_posedge(0),
	HoldHigh => thold_PHYEMAC0PHYAD_HOSTCLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0PHYAD1_HOSTCLK_posedge,
	TimingData => Tmkr_PHYEMAC0PHYAD1_HOSTCLK_posedge,
	TestSignal => PHYEMAC0PHYAD_HOSTCLK_dly(1),
	TestSignalName => "PHYEMAC0PHYAD(1)",
	TestDelay => tisd_PHYEMAC0PHYAD_HOSTCLK(1),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_PHYEMAC0PHYAD_HOSTCLK_posedge_posedge(1),
	SetupLow => tsetup_PHYEMAC0PHYAD_HOSTCLK_negedge_posedge(1),
	HoldLow => thold_PHYEMAC0PHYAD_HOSTCLK_posedge_posedge(1),
	HoldHigh => thold_PHYEMAC0PHYAD_HOSTCLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0PHYAD2_HOSTCLK_posedge,
	TimingData => Tmkr_PHYEMAC0PHYAD2_HOSTCLK_posedge,
	TestSignal => PHYEMAC0PHYAD_HOSTCLK_dly(2),
	TestSignalName => "PHYEMAC0PHYAD(2)",
	TestDelay => tisd_PHYEMAC0PHYAD_HOSTCLK(2),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_PHYEMAC0PHYAD_HOSTCLK_posedge_posedge(2),
	SetupLow => tsetup_PHYEMAC0PHYAD_HOSTCLK_negedge_posedge(2),
	HoldLow => thold_PHYEMAC0PHYAD_HOSTCLK_posedge_posedge(2),
	HoldHigh => thold_PHYEMAC0PHYAD_HOSTCLK_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0PHYAD3_HOSTCLK_posedge,
	TimingData => Tmkr_PHYEMAC0PHYAD3_HOSTCLK_posedge,
	TestSignal => PHYEMAC0PHYAD_HOSTCLK_dly(3),
	TestSignalName => "PHYEMAC0PHYAD(3)",
	TestDelay => tisd_PHYEMAC0PHYAD_HOSTCLK(3),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_PHYEMAC0PHYAD_HOSTCLK_posedge_posedge(3),
	SetupLow => tsetup_PHYEMAC0PHYAD_HOSTCLK_negedge_posedge(3),
	HoldLow => thold_PHYEMAC0PHYAD_HOSTCLK_posedge_posedge(3),
	HoldHigh => thold_PHYEMAC0PHYAD_HOSTCLK_negedge_posedge(3),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0PHYAD4_HOSTCLK_posedge,
	TimingData => Tmkr_PHYEMAC0PHYAD4_HOSTCLK_posedge,
	TestSignal => PHYEMAC0PHYAD_HOSTCLK_dly(4),
	TestSignalName => "PHYEMAC0PHYAD(4)",
	TestDelay => tisd_PHYEMAC0PHYAD_HOSTCLK(4),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_PHYEMAC0PHYAD_HOSTCLK_posedge_posedge(4),
	SetupLow => tsetup_PHYEMAC0PHYAD_HOSTCLK_negedge_posedge(4),
	HoldLow => thold_PHYEMAC0PHYAD_HOSTCLK_posedge_posedge(4),
	HoldHigh => thold_PHYEMAC0PHYAD_HOSTCLK_negedge_posedge(4),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0RXBUFERR_PHYEMAC0GTXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC0RXBUFERR_PHYEMAC0GTXCLK_posedge,
	TestSignal     => PHYEMAC0RXBUFERR,
	TestSignalName => "PHYEMAC0RXBUFERR",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0GTXCLK_dly,
	RefSignalName  => "PHYEMAC0GTXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0RXBUFERR_PHYEMAC0GTXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0RXBUFERR_PHYEMAC0GTXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC0RXBUFERR_PHYEMAC0GTXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0RXBUFERR_PHYEMAC0GTXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0RXBUFERR_PHYEMAC0RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC0RXBUFERR_PHYEMAC0RXCLK_posedge,
	TestSignal     => PHYEMAC0RXBUFERR,
	TestSignalName => "PHYEMAC0RXBUFERR",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName  => "PHYEMAC0RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0RXBUFERR_PHYEMAC0RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0RXBUFERR_PHYEMAC0RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC0RXBUFERR_PHYEMAC0RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0RXBUFERR_PHYEMAC0RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0RXBUFERR_PHYEMAC0RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC0RXBUFERR_PHYEMAC0RXCLK_posedge,
	TestSignal     => PHYEMAC0RXBUFERR,
	TestSignalName => "PHYEMAC0RXBUFERR",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName  => "PHYEMAC0RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0RXBUFERR_PHYEMAC0RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0RXBUFERR_PHYEMAC0RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC0RXBUFERR_PHYEMAC0RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0RXBUFERR_PHYEMAC0RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXBUFSTATUS0_PHYEMAC0GTXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXBUFSTATUS0_PHYEMAC0GTXCLK_posedge,
	TestSignal => PHYEMAC0RXBUFSTATUS_dly(0),
	TestSignalName => "PHYEMAC0RXBUFSTATUS(0)",
	TestDelay => tisd_PHYEMAC0RXBUFSTATUS_PHYEMAC0GTXCLK(0),
	RefSignal => PHYEMAC0GTXCLK_dly,
	RefSignalName => "PHYEMAC0GTXCLK",
	RefDelay => ticd_PHYEMAC0GTXCLK,
	SetupHigh => tsetup_PHYEMAC0RXBUFSTATUS_PHYEMAC0GTXCLK_posedge_posedge(0),
	SetupLow => tsetup_PHYEMAC0RXBUFSTATUS_PHYEMAC0GTXCLK_negedge_posedge(0),
	HoldLow => thold_PHYEMAC0RXBUFSTATUS_PHYEMAC0GTXCLK_posedge_posedge(0),
	HoldHigh => thold_PHYEMAC0RXBUFSTATUS_PHYEMAC0GTXCLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXBUFSTATUS0_PHYEMAC0RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXBUFSTATUS0_PHYEMAC0RXCLK_posedge,
	TestSignal => PHYEMAC0RXBUFSTATUS_PHYEMAC0RXCLK_dly(0),
	TestSignalName => "PHYEMAC0RXBUFSTATUS(0)",
	TestDelay => tisd_PHYEMAC0RXBUFSTATUS_PHYEMAC0RXCLK(0),
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName => "PHYEMAC0RXCLK",
	RefDelay => ticd_PHYEMAC0RXCLK,
	SetupHigh => tsetup_PHYEMAC0RXBUFSTATUS_PHYEMAC0RXCLK_posedge_posedge(0),
	SetupLow => tsetup_PHYEMAC0RXBUFSTATUS_PHYEMAC0RXCLK_negedge_posedge(0),
	HoldLow => thold_PHYEMAC0RXBUFSTATUS_PHYEMAC0RXCLK_posedge_posedge(0),
	HoldHigh => thold_PHYEMAC0RXBUFSTATUS_PHYEMAC0RXCLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXBUFSTATUS0_PHYEMAC0RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXBUFSTATUS0_PHYEMAC0RXCLK_posedge,
	TestSignal => PHYEMAC0RXBUFSTATUS_PHYEMAC0RXCLK_dly(0),
	TestSignalName => "PHYEMAC0RXBUFSTATUS(0)",
	TestDelay => tisd_PHYEMAC0RXBUFSTATUS_PHYEMAC0RXCLK(0),
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName => "PHYEMAC0RXCLK",
	RefDelay => ticd_PHYEMAC0RXCLK,
	SetupHigh => tsetup_PHYEMAC0RXBUFSTATUS_PHYEMAC0RXCLK_posedge_posedge(0),
	SetupLow => tsetup_PHYEMAC0RXBUFSTATUS_PHYEMAC0RXCLK_negedge_posedge(0),
	HoldLow => thold_PHYEMAC0RXBUFSTATUS_PHYEMAC0RXCLK_posedge_posedge(0),
	HoldHigh => thold_PHYEMAC0RXBUFSTATUS_PHYEMAC0RXCLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXBUFSTATUS1_PHYEMAC0GTXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXBUFSTATUS1_PHYEMAC0GTXCLK_posedge,
	TestSignal => PHYEMAC0RXBUFSTATUS_PHYEMAC0GTXCLK_dly(1),
	TestSignalName => "PHYEMAC0RXBUFSTATUS(1)",
	TestDelay => tisd_PHYEMAC0RXBUFSTATUS_PHYEMAC0GTXCLK(1),
	RefSignal => PHYEMAC0GTXCLK_dly,
	RefSignalName => "PHYEMAC0GTXCLK",
	RefDelay => ticd_PHYEMAC0GTXCLK,
	SetupHigh => tsetup_PHYEMAC0RXBUFSTATUS_PHYEMAC0GTXCLK_posedge_posedge(1),
	SetupLow => tsetup_PHYEMAC0RXBUFSTATUS_PHYEMAC0GTXCLK_negedge_posedge(1),
	HoldLow => thold_PHYEMAC0RXBUFSTATUS_PHYEMAC0GTXCLK_posedge_posedge(1),
	HoldHigh => thold_PHYEMAC0RXBUFSTATUS_PHYEMAC0GTXCLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXBUFSTATUS1_PHYEMAC0RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXBUFSTATUS1_PHYEMAC0RXCLK_posedge,
	TestSignal => PHYEMAC0RXBUFSTATUS_PHYEMAC0RXCLK_dly(1),
	TestSignalName => "PHYEMAC0RXBUFSTATUS(1)",
	TestDelay => tisd_PHYEMAC0RXBUFSTATUS_PHYEMAC0RXCLK(1),
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName => "PHYEMAC0RXCLK",
	RefDelay => ticd_PHYEMAC0RXCLK,
	SetupHigh => tsetup_PHYEMAC0RXBUFSTATUS_PHYEMAC0RXCLK_posedge_posedge(1),
	SetupLow => tsetup_PHYEMAC0RXBUFSTATUS_PHYEMAC0RXCLK_negedge_posedge(1),
	HoldLow => thold_PHYEMAC0RXBUFSTATUS_PHYEMAC0RXCLK_posedge_posedge(1),
	HoldHigh => thold_PHYEMAC0RXBUFSTATUS_PHYEMAC0RXCLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXBUFSTATUS1_PHYEMAC0RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXBUFSTATUS1_PHYEMAC0RXCLK_posedge,
	TestSignal => PHYEMAC0RXBUFSTATUS_PHYEMAC0RXCLK_dly(1),
	TestSignalName => "PHYEMAC0RXBUFSTATUS(1)",
	TestDelay => tisd_PHYEMAC0RXBUFSTATUS_PHYEMAC0RXCLK(1),
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName => "PHYEMAC0RXCLK",
	RefDelay => ticd_PHYEMAC0RXCLK,
	SetupHigh => tsetup_PHYEMAC0RXBUFSTATUS_PHYEMAC0RXCLK_posedge_posedge(1),
	SetupLow => tsetup_PHYEMAC0RXBUFSTATUS_PHYEMAC0RXCLK_negedge_posedge(1),
	HoldLow => thold_PHYEMAC0RXBUFSTATUS_PHYEMAC0RXCLK_posedge_posedge(1),
	HoldHigh => thold_PHYEMAC0RXBUFSTATUS_PHYEMAC0RXCLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0RXCHARISCOMMA_PHYEMAC0GTXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC0RXCHARISCOMMA_PHYEMAC0GTXCLK_posedge,
	TestSignal     => PHYEMAC0RXCHARISCOMMA,
	TestSignalName => "PHYEMAC0RXCHARISCOMMA",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0GTXCLK_dly,
	RefSignalName  => "PHYEMAC0GTXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0RXCHARISCOMMA_PHYEMAC0GTXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0RXCHARISCOMMA_PHYEMAC0GTXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC0RXCHARISCOMMA_PHYEMAC0GTXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0RXCHARISCOMMA_PHYEMAC0GTXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0RXCHARISCOMMA_PHYEMAC0RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC0RXCHARISCOMMA_PHYEMAC0RXCLK_posedge,
	TestSignal     => PHYEMAC0RXCHARISCOMMA,
	TestSignalName => "PHYEMAC0RXCHARISCOMMA",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName  => "PHYEMAC0RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0RXCHARISCOMMA_PHYEMAC0RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0RXCHARISCOMMA_PHYEMAC0RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC0RXCHARISCOMMA_PHYEMAC0RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0RXCHARISCOMMA_PHYEMAC0RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0RXCHARISCOMMA_PHYEMAC0RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC0RXCHARISCOMMA_PHYEMAC0RXCLK_posedge,
	TestSignal     => PHYEMAC0RXCHARISCOMMA,
	TestSignalName => "PHYEMAC0RXCHARISCOMMA",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName  => "PHYEMAC0RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0RXCHARISCOMMA_PHYEMAC0RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0RXCHARISCOMMA_PHYEMAC0RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC0RXCHARISCOMMA_PHYEMAC0RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0RXCHARISCOMMA_PHYEMAC0RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0RXCHARISK_PHYEMAC0GTXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC0RXCHARISK_PHYEMAC0GTXCLK_posedge,
	TestSignal     => PHYEMAC0RXCHARISK,
	TestSignalName => "PHYEMAC0RXCHARISK",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0GTXCLK_dly,
	RefSignalName  => "PHYEMAC0GTXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0RXCHARISK_PHYEMAC0GTXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0RXCHARISK_PHYEMAC0GTXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC0RXCHARISK_PHYEMAC0GTXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0RXCHARISK_PHYEMAC0GTXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0RXCHARISK_PHYEMAC0RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC0RXCHARISK_PHYEMAC0RXCLK_posedge,
	TestSignal     => PHYEMAC0RXCHARISK,
	TestSignalName => "PHYEMAC0RXCHARISK",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName  => "PHYEMAC0RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0RXCHARISK_PHYEMAC0RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0RXCHARISK_PHYEMAC0RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC0RXCHARISK_PHYEMAC0RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0RXCHARISK_PHYEMAC0RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0RXCHARISK_PHYEMAC0RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC0RXCHARISK_PHYEMAC0RXCLK_posedge,
	TestSignal     => PHYEMAC0RXCHARISK,
	TestSignalName => "PHYEMAC0RXCHARISK",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName  => "PHYEMAC0RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0RXCHARISK_PHYEMAC0RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0RXCHARISK_PHYEMAC0RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC0RXCHARISK_PHYEMAC0RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0RXCHARISK_PHYEMAC0RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0RXCHECKINGCRC_PHYEMAC0GTXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC0RXCHECKINGCRC_PHYEMAC0GTXCLK_posedge,
	TestSignal     => PHYEMAC0RXCHECKINGCRC,
	TestSignalName => "PHYEMAC0RXCHECKINGCRC",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0GTXCLK_dly,
	RefSignalName  => "PHYEMAC0GTXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0RXCHECKINGCRC_PHYEMAC0GTXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0RXCHECKINGCRC_PHYEMAC0GTXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC0RXCHECKINGCRC_PHYEMAC0GTXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0RXCHECKINGCRC_PHYEMAC0GTXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0RXCHECKINGCRC_PHYEMAC0RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC0RXCHECKINGCRC_PHYEMAC0RXCLK_posedge,
	TestSignal     => PHYEMAC0RXCHECKINGCRC,
	TestSignalName => "PHYEMAC0RXCHECKINGCRC",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName  => "PHYEMAC0RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0RXCHECKINGCRC_PHYEMAC0RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0RXCHECKINGCRC_PHYEMAC0RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC0RXCHECKINGCRC_PHYEMAC0RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0RXCHECKINGCRC_PHYEMAC0RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0RXCHECKINGCRC_PHYEMAC0RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC0RXCHECKINGCRC_PHYEMAC0RXCLK_posedge,
	TestSignal     => PHYEMAC0RXCHECKINGCRC,
	TestSignalName => "PHYEMAC0RXCHECKINGCRC",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName  => "PHYEMAC0RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0RXCHECKINGCRC_PHYEMAC0RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0RXCHECKINGCRC_PHYEMAC0RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC0RXCHECKINGCRC_PHYEMAC0RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0RXCHECKINGCRC_PHYEMAC0RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXCLKCORCNT0_PHYEMAC0GTXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXCLKCORCNT0_PHYEMAC0GTXCLK_posedge,
	TestSignal => PHYEMAC0RXCLKCORCNT_PHYEMAC0GTXCLK_dly(0),
	TestSignalName => "PHYEMAC0RXCLKCORCNT(0)",
	TestDelay => tisd_PHYEMAC0RXCLKCORCNT_PHYEMAC0GTXCLK(0),
	RefSignal => PHYEMAC0GTXCLK_dly,
	RefSignalName => "PHYEMAC0GTXCLK",
	RefDelay => ticd_PHYEMAC0GTXCLK,
	SetupHigh => tsetup_PHYEMAC0RXCLKCORCNT_PHYEMAC0GTXCLK_posedge_posedge(0),
	SetupLow => tsetup_PHYEMAC0RXCLKCORCNT_PHYEMAC0GTXCLK_negedge_posedge(0),
	HoldLow => thold_PHYEMAC0RXCLKCORCNT_PHYEMAC0GTXCLK_posedge_posedge(0),
	HoldHigh => thold_PHYEMAC0RXCLKCORCNT_PHYEMAC0GTXCLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXCLKCORCNT0_PHYEMAC0RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXCLKCORCNT0_PHYEMAC0RXCLK_posedge,
	TestSignal => PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK_dly(0),
	TestSignalName => "PHYEMAC0RXCLKCORCNT(0)",
	TestDelay => tisd_PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK(0),
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName => "PHYEMAC0RXCLK",
	RefDelay => ticd_PHYEMAC0RXCLK,
	SetupHigh => tsetup_PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK_posedge_posedge(0),
	SetupLow => tsetup_PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK_negedge_posedge(0),
	HoldLow => thold_PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK_posedge_posedge(0),
	HoldHigh => thold_PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXCLKCORCNT0_PHYEMAC0RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXCLKCORCNT0_PHYEMAC0RXCLK_posedge,
	TestSignal => PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK_dly(0),
	TestSignalName => "PHYEMAC0RXCLKCORCNT(0)",
	TestDelay => tisd_PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK(0),
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName => "PHYEMAC0RXCLK",
	RefDelay => ticd_PHYEMAC0RXCLK,
	SetupHigh => tsetup_PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK_posedge_posedge(0),
	SetupLow => tsetup_PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK_negedge_posedge(0),
	HoldLow => thold_PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK_posedge_posedge(0),
	HoldHigh => thold_PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXCLKCORCNT1_PHYEMAC0GTXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXCLKCORCNT1_PHYEMAC0GTXCLK_posedge,
	TestSignal => PHYEMAC0RXCLKCORCNT_PHYEMAC0GTXCLK_dly(1),
	TestSignalName => "PHYEMAC0RXCLKCORCNT(1)",
	TestDelay => tisd_PHYEMAC0RXCLKCORCNT_PHYEMAC0GTXCLK(1),
	RefSignal => PHYEMAC0GTXCLK_dly,
	RefSignalName => "PHYEMAC0GTXCLK",
	RefDelay => ticd_PHYEMAC0GTXCLK,
	SetupHigh => tsetup_PHYEMAC0RXCLKCORCNT_PHYEMAC0GTXCLK_posedge_posedge(1),
	SetupLow => tsetup_PHYEMAC0RXCLKCORCNT_PHYEMAC0GTXCLK_negedge_posedge(1),
	HoldLow => thold_PHYEMAC0RXCLKCORCNT_PHYEMAC0GTXCLK_posedge_posedge(1),
	HoldHigh => thold_PHYEMAC0RXCLKCORCNT_PHYEMAC0GTXCLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXCLKCORCNT1_PHYEMAC0RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXCLKCORCNT1_PHYEMAC0RXCLK_posedge,
	TestSignal => PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK_dly(1),
	TestSignalName => "PHYEMAC0RXCLKCORCNT(1)",
	TestDelay => tisd_PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK(1),
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName => "PHYEMAC0RXCLK",
	RefDelay => ticd_PHYEMAC0RXCLK,
	SetupHigh => tsetup_PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK_posedge_posedge(1),
	SetupLow => tsetup_PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK_negedge_posedge(1),
	HoldLow => thold_PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK_posedge_posedge(1),
	HoldHigh => thold_PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXCLKCORCNT1_PHYEMAC0RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXCLKCORCNT1_PHYEMAC0RXCLK_posedge,
	TestSignal => PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK_dly(1),
	TestSignalName => "PHYEMAC0RXCLKCORCNT(1)",
	TestDelay => tisd_PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK(1),
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName => "PHYEMAC0RXCLK",
	RefDelay => ticd_PHYEMAC0RXCLK,
	SetupHigh => tsetup_PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK_posedge_posedge(1),
	SetupLow => tsetup_PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK_negedge_posedge(1),
	HoldLow => thold_PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK_posedge_posedge(1),
	HoldHigh => thold_PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXCLKCORCNT2_PHYEMAC0GTXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXCLKCORCNT2_PHYEMAC0GTXCLK_posedge,
	TestSignal => PHYEMAC0RXCLKCORCNT_PHYEMAC0GTXCLK_dly(2),
	TestSignalName => "PHYEMAC0RXCLKCORCNT(2)",
	TestDelay => tisd_PHYEMAC0RXCLKCORCNT_PHYEMAC0GTXCLK(2),
	RefSignal => PHYEMAC0GTXCLK_dly,
	RefSignalName => "PHYEMAC0GTXCLK",
	RefDelay => ticd_PHYEMAC0GTXCLK,
	SetupHigh => tsetup_PHYEMAC0RXCLKCORCNT_PHYEMAC0GTXCLK_posedge_posedge(2),
	SetupLow => tsetup_PHYEMAC0RXCLKCORCNT_PHYEMAC0GTXCLK_negedge_posedge(2),
	HoldLow => thold_PHYEMAC0RXCLKCORCNT_PHYEMAC0GTXCLK_posedge_posedge(2),
	HoldHigh => thold_PHYEMAC0RXCLKCORCNT_PHYEMAC0GTXCLK_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXCLKCORCNT2_PHYEMAC0RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXCLKCORCNT2_PHYEMAC0RXCLK_posedge,
	TestSignal => PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK_dly(2),
	TestSignalName => "PHYEMAC0RXCLKCORCNT(2)",
	TestDelay => tisd_PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK(2),
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName => "PHYEMAC0RXCLK",
	RefDelay => ticd_PHYEMAC0RXCLK,
	SetupHigh => tsetup_PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK_posedge_posedge(2),
	SetupLow => tsetup_PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK_negedge_posedge(2),
	HoldLow => thold_PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK_posedge_posedge(2),
	HoldHigh => thold_PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXCLKCORCNT2_PHYEMAC0RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXCLKCORCNT2_PHYEMAC0RXCLK_posedge,
	TestSignal => PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK_dly(2),
	TestSignalName => "PHYEMAC0RXCLKCORCNT(2)",
	TestDelay => tisd_PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK(2),
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName => "PHYEMAC0RXCLK",
	RefDelay => ticd_PHYEMAC0RXCLK,
	SetupHigh => tsetup_PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK_posedge_posedge(2),
	SetupLow => tsetup_PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK_negedge_posedge(2),
	HoldLow => thold_PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK_posedge_posedge(2),
	HoldHigh => thold_PHYEMAC0RXCLKCORCNT_PHYEMAC0RXCLK_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0RXCOMMADET_PHYEMAC0GTXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC0RXCOMMADET_PHYEMAC0GTXCLK_posedge,
	TestSignal     => PHYEMAC0RXCOMMADET,
	TestSignalName => "PHYEMAC0RXCOMMADET",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0GTXCLK_dly,
	RefSignalName  => "PHYEMAC0GTXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0RXCOMMADET_PHYEMAC0GTXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0RXCOMMADET_PHYEMAC0GTXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC0RXCOMMADET_PHYEMAC0GTXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0RXCOMMADET_PHYEMAC0GTXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0RXCOMMADET_PHYEMAC0RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC0RXCOMMADET_PHYEMAC0RXCLK_posedge,
	TestSignal     => PHYEMAC0RXCOMMADET,
	TestSignalName => "PHYEMAC0RXCOMMADET",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName  => "PHYEMAC0RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0RXCOMMADET_PHYEMAC0RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0RXCOMMADET_PHYEMAC0RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC0RXCOMMADET_PHYEMAC0RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0RXCOMMADET_PHYEMAC0RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0RXCOMMADET_PHYEMAC0RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC0RXCOMMADET_PHYEMAC0RXCLK_posedge,
	TestSignal     => PHYEMAC0RXCOMMADET,
	TestSignalName => "PHYEMAC0RXCOMMADET",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName  => "PHYEMAC0RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0RXCOMMADET_PHYEMAC0RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0RXCOMMADET_PHYEMAC0RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC0RXCOMMADET_PHYEMAC0RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0RXCOMMADET_PHYEMAC0RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXD0_PHYEMAC0GTXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXD0_PHYEMAC0GTXCLK_posedge,
	TestSignal => PHYEMAC0RXD_PHYEMAC0GTXCLK_dly(0),
	TestSignalName => "PHYEMAC0RXD(0)",
	TestDelay => tisd_PHYEMAC0RXD_PHYEMAC0GTXCLK(0),
	RefSignal => PHYEMAC0GTXCLK_dly,
	RefSignalName => "PHYEMAC0GTXCLK",
	RefDelay => ticd_PHYEMAC0GTXCLK,
	SetupHigh => tsetup_PHYEMAC0RXD_PHYEMAC0GTXCLK_posedge_posedge(0),
	SetupLow => tsetup_PHYEMAC0RXD_PHYEMAC0GTXCLK_negedge_posedge(0),
	HoldLow => thold_PHYEMAC0RXD_PHYEMAC0GTXCLK_posedge_posedge(0),
	HoldHigh => thold_PHYEMAC0RXD_PHYEMAC0GTXCLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXD0_PHYEMAC0RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXD0_PHYEMAC0RXCLK_posedge,
	TestSignal => PHYEMAC0RXD_PHYEMAC0RXCLK_dly(0),
	TestSignalName => "PHYEMAC0RXD(0)",
	TestDelay => tisd_PHYEMAC0RXD_PHYEMAC0RXCLK(0),
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName => "PHYEMAC0RXCLK",
	RefDelay => ticd_PHYEMAC0RXCLK,
	SetupHigh => tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_posedge(0),
	SetupLow => tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_posedge(0),
	HoldLow => thold_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_posedge(0),
	HoldHigh => thold_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXD0_PHYEMAC0RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXD0_PHYEMAC0RXCLK_posedge,
	TestSignal => PHYEMAC0RXD_PHYEMAC0RXCLK_dly(0),
	TestSignalName => "PHYEMAC0RXD(0)",
	TestDelay => tisd_PHYEMAC0RXD_PHYEMAC0RXCLK(0),
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName => "PHYEMAC0RXCLK",
	RefDelay => ticd_PHYEMAC0RXCLK,
	SetupHigh => tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_posedge(0),
	SetupLow => tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_posedge(0),
	HoldLow => thold_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_posedge(0),
	HoldHigh => thold_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXD1_PHYEMAC0GTXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXD1_PHYEMAC0GTXCLK_posedge,
	TestSignal => PHYEMAC0RXD_PHYEMAC0GTXCLK_dly(1),
	TestSignalName => "PHYEMAC0RXD(1)",
	TestDelay => tisd_PHYEMAC0RXD_PHYEMAC0GTXCLK(1),
	RefSignal => PHYEMAC0GTXCLK_dly,
	RefSignalName => "PHYEMAC0GTXCLK",
	RefDelay => ticd_PHYEMAC0GTXCLK,
	SetupHigh => tsetup_PHYEMAC0RXD_PHYEMAC0GTXCLK_posedge_posedge(1),
	SetupLow => tsetup_PHYEMAC0RXD_PHYEMAC0GTXCLK_negedge_posedge(1),
	HoldLow => thold_PHYEMAC0RXD_PHYEMAC0GTXCLK_posedge_posedge(1),
	HoldHigh => thold_PHYEMAC0RXD_PHYEMAC0GTXCLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXD1_PHYEMAC0RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXD1_PHYEMAC0RXCLK_posedge,
	TestSignal => PHYEMAC0RXD_PHYEMAC0RXCLK_dly(1),
	TestSignalName => "PHYEMAC0RXD(1)",
	TestDelay => tisd_PHYEMAC0RXD_PHYEMAC0RXCLK(1),
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName => "PHYEMAC0RXCLK",
	RefDelay => ticd_PHYEMAC0RXCLK,
	SetupHigh => tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_posedge(1),
	SetupLow => tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_posedge(1),
	HoldLow => thold_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_posedge(1),
	HoldHigh => thold_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXD1_PHYEMAC0RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXD1_PHYEMAC0RXCLK_posedge,
	TestSignal => PHYEMAC0RXD_PHYEMAC0RXCLK_dly(1),
	TestSignalName => "PHYEMAC0RXD(1)",
	TestDelay => tisd_PHYEMAC0RXD_PHYEMAC0RXCLK(1),
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName => "PHYEMAC0RXCLK",
	RefDelay => ticd_PHYEMAC0RXCLK,
	SetupHigh => tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_posedge(1),
	SetupLow => tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_posedge(1),
	HoldLow => thold_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_posedge(1),
	HoldHigh => thold_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXD2_PHYEMAC0GTXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXD2_PHYEMAC0GTXCLK_posedge,
	TestSignal => PHYEMAC0RXD_PHYEMAC0GTXCLK_dly(2),
	TestSignalName => "PHYEMAC0RXD(2)",
	TestDelay => tisd_PHYEMAC0RXD_PHYEMAC0GTXCLK(2),
	RefSignal => PHYEMAC0GTXCLK_dly,
	RefSignalName => "PHYEMAC0GTXCLK",
	RefDelay => ticd_PHYEMAC0GTXCLK,
	SetupHigh => tsetup_PHYEMAC0RXD_PHYEMAC0GTXCLK_posedge_posedge(2),
	SetupLow => tsetup_PHYEMAC0RXD_PHYEMAC0GTXCLK_negedge_posedge(2),
	HoldLow => thold_PHYEMAC0RXD_PHYEMAC0GTXCLK_posedge_posedge(2),
	HoldHigh => thold_PHYEMAC0RXD_PHYEMAC0GTXCLK_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXD2_PHYEMAC0RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXD2_PHYEMAC0RXCLK_posedge,
	TestSignal => PHYEMAC0RXD_PHYEMAC0RXCLK_dly(2),
	TestSignalName => "PHYEMAC0RXD(2)",
	TestDelay => tisd_PHYEMAC0RXD_PHYEMAC0RXCLK(2),
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName => "PHYEMAC0RXCLK",
	RefDelay => ticd_PHYEMAC0RXCLK,
	SetupHigh => tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_posedge(2),
	SetupLow => tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_posedge(2),
	HoldLow => thold_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_posedge(2),
	HoldHigh => thold_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXD2_PHYEMAC0RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXD2_PHYEMAC0RXCLK_posedge,
	TestSignal => PHYEMAC0RXD_PHYEMAC0RXCLK_dly(2),
	TestSignalName => "PHYEMAC0RXD(2)",
	TestDelay => tisd_PHYEMAC0RXD_PHYEMAC0RXCLK(2),
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName => "PHYEMAC0RXCLK",
	RefDelay => ticd_PHYEMAC0RXCLK,
	SetupHigh => tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_posedge(2),
	SetupLow => tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_posedge(2),
	HoldLow => thold_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_posedge(2),
	HoldHigh => thold_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXD3_PHYEMAC0GTXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXD3_PHYEMAC0GTXCLK_posedge,
	TestSignal => PHYEMAC0RXD_PHYEMAC0GTXCLK_dly(3),
	TestSignalName => "PHYEMAC0RXD(3)",
	TestDelay => tisd_PHYEMAC0RXD_PHYEMAC0GTXCLK(3),
	RefSignal => PHYEMAC0GTXCLK_dly,
	RefSignalName => "PHYEMAC0GTXCLK",
	RefDelay => ticd_PHYEMAC0GTXCLK,
	SetupHigh => tsetup_PHYEMAC0RXD_PHYEMAC0GTXCLK_posedge_posedge(3),
	SetupLow => tsetup_PHYEMAC0RXD_PHYEMAC0GTXCLK_negedge_posedge(3),
	HoldLow => thold_PHYEMAC0RXD_PHYEMAC0GTXCLK_posedge_posedge(3),
	HoldHigh => thold_PHYEMAC0RXD_PHYEMAC0GTXCLK_negedge_posedge(3),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXD3_PHYEMAC0RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXD3_PHYEMAC0RXCLK_posedge,
	TestSignal => PHYEMAC0RXD_PHYEMAC0RXCLK_dly(3),
	TestSignalName => "PHYEMAC0RXD(3)",
	TestDelay => tisd_PHYEMAC0RXD_PHYEMAC0RXCLK(3),
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName => "PHYEMAC0RXCLK",
	RefDelay => ticd_PHYEMAC0RXCLK,
	SetupHigh => tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_posedge(3),
	SetupLow => tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_posedge(3),
	HoldLow => thold_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_posedge(3),
	HoldHigh => thold_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_posedge(3),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXD3_PHYEMAC0RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXD3_PHYEMAC0RXCLK_posedge,
	TestSignal => PHYEMAC0RXD_PHYEMAC0RXCLK_dly(3),
	TestSignalName => "PHYEMAC0RXD(3)",
	TestDelay => tisd_PHYEMAC0RXD_PHYEMAC0RXCLK(3),
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName => "PHYEMAC0RXCLK",
	RefDelay => ticd_PHYEMAC0RXCLK,
	SetupHigh => tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_posedge(3),
	SetupLow => tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_posedge(3),
	HoldLow => thold_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_posedge(3),
	HoldHigh => thold_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_posedge(3),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXD4_PHYEMAC0GTXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXD4_PHYEMAC0GTXCLK_posedge,
	TestSignal => PHYEMAC0RXD_PHYEMAC0GTXCLK_dly(4),
	TestSignalName => "PHYEMAC0RXD(4)",
	TestDelay => tisd_PHYEMAC0RXD_PHYEMAC0GTXCLK(4),
	RefSignal => PHYEMAC0GTXCLK_dly,
	RefSignalName => "PHYEMAC0GTXCLK",
	RefDelay => ticd_PHYEMAC0GTXCLK,
	SetupHigh => tsetup_PHYEMAC0RXD_PHYEMAC0GTXCLK_posedge_posedge(4),
	SetupLow => tsetup_PHYEMAC0RXD_PHYEMAC0GTXCLK_negedge_posedge(4),
	HoldLow => thold_PHYEMAC0RXD_PHYEMAC0GTXCLK_posedge_posedge(4),
	HoldHigh => thold_PHYEMAC0RXD_PHYEMAC0GTXCLK_negedge_posedge(4),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXD4_PHYEMAC0RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXD4_PHYEMAC0RXCLK_posedge,
	TestSignal => PHYEMAC0RXD_PHYEMAC0RXCLK_dly(4),
	TestSignalName => "PHYEMAC0RXD(4)",
	TestDelay => tisd_PHYEMAC0RXD_PHYEMAC0RXCLK(4),
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName => "PHYEMAC0RXCLK",
	RefDelay => ticd_PHYEMAC0RXCLK,
	SetupHigh => tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_posedge(4),
	SetupLow => tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_posedge(4),
	HoldLow => thold_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_posedge(4),
	HoldHigh => thold_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_posedge(4),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXD4_PHYEMAC0RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXD4_PHYEMAC0RXCLK_posedge,
	TestSignal => PHYEMAC0RXD_PHYEMAC0RXCLK_dly(4),
	TestSignalName => "PHYEMAC0RXD(4)",
	TestDelay => tisd_PHYEMAC0RXD_PHYEMAC0RXCLK(4),
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName => "PHYEMAC0RXCLK",
	RefDelay => ticd_PHYEMAC0RXCLK,
	SetupHigh => tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_posedge(4),
	SetupLow => tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_posedge(4),
	HoldLow => thold_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_posedge(4),
	HoldHigh => thold_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_posedge(4),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXD4_PHYEMAC0RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXD4_PHYEMAC0RXCLK_posedge,
	TestSignal => PHYEMAC0RXD_PHYEMAC0RXCLK_dly(4),
	TestSignalName => "PHYEMAC0RXD(4)",
	TestDelay => tisd_PHYEMAC0RXD_PHYEMAC0RXCLK(4),
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName => "PHYEMAC0RXCLK",
	RefDelay => ticd_PHYEMAC0RXCLK,
	SetupHigh => tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_negedge(4),
	SetupLow => tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_negedge(4),
	HoldLow => thold_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_negedge(4),
	HoldHigh => thold_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_negedge(4),
	CheckEnabled   => TRUE,
	RefTransition  => 'F',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXD5_PHYEMAC0GTXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXD5_PHYEMAC0GTXCLK_posedge,
	TestSignal => PHYEMAC0RXD_PHYEMAC0GTXCLK_dly(5),
	TestSignalName => "PHYEMAC0RXD(5)",
	TestDelay => tisd_PHYEMAC0RXD_PHYEMAC0GTXCLK(5),
	RefSignal => PHYEMAC0GTXCLK_dly,
	RefSignalName => "PHYEMAC0GTXCLK",
	RefDelay => ticd_PHYEMAC0GTXCLK,
	SetupHigh => tsetup_PHYEMAC0RXD_PHYEMAC0GTXCLK_posedge_posedge(5),
	SetupLow => tsetup_PHYEMAC0RXD_PHYEMAC0GTXCLK_negedge_posedge(5),
	HoldLow => thold_PHYEMAC0RXD_PHYEMAC0GTXCLK_posedge_posedge(5),
	HoldHigh => thold_PHYEMAC0RXD_PHYEMAC0GTXCLK_negedge_posedge(5),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXD5_PHYEMAC0RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXD5_PHYEMAC0RXCLK_posedge,
	TestSignal => PHYEMAC0RXD_PHYEMAC0RXCLK_dly(5),
	TestSignalName => "PHYEMAC0RXD(5)",
	TestDelay => tisd_PHYEMAC0RXD_PHYEMAC0RXCLK(5),
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName => "PHYEMAC0RXCLK",
	RefDelay => ticd_PHYEMAC0RXCLK,
	SetupHigh => tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_posedge(5),
	SetupLow => tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_posedge(5),
	HoldLow => thold_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_posedge(5),
	HoldHigh => thold_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_posedge(5),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXD5_PHYEMAC0RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXD5_PHYEMAC0RXCLK_posedge,
	TestSignal => PHYEMAC0RXD_PHYEMAC0RXCLK_dly(5),
	TestSignalName => "PHYEMAC0RXD(5)",
	TestDelay => tisd_PHYEMAC0RXD_PHYEMAC0RXCLK(5),
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName => "PHYEMAC0RXCLK",
	RefDelay => ticd_PHYEMAC0RXCLK,
	SetupHigh => tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_posedge(5),
	SetupLow => tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_posedge(5),
	HoldLow => thold_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_posedge(5),
	HoldHigh => thold_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_posedge(5),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXD5_PHYEMAC0RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXD5_PHYEMAC0RXCLK_posedge,
	TestSignal => PHYEMAC0RXD_PHYEMAC0RXCLK_dly(5),
	TestSignalName => "PHYEMAC0RXD(5)",
	TestDelay => tisd_PHYEMAC0RXD_PHYEMAC0RXCLK(5),
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName => "PHYEMAC0RXCLK",
	RefDelay => ticd_PHYEMAC0RXCLK,
	SetupHigh => tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_negedge(5),
	SetupLow => tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_negedge(5),
	HoldLow => thold_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_negedge(5),
	HoldHigh => thold_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_negedge(5),
	CheckEnabled   => TRUE,
	RefTransition  => 'F',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXD6_PHYEMAC0GTXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXD6_PHYEMAC0GTXCLK_posedge,
	TestSignal => PHYEMAC0RXD_PHYEMAC0GTXCLK_dly(6),
	TestSignalName => "PHYEMAC0RXD(6)",
	TestDelay => tisd_PHYEMAC0RXD_PHYEMAC0GTXCLK(6),
	RefSignal => PHYEMAC0GTXCLK_dly,
	RefSignalName => "PHYEMAC0GTXCLK",
	RefDelay => ticd_PHYEMAC0GTXCLK,
	SetupHigh => tsetup_PHYEMAC0RXD_PHYEMAC0GTXCLK_posedge_posedge(6),
	SetupLow => tsetup_PHYEMAC0RXD_PHYEMAC0GTXCLK_negedge_posedge(6),
	HoldLow => thold_PHYEMAC0RXD_PHYEMAC0GTXCLK_posedge_posedge(6),
	HoldHigh => thold_PHYEMAC0RXD_PHYEMAC0GTXCLK_negedge_posedge(6),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXD6_PHYEMAC0RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXD6_PHYEMAC0RXCLK_posedge,
	TestSignal => PHYEMAC0RXD_PHYEMAC0RXCLK_dly(6),
	TestSignalName => "PHYEMAC0RXD(6)",
	TestDelay => tisd_PHYEMAC0RXD_PHYEMAC0RXCLK(6),
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName => "PHYEMAC0RXCLK",
	RefDelay => ticd_PHYEMAC0RXCLK,
	SetupHigh => tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_posedge(6),
	SetupLow => tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_posedge(6),
	HoldLow => thold_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_posedge(6),
	HoldHigh => thold_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_posedge(6),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXD6_PHYEMAC0RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXD6_PHYEMAC0RXCLK_posedge,
	TestSignal => PHYEMAC0RXD_PHYEMAC0RXCLK_dly(6),
	TestSignalName => "PHYEMAC0RXD(6)",
	TestDelay => tisd_PHYEMAC0RXD_PHYEMAC0RXCLK(6),
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName => "PHYEMAC0RXCLK",
	RefDelay => ticd_PHYEMAC0RXCLK,
	SetupHigh => tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_posedge(6),
	SetupLow => tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_posedge(6),
	HoldLow => thold_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_posedge(6),
	HoldHigh => thold_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_posedge(6),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXD6_PHYEMAC0RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXD6_PHYEMAC0RXCLK_posedge,
	TestSignal => PHYEMAC0RXD_PHYEMAC0RXCLK_dly(6),
	TestSignalName => "PHYEMAC0RXD(6)",
	TestDelay => tisd_PHYEMAC0RXD_PHYEMAC0RXCLK(6),
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName => "PHYEMAC0RXCLK",
	RefDelay => ticd_PHYEMAC0RXCLK,
	SetupHigh => tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_negedge(6),
	SetupLow => tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_negedge(6),
	HoldLow => thold_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_negedge(6),
	HoldHigh => thold_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_negedge(6),
	CheckEnabled   => TRUE,
	RefTransition  => 'F',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXD7_PHYEMAC0GTXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXD7_PHYEMAC0GTXCLK_posedge,
	TestSignal => PHYEMAC0RXD_PHYEMAC0GTXCLK_dly(7),
	TestSignalName => "PHYEMAC0RXD(7)",
	TestDelay => tisd_PHYEMAC0RXD_PHYEMAC0GTXCLK(7),
	RefSignal => PHYEMAC0GTXCLK_dly,
	RefSignalName => "PHYEMAC0GTXCLK",
	RefDelay => ticd_PHYEMAC0GTXCLK,
	SetupHigh => tsetup_PHYEMAC0RXD_PHYEMAC0GTXCLK_posedge_posedge(7),
	SetupLow => tsetup_PHYEMAC0RXD_PHYEMAC0GTXCLK_negedge_posedge(7),
	HoldLow => thold_PHYEMAC0RXD_PHYEMAC0GTXCLK_posedge_posedge(7),
	HoldHigh => thold_PHYEMAC0RXD_PHYEMAC0GTXCLK_negedge_posedge(7),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXD7_PHYEMAC0RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXD7_PHYEMAC0RXCLK_posedge,
	TestSignal => PHYEMAC0RXD_PHYEMAC0RXCLK_dly(7),
	TestSignalName => "PHYEMAC0RXD(7)",
	TestDelay => tisd_PHYEMAC0RXD_PHYEMAC0RXCLK(7),
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName => "PHYEMAC0RXCLK",
	RefDelay => ticd_PHYEMAC0RXCLK,
	SetupHigh => tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_posedge(7),
	SetupLow => tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_posedge(7),
	HoldLow => thold_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_posedge(7),
	HoldHigh => thold_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_posedge(7),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXD7_PHYEMAC0RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXD7_PHYEMAC0RXCLK_posedge,
	TestSignal => PHYEMAC0RXD_PHYEMAC0RXCLK_dly(7),
	TestSignalName => "PHYEMAC0RXD(7)",
	TestDelay => tisd_PHYEMAC0RXD_PHYEMAC0RXCLK(7),
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName => "PHYEMAC0RXCLK",
	RefDelay => ticd_PHYEMAC0RXCLK,
	SetupHigh => tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_posedge(7),
	SetupLow => tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_posedge(7),
	HoldLow => thold_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_posedge(7),
	HoldHigh => thold_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_posedge(7),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXD7_PHYEMAC0RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXD7_PHYEMAC0RXCLK_posedge,
	TestSignal => PHYEMAC0RXD_PHYEMAC0RXCLK_dly(7),
	TestSignalName => "PHYEMAC0RXD(7)",
	TestDelay => tisd_PHYEMAC0RXD_PHYEMAC0RXCLK(7),
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName => "PHYEMAC0RXCLK",
	RefDelay => ticd_PHYEMAC0RXCLK,
	SetupHigh => tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_negedge(7),
	SetupLow => tsetup_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_negedge(7),
	HoldLow => thold_PHYEMAC0RXD_PHYEMAC0RXCLK_posedge_negedge(7),
	HoldHigh => thold_PHYEMAC0RXD_PHYEMAC0RXCLK_negedge_negedge(7),
	CheckEnabled   => TRUE,
	RefTransition  => 'F',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0RXDISPERR_PHYEMAC0GTXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC0RXDISPERR_PHYEMAC0GTXCLK_posedge,
	TestSignal     => PHYEMAC0RXDISPERR,
	TestSignalName => "PHYEMAC0RXDISPERR",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0GTXCLK_dly,
	RefSignalName  => "PHYEMAC0GTXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0RXDISPERR_PHYEMAC0GTXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0RXDISPERR_PHYEMAC0GTXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC0RXDISPERR_PHYEMAC0GTXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0RXDISPERR_PHYEMAC0GTXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0RXDISPERR_PHYEMAC0RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC0RXDISPERR_PHYEMAC0RXCLK_posedge,
	TestSignal     => PHYEMAC0RXDISPERR,
	TestSignalName => "PHYEMAC0RXDISPERR",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName  => "PHYEMAC0RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0RXDISPERR_PHYEMAC0RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0RXDISPERR_PHYEMAC0RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC0RXDISPERR_PHYEMAC0RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0RXDISPERR_PHYEMAC0RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0RXDISPERR_PHYEMAC0RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC0RXDISPERR_PHYEMAC0RXCLK_posedge,
	TestSignal     => PHYEMAC0RXDISPERR,
	TestSignalName => "PHYEMAC0RXDISPERR",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName  => "PHYEMAC0RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0RXDISPERR_PHYEMAC0RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0RXDISPERR_PHYEMAC0RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC0RXDISPERR_PHYEMAC0RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0RXDISPERR_PHYEMAC0RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0RXDV_PHYEMAC0GTXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC0RXDV_PHYEMAC0GTXCLK_posedge,
	TestSignal     => PHYEMAC0RXDV,
	TestSignalName => "PHYEMAC0RXDV",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0GTXCLK_dly,
	RefSignalName  => "PHYEMAC0GTXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0RXDV_PHYEMAC0GTXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0RXDV_PHYEMAC0GTXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC0RXDV_PHYEMAC0GTXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0RXDV_PHYEMAC0GTXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0RXDV_PHYEMAC0RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC0RXDV_PHYEMAC0RXCLK_posedge,
	TestSignal     => PHYEMAC0RXDV,
	TestSignalName => "PHYEMAC0RXDV",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName  => "PHYEMAC0RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0RXDV_PHYEMAC0RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0RXDV_PHYEMAC0RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC0RXDV_PHYEMAC0RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0RXDV_PHYEMAC0RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0RXDV_PHYEMAC0RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC0RXDV_PHYEMAC0RXCLK_posedge,
	TestSignal     => PHYEMAC0RXDV,
	TestSignalName => "PHYEMAC0RXDV",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName  => "PHYEMAC0RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0RXDV_PHYEMAC0RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0RXDV_PHYEMAC0RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC0RXDV_PHYEMAC0RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0RXDV_PHYEMAC0RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0RXER_PHYEMAC0GTXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC0RXER_PHYEMAC0GTXCLK_posedge,
	TestSignal     => PHYEMAC0RXER,
	TestSignalName => "PHYEMAC0RXER",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0GTXCLK_dly,
	RefSignalName  => "PHYEMAC0GTXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0RXER_PHYEMAC0GTXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0RXER_PHYEMAC0GTXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC0RXER_PHYEMAC0GTXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0RXER_PHYEMAC0GTXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0RXER_PHYEMAC0RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC0RXER_PHYEMAC0RXCLK_posedge,
	TestSignal     => PHYEMAC0RXER,
	TestSignalName => "PHYEMAC0RXER",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName  => "PHYEMAC0RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0RXER_PHYEMAC0RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0RXER_PHYEMAC0RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC0RXER_PHYEMAC0RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0RXER_PHYEMAC0RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0RXER_PHYEMAC0RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC0RXER_PHYEMAC0RXCLK_posedge,
	TestSignal     => PHYEMAC0RXER,
	TestSignalName => "PHYEMAC0RXER",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName  => "PHYEMAC0RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0RXER_PHYEMAC0RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0RXER_PHYEMAC0RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC0RXER_PHYEMAC0RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0RXER_PHYEMAC0RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0RXER_PHYEMAC0RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC0RXER_PHYEMAC0RXCLK_posedge,
	TestSignal     => PHYEMAC0RXER,
	TestSignalName => "PHYEMAC0RXER",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName  => "PHYEMAC0RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0RXER_PHYEMAC0RXCLK_posedge_negedge,
	SetupLow       => tsetup_PHYEMAC0RXER_PHYEMAC0RXCLK_negedge_negedge,
	HoldLow        => thold_PHYEMAC0RXER_PHYEMAC0RXCLK_posedge_negedge,
	HoldHigh       => thold_PHYEMAC0RXER_PHYEMAC0RXCLK_negedge_negedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'F',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXLOSSOFSYNC0_PHYEMAC0GTXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXLOSSOFSYNC0_PHYEMAC0GTXCLK_posedge,
	TestSignal => PHYEMAC0RXLOSSOFSYNC_PHYEMAC0GTXCLK_dly(0),
	TestSignalName => "PHYEMAC0RXLOSSOFSYNC(0)",
	TestDelay => tisd_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0GTXCLK(0),
	RefSignal => PHYEMAC0GTXCLK_dly,
	RefSignalName => "PHYEMAC0GTXCLK",
	RefDelay => ticd_PHYEMAC0GTXCLK,
	SetupHigh => tsetup_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0GTXCLK_posedge_posedge(0),
	SetupLow => tsetup_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0GTXCLK_negedge_posedge(0),
	HoldLow => thold_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0GTXCLK_posedge_posedge(0),
	HoldHigh => thold_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0GTXCLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXLOSSOFSYNC0_PHYEMAC0RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXLOSSOFSYNC0_PHYEMAC0RXCLK_posedge,
	TestSignal => PHYEMAC0RXLOSSOFSYNC_PHYEMAC0RXCLK_dly(0),
	TestSignalName => "PHYEMAC0RXLOSSOFSYNC(0)",
	TestDelay => tisd_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0RXCLK(0),
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName => "PHYEMAC0RXCLK",
	RefDelay => ticd_PHYEMAC0RXCLK,
	SetupHigh => tsetup_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0RXCLK_posedge_posedge(0),
	SetupLow => tsetup_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0RXCLK_negedge_posedge(0),
	HoldLow => thold_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0RXCLK_posedge_posedge(0),
	HoldHigh => thold_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0RXCLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXLOSSOFSYNC0_PHYEMAC0RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXLOSSOFSYNC0_PHYEMAC0RXCLK_posedge,
	TestSignal => PHYEMAC0RXLOSSOFSYNC_PHYEMAC0RXCLK_dly(0),
	TestSignalName => "PHYEMAC0RXLOSSOFSYNC(0)",
	TestDelay => tisd_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0RXCLK(0),
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName => "PHYEMAC0RXCLK",
	RefDelay => ticd_PHYEMAC0RXCLK,
	SetupHigh => tsetup_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0RXCLK_posedge_posedge(0),
	SetupLow => tsetup_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0RXCLK_negedge_posedge(0),
	HoldLow => thold_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0RXCLK_posedge_posedge(0),
	HoldHigh => thold_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0RXCLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXLOSSOFSYNC1_PHYEMAC0GTXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXLOSSOFSYNC1_PHYEMAC0GTXCLK_posedge,
	TestSignal => PHYEMAC0RXLOSSOFSYNC_PHYEMAC0GTXCLK_dly(1),
	TestSignalName => "PHYEMAC0RXLOSSOFSYNC(1)",
	TestDelay => tisd_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0GTXCLK(1),
	RefSignal => PHYEMAC0GTXCLK_dly,
	RefSignalName => "PHYEMAC0GTXCLK",
	RefDelay => ticd_PHYEMAC0GTXCLK,
	SetupHigh => tsetup_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0GTXCLK_posedge_posedge(1),
	SetupLow => tsetup_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0GTXCLK_negedge_posedge(1),
	HoldLow => thold_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0GTXCLK_posedge_posedge(1),
	HoldHigh => thold_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0GTXCLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXLOSSOFSYNC1_PHYEMAC0RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXLOSSOFSYNC1_PHYEMAC0RXCLK_posedge,
	TestSignal => PHYEMAC0RXLOSSOFSYNC_PHYEMAC0RXCLK_dly(1),
	TestSignalName => "PHYEMAC0RXLOSSOFSYNC(1)",
	TestDelay => tisd_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0RXCLK(1),
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName => "PHYEMAC0RXCLK",
	RefDelay => ticd_PHYEMAC0RXCLK,
	SetupHigh => tsetup_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0RXCLK_posedge_posedge(1),
	SetupLow => tsetup_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0RXCLK_negedge_posedge(1),
	HoldLow => thold_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0RXCLK_posedge_posedge(1),
	HoldHigh => thold_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0RXCLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC0RXLOSSOFSYNC1_PHYEMAC0RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC0RXLOSSOFSYNC1_PHYEMAC0RXCLK_posedge,
	TestSignal => PHYEMAC0RXLOSSOFSYNC_PHYEMAC0RXCLK_dly(1),
	TestSignalName => "PHYEMAC0RXLOSSOFSYNC(1)",
	TestDelay => tisd_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0RXCLK(1),
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName => "PHYEMAC0RXCLK",
	RefDelay => ticd_PHYEMAC0RXCLK,
	SetupHigh => tsetup_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0RXCLK_posedge_posedge(1),
	SetupLow => tsetup_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0RXCLK_negedge_posedge(1),
	HoldLow => thold_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0RXCLK_posedge_posedge(1),
	HoldHigh => thold_PHYEMAC0RXLOSSOFSYNC_PHYEMAC0RXCLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0RXNOTINTABLE_PHYEMAC0GTXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC0RXNOTINTABLE_PHYEMAC0GTXCLK_posedge,
	TestSignal     => PHYEMAC0RXNOTINTABLE,
	TestSignalName => "PHYEMAC0RXNOTINTABLE",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0GTXCLK_dly,
	RefSignalName  => "PHYEMAC0GTXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0RXNOTINTABLE_PHYEMAC0GTXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0RXNOTINTABLE_PHYEMAC0GTXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC0RXNOTINTABLE_PHYEMAC0GTXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0RXNOTINTABLE_PHYEMAC0GTXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0RXNOTINTABLE_PHYEMAC0RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC0RXNOTINTABLE_PHYEMAC0RXCLK_posedge,
	TestSignal     => PHYEMAC0RXNOTINTABLE,
	TestSignalName => "PHYEMAC0RXNOTINTABLE",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName  => "PHYEMAC0RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0RXNOTINTABLE_PHYEMAC0RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0RXNOTINTABLE_PHYEMAC0RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC0RXNOTINTABLE_PHYEMAC0RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0RXNOTINTABLE_PHYEMAC0RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0RXNOTINTABLE_PHYEMAC0RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC0RXNOTINTABLE_PHYEMAC0RXCLK_posedge,
	TestSignal     => PHYEMAC0RXNOTINTABLE,
	TestSignalName => "PHYEMAC0RXNOTINTABLE",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName  => "PHYEMAC0RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0RXNOTINTABLE_PHYEMAC0RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0RXNOTINTABLE_PHYEMAC0RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC0RXNOTINTABLE_PHYEMAC0RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0RXNOTINTABLE_PHYEMAC0RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0RXRUNDISP_PHYEMAC0GTXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC0RXRUNDISP_PHYEMAC0GTXCLK_posedge,
	TestSignal     => PHYEMAC0RXRUNDISP,
	TestSignalName => "PHYEMAC0RXRUNDISP",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0GTXCLK_dly,
	RefSignalName  => "PHYEMAC0GTXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0RXRUNDISP_PHYEMAC0GTXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0RXRUNDISP_PHYEMAC0GTXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC0RXRUNDISP_PHYEMAC0GTXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0RXRUNDISP_PHYEMAC0GTXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0RXRUNDISP_PHYEMAC0RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC0RXRUNDISP_PHYEMAC0RXCLK_posedge,
	TestSignal     => PHYEMAC0RXRUNDISP,
	TestSignalName => "PHYEMAC0RXRUNDISP",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName  => "PHYEMAC0RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0RXRUNDISP_PHYEMAC0RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0RXRUNDISP_PHYEMAC0RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC0RXRUNDISP_PHYEMAC0RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0RXRUNDISP_PHYEMAC0RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0RXRUNDISP_PHYEMAC0RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC0RXRUNDISP_PHYEMAC0RXCLK_posedge,
	TestSignal     => PHYEMAC0RXRUNDISP,
	TestSignalName => "PHYEMAC0RXRUNDISP",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName  => "PHYEMAC0RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0RXRUNDISP_PHYEMAC0RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0RXRUNDISP_PHYEMAC0RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC0RXRUNDISP_PHYEMAC0RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0RXRUNDISP_PHYEMAC0RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0SIGNALDET_PHYEMAC0GTXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC0SIGNALDET_PHYEMAC0GTXCLK_posedge,
	TestSignal     => PHYEMAC0SIGNALDET,
	TestSignalName => "PHYEMAC0SIGNALDET",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0GTXCLK_dly,
	RefSignalName  => "PHYEMAC0GTXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0SIGNALDET_PHYEMAC0GTXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0SIGNALDET_PHYEMAC0GTXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC0SIGNALDET_PHYEMAC0GTXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0SIGNALDET_PHYEMAC0GTXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0SIGNALDET_PHYEMAC0RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC0SIGNALDET_PHYEMAC0RXCLK_posedge,
	TestSignal     => PHYEMAC0SIGNALDET,
	TestSignalName => "PHYEMAC0SIGNALDET",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName  => "PHYEMAC0RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0SIGNALDET_PHYEMAC0RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0SIGNALDET_PHYEMAC0RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC0SIGNALDET_PHYEMAC0RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0SIGNALDET_PHYEMAC0RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0SIGNALDET_PHYEMAC0RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC0SIGNALDET_PHYEMAC0RXCLK_posedge,
	TestSignal     => PHYEMAC0SIGNALDET,
	TestSignalName => "PHYEMAC0SIGNALDET",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0RXCLK_dly,
	RefSignalName  => "PHYEMAC0RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0SIGNALDET_PHYEMAC0RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0SIGNALDET_PHYEMAC0RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC0SIGNALDET_PHYEMAC0RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0SIGNALDET_PHYEMAC0RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0TXBUFERR_PHYEMAC0GTXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC0TXBUFERR_PHYEMAC0GTXCLK_posedge,
	TestSignal     => PHYEMAC0TXBUFERR,
	TestSignalName => "PHYEMAC0TXBUFERR",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0GTXCLK_dly,
	RefSignalName  => "PHYEMAC0GTXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0TXBUFERR_PHYEMAC0GTXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0TXBUFERR_PHYEMAC0GTXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC0TXBUFERR_PHYEMAC0GTXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0TXBUFERR_PHYEMAC0GTXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0TXBUFERR_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData     => Tmkr_PHYEMAC0TXBUFERR_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal     => PHYEMAC0TXBUFERR,
	TestSignalName => "PHYEMAC0TXBUFERR",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName  => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0TXBUFERR_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0TXBUFERR_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge,
	HoldLow        => thold_PHYEMAC0TXBUFERR_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0TXBUFERR_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC0TXBUFERR_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TimingData     => Tmkr_PHYEMAC0TXBUFERR_PHYEMAC0TXGMIIMIICLKIN_posedge,
	TestSignal     => PHYEMAC0TXBUFERR,
	TestSignalName => "PHYEMAC0TXBUFERR",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC0TXGMIIMIICLKIN_dly,
	RefSignalName  => "PHYEMAC0TXGMIIMIICLKIN",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC0TXBUFERR_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC0TXBUFERR_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge,
	HoldLow        => thold_PHYEMAC0TXBUFERR_PHYEMAC0TXGMIIMIICLKIN_posedge_posedge,
	HoldHigh       => thold_PHYEMAC0TXBUFERR_PHYEMAC0TXGMIIMIICLKIN_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1COL_PHYEMAC1GTXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC1COL_PHYEMAC1GTXCLK_posedge,
	TestSignal     => PHYEMAC1COL,
	TestSignalName => "PHYEMAC1COL",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1GTXCLK_dly,
	RefSignalName  => "PHYEMAC1GTXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1COL_PHYEMAC1GTXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1COL_PHYEMAC1GTXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC1COL_PHYEMAC1GTXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1COL_PHYEMAC1GTXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1COL_PHYEMAC1RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC1COL_PHYEMAC1RXCLK_posedge,
	TestSignal     => PHYEMAC1COL,
	TestSignalName => "PHYEMAC1COL",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName  => "PHYEMAC1RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1COL_PHYEMAC1RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1COL_PHYEMAC1RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC1COL_PHYEMAC1RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1COL_PHYEMAC1RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1COL_PHYEMAC1RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC1COL_PHYEMAC1RXCLK_posedge,
	TestSignal     => PHYEMAC1COL,
	TestSignalName => "PHYEMAC1COL",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName  => "PHYEMAC1RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1COL_PHYEMAC1RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1COL_PHYEMAC1RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC1COL_PHYEMAC1RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1COL_PHYEMAC1RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1CRS_PHYEMAC1GTXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC1CRS_PHYEMAC1GTXCLK_posedge,
	TestSignal     => PHYEMAC1CRS,
	TestSignalName => "PHYEMAC1CRS",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1GTXCLK_dly,
	RefSignalName  => "PHYEMAC1GTXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1CRS_PHYEMAC1GTXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1CRS_PHYEMAC1GTXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC1CRS_PHYEMAC1GTXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1CRS_PHYEMAC1GTXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1CRS_PHYEMAC1RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC1CRS_PHYEMAC1RXCLK_posedge,
	TestSignal     => PHYEMAC1CRS,
	TestSignalName => "PHYEMAC1CRS",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName  => "PHYEMAC1RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1CRS_PHYEMAC1RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1CRS_PHYEMAC1RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC1CRS_PHYEMAC1RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1CRS_PHYEMAC1RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1CRS_PHYEMAC1RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC1CRS_PHYEMAC1RXCLK_posedge,
	TestSignal     => PHYEMAC1CRS,
	TestSignalName => "PHYEMAC1CRS",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName  => "PHYEMAC1RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1CRS_PHYEMAC1RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1CRS_PHYEMAC1RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC1CRS_PHYEMAC1RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1CRS_PHYEMAC1RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1MDIN_HOSTCLK_posedge,
	TimingData     => Tmkr_PHYEMAC1MDIN_HOSTCLK_posedge,
	TestSignal     => PHYEMAC1MDIN,
	TestSignalName => "PHYEMAC1MDIN",
	TestDelay      => 0 ps,
	RefSignal => HOSTCLK_dly,
	RefSignalName  => "HOSTCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1MDIN_HOSTCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1MDIN_HOSTCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC1MDIN_HOSTCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1MDIN_HOSTCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1MDIN_PHYEMAC1MCLKIN_posedge,
	TimingData     => Tmkr_PHYEMAC1MDIN_PHYEMAC1MCLKIN_posedge,
	TestSignal     => PHYEMAC1MDIN,
	TestSignalName => "PHYEMAC1MDIN",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1MCLKIN_dly,
	RefSignalName  => "PHYEMAC1MCLKIN",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1MDIN_PHYEMAC1MCLKIN_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1MDIN_PHYEMAC1MCLKIN_negedge_posedge,
	HoldLow        => thold_PHYEMAC1MDIN_PHYEMAC1MCLKIN_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1MDIN_PHYEMAC1MCLKIN_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1PHYAD0_HOSTCLK_posedge,
	TimingData => Tmkr_PHYEMAC1PHYAD0_HOSTCLK_posedge,
	TestSignal => PHYEMAC1PHYAD_HOSTCLK_dly(0),
	TestSignalName => "PHYEMAC1PHYAD(0)",
	TestDelay => tisd_PHYEMAC1PHYAD_HOSTCLK(0),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_PHYEMAC1PHYAD_HOSTCLK_posedge_posedge(0),
	SetupLow => tsetup_PHYEMAC1PHYAD_HOSTCLK_negedge_posedge(0),
	HoldLow => thold_PHYEMAC1PHYAD_HOSTCLK_posedge_posedge(0),
	HoldHigh => thold_PHYEMAC1PHYAD_HOSTCLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1PHYAD1_HOSTCLK_posedge,
	TimingData => Tmkr_PHYEMAC1PHYAD1_HOSTCLK_posedge,
	TestSignal => PHYEMAC1PHYAD_HOSTCLK_dly(1),
	TestSignalName => "PHYEMAC1PHYAD(1)",
	TestDelay => tisd_PHYEMAC1PHYAD_HOSTCLK(1),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_PHYEMAC1PHYAD_HOSTCLK_posedge_posedge(1),
	SetupLow => tsetup_PHYEMAC1PHYAD_HOSTCLK_negedge_posedge(1),
	HoldLow => thold_PHYEMAC1PHYAD_HOSTCLK_posedge_posedge(1),
	HoldHigh => thold_PHYEMAC1PHYAD_HOSTCLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1PHYAD2_HOSTCLK_posedge,
	TimingData => Tmkr_PHYEMAC1PHYAD2_HOSTCLK_posedge,
	TestSignal => PHYEMAC1PHYAD_HOSTCLK_dly(2),
	TestSignalName => "PHYEMAC1PHYAD(2)",
	TestDelay => tisd_PHYEMAC1PHYAD_HOSTCLK(2),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_PHYEMAC1PHYAD_HOSTCLK_posedge_posedge(2),
	SetupLow => tsetup_PHYEMAC1PHYAD_HOSTCLK_negedge_posedge(2),
	HoldLow => thold_PHYEMAC1PHYAD_HOSTCLK_posedge_posedge(2),
	HoldHigh => thold_PHYEMAC1PHYAD_HOSTCLK_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1PHYAD3_HOSTCLK_posedge,
	TimingData => Tmkr_PHYEMAC1PHYAD3_HOSTCLK_posedge,
	TestSignal => PHYEMAC1PHYAD_HOSTCLK_dly(3),
	TestSignalName => "PHYEMAC1PHYAD(3)",
	TestDelay => tisd_PHYEMAC1PHYAD_HOSTCLK(3),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_PHYEMAC1PHYAD_HOSTCLK_posedge_posedge(3),
	SetupLow => tsetup_PHYEMAC1PHYAD_HOSTCLK_negedge_posedge(3),
	HoldLow => thold_PHYEMAC1PHYAD_HOSTCLK_posedge_posedge(3),
	HoldHigh => thold_PHYEMAC1PHYAD_HOSTCLK_negedge_posedge(3),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1PHYAD4_HOSTCLK_posedge,
	TimingData => Tmkr_PHYEMAC1PHYAD4_HOSTCLK_posedge,
	TestSignal => PHYEMAC1PHYAD_HOSTCLK_dly(4),
	TestSignalName => "PHYEMAC1PHYAD(4)",
	TestDelay => tisd_PHYEMAC1PHYAD_HOSTCLK(4),
	RefSignal => HOSTCLK_dly,
	RefSignalName => "HOSTCLK",
	RefDelay => ticd_HOSTCLK,
	SetupHigh => tsetup_PHYEMAC1PHYAD_HOSTCLK_posedge_posedge(4),
	SetupLow => tsetup_PHYEMAC1PHYAD_HOSTCLK_negedge_posedge(4),
	HoldLow => thold_PHYEMAC1PHYAD_HOSTCLK_posedge_posedge(4),
	HoldHigh => thold_PHYEMAC1PHYAD_HOSTCLK_negedge_posedge(4),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1RXBUFERR_PHYEMAC1GTXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC1RXBUFERR_PHYEMAC1GTXCLK_posedge,
	TestSignal     => PHYEMAC1RXBUFERR,
	TestSignalName => "PHYEMAC1RXBUFERR",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1GTXCLK_dly,
	RefSignalName  => "PHYEMAC1GTXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1RXBUFERR_PHYEMAC1GTXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1RXBUFERR_PHYEMAC1GTXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC1RXBUFERR_PHYEMAC1GTXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1RXBUFERR_PHYEMAC1GTXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1RXBUFERR_PHYEMAC1RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC1RXBUFERR_PHYEMAC1RXCLK_posedge,
	TestSignal     => PHYEMAC1RXBUFERR,
	TestSignalName => "PHYEMAC1RXBUFERR",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName  => "PHYEMAC1RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1RXBUFERR_PHYEMAC1RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1RXBUFERR_PHYEMAC1RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC1RXBUFERR_PHYEMAC1RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1RXBUFERR_PHYEMAC1RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1RXBUFERR_PHYEMAC1RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC1RXBUFERR_PHYEMAC1RXCLK_posedge,
	TestSignal     => PHYEMAC1RXBUFERR,
	TestSignalName => "PHYEMAC1RXBUFERR",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName  => "PHYEMAC1RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1RXBUFERR_PHYEMAC1RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1RXBUFERR_PHYEMAC1RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC1RXBUFERR_PHYEMAC1RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1RXBUFERR_PHYEMAC1RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXBUFSTATUS0_PHYEMAC1GTXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXBUFSTATUS0_PHYEMAC1GTXCLK_posedge,
	TestSignal => PHYEMAC1RXBUFSTATUS_PHYEMAC1GTXCLK_dly(0),
	TestSignalName => "PHYEMAC1RXBUFSTATUS(0)",
	TestDelay => tisd_PHYEMAC1RXBUFSTATUS_PHYEMAC1GTXCLK(0),
	RefSignal => PHYEMAC1GTXCLK_dly,
	RefSignalName => "PHYEMAC1GTXCLK",
	RefDelay => ticd_PHYEMAC1GTXCLK,
	SetupHigh => tsetup_PHYEMAC1RXBUFSTATUS_PHYEMAC1GTXCLK_posedge_posedge(0),
	SetupLow => tsetup_PHYEMAC1RXBUFSTATUS_PHYEMAC1GTXCLK_negedge_posedge(0),
	HoldLow => thold_PHYEMAC1RXBUFSTATUS_PHYEMAC1GTXCLK_posedge_posedge(0),
	HoldHigh => thold_PHYEMAC1RXBUFSTATUS_PHYEMAC1GTXCLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXBUFSTATUS0_PHYEMAC1RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXBUFSTATUS0_PHYEMAC1RXCLK_posedge,
	TestSignal => PHYEMAC1RXBUFSTATUS_PHYEMAC1RXCLK_dly(0),
	TestSignalName => "PHYEMAC1RXBUFSTATUS(0)",
	TestDelay => tisd_PHYEMAC1RXBUFSTATUS_PHYEMAC1RXCLK(0),
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName => "PHYEMAC1RXCLK",
	RefDelay => ticd_PHYEMAC1RXCLK,
	SetupHigh => tsetup_PHYEMAC1RXBUFSTATUS_PHYEMAC1RXCLK_posedge_posedge(0),
	SetupLow => tsetup_PHYEMAC1RXBUFSTATUS_PHYEMAC1RXCLK_negedge_posedge(0),
	HoldLow => thold_PHYEMAC1RXBUFSTATUS_PHYEMAC1RXCLK_posedge_posedge(0),
	HoldHigh => thold_PHYEMAC1RXBUFSTATUS_PHYEMAC1RXCLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXBUFSTATUS0_PHYEMAC1RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXBUFSTATUS0_PHYEMAC1RXCLK_posedge,
	TestSignal => PHYEMAC1RXBUFSTATUS_PHYEMAC1RXCLK_dly(0),
	TestSignalName => "PHYEMAC1RXBUFSTATUS(0)",
	TestDelay => tisd_PHYEMAC1RXBUFSTATUS_PHYEMAC1RXCLK(0),
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName => "PHYEMAC1RXCLK",
	RefDelay => ticd_PHYEMAC1RXCLK,
	SetupHigh => tsetup_PHYEMAC1RXBUFSTATUS_PHYEMAC1RXCLK_posedge_posedge(0),
	SetupLow => tsetup_PHYEMAC1RXBUFSTATUS_PHYEMAC1RXCLK_negedge_posedge(0),
	HoldLow => thold_PHYEMAC1RXBUFSTATUS_PHYEMAC1RXCLK_posedge_posedge(0),
	HoldHigh => thold_PHYEMAC1RXBUFSTATUS_PHYEMAC1RXCLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXBUFSTATUS1_PHYEMAC1GTXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXBUFSTATUS1_PHYEMAC1GTXCLK_posedge,
	TestSignal => PHYEMAC1RXBUFSTATUS_PHYEMAC1GTXCLK_dly(1),
	TestSignalName => "PHYEMAC1RXBUFSTATUS(1)",
	TestDelay => tisd_PHYEMAC1RXBUFSTATUS_PHYEMAC1GTXCLK(1),
	RefSignal => PHYEMAC1GTXCLK_dly,
	RefSignalName => "PHYEMAC1GTXCLK",
	RefDelay => ticd_PHYEMAC1GTXCLK,
	SetupHigh => tsetup_PHYEMAC1RXBUFSTATUS_PHYEMAC1GTXCLK_posedge_posedge(1),
	SetupLow => tsetup_PHYEMAC1RXBUFSTATUS_PHYEMAC1GTXCLK_negedge_posedge(1),
	HoldLow => thold_PHYEMAC1RXBUFSTATUS_PHYEMAC1GTXCLK_posedge_posedge(1),
	HoldHigh => thold_PHYEMAC1RXBUFSTATUS_PHYEMAC1GTXCLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXBUFSTATUS1_PHYEMAC1RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXBUFSTATUS1_PHYEMAC1RXCLK_posedge,
	TestSignal => PHYEMAC1RXBUFSTATUS_PHYEMAC1RXCLK_dly(1),
	TestSignalName => "PHYEMAC1RXBUFSTATUS(1)",
	TestDelay => tisd_PHYEMAC1RXBUFSTATUS_PHYEMAC1RXCLK(1),
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName => "PHYEMAC1RXCLK",
	RefDelay => ticd_PHYEMAC1RXCLK,
	SetupHigh => tsetup_PHYEMAC1RXBUFSTATUS_PHYEMAC1RXCLK_posedge_posedge(1),
	SetupLow => tsetup_PHYEMAC1RXBUFSTATUS_PHYEMAC1RXCLK_negedge_posedge(1),
	HoldLow => thold_PHYEMAC1RXBUFSTATUS_PHYEMAC1RXCLK_posedge_posedge(1),
	HoldHigh => thold_PHYEMAC1RXBUFSTATUS_PHYEMAC1RXCLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXBUFSTATUS1_PHYEMAC1RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXBUFSTATUS1_PHYEMAC1RXCLK_posedge,
	TestSignal => PHYEMAC1RXBUFSTATUS_PHYEMAC1RXCLK_dly(1),
	TestSignalName => "PHYEMAC1RXBUFSTATUS(1)",
	TestDelay => tisd_PHYEMAC1RXBUFSTATUS_PHYEMAC1RXCLK(1),
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName => "PHYEMAC1RXCLK",
	RefDelay => ticd_PHYEMAC1RXCLK,
	SetupHigh => tsetup_PHYEMAC1RXBUFSTATUS_PHYEMAC1RXCLK_posedge_posedge(1),
	SetupLow => tsetup_PHYEMAC1RXBUFSTATUS_PHYEMAC1RXCLK_negedge_posedge(1),
	HoldLow => thold_PHYEMAC1RXBUFSTATUS_PHYEMAC1RXCLK_posedge_posedge(1),
	HoldHigh => thold_PHYEMAC1RXBUFSTATUS_PHYEMAC1RXCLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1RXCHARISCOMMA_PHYEMAC1GTXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC1RXCHARISCOMMA_PHYEMAC1GTXCLK_posedge,
	TestSignal     => PHYEMAC1RXCHARISCOMMA,
	TestSignalName => "PHYEMAC1RXCHARISCOMMA",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1GTXCLK_dly,
	RefSignalName  => "PHYEMAC1GTXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1RXCHARISCOMMA_PHYEMAC1GTXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1RXCHARISCOMMA_PHYEMAC1GTXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC1RXCHARISCOMMA_PHYEMAC1GTXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1RXCHARISCOMMA_PHYEMAC1GTXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1RXCHARISCOMMA_PHYEMAC1RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC1RXCHARISCOMMA_PHYEMAC1RXCLK_posedge,
	TestSignal     => PHYEMAC1RXCHARISCOMMA,
	TestSignalName => "PHYEMAC1RXCHARISCOMMA",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName  => "PHYEMAC1RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1RXCHARISCOMMA_PHYEMAC1RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1RXCHARISCOMMA_PHYEMAC1RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC1RXCHARISCOMMA_PHYEMAC1RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1RXCHARISCOMMA_PHYEMAC1RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1RXCHARISCOMMA_PHYEMAC1RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC1RXCHARISCOMMA_PHYEMAC1RXCLK_posedge,
	TestSignal     => PHYEMAC1RXCHARISCOMMA,
	TestSignalName => "PHYEMAC1RXCHARISCOMMA",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName  => "PHYEMAC1RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1RXCHARISCOMMA_PHYEMAC1RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1RXCHARISCOMMA_PHYEMAC1RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC1RXCHARISCOMMA_PHYEMAC1RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1RXCHARISCOMMA_PHYEMAC1RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1RXCHARISK_PHYEMAC1GTXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC1RXCHARISK_PHYEMAC1GTXCLK_posedge,
	TestSignal     => PHYEMAC1RXCHARISK,
	TestSignalName => "PHYEMAC1RXCHARISK",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1GTXCLK_dly,
	RefSignalName  => "PHYEMAC1GTXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1RXCHARISK_PHYEMAC1GTXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1RXCHARISK_PHYEMAC1GTXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC1RXCHARISK_PHYEMAC1GTXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1RXCHARISK_PHYEMAC1GTXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1RXCHARISK_PHYEMAC1RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC1RXCHARISK_PHYEMAC1RXCLK_posedge,
	TestSignal     => PHYEMAC1RXCHARISK,
	TestSignalName => "PHYEMAC1RXCHARISK",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName  => "PHYEMAC1RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1RXCHARISK_PHYEMAC1RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1RXCHARISK_PHYEMAC1RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC1RXCHARISK_PHYEMAC1RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1RXCHARISK_PHYEMAC1RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1RXCHARISK_PHYEMAC1RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC1RXCHARISK_PHYEMAC1RXCLK_posedge,
	TestSignal     => PHYEMAC1RXCHARISK,
	TestSignalName => "PHYEMAC1RXCHARISK",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName  => "PHYEMAC1RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1RXCHARISK_PHYEMAC1RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1RXCHARISK_PHYEMAC1RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC1RXCHARISK_PHYEMAC1RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1RXCHARISK_PHYEMAC1RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1RXCHECKINGCRC_PHYEMAC1GTXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC1RXCHECKINGCRC_PHYEMAC1GTXCLK_posedge,
	TestSignal     => PHYEMAC1RXCHECKINGCRC,
	TestSignalName => "PHYEMAC1RXCHECKINGCRC",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1GTXCLK_dly,
	RefSignalName  => "PHYEMAC1GTXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1RXCHECKINGCRC_PHYEMAC1GTXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1RXCHECKINGCRC_PHYEMAC1GTXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC1RXCHECKINGCRC_PHYEMAC1GTXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1RXCHECKINGCRC_PHYEMAC1GTXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1RXCHECKINGCRC_PHYEMAC1RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC1RXCHECKINGCRC_PHYEMAC1RXCLK_posedge,
	TestSignal     => PHYEMAC1RXCHECKINGCRC,
	TestSignalName => "PHYEMAC1RXCHECKINGCRC",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName  => "PHYEMAC1RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1RXCHECKINGCRC_PHYEMAC1RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1RXCHECKINGCRC_PHYEMAC1RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC1RXCHECKINGCRC_PHYEMAC1RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1RXCHECKINGCRC_PHYEMAC1RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1RXCHECKINGCRC_PHYEMAC1RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC1RXCHECKINGCRC_PHYEMAC1RXCLK_posedge,
	TestSignal     => PHYEMAC1RXCHECKINGCRC,
	TestSignalName => "PHYEMAC1RXCHECKINGCRC",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName  => "PHYEMAC1RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1RXCHECKINGCRC_PHYEMAC1RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1RXCHECKINGCRC_PHYEMAC1RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC1RXCHECKINGCRC_PHYEMAC1RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1RXCHECKINGCRC_PHYEMAC1RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXCLKCORCNT0_PHYEMAC1GTXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXCLKCORCNT0_PHYEMAC1GTXCLK_posedge,
	TestSignal => PHYEMAC1RXCLKCORCNT_PHYEMAC1GTXCLK_dly(0),
	TestSignalName => "PHYEMAC1RXCLKCORCNT(0)",
	TestDelay => tisd_PHYEMAC1RXCLKCORCNT_PHYEMAC1GTXCLK(0),
	RefSignal => PHYEMAC1GTXCLK_dly,
	RefSignalName => "PHYEMAC1GTXCLK",
	RefDelay => ticd_PHYEMAC1GTXCLK,
	SetupHigh => tsetup_PHYEMAC1RXCLKCORCNT_PHYEMAC1GTXCLK_posedge_posedge(0),
	SetupLow => tsetup_PHYEMAC1RXCLKCORCNT_PHYEMAC1GTXCLK_negedge_posedge(0),
	HoldLow => thold_PHYEMAC1RXCLKCORCNT_PHYEMAC1GTXCLK_posedge_posedge(0),
	HoldHigh => thold_PHYEMAC1RXCLKCORCNT_PHYEMAC1GTXCLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXCLKCORCNT0_PHYEMAC1RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXCLKCORCNT0_PHYEMAC1RXCLK_posedge,
	TestSignal => PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK_dly(0),
	TestSignalName => "PHYEMAC1RXCLKCORCNT(0)",
	TestDelay => tisd_PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK(0),
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName => "PHYEMAC1RXCLK",
	RefDelay => ticd_PHYEMAC1RXCLK,
	SetupHigh => tsetup_PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK_posedge_posedge(0),
	SetupLow => tsetup_PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK_negedge_posedge(0),
	HoldLow => thold_PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK_posedge_posedge(0),
	HoldHigh => thold_PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXCLKCORCNT0_PHYEMAC1RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXCLKCORCNT0_PHYEMAC1RXCLK_posedge,
	TestSignal => PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK_dly(0),
	TestSignalName => "PHYEMAC1RXCLKCORCNT(0)",
	TestDelay => tisd_PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK(0),
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName => "PHYEMAC1RXCLK",
	RefDelay => ticd_PHYEMAC1RXCLK,
	SetupHigh => tsetup_PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK_posedge_posedge(0),
	SetupLow => tsetup_PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK_negedge_posedge(0),
	HoldLow => thold_PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK_posedge_posedge(0),
	HoldHigh => thold_PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXCLKCORCNT1_PHYEMAC1GTXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXCLKCORCNT1_PHYEMAC1GTXCLK_posedge,
	TestSignal => PHYEMAC1RXCLKCORCNT_PHYEMAC1GTXCLK_dly(1),
	TestSignalName => "PHYEMAC1RXCLKCORCNT(1)",
	TestDelay => tisd_PHYEMAC1RXCLKCORCNT_PHYEMAC1GTXCLK(1),
	RefSignal => PHYEMAC1GTXCLK_dly,
	RefSignalName => "PHYEMAC1GTXCLK",
	RefDelay => ticd_PHYEMAC1GTXCLK,
	SetupHigh => tsetup_PHYEMAC1RXCLKCORCNT_PHYEMAC1GTXCLK_posedge_posedge(1),
	SetupLow => tsetup_PHYEMAC1RXCLKCORCNT_PHYEMAC1GTXCLK_negedge_posedge(1),
	HoldLow => thold_PHYEMAC1RXCLKCORCNT_PHYEMAC1GTXCLK_posedge_posedge(1),
	HoldHigh => thold_PHYEMAC1RXCLKCORCNT_PHYEMAC1GTXCLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXCLKCORCNT1_PHYEMAC1RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXCLKCORCNT1_PHYEMAC1RXCLK_posedge,
	TestSignal => PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK_dly(1),
	TestSignalName => "PHYEMAC1RXCLKCORCNT(1)",
	TestDelay => tisd_PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK(1),
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName => "PHYEMAC1RXCLK",
	RefDelay => ticd_PHYEMAC1RXCLK,
	SetupHigh => tsetup_PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK_posedge_posedge(1),
	SetupLow => tsetup_PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK_negedge_posedge(1),
	HoldLow => thold_PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK_posedge_posedge(1),
	HoldHigh => thold_PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXCLKCORCNT1_PHYEMAC1RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXCLKCORCNT1_PHYEMAC1RXCLK_posedge,
	TestSignal => PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK_dly(1),
	TestSignalName => "PHYEMAC1RXCLKCORCNT(1)",
	TestDelay => tisd_PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK(1),
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName => "PHYEMAC1RXCLK",
	RefDelay => ticd_PHYEMAC1RXCLK,
	SetupHigh => tsetup_PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK_posedge_posedge(1),
	SetupLow => tsetup_PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK_negedge_posedge(1),
	HoldLow => thold_PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK_posedge_posedge(1),
	HoldHigh => thold_PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXCLKCORCNT2_PHYEMAC1GTXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXCLKCORCNT2_PHYEMAC1GTXCLK_posedge,
	TestSignal => PHYEMAC1RXCLKCORCNT_PHYEMAC1GTXCLK_dly(2),
	TestSignalName => "PHYEMAC1RXCLKCORCNT(2)",
	TestDelay => tisd_PHYEMAC1RXCLKCORCNT_PHYEMAC1GTXCLK(2),
	RefSignal => PHYEMAC1GTXCLK_dly,
	RefSignalName => "PHYEMAC1GTXCLK",
	RefDelay => ticd_PHYEMAC1GTXCLK,
	SetupHigh => tsetup_PHYEMAC1RXCLKCORCNT_PHYEMAC1GTXCLK_posedge_posedge(2),
	SetupLow => tsetup_PHYEMAC1RXCLKCORCNT_PHYEMAC1GTXCLK_negedge_posedge(2),
	HoldLow => thold_PHYEMAC1RXCLKCORCNT_PHYEMAC1GTXCLK_posedge_posedge(2),
	HoldHigh => thold_PHYEMAC1RXCLKCORCNT_PHYEMAC1GTXCLK_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXCLKCORCNT2_PHYEMAC1RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXCLKCORCNT2_PHYEMAC1RXCLK_posedge,
	TestSignal => PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK_dly(2),
	TestSignalName => "PHYEMAC1RXCLKCORCNT(2)",
	TestDelay => tisd_PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK(2),
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName => "PHYEMAC1RXCLK",
	RefDelay => ticd_PHYEMAC1RXCLK,
	SetupHigh => tsetup_PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK_posedge_posedge(2),
	SetupLow => tsetup_PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK_negedge_posedge(2),
	HoldLow => thold_PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK_posedge_posedge(2),
	HoldHigh => thold_PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXCLKCORCNT2_PHYEMAC1RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXCLKCORCNT2_PHYEMAC1RXCLK_posedge,
	TestSignal => PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK_dly(2),
	TestSignalName => "PHYEMAC1RXCLKCORCNT(2)",
	TestDelay => tisd_PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK(2),
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName => "PHYEMAC1RXCLK",
	RefDelay => ticd_PHYEMAC1RXCLK,
	SetupHigh => tsetup_PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK_posedge_posedge(2),
	SetupLow => tsetup_PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK_negedge_posedge(2),
	HoldLow => thold_PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK_posedge_posedge(2),
	HoldHigh => thold_PHYEMAC1RXCLKCORCNT_PHYEMAC1RXCLK_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1RXCOMMADET_PHYEMAC1GTXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC1RXCOMMADET_PHYEMAC1GTXCLK_posedge,
	TestSignal     => PHYEMAC1RXCOMMADET,
	TestSignalName => "PHYEMAC1RXCOMMADET",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1GTXCLK_dly,
	RefSignalName  => "PHYEMAC1GTXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1RXCOMMADET_PHYEMAC1GTXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1RXCOMMADET_PHYEMAC1GTXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC1RXCOMMADET_PHYEMAC1GTXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1RXCOMMADET_PHYEMAC1GTXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1RXCOMMADET_PHYEMAC1RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC1RXCOMMADET_PHYEMAC1RXCLK_posedge,
	TestSignal     => PHYEMAC1RXCOMMADET,
	TestSignalName => "PHYEMAC1RXCOMMADET",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName  => "PHYEMAC1RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1RXCOMMADET_PHYEMAC1RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1RXCOMMADET_PHYEMAC1RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC1RXCOMMADET_PHYEMAC1RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1RXCOMMADET_PHYEMAC1RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1RXCOMMADET_PHYEMAC1RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC1RXCOMMADET_PHYEMAC1RXCLK_posedge,
	TestSignal     => PHYEMAC1RXCOMMADET,
	TestSignalName => "PHYEMAC1RXCOMMADET",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName  => "PHYEMAC1RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1RXCOMMADET_PHYEMAC1RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1RXCOMMADET_PHYEMAC1RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC1RXCOMMADET_PHYEMAC1RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1RXCOMMADET_PHYEMAC1RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXD0_PHYEMAC1GTXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXD0_PHYEMAC1GTXCLK_posedge,
	TestSignal => PHYEMAC1RXD_PHYEMAC1GTXCLK_dly(0),
	TestSignalName => "PHYEMAC1RXD(0)",
	TestDelay => tisd_PHYEMAC1RXD_PHYEMAC1GTXCLK(0),
	RefSignal => PHYEMAC1GTXCLK_dly,
	RefSignalName => "PHYEMAC1GTXCLK",
	RefDelay => ticd_PHYEMAC1GTXCLK,
	SetupHigh => tsetup_PHYEMAC1RXD_PHYEMAC1GTXCLK_posedge_posedge(0),
	SetupLow => tsetup_PHYEMAC1RXD_PHYEMAC1GTXCLK_negedge_posedge(0),
	HoldLow => thold_PHYEMAC1RXD_PHYEMAC1GTXCLK_posedge_posedge(0),
	HoldHigh => thold_PHYEMAC1RXD_PHYEMAC1GTXCLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXD0_PHYEMAC1RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXD0_PHYEMAC1RXCLK_posedge,
	TestSignal => PHYEMAC1RXD_PHYEMAC1RXCLK_dly(0),
	TestSignalName => "PHYEMAC1RXD(0)",
	TestDelay => tisd_PHYEMAC1RXD_PHYEMAC1RXCLK(0),
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName => "PHYEMAC1RXCLK",
	RefDelay => ticd_PHYEMAC1RXCLK,
	SetupHigh => tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_posedge(0),
	SetupLow => tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_posedge(0),
	HoldLow => thold_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_posedge(0),
	HoldHigh => thold_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXD0_PHYEMAC1RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXD0_PHYEMAC1RXCLK_posedge,
	TestSignal => PHYEMAC1RXD_PHYEMAC1RXCLK_dly(0),
	TestSignalName => "PHYEMAC1RXD(0)",
	TestDelay => tisd_PHYEMAC1RXD_PHYEMAC1RXCLK(0),
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName => "PHYEMAC1RXCLK",
	RefDelay => ticd_PHYEMAC1RXCLK,
	SetupHigh => tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_posedge(0),
	SetupLow => tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_posedge(0),
	HoldLow => thold_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_posedge(0),
	HoldHigh => thold_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXD1_PHYEMAC1GTXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXD1_PHYEMAC1GTXCLK_posedge,
	TestSignal => PHYEMAC1RXD_PHYEMAC1GTXCLK_dly(1),
	TestSignalName => "PHYEMAC1RXD(1)",
	TestDelay => tisd_PHYEMAC1RXD_PHYEMAC1GTXCLK(1),
	RefSignal => PHYEMAC1GTXCLK_dly,
	RefSignalName => "PHYEMAC1GTXCLK",
	RefDelay => ticd_PHYEMAC1GTXCLK,
	SetupHigh => tsetup_PHYEMAC1RXD_PHYEMAC1GTXCLK_posedge_posedge(1),
	SetupLow => tsetup_PHYEMAC1RXD_PHYEMAC1GTXCLK_negedge_posedge(1),
	HoldLow => thold_PHYEMAC1RXD_PHYEMAC1GTXCLK_posedge_posedge(1),
	HoldHigh => thold_PHYEMAC1RXD_PHYEMAC1GTXCLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXD1_PHYEMAC1RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXD1_PHYEMAC1RXCLK_posedge,
	TestSignal => PHYEMAC1RXD_PHYEMAC1RXCLK_dly(1),
	TestSignalName => "PHYEMAC1RXD(1)",
	TestDelay => tisd_PHYEMAC1RXD_PHYEMAC1RXCLK(1),
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName => "PHYEMAC1RXCLK",
	RefDelay => ticd_PHYEMAC1RXCLK,
	SetupHigh => tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_posedge(1),
	SetupLow => tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_posedge(1),
	HoldLow => thold_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_posedge(1),
	HoldHigh => thold_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXD1_PHYEMAC1RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXD1_PHYEMAC1RXCLK_posedge,
	TestSignal => PHYEMAC1RXD_PHYEMAC1RXCLK_dly(1),
	TestSignalName => "PHYEMAC1RXD(1)",
	TestDelay => tisd_PHYEMAC1RXD_PHYEMAC1RXCLK(1),
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName => "PHYEMAC1RXCLK",
	RefDelay => ticd_PHYEMAC1RXCLK,
	SetupHigh => tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_posedge(1),
	SetupLow => tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_posedge(1),
	HoldLow => thold_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_posedge(1),
	HoldHigh => thold_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXD2_PHYEMAC1GTXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXD2_PHYEMAC1GTXCLK_posedge,
	TestSignal => PHYEMAC1RXD_PHYEMAC1GTXCLK_dly(2),
	TestSignalName => "PHYEMAC1RXD(2)",
	TestDelay => tisd_PHYEMAC1RXD_PHYEMAC1GTXCLK(2),
	RefSignal => PHYEMAC1GTXCLK_dly,
	RefSignalName => "PHYEMAC1GTXCLK",
	RefDelay => ticd_PHYEMAC1GTXCLK,
	SetupHigh => tsetup_PHYEMAC1RXD_PHYEMAC1GTXCLK_posedge_posedge(2),
	SetupLow => tsetup_PHYEMAC1RXD_PHYEMAC1GTXCLK_negedge_posedge(2),
	HoldLow => thold_PHYEMAC1RXD_PHYEMAC1GTXCLK_posedge_posedge(2),
	HoldHigh => thold_PHYEMAC1RXD_PHYEMAC1GTXCLK_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXD2_PHYEMAC1RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXD2_PHYEMAC1RXCLK_posedge,
	TestSignal => PHYEMAC1RXD_PHYEMAC1RXCLK_dly(2),
	TestSignalName => "PHYEMAC1RXD(2)",
	TestDelay => tisd_PHYEMAC1RXD_PHYEMAC1RXCLK(2),
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName => "PHYEMAC1RXCLK",
	RefDelay => ticd_PHYEMAC1RXCLK,
	SetupHigh => tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_posedge(2),
	SetupLow => tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_posedge(2),
	HoldLow => thold_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_posedge(2),
	HoldHigh => thold_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXD2_PHYEMAC1RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXD2_PHYEMAC1RXCLK_posedge,
	TestSignal => PHYEMAC1RXD_PHYEMAC1RXCLK_dly(2),
	TestSignalName => "PHYEMAC1RXD(2)",
	TestDelay => tisd_PHYEMAC1RXD_PHYEMAC1RXCLK(2),
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName => "PHYEMAC1RXCLK",
	RefDelay => ticd_PHYEMAC1RXCLK,
	SetupHigh => tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_posedge(2),
	SetupLow => tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_posedge(2),
	HoldLow => thold_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_posedge(2),
	HoldHigh => thold_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXD3_PHYEMAC1GTXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXD3_PHYEMAC1GTXCLK_posedge,
	TestSignal => PHYEMAC1RXD_PHYEMAC1GTXCLK_dly(3),
	TestSignalName => "PHYEMAC1RXD(3)",
	TestDelay => tisd_PHYEMAC1RXD_PHYEMAC1GTXCLK(3),
	RefSignal => PHYEMAC1GTXCLK_dly,
	RefSignalName => "PHYEMAC1GTXCLK",
	RefDelay => ticd_PHYEMAC1GTXCLK,
	SetupHigh => tsetup_PHYEMAC1RXD_PHYEMAC1GTXCLK_posedge_posedge(3),
	SetupLow => tsetup_PHYEMAC1RXD_PHYEMAC1GTXCLK_negedge_posedge(3),
	HoldLow => thold_PHYEMAC1RXD_PHYEMAC1GTXCLK_posedge_posedge(3),
	HoldHigh => thold_PHYEMAC1RXD_PHYEMAC1GTXCLK_negedge_posedge(3),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXD3_PHYEMAC1RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXD3_PHYEMAC1RXCLK_posedge,
	TestSignal => PHYEMAC1RXD_PHYEMAC1RXCLK_dly(3),
	TestSignalName => "PHYEMAC1RXD(3)",
	TestDelay => tisd_PHYEMAC1RXD_PHYEMAC1RXCLK(3),
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName => "PHYEMAC1RXCLK",
	RefDelay => ticd_PHYEMAC1RXCLK,
	SetupHigh => tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_posedge(3),
	SetupLow => tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_posedge(3),
	HoldLow => thold_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_posedge(3),
	HoldHigh => thold_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_posedge(3),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXD3_PHYEMAC1RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXD3_PHYEMAC1RXCLK_posedge,
	TestSignal => PHYEMAC1RXD_PHYEMAC1RXCLK_dly(3),
	TestSignalName => "PHYEMAC1RXD(3)",
	TestDelay => tisd_PHYEMAC1RXD_PHYEMAC1RXCLK(3),
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName => "PHYEMAC1RXCLK",
	RefDelay => ticd_PHYEMAC1RXCLK,
	SetupHigh => tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_posedge(3),
	SetupLow => tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_posedge(3),
	HoldLow => thold_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_posedge(3),
	HoldHigh => thold_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_posedge(3),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXD4_PHYEMAC1GTXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXD4_PHYEMAC1GTXCLK_posedge,
	TestSignal => PHYEMAC1RXD_PHYEMAC1GTXCLK_dly(4),
	TestSignalName => "PHYEMAC1RXD(4)",
	TestDelay => tisd_PHYEMAC1RXD_PHYEMAC1GTXCLK(4),
	RefSignal => PHYEMAC1GTXCLK_dly,
	RefSignalName => "PHYEMAC1GTXCLK",
	RefDelay => ticd_PHYEMAC1GTXCLK,
	SetupHigh => tsetup_PHYEMAC1RXD_PHYEMAC1GTXCLK_posedge_posedge(4),
	SetupLow => tsetup_PHYEMAC1RXD_PHYEMAC1GTXCLK_negedge_posedge(4),
	HoldLow => thold_PHYEMAC1RXD_PHYEMAC1GTXCLK_posedge_posedge(4),
	HoldHigh => thold_PHYEMAC1RXD_PHYEMAC1GTXCLK_negedge_posedge(4),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXD4_PHYEMAC1RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXD4_PHYEMAC1RXCLK_posedge,
	TestSignal => PHYEMAC1RXD_PHYEMAC1RXCLK_dly(4),
	TestSignalName => "PHYEMAC1RXD(4)",
	TestDelay => tisd_PHYEMAC1RXD_PHYEMAC1RXCLK(4),
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName => "PHYEMAC1RXCLK",
	RefDelay => ticd_PHYEMAC1RXCLK,
	SetupHigh => tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_posedge(4),
	SetupLow => tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_posedge(4),
	HoldLow => thold_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_posedge(4),
	HoldHigh => thold_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_posedge(4),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXD4_PHYEMAC1RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXD4_PHYEMAC1RXCLK_posedge,
	TestSignal => PHYEMAC1RXD_PHYEMAC1RXCLK_dly(4),
	TestSignalName => "PHYEMAC1RXD(4)",
	TestDelay => tisd_PHYEMAC1RXD_PHYEMAC1RXCLK(4),
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName => "PHYEMAC1RXCLK",
	RefDelay => ticd_PHYEMAC1RXCLK,
	SetupHigh => tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_posedge(4),
	SetupLow => tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_posedge(4),
	HoldLow => thold_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_posedge(4),
	HoldHigh => thold_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_posedge(4),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXD4_PHYEMAC1RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXD4_PHYEMAC1RXCLK_posedge,
	TestSignal => PHYEMAC1RXD_PHYEMAC1RXCLK_dly(4),
	TestSignalName => "PHYEMAC1RXD(4)",
	TestDelay => tisd_PHYEMAC1RXD_PHYEMAC1RXCLK(4),
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName => "PHYEMAC1RXCLK",
	RefDelay => ticd_PHYEMAC1RXCLK,
	SetupHigh => tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_negedge(4),
	SetupLow => tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_negedge(4),
	HoldLow => thold_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_negedge(4),
	HoldHigh => thold_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_negedge(4),
	CheckEnabled   => TRUE,
	RefTransition  => 'F',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXD5_PHYEMAC1GTXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXD5_PHYEMAC1GTXCLK_posedge,
	TestSignal => PHYEMAC1RXD_PHYEMAC1GTXCLK_dly(5),
	TestSignalName => "PHYEMAC1RXD(5)",
	TestDelay => tisd_PHYEMAC1RXD_PHYEMAC1GTXCLK(5),
	RefSignal => PHYEMAC1GTXCLK_dly,
	RefSignalName => "PHYEMAC1GTXCLK",
	RefDelay => ticd_PHYEMAC1GTXCLK,
	SetupHigh => tsetup_PHYEMAC1RXD_PHYEMAC1GTXCLK_posedge_posedge(5),
	SetupLow => tsetup_PHYEMAC1RXD_PHYEMAC1GTXCLK_negedge_posedge(5),
	HoldLow => thold_PHYEMAC1RXD_PHYEMAC1GTXCLK_posedge_posedge(5),
	HoldHigh => thold_PHYEMAC1RXD_PHYEMAC1GTXCLK_negedge_posedge(5),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXD5_PHYEMAC1RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXD5_PHYEMAC1RXCLK_posedge,
	TestSignal => PHYEMAC1RXD_PHYEMAC1RXCLK_dly(5),
	TestSignalName => "PHYEMAC1RXD(5)",
	TestDelay => tisd_PHYEMAC1RXD_PHYEMAC1RXCLK(5),
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName => "PHYEMAC1RXCLK",
	RefDelay => ticd_PHYEMAC1RXCLK,
	SetupHigh => tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_posedge(5),
	SetupLow => tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_posedge(5),
	HoldLow => thold_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_posedge(5),
	HoldHigh => thold_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_posedge(5),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXD5_PHYEMAC1RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXD5_PHYEMAC1RXCLK_posedge,
	TestSignal => PHYEMAC1RXD_PHYEMAC1RXCLK_dly(5),
	TestSignalName => "PHYEMAC1RXD(5)",
	TestDelay => tisd_PHYEMAC1RXD_PHYEMAC1RXCLK(5),
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName => "PHYEMAC1RXCLK",
	RefDelay => ticd_PHYEMAC1RXCLK,
	SetupHigh => tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_posedge(5),
	SetupLow => tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_posedge(5),
	HoldLow => thold_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_posedge(5),
	HoldHigh => thold_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_posedge(5),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXD5_PHYEMAC1RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXD5_PHYEMAC1RXCLK_posedge,
	TestSignal => PHYEMAC1RXD_PHYEMAC1RXCLK_dly(5),
	TestSignalName => "PHYEMAC1RXD(5)",
	TestDelay => tisd_PHYEMAC1RXD_PHYEMAC1RXCLK(5),
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName => "PHYEMAC1RXCLK",
	RefDelay => ticd_PHYEMAC1RXCLK,
	SetupHigh => tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_negedge(5),
	SetupLow => tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_negedge(5),
	HoldLow => thold_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_negedge(5),
	HoldHigh => thold_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_negedge(5),
	CheckEnabled   => TRUE,
	RefTransition  => 'F',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXD6_PHYEMAC1GTXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXD6_PHYEMAC1GTXCLK_posedge,
	TestSignal => PHYEMAC1RXD_PHYEMAC1GTXCLK_dly(6),
	TestSignalName => "PHYEMAC1RXD(6)",
	TestDelay => tisd_PHYEMAC1RXD_PHYEMAC1GTXCLK(6),
	RefSignal => PHYEMAC1GTXCLK_dly,
	RefSignalName => "PHYEMAC1GTXCLK",
	RefDelay => ticd_PHYEMAC1GTXCLK,
	SetupHigh => tsetup_PHYEMAC1RXD_PHYEMAC1GTXCLK_posedge_posedge(6),
	SetupLow => tsetup_PHYEMAC1RXD_PHYEMAC1GTXCLK_negedge_posedge(6),
	HoldLow => thold_PHYEMAC1RXD_PHYEMAC1GTXCLK_posedge_posedge(6),
	HoldHigh => thold_PHYEMAC1RXD_PHYEMAC1GTXCLK_negedge_posedge(6),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXD6_PHYEMAC1RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXD6_PHYEMAC1RXCLK_posedge,
	TestSignal => PHYEMAC1RXD_PHYEMAC1RXCLK_dly(6),
	TestSignalName => "PHYEMAC1RXD(6)",
	TestDelay => tisd_PHYEMAC1RXD_PHYEMAC1RXCLK(6),
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName => "PHYEMAC1RXCLK",
	RefDelay => ticd_PHYEMAC1RXCLK,
	SetupHigh => tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_posedge(6),
	SetupLow => tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_posedge(6),
	HoldLow => thold_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_posedge(6),
	HoldHigh => thold_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_posedge(6),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXD6_PHYEMAC1RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXD6_PHYEMAC1RXCLK_posedge,
	TestSignal => PHYEMAC1RXD_PHYEMAC1RXCLK_dly(6),
	TestSignalName => "PHYEMAC1RXD(6)",
	TestDelay => tisd_PHYEMAC1RXD_PHYEMAC1RXCLK(6),
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName => "PHYEMAC1RXCLK",
	RefDelay => ticd_PHYEMAC1RXCLK,
	SetupHigh => tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_posedge(6),
	SetupLow => tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_posedge(6),
	HoldLow => thold_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_posedge(6),
	HoldHigh => thold_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_posedge(6),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXD6_PHYEMAC1RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXD6_PHYEMAC1RXCLK_posedge,
	TestSignal => PHYEMAC1RXD_PHYEMAC1RXCLK_dly(6),
	TestSignalName => "PHYEMAC1RXD(6)",
	TestDelay => tisd_PHYEMAC1RXD_PHYEMAC1RXCLK(6),
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName => "PHYEMAC1RXCLK",
	RefDelay => ticd_PHYEMAC1RXCLK,
	SetupHigh => tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_negedge(6),
	SetupLow => tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_negedge(6),
	HoldLow => thold_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_negedge(6),
	HoldHigh => thold_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_negedge(6),
	CheckEnabled   => TRUE,
	RefTransition  => 'F',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXD7_PHYEMAC1GTXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXD7_PHYEMAC1GTXCLK_posedge,
	TestSignal => PHYEMAC1RXD_PHYEMAC1GTXCLK_dly(7),
	TestSignalName => "PHYEMAC1RXD(7)",
	TestDelay => tisd_PHYEMAC1RXD_PHYEMAC1GTXCLK(7),
	RefSignal => PHYEMAC1GTXCLK_dly,
	RefSignalName => "PHYEMAC1GTXCLK",
	RefDelay => ticd_PHYEMAC1GTXCLK,
	SetupHigh => tsetup_PHYEMAC1RXD_PHYEMAC1GTXCLK_posedge_posedge(7),
	SetupLow => tsetup_PHYEMAC1RXD_PHYEMAC1GTXCLK_negedge_posedge(7),
	HoldLow => thold_PHYEMAC1RXD_PHYEMAC1GTXCLK_posedge_posedge(7),
	HoldHigh => thold_PHYEMAC1RXD_PHYEMAC1GTXCLK_negedge_posedge(7),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXD7_PHYEMAC1RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXD7_PHYEMAC1RXCLK_posedge,
	TestSignal => PHYEMAC1RXD_PHYEMAC1RXCLK_dly(7),
	TestSignalName => "PHYEMAC1RXD(7)",
	TestDelay => tisd_PHYEMAC1RXD_PHYEMAC1RXCLK(7),
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName => "PHYEMAC1RXCLK",
	RefDelay => ticd_PHYEMAC1RXCLK,
	SetupHigh => tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_posedge(7),
	SetupLow => tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_posedge(7),
	HoldLow => thold_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_posedge(7),
	HoldHigh => thold_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_posedge(7),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXD7_PHYEMAC1RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXD7_PHYEMAC1RXCLK_posedge,
	TestSignal => PHYEMAC1RXD_PHYEMAC1RXCLK_dly(7),
	TestSignalName => "PHYEMAC1RXD(7)",
	TestDelay => tisd_PHYEMAC1RXD_PHYEMAC1RXCLK(7),
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName => "PHYEMAC1RXCLK",
	RefDelay => ticd_PHYEMAC1RXCLK,
	SetupHigh => tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_posedge(7),
	SetupLow => tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_posedge(7),
	HoldLow => thold_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_posedge(7),
	HoldHigh => thold_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_posedge(7),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXD7_PHYEMAC1RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXD7_PHYEMAC1RXCLK_posedge,
	TestSignal => PHYEMAC1RXD_PHYEMAC1RXCLK_dly(7),
	TestSignalName => "PHYEMAC1RXD(7)",
	TestDelay => tisd_PHYEMAC1RXD_PHYEMAC1RXCLK(7),
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName => "PHYEMAC1RXCLK",
	RefDelay => ticd_PHYEMAC1RXCLK,
	SetupHigh => tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_negedge(7),
	SetupLow => tsetup_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_negedge(7),
	HoldLow => thold_PHYEMAC1RXD_PHYEMAC1RXCLK_posedge_negedge(7),
	HoldHigh => thold_PHYEMAC1RXD_PHYEMAC1RXCLK_negedge_negedge(7),
	CheckEnabled   => TRUE,
	RefTransition  => 'F',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1RXDISPERR_PHYEMAC1GTXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC1RXDISPERR_PHYEMAC1GTXCLK_posedge,
	TestSignal     => PHYEMAC1RXDISPERR,
	TestSignalName => "PHYEMAC1RXDISPERR",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1GTXCLK_dly,
	RefSignalName  => "PHYEMAC1GTXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1RXDISPERR_PHYEMAC1GTXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1RXDISPERR_PHYEMAC1GTXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC1RXDISPERR_PHYEMAC1GTXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1RXDISPERR_PHYEMAC1GTXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1RXDISPERR_PHYEMAC1RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC1RXDISPERR_PHYEMAC1RXCLK_posedge,
	TestSignal     => PHYEMAC1RXDISPERR,
	TestSignalName => "PHYEMAC1RXDISPERR",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName  => "PHYEMAC1RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1RXDISPERR_PHYEMAC1RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1RXDISPERR_PHYEMAC1RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC1RXDISPERR_PHYEMAC1RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1RXDISPERR_PHYEMAC1RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1RXDISPERR_PHYEMAC1RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC1RXDISPERR_PHYEMAC1RXCLK_posedge,
	TestSignal     => PHYEMAC1RXDISPERR,
	TestSignalName => "PHYEMAC1RXDISPERR",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName  => "PHYEMAC1RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1RXDISPERR_PHYEMAC1RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1RXDISPERR_PHYEMAC1RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC1RXDISPERR_PHYEMAC1RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1RXDISPERR_PHYEMAC1RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1RXDV_PHYEMAC1GTXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC1RXDV_PHYEMAC1GTXCLK_posedge,
	TestSignal     => PHYEMAC1RXDV,
	TestSignalName => "PHYEMAC1RXDV",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1GTXCLK_dly,
	RefSignalName  => "PHYEMAC1GTXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1RXDV_PHYEMAC1GTXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1RXDV_PHYEMAC1GTXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC1RXDV_PHYEMAC1GTXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1RXDV_PHYEMAC1GTXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1RXDV_PHYEMAC1RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC1RXDV_PHYEMAC1RXCLK_posedge,
	TestSignal     => PHYEMAC1RXDV,
	TestSignalName => "PHYEMAC1RXDV",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName  => "PHYEMAC1RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1RXDV_PHYEMAC1RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1RXDV_PHYEMAC1RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC1RXDV_PHYEMAC1RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1RXDV_PHYEMAC1RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1RXDV_PHYEMAC1RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC1RXDV_PHYEMAC1RXCLK_posedge,
	TestSignal     => PHYEMAC1RXDV,
	TestSignalName => "PHYEMAC1RXDV",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName  => "PHYEMAC1RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1RXDV_PHYEMAC1RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1RXDV_PHYEMAC1RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC1RXDV_PHYEMAC1RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1RXDV_PHYEMAC1RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1RXER_PHYEMAC1GTXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC1RXER_PHYEMAC1GTXCLK_posedge,
	TestSignal     => PHYEMAC1RXER,
	TestSignalName => "PHYEMAC1RXER",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1GTXCLK_dly,
	RefSignalName  => "PHYEMAC1GTXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1RXER_PHYEMAC1GTXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1RXER_PHYEMAC1GTXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC1RXER_PHYEMAC1GTXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1RXER_PHYEMAC1GTXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1RXER_PHYEMAC1RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC1RXER_PHYEMAC1RXCLK_posedge,
	TestSignal     => PHYEMAC1RXER,
	TestSignalName => "PHYEMAC1RXER",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName  => "PHYEMAC1RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1RXER_PHYEMAC1RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1RXER_PHYEMAC1RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC1RXER_PHYEMAC1RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1RXER_PHYEMAC1RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1RXER_PHYEMAC1RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC1RXER_PHYEMAC1RXCLK_posedge,
	TestSignal     => PHYEMAC1RXER,
	TestSignalName => "PHYEMAC1RXER",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName  => "PHYEMAC1RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1RXER_PHYEMAC1RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1RXER_PHYEMAC1RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC1RXER_PHYEMAC1RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1RXER_PHYEMAC1RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1RXER_PHYEMAC1RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC1RXER_PHYEMAC1RXCLK_posedge,
	TestSignal     => PHYEMAC1RXER,
	TestSignalName => "PHYEMAC1RXER",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName  => "PHYEMAC1RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1RXER_PHYEMAC1RXCLK_posedge_negedge,
	SetupLow       => tsetup_PHYEMAC1RXER_PHYEMAC1RXCLK_negedge_negedge,
	HoldLow        => thold_PHYEMAC1RXER_PHYEMAC1RXCLK_posedge_negedge,
	HoldHigh       => thold_PHYEMAC1RXER_PHYEMAC1RXCLK_negedge_negedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'F',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXLOSSOFSYNC0_PHYEMAC1GTXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXLOSSOFSYNC0_PHYEMAC1GTXCLK_posedge,
	TestSignal => PHYEMAC1RXLOSSOFSYNC_PHYEMAC1GTXCLK_dly(0),
	TestSignalName => "PHYEMAC1RXLOSSOFSYNC(0)",
	TestDelay => tisd_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1GTXCLK(0),
	RefSignal => PHYEMAC1GTXCLK_dly,
	RefSignalName => "PHYEMAC1GTXCLK",
	RefDelay => ticd_PHYEMAC1GTXCLK,
	SetupHigh => tsetup_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1GTXCLK_posedge_posedge(0),
	SetupLow => tsetup_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1GTXCLK_negedge_posedge(0),
	HoldLow => thold_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1GTXCLK_posedge_posedge(0),
	HoldHigh => thold_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1GTXCLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXLOSSOFSYNC0_PHYEMAC1RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXLOSSOFSYNC0_PHYEMAC1RXCLK_posedge,
	TestSignal => PHYEMAC1RXLOSSOFSYNC_PHYEMAC1RXCLK_dly(0),
	TestSignalName => "PHYEMAC1RXLOSSOFSYNC(0)",
	TestDelay => tisd_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1RXCLK(0),
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName => "PHYEMAC1RXCLK",
	RefDelay => ticd_PHYEMAC1RXCLK,
	SetupHigh => tsetup_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1RXCLK_posedge_posedge(0),
	SetupLow => tsetup_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1RXCLK_negedge_posedge(0),
	HoldLow => thold_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1RXCLK_posedge_posedge(0),
	HoldHigh => thold_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1RXCLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXLOSSOFSYNC0_PHYEMAC1RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXLOSSOFSYNC0_PHYEMAC1RXCLK_posedge,
	TestSignal => PHYEMAC1RXLOSSOFSYNC_PHYEMAC1RXCLK_dly(0),
	TestSignalName => "PHYEMAC1RXLOSSOFSYNC(0)",
	TestDelay => tisd_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1RXCLK(0),
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName => "PHYEMAC1RXCLK",
	RefDelay => ticd_PHYEMAC1RXCLK,
	SetupHigh => tsetup_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1RXCLK_posedge_posedge(0),
	SetupLow => tsetup_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1RXCLK_negedge_posedge(0),
	HoldLow => thold_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1RXCLK_posedge_posedge(0),
	HoldHigh => thold_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1RXCLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXLOSSOFSYNC1_PHYEMAC1GTXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXLOSSOFSYNC1_PHYEMAC1GTXCLK_posedge,
	TestSignal => PHYEMAC1RXLOSSOFSYNC_PHYEMAC1GTXCLK_dly(1),
	TestSignalName => "PHYEMAC1RXLOSSOFSYNC(1)",
	TestDelay => tisd_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1GTXCLK(1),
	RefSignal => PHYEMAC1GTXCLK_dly,
	RefSignalName => "PHYEMAC1GTXCLK",
	RefDelay => ticd_PHYEMAC1GTXCLK,
	SetupHigh => tsetup_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1GTXCLK_posedge_posedge(1),
	SetupLow => tsetup_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1GTXCLK_negedge_posedge(1),
	HoldLow => thold_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1GTXCLK_posedge_posedge(1),
	HoldHigh => thold_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1GTXCLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXLOSSOFSYNC1_PHYEMAC1RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXLOSSOFSYNC1_PHYEMAC1RXCLK_posedge,
	TestSignal => PHYEMAC1RXLOSSOFSYNC_PHYEMAC1RXCLK_dly(1),
	TestSignalName => "PHYEMAC1RXLOSSOFSYNC(1)",
	TestDelay => tisd_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1RXCLK(1),
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName => "PHYEMAC1RXCLK",
	RefDelay => ticd_PHYEMAC1RXCLK,
	SetupHigh => tsetup_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1RXCLK_posedge_posedge(1),
	SetupLow => tsetup_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1RXCLK_negedge_posedge(1),
	HoldLow => thold_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1RXCLK_posedge_posedge(1),
	HoldHigh => thold_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1RXCLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PHYEMAC1RXLOSSOFSYNC1_PHYEMAC1RXCLK_posedge,
	TimingData => Tmkr_PHYEMAC1RXLOSSOFSYNC1_PHYEMAC1RXCLK_posedge,
	TestSignal => PHYEMAC1RXLOSSOFSYNC_PHYEMAC1RXCLK_dly(1),
	TestSignalName => "PHYEMAC1RXLOSSOFSYNC(1)",
	TestDelay => tisd_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1RXCLK(1),
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName => "PHYEMAC1RXCLK",
	RefDelay => ticd_PHYEMAC1RXCLK,
	SetupHigh => tsetup_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1RXCLK_posedge_posedge(1),
	SetupLow => tsetup_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1RXCLK_negedge_posedge(1),
	HoldLow => thold_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1RXCLK_posedge_posedge(1),
	HoldHigh => thold_PHYEMAC1RXLOSSOFSYNC_PHYEMAC1RXCLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1RXNOTINTABLE_PHYEMAC1GTXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC1RXNOTINTABLE_PHYEMAC1GTXCLK_posedge,
	TestSignal     => PHYEMAC1RXNOTINTABLE,
	TestSignalName => "PHYEMAC1RXNOTINTABLE",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1GTXCLK_dly,
	RefSignalName  => "PHYEMAC1GTXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1RXNOTINTABLE_PHYEMAC1GTXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1RXNOTINTABLE_PHYEMAC1GTXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC1RXNOTINTABLE_PHYEMAC1GTXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1RXNOTINTABLE_PHYEMAC1GTXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1RXNOTINTABLE_PHYEMAC1RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC1RXNOTINTABLE_PHYEMAC1RXCLK_posedge,
	TestSignal     => PHYEMAC1RXNOTINTABLE,
	TestSignalName => "PHYEMAC1RXNOTINTABLE",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName  => "PHYEMAC1RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1RXNOTINTABLE_PHYEMAC1RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1RXNOTINTABLE_PHYEMAC1RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC1RXNOTINTABLE_PHYEMAC1RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1RXNOTINTABLE_PHYEMAC1RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1RXNOTINTABLE_PHYEMAC1RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC1RXNOTINTABLE_PHYEMAC1RXCLK_posedge,
	TestSignal     => PHYEMAC1RXNOTINTABLE,
	TestSignalName => "PHYEMAC1RXNOTINTABLE",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName  => "PHYEMAC1RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1RXNOTINTABLE_PHYEMAC1RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1RXNOTINTABLE_PHYEMAC1RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC1RXNOTINTABLE_PHYEMAC1RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1RXNOTINTABLE_PHYEMAC1RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1RXRUNDISP_PHYEMAC1GTXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC1RXRUNDISP_PHYEMAC1GTXCLK_posedge,
	TestSignal     => PHYEMAC1RXRUNDISP,
	TestSignalName => "PHYEMAC1RXRUNDISP",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1GTXCLK_dly,
	RefSignalName  => "PHYEMAC1GTXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1RXRUNDISP_PHYEMAC1GTXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1RXRUNDISP_PHYEMAC1GTXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC1RXRUNDISP_PHYEMAC1GTXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1RXRUNDISP_PHYEMAC1GTXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1RXRUNDISP_PHYEMAC1RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC1RXRUNDISP_PHYEMAC1RXCLK_posedge,
	TestSignal     => PHYEMAC1RXRUNDISP,
	TestSignalName => "PHYEMAC1RXRUNDISP",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName  => "PHYEMAC1RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1RXRUNDISP_PHYEMAC1RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1RXRUNDISP_PHYEMAC1RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC1RXRUNDISP_PHYEMAC1RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1RXRUNDISP_PHYEMAC1RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1RXRUNDISP_PHYEMAC1RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC1RXRUNDISP_PHYEMAC1RXCLK_posedge,
	TestSignal     => PHYEMAC1RXRUNDISP,
	TestSignalName => "PHYEMAC1RXRUNDISP",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName  => "PHYEMAC1RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1RXRUNDISP_PHYEMAC1RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1RXRUNDISP_PHYEMAC1RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC1RXRUNDISP_PHYEMAC1RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1RXRUNDISP_PHYEMAC1RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1SIGNALDET_PHYEMAC1GTXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC1SIGNALDET_PHYEMAC1GTXCLK_posedge,
	TestSignal     => PHYEMAC1SIGNALDET,
	TestSignalName => "PHYEMAC1SIGNALDET",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1GTXCLK_dly,
	RefSignalName  => "PHYEMAC1GTXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1SIGNALDET_PHYEMAC1GTXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1SIGNALDET_PHYEMAC1GTXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC1SIGNALDET_PHYEMAC1GTXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1SIGNALDET_PHYEMAC1GTXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1SIGNALDET_PHYEMAC1RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC1SIGNALDET_PHYEMAC1RXCLK_posedge,
	TestSignal     => PHYEMAC1SIGNALDET,
	TestSignalName => "PHYEMAC1SIGNALDET",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName  => "PHYEMAC1RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1SIGNALDET_PHYEMAC1RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1SIGNALDET_PHYEMAC1RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC1SIGNALDET_PHYEMAC1RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1SIGNALDET_PHYEMAC1RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1SIGNALDET_PHYEMAC1RXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC1SIGNALDET_PHYEMAC1RXCLK_posedge,
	TestSignal     => PHYEMAC1SIGNALDET,
	TestSignalName => "PHYEMAC1SIGNALDET",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1RXCLK_dly,
	RefSignalName  => "PHYEMAC1RXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1SIGNALDET_PHYEMAC1RXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1SIGNALDET_PHYEMAC1RXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC1SIGNALDET_PHYEMAC1RXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1SIGNALDET_PHYEMAC1RXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1TXBUFERR_PHYEMAC1GTXCLK_posedge,
	TimingData     => Tmkr_PHYEMAC1TXBUFERR_PHYEMAC1GTXCLK_posedge,
	TestSignal     => PHYEMAC1TXBUFERR,
	TestSignalName => "PHYEMAC1TXBUFERR",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1GTXCLK_dly,
	RefSignalName  => "PHYEMAC1GTXCLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1TXBUFERR_PHYEMAC1GTXCLK_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1TXBUFERR_PHYEMAC1GTXCLK_negedge_posedge,
	HoldLow        => thold_PHYEMAC1TXBUFERR_PHYEMAC1GTXCLK_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1TXBUFERR_PHYEMAC1GTXCLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1TXBUFERR_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData     => Tmkr_PHYEMAC1TXBUFERR_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal     => PHYEMAC1TXBUFERR,
	TestSignalName => "PHYEMAC1TXBUFERR",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName  => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1TXBUFERR_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1TXBUFERR_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge,
	HoldLow        => thold_PHYEMAC1TXBUFERR_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1TXBUFERR_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PHYEMAC1TXBUFERR_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TimingData     => Tmkr_PHYEMAC1TXBUFERR_PHYEMAC1TXGMIIMIICLKIN_posedge,
	TestSignal     => PHYEMAC1TXBUFERR,
	TestSignalName => "PHYEMAC1TXBUFERR",
	TestDelay      => 0 ps,
	RefSignal => PHYEMAC1TXGMIIMIICLKIN_dly,
	RefSignalName  => "PHYEMAC1TXGMIIMIICLKIN",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PHYEMAC1TXBUFERR_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge,
	SetupLow       => tsetup_PHYEMAC1TXBUFERR_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge,
	HoldLow        => thold_PHYEMAC1TXBUFERR_PHYEMAC1TXGMIIMIICLKIN_posedge_posedge,
	HoldHigh       => thold_PHYEMAC1TXBUFERR_PHYEMAC1TXGMIIMIICLKIN_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_TEMAC",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);

     end if;

	VitalPathDelay01
	(
	OutSignal     => DCRHOSTDONEIR,
	GlitchData    => DCRHOSTDONEIR_GlitchData,
	OutSignalName => "DCRHOSTDONEIR",
	OutTemp       => DCRHOSTDONEIR_OUT,
	Paths         => (0 => (HOSTCLK_dly'last_event, tpd_HOSTCLK_DCRHOSTDONEIR,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTANINTERRUPT,
	GlitchData    => EMAC0CLIENTANINTERRUPT_GlitchData,
	OutSignalName => "EMAC0CLIENTANINTERRUPT",
	OutTemp       => EMAC0CLIENTANINTERRUPT_OUT,
	Paths         => (0 => (PHYEMAC0GTXCLK_dly'last_event, tpd_PHYEMAC0GTXCLK_EMAC0CLIENTANINTERRUPT,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXBADFRAME,
	GlitchData    => EMAC0CLIENTRXBADFRAME_GlitchData,
	OutSignalName => "EMAC0CLIENTRXBADFRAME",
	OutTemp       => EMAC0CLIENTRXBADFRAME_OUT,
	Paths         => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXBADFRAME,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXBADFRAME,
	GlitchData    => EMAC0CLIENTRXBADFRAME_GlitchData,
	OutSignalName => "EMAC0CLIENTRXBADFRAME",
	OutTemp       => EMAC0CLIENTRXBADFRAME_OUT,
	Paths         => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXBADFRAME,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXBADFRAME,
	GlitchData    => EMAC0CLIENTRXBADFRAME_GlitchData,
	OutSignalName => "EMAC0CLIENTRXBADFRAME",
	OutTemp       => EMAC0CLIENTRXBADFRAME_OUT,
	Paths         => (0 => (PHYEMAC0RXCLK_dly'last_event, tpd_PHYEMAC0RXCLK_EMAC0CLIENTRXBADFRAME,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXCLIENTCLKOUT,
	GlitchData    => EMAC0CLIENTRXCLIENTCLKOUT_GlitchData,
	OutSignalName => "EMAC0CLIENTRXCLIENTCLKOUT",
	OutTemp       => EMAC0CLIENTRXCLIENTCLKOUT_OUT,
	Paths         => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXCLIENTCLKOUT,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXCLIENTCLKOUT,
	GlitchData    => EMAC0CLIENTRXCLIENTCLKOUT_GlitchData,
	OutSignalName => "EMAC0CLIENTRXCLIENTCLKOUT",
	OutTemp       => EMAC0CLIENTRXCLIENTCLKOUT_OUT,
	Paths         => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXCLIENTCLKOUT,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXCLIENTCLKOUT,
	GlitchData    => EMAC0CLIENTRXCLIENTCLKOUT_GlitchData,
	OutSignalName => "EMAC0CLIENTRXCLIENTCLKOUT",
	OutTemp       => EMAC0CLIENTRXCLIENTCLKOUT_OUT,
	Paths         => (0 => (PHYEMAC0RXCLK_dly'last_event, tpd_PHYEMAC0RXCLK_EMAC0CLIENTRXCLIENTCLKOUT,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXCLIENTCLKOUT,
	GlitchData    => EMAC0CLIENTRXCLIENTCLKOUT_GlitchData,
	OutSignalName => "EMAC0CLIENTRXCLIENTCLKOUT",
	OutTemp       => EMAC0CLIENTRXCLIENTCLKOUT_OUT,
	Paths         => (0 => (PHYEMAC0GTXCLK_dly'last_event, tpd_PHYEMAC0GTXCLK_EMAC0CLIENTRXCLIENTCLKOUT,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(0),
	GlitchData    => EMAC0CLIENTRXD0_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(0)",
	OutTemp       => EMAC0CLIENTRXD_OUT(0),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXD(0),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(0),
	GlitchData    => EMAC0CLIENTRXD0_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(0)",
	OutTemp       => EMAC0CLIENTRXD_OUT(0),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXD(0),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(0),
	GlitchData    => EMAC0CLIENTRXD0_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(0)",
	OutTemp       => EMAC0CLIENTRXD_OUT(0),
	Paths       => (0 => (PHYEMAC0RXCLK_dly'last_event, tpd_PHYEMAC0RXCLK_EMAC0CLIENTRXD(0),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(1),
	GlitchData    => EMAC0CLIENTRXD1_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(1)",
	OutTemp       => EMAC0CLIENTRXD_OUT(1),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXD(1),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(1),
	GlitchData    => EMAC0CLIENTRXD1_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(1)",
	OutTemp       => EMAC0CLIENTRXD_OUT(1),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXD(1),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(1),
	GlitchData    => EMAC0CLIENTRXD1_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(1)",
	OutTemp       => EMAC0CLIENTRXD_OUT(1),
	Paths       => (0 => (PHYEMAC0RXCLK_dly'last_event, tpd_PHYEMAC0RXCLK_EMAC0CLIENTRXD(1),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(2),
	GlitchData    => EMAC0CLIENTRXD2_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(2)",
	OutTemp       => EMAC0CLIENTRXD_OUT(2),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXD(2),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(2),
	GlitchData    => EMAC0CLIENTRXD2_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(2)",
	OutTemp       => EMAC0CLIENTRXD_OUT(2),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXD(2),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(2),
	GlitchData    => EMAC0CLIENTRXD2_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(2)",
	OutTemp       => EMAC0CLIENTRXD_OUT(2),
	Paths       => (0 => (PHYEMAC0RXCLK_dly'last_event, tpd_PHYEMAC0RXCLK_EMAC0CLIENTRXD(2),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(3),
	GlitchData    => EMAC0CLIENTRXD3_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(3)",
	OutTemp       => EMAC0CLIENTRXD_OUT(3),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXD(3),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(3),
	GlitchData    => EMAC0CLIENTRXD3_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(3)",
	OutTemp       => EMAC0CLIENTRXD_OUT(3),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXD(3),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(3),
	GlitchData    => EMAC0CLIENTRXD3_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(3)",
	OutTemp       => EMAC0CLIENTRXD_OUT(3),
	Paths       => (0 => (PHYEMAC0RXCLK_dly'last_event, tpd_PHYEMAC0RXCLK_EMAC0CLIENTRXD(3),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(4),
	GlitchData    => EMAC0CLIENTRXD4_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(4)",
	OutTemp       => EMAC0CLIENTRXD_OUT(4),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXD(4),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(4),
	GlitchData    => EMAC0CLIENTRXD4_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(4)",
	OutTemp       => EMAC0CLIENTRXD_OUT(4),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXD(4),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(4),
	GlitchData    => EMAC0CLIENTRXD4_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(4)",
	OutTemp       => EMAC0CLIENTRXD_OUT(4),
	Paths       => (0 => (PHYEMAC0RXCLK_dly'last_event, tpd_PHYEMAC0RXCLK_EMAC0CLIENTRXD(4),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(5),
	GlitchData    => EMAC0CLIENTRXD5_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(5)",
	OutTemp       => EMAC0CLIENTRXD_OUT(5),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXD(5),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(5),
	GlitchData    => EMAC0CLIENTRXD5_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(5)",
	OutTemp       => EMAC0CLIENTRXD_OUT(5),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXD(5),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(5),
	GlitchData    => EMAC0CLIENTRXD5_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(5)",
	OutTemp       => EMAC0CLIENTRXD_OUT(5),
	Paths       => (0 => (PHYEMAC0RXCLK_dly'last_event, tpd_PHYEMAC0RXCLK_EMAC0CLIENTRXD(5),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(6),
	GlitchData    => EMAC0CLIENTRXD6_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(6)",
	OutTemp       => EMAC0CLIENTRXD_OUT(6),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXD(6),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(6),
	GlitchData    => EMAC0CLIENTRXD6_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(6)",
	OutTemp       => EMAC0CLIENTRXD_OUT(6),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXD(6),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(6),
	GlitchData    => EMAC0CLIENTRXD6_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(6)",
	OutTemp       => EMAC0CLIENTRXD_OUT(6),
	Paths       => (0 => (PHYEMAC0RXCLK_dly'last_event, tpd_PHYEMAC0RXCLK_EMAC0CLIENTRXD(6),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(7),
	GlitchData    => EMAC0CLIENTRXD7_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(7)",
	OutTemp       => EMAC0CLIENTRXD_OUT(7),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXD(7),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(7),
	GlitchData    => EMAC0CLIENTRXD7_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(7)",
	OutTemp       => EMAC0CLIENTRXD_OUT(7),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXD(7),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(7),
	GlitchData    => EMAC0CLIENTRXD7_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(7)",
	OutTemp       => EMAC0CLIENTRXD_OUT(7),
	Paths       => (0 => (PHYEMAC0RXCLK_dly'last_event, tpd_PHYEMAC0RXCLK_EMAC0CLIENTRXD(7),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(8),
	GlitchData    => EMAC0CLIENTRXD8_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(8)",
	OutTemp       => EMAC0CLIENTRXD_OUT(8),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXD(8),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(8),
	GlitchData    => EMAC0CLIENTRXD8_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(8)",
	OutTemp       => EMAC0CLIENTRXD_OUT(8),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXD(8),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(8),
	GlitchData    => EMAC0CLIENTRXD8_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(8)",
	OutTemp       => EMAC0CLIENTRXD_OUT(8),
	Paths       => (0 => (PHYEMAC0RXCLK_dly'last_event, tpd_PHYEMAC0RXCLK_EMAC0CLIENTRXD(8),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(9),
	GlitchData    => EMAC0CLIENTRXD9_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(9)",
	OutTemp       => EMAC0CLIENTRXD_OUT(9),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXD(9),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(9),
	GlitchData    => EMAC0CLIENTRXD9_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(9)",
	OutTemp       => EMAC0CLIENTRXD_OUT(9),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXD(9),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(9),
	GlitchData    => EMAC0CLIENTRXD9_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(9)",
	OutTemp       => EMAC0CLIENTRXD_OUT(9),
	Paths       => (0 => (PHYEMAC0RXCLK_dly'last_event, tpd_PHYEMAC0RXCLK_EMAC0CLIENTRXD(9),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(10),
	GlitchData    => EMAC0CLIENTRXD10_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(10)",
	OutTemp       => EMAC0CLIENTRXD_OUT(10),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXD(10),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(10),
	GlitchData    => EMAC0CLIENTRXD10_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(10)",
	OutTemp       => EMAC0CLIENTRXD_OUT(10),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXD(10),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(10),
	GlitchData    => EMAC0CLIENTRXD10_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(10)",
	OutTemp       => EMAC0CLIENTRXD_OUT(10),
	Paths       => (0 => (PHYEMAC0RXCLK_dly'last_event, tpd_PHYEMAC0RXCLK_EMAC0CLIENTRXD(10),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(11),
	GlitchData    => EMAC0CLIENTRXD11_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(11)",
	OutTemp       => EMAC0CLIENTRXD_OUT(11),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXD(11),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(11),
	GlitchData    => EMAC0CLIENTRXD11_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(11)",
	OutTemp       => EMAC0CLIENTRXD_OUT(11),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXD(11),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(11),
	GlitchData    => EMAC0CLIENTRXD11_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(11)",
	OutTemp       => EMAC0CLIENTRXD_OUT(11),
	Paths       => (0 => (PHYEMAC0RXCLK_dly'last_event, tpd_PHYEMAC0RXCLK_EMAC0CLIENTRXD(11),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(12),
	GlitchData    => EMAC0CLIENTRXD12_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(12)",
	OutTemp       => EMAC0CLIENTRXD_OUT(12),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXD(12),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(12),
	GlitchData    => EMAC0CLIENTRXD12_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(12)",
	OutTemp       => EMAC0CLIENTRXD_OUT(12),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXD(12),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(12),
	GlitchData    => EMAC0CLIENTRXD12_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(12)",
	OutTemp       => EMAC0CLIENTRXD_OUT(12),
	Paths       => (0 => (PHYEMAC0RXCLK_dly'last_event, tpd_PHYEMAC0RXCLK_EMAC0CLIENTRXD(12),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(13),
	GlitchData    => EMAC0CLIENTRXD13_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(13)",
	OutTemp       => EMAC0CLIENTRXD_OUT(13),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXD(13),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(13),
	GlitchData    => EMAC0CLIENTRXD13_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(13)",
	OutTemp       => EMAC0CLIENTRXD_OUT(13),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXD(13),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(13),
	GlitchData    => EMAC0CLIENTRXD13_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(13)",
	OutTemp       => EMAC0CLIENTRXD_OUT(13),
	Paths       => (0 => (PHYEMAC0RXCLK_dly'last_event, tpd_PHYEMAC0RXCLK_EMAC0CLIENTRXD(13),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(14),
	GlitchData    => EMAC0CLIENTRXD14_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(14)",
	OutTemp       => EMAC0CLIENTRXD_OUT(14),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXD(14),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(14),
	GlitchData    => EMAC0CLIENTRXD14_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(14)",
	OutTemp       => EMAC0CLIENTRXD_OUT(14),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXD(14),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(14),
	GlitchData    => EMAC0CLIENTRXD14_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(14)",
	OutTemp       => EMAC0CLIENTRXD_OUT(14),
	Paths       => (0 => (PHYEMAC0RXCLK_dly'last_event, tpd_PHYEMAC0RXCLK_EMAC0CLIENTRXD(14),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(15),
	GlitchData    => EMAC0CLIENTRXD15_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(15)",
	OutTemp       => EMAC0CLIENTRXD_OUT(15),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXD(15),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(15),
	GlitchData    => EMAC0CLIENTRXD15_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(15)",
	OutTemp       => EMAC0CLIENTRXD_OUT(15),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXD(15),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXD(15),
	GlitchData    => EMAC0CLIENTRXD15_GlitchData,
	OutSignalName => "EMAC0CLIENTRXD(15)",
	OutTemp       => EMAC0CLIENTRXD_OUT(15),
	Paths       => (0 => (PHYEMAC0RXCLK_dly'last_event, tpd_PHYEMAC0RXCLK_EMAC0CLIENTRXD(15),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXDVLD,
	GlitchData    => EMAC0CLIENTRXDVLD_GlitchData,
	OutSignalName => "EMAC0CLIENTRXDVLD",
	OutTemp       => EMAC0CLIENTRXDVLD_OUT,
	Paths         => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXDVLD,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXDVLD,
	GlitchData    => EMAC0CLIENTRXDVLD_GlitchData,
	OutSignalName => "EMAC0CLIENTRXDVLD",
	OutTemp       => EMAC0CLIENTRXDVLD_OUT,
	Paths         => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXDVLD,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXDVLD,
	GlitchData    => EMAC0CLIENTRXDVLD_GlitchData,
	OutSignalName => "EMAC0CLIENTRXDVLD",
	OutTemp       => EMAC0CLIENTRXDVLD_OUT,
	Paths         => (0 => (PHYEMAC0RXCLK_dly'last_event, tpd_PHYEMAC0RXCLK_EMAC0CLIENTRXDVLD,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXDVLDMSW,
	GlitchData    => EMAC0CLIENTRXDVLDMSW_GlitchData,
	OutSignalName => "EMAC0CLIENTRXDVLDMSW",
	OutTemp       => EMAC0CLIENTRXDVLDMSW_OUT,
	Paths         => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXDVLDMSW,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXDVLDMSW,
	GlitchData    => EMAC0CLIENTRXDVLDMSW_GlitchData,
	OutSignalName => "EMAC0CLIENTRXDVLDMSW",
	OutTemp       => EMAC0CLIENTRXDVLDMSW_OUT,
	Paths         => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXDVLDMSW,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXDVLDMSW,
	GlitchData    => EMAC0CLIENTRXDVLDMSW_GlitchData,
	OutSignalName => "EMAC0CLIENTRXDVLDMSW",
	OutTemp       => EMAC0CLIENTRXDVLDMSW_OUT,
	Paths         => (0 => (PHYEMAC0RXCLK_dly'last_event, tpd_PHYEMAC0RXCLK_EMAC0CLIENTRXDVLDMSW,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXFRAMEDROP,
	GlitchData    => EMAC0CLIENTRXFRAMEDROP_GlitchData,
	OutSignalName => "EMAC0CLIENTRXFRAMEDROP",
	OutTemp       => EMAC0CLIENTRXFRAMEDROP_OUT,
	Paths         => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXFRAMEDROP,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXFRAMEDROP,
	GlitchData    => EMAC0CLIENTRXFRAMEDROP_GlitchData,
	OutSignalName => "EMAC0CLIENTRXFRAMEDROP",
	OutTemp       => EMAC0CLIENTRXFRAMEDROP_OUT,
	Paths         => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXFRAMEDROP,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXFRAMEDROP,
	GlitchData    => EMAC0CLIENTRXFRAMEDROP_GlitchData,
	OutSignalName => "EMAC0CLIENTRXFRAMEDROP",
	OutTemp       => EMAC0CLIENTRXFRAMEDROP_OUT,
	Paths         => (0 => (PHYEMAC0RXCLK_dly'last_event, tpd_PHYEMAC0RXCLK_EMAC0CLIENTRXFRAMEDROP,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXGOODFRAME,
	GlitchData    => EMAC0CLIENTRXGOODFRAME_GlitchData,
	OutSignalName => "EMAC0CLIENTRXGOODFRAME",
	OutTemp       => EMAC0CLIENTRXGOODFRAME_OUT,
	Paths         => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXGOODFRAME,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXGOODFRAME,
	GlitchData    => EMAC0CLIENTRXGOODFRAME_GlitchData,
	OutSignalName => "EMAC0CLIENTRXGOODFRAME",
	OutTemp       => EMAC0CLIENTRXGOODFRAME_OUT,
	Paths         => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXGOODFRAME,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXGOODFRAME,
	GlitchData    => EMAC0CLIENTRXGOODFRAME_GlitchData,
	OutSignalName => "EMAC0CLIENTRXGOODFRAME",
	OutTemp       => EMAC0CLIENTRXGOODFRAME_OUT,
	Paths         => (0 => (PHYEMAC0RXCLK_dly'last_event, tpd_PHYEMAC0RXCLK_EMAC0CLIENTRXGOODFRAME,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXSTATS(0),
	GlitchData    => EMAC0CLIENTRXSTATS0_GlitchData,
	OutSignalName => "EMAC0CLIENTRXSTATS(0)",
	OutTemp       => EMAC0CLIENTRXSTATS_OUT(0),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXSTATS(0),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXSTATS(0),
	GlitchData    => EMAC0CLIENTRXSTATS0_GlitchData,
	OutSignalName => "EMAC0CLIENTRXSTATS(0)",
	OutTemp       => EMAC0CLIENTRXSTATS_OUT(0),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXSTATS(0),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXSTATS(0),
	GlitchData    => EMAC0CLIENTRXSTATS0_GlitchData,
	OutSignalName => "EMAC0CLIENTRXSTATS(0)",
	OutTemp       => EMAC0CLIENTRXSTATS_OUT(0),
	Paths       => (0 => (PHYEMAC0RXCLK_dly'last_event, tpd_PHYEMAC0RXCLK_EMAC0CLIENTRXSTATS(0),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXSTATS(1),
	GlitchData    => EMAC0CLIENTRXSTATS1_GlitchData,
	OutSignalName => "EMAC0CLIENTRXSTATS(1)",
	OutTemp       => EMAC0CLIENTRXSTATS_OUT(1),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXSTATS(1),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXSTATS(1),
	GlitchData    => EMAC0CLIENTRXSTATS1_GlitchData,
	OutSignalName => "EMAC0CLIENTRXSTATS(1)",
	OutTemp       => EMAC0CLIENTRXSTATS_OUT(1),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXSTATS(1),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXSTATS(1),
	GlitchData    => EMAC0CLIENTRXSTATS1_GlitchData,
	OutSignalName => "EMAC0CLIENTRXSTATS(1)",
	OutTemp       => EMAC0CLIENTRXSTATS_OUT(1),
	Paths       => (0 => (PHYEMAC0RXCLK_dly'last_event, tpd_PHYEMAC0RXCLK_EMAC0CLIENTRXSTATS(1),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXSTATS(2),
	GlitchData    => EMAC0CLIENTRXSTATS2_GlitchData,
	OutSignalName => "EMAC0CLIENTRXSTATS(2)",
	OutTemp       => EMAC0CLIENTRXSTATS_OUT(2),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXSTATS(2),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXSTATS(2),
	GlitchData    => EMAC0CLIENTRXSTATS2_GlitchData,
	OutSignalName => "EMAC0CLIENTRXSTATS(2)",
	OutTemp       => EMAC0CLIENTRXSTATS_OUT(2),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXSTATS(2),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXSTATS(2),
	GlitchData    => EMAC0CLIENTRXSTATS2_GlitchData,
	OutSignalName => "EMAC0CLIENTRXSTATS(2)",
	OutTemp       => EMAC0CLIENTRXSTATS_OUT(2),
	Paths       => (0 => (PHYEMAC0RXCLK_dly'last_event, tpd_PHYEMAC0RXCLK_EMAC0CLIENTRXSTATS(2),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXSTATS(3),
	GlitchData    => EMAC0CLIENTRXSTATS3_GlitchData,
	OutSignalName => "EMAC0CLIENTRXSTATS(3)",
	OutTemp       => EMAC0CLIENTRXSTATS_OUT(3),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXSTATS(3),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXSTATS(3),
	GlitchData    => EMAC0CLIENTRXSTATS3_GlitchData,
	OutSignalName => "EMAC0CLIENTRXSTATS(3)",
	OutTemp       => EMAC0CLIENTRXSTATS_OUT(3),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXSTATS(3),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXSTATS(3),
	GlitchData    => EMAC0CLIENTRXSTATS3_GlitchData,
	OutSignalName => "EMAC0CLIENTRXSTATS(3)",
	OutTemp       => EMAC0CLIENTRXSTATS_OUT(3),
	Paths       => (0 => (PHYEMAC0RXCLK_dly'last_event, tpd_PHYEMAC0RXCLK_EMAC0CLIENTRXSTATS(3),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXSTATS(4),
	GlitchData    => EMAC0CLIENTRXSTATS4_GlitchData,
	OutSignalName => "EMAC0CLIENTRXSTATS(4)",
	OutTemp       => EMAC0CLIENTRXSTATS_OUT(4),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXSTATS(4),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXSTATS(4),
	GlitchData    => EMAC0CLIENTRXSTATS4_GlitchData,
	OutSignalName => "EMAC0CLIENTRXSTATS(4)",
	OutTemp       => EMAC0CLIENTRXSTATS_OUT(4),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXSTATS(4),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXSTATS(4),
	GlitchData    => EMAC0CLIENTRXSTATS4_GlitchData,
	OutSignalName => "EMAC0CLIENTRXSTATS(4)",
	OutTemp       => EMAC0CLIENTRXSTATS_OUT(4),
	Paths       => (0 => (PHYEMAC0RXCLK_dly'last_event, tpd_PHYEMAC0RXCLK_EMAC0CLIENTRXSTATS(4),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXSTATS(5),
	GlitchData    => EMAC0CLIENTRXSTATS5_GlitchData,
	OutSignalName => "EMAC0CLIENTRXSTATS(5)",
	OutTemp       => EMAC0CLIENTRXSTATS_OUT(5),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXSTATS(5),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXSTATS(5),
	GlitchData    => EMAC0CLIENTRXSTATS5_GlitchData,
	OutSignalName => "EMAC0CLIENTRXSTATS(5)",
	OutTemp       => EMAC0CLIENTRXSTATS_OUT(5),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXSTATS(5),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXSTATS(5),
	GlitchData    => EMAC0CLIENTRXSTATS5_GlitchData,
	OutSignalName => "EMAC0CLIENTRXSTATS(5)",
	OutTemp       => EMAC0CLIENTRXSTATS_OUT(5),
	Paths       => (0 => (PHYEMAC0RXCLK_dly'last_event, tpd_PHYEMAC0RXCLK_EMAC0CLIENTRXSTATS(5),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXSTATS(6),
	GlitchData    => EMAC0CLIENTRXSTATS6_GlitchData,
	OutSignalName => "EMAC0CLIENTRXSTATS(6)",
	OutTemp       => EMAC0CLIENTRXSTATS_OUT(6),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXSTATS(6),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXSTATS(6),
	GlitchData    => EMAC0CLIENTRXSTATS6_GlitchData,
	OutSignalName => "EMAC0CLIENTRXSTATS(6)",
	OutTemp       => EMAC0CLIENTRXSTATS_OUT(6),
	Paths       => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXSTATS(6),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXSTATS(6),
	GlitchData    => EMAC0CLIENTRXSTATS6_GlitchData,
	OutSignalName => "EMAC0CLIENTRXSTATS(6)",
	OutTemp       => EMAC0CLIENTRXSTATS_OUT(6),
	Paths       => (0 => (PHYEMAC0RXCLK_dly'last_event, tpd_PHYEMAC0RXCLK_EMAC0CLIENTRXSTATS(6),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXSTATSBYTEVLD,
	GlitchData    => EMAC0CLIENTRXSTATSBYTEVLD_GlitchData,
	OutSignalName => "EMAC0CLIENTRXSTATSBYTEVLD",
	OutTemp       => EMAC0CLIENTRXSTATSBYTEVLD_OUT,
	Paths         => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXSTATSBYTEVLD,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXSTATSBYTEVLD,
	GlitchData    => EMAC0CLIENTRXSTATSBYTEVLD_GlitchData,
	OutSignalName => "EMAC0CLIENTRXSTATSBYTEVLD",
	OutTemp       => EMAC0CLIENTRXSTATSBYTEVLD_OUT,
	Paths         => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXSTATSBYTEVLD,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXSTATSBYTEVLD,
	GlitchData    => EMAC0CLIENTRXSTATSBYTEVLD_GlitchData,
	OutSignalName => "EMAC0CLIENTRXSTATSBYTEVLD",
	OutTemp       => EMAC0CLIENTRXSTATSBYTEVLD_OUT,
	Paths         => (0 => (PHYEMAC0RXCLK_dly'last_event, tpd_PHYEMAC0RXCLK_EMAC0CLIENTRXSTATSBYTEVLD,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXSTATSVLD,
	GlitchData    => EMAC0CLIENTRXSTATSVLD_GlitchData,
	OutSignalName => "EMAC0CLIENTRXSTATSVLD",
	OutTemp       => EMAC0CLIENTRXSTATSVLD_OUT,
	Paths         => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXSTATSVLD,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXSTATSVLD,
	GlitchData    => EMAC0CLIENTRXSTATSVLD_GlitchData,
	OutSignalName => "EMAC0CLIENTRXSTATSVLD",
	OutTemp       => EMAC0CLIENTRXSTATSVLD_OUT,
	Paths         => (0 => (CLIENTEMAC0RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0RXCLIENTCLKIN_EMAC0CLIENTRXSTATSVLD,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTRXSTATSVLD,
	GlitchData    => EMAC0CLIENTRXSTATSVLD_GlitchData,
	OutSignalName => "EMAC0CLIENTRXSTATSVLD",
	OutTemp       => EMAC0CLIENTRXSTATSVLD_OUT,
	Paths         => (0 => (PHYEMAC0RXCLK_dly'last_event, tpd_PHYEMAC0RXCLK_EMAC0CLIENTRXSTATSVLD,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTTXACK,
	GlitchData    => EMAC0CLIENTTXACK_GlitchData,
	OutSignalName => "EMAC0CLIENTTXACK",
	OutTemp       => EMAC0CLIENTTXACK_OUT,
	Paths         => (0 => (CLIENTEMAC0TXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0TXCLIENTCLKIN_EMAC0CLIENTTXACK,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTTXACK,
	GlitchData    => EMAC0CLIENTTXACK_GlitchData,
	OutSignalName => "EMAC0CLIENTTXACK",
	OutTemp       => EMAC0CLIENTTXACK_OUT,
	Paths         => (0 => (CLIENTEMAC0TXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0TXCLIENTCLKIN_EMAC0CLIENTTXACK,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTTXACK,
	GlitchData    => EMAC0CLIENTTXACK_GlitchData,
	OutSignalName => "EMAC0CLIENTTXACK",
	OutTemp       => EMAC0CLIENTTXACK_OUT,
	Paths         => (0 => (PHYEMAC0TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0CLIENTTXACK,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTTXCLIENTCLKOUT,
	GlitchData    => EMAC0CLIENTTXCLIENTCLKOUT_GlitchData,
	OutSignalName => "EMAC0CLIENTTXCLIENTCLKOUT",
	OutTemp       => EMAC0CLIENTTXCLIENTCLKOUT_OUT,
	Paths         => (0 => (PHYEMAC0TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0CLIENTTXCLIENTCLKOUT,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTTXCLIENTCLKOUT,
	GlitchData    => EMAC0CLIENTTXCLIENTCLKOUT_GlitchData,
	OutSignalName => "EMAC0CLIENTTXCLIENTCLKOUT",
	OutTemp       => EMAC0CLIENTTXCLIENTCLKOUT_OUT,
	Paths         => (0 => (PHYEMAC0MIITXCLK_dly'last_event, tpd_PHYEMAC0MIITXCLK_EMAC0CLIENTTXCLIENTCLKOUT,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTTXCLIENTCLKOUT,
	GlitchData    => EMAC0CLIENTTXCLIENTCLKOUT_GlitchData,
	OutSignalName => "EMAC0CLIENTTXCLIENTCLKOUT",
	OutTemp       => EMAC0CLIENTTXCLIENTCLKOUT_OUT,
	Paths         => (0 => (PHYEMAC0GTXCLK_dly'last_event, tpd_PHYEMAC0GTXCLK_EMAC0CLIENTTXCLIENTCLKOUT,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTTXCOLLISION,
	GlitchData    => EMAC0CLIENTTXCOLLISION_GlitchData,
	OutSignalName => "EMAC0CLIENTTXCOLLISION",
	OutTemp       => EMAC0CLIENTTXCOLLISION_OUT,
	Paths         => (0 => (CLIENTEMAC0TXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0TXCLIENTCLKIN_EMAC0CLIENTTXCOLLISION,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTTXCOLLISION,
	GlitchData    => EMAC0CLIENTTXCOLLISION_GlitchData,
	OutSignalName => "EMAC0CLIENTTXCOLLISION",
	OutTemp       => EMAC0CLIENTTXCOLLISION_OUT,
	Paths         => (0 => (CLIENTEMAC0TXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0TXCLIENTCLKIN_EMAC0CLIENTTXCOLLISION,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTTXCOLLISION,
	GlitchData    => EMAC0CLIENTTXCOLLISION_GlitchData,
	OutSignalName => "EMAC0CLIENTTXCOLLISION",
	OutTemp       => EMAC0CLIENTTXCOLLISION_OUT,
	Paths         => (0 => (PHYEMAC0TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0CLIENTTXCOLLISION,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXGMIIMIICLKOUT,
	GlitchData    => EMAC0PHYTXGMIIMIICLKOUT_GlitchData,
	OutSignalName => "EMAC0PHYTXGMIIMIICLKOUT",
	OutTemp       => EMAC0PHYTXGMIIMIICLKOUT_OUT,
	Paths         => (0 => (PHYEMAC0GTXCLK_dly'last_event, tpd_PHYEMAC0GTXCLK_EMAC0PHYTXGMIIMIICLKOUT,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXGMIIMIICLKOUT,
	GlitchData    => EMAC0PHYTXGMIIMIICLKOUT_GlitchData,
	OutSignalName => "EMAC0PHYTXGMIIMIICLKOUT",
	OutTemp       => EMAC0PHYTXGMIIMIICLKOUT_OUT,
	Paths         => (0 => (PHYEMAC0MIITXCLK_dly'last_event, tpd_PHYEMAC0MIITXCLK_EMAC0PHYTXGMIIMIICLKOUT,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTTXRETRANSMIT,
	GlitchData    => EMAC0CLIENTTXRETRANSMIT_GlitchData,
	OutSignalName => "EMAC0CLIENTTXRETRANSMIT",
	OutTemp       => EMAC0CLIENTTXRETRANSMIT_OUT,
	Paths         => (0 => (CLIENTEMAC0TXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0TXCLIENTCLKIN_EMAC0CLIENTTXRETRANSMIT,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTTXRETRANSMIT,
	GlitchData    => EMAC0CLIENTTXRETRANSMIT_GlitchData,
	OutSignalName => "EMAC0CLIENTTXRETRANSMIT",
	OutTemp       => EMAC0CLIENTTXRETRANSMIT_OUT,
	Paths         => (0 => (CLIENTEMAC0TXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0TXCLIENTCLKIN_EMAC0CLIENTTXRETRANSMIT,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTTXRETRANSMIT,
	GlitchData    => EMAC0CLIENTTXRETRANSMIT_GlitchData,
	OutSignalName => "EMAC0CLIENTTXRETRANSMIT",
	OutTemp       => EMAC0CLIENTTXRETRANSMIT_OUT,
	Paths         => (0 => (PHYEMAC0TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0CLIENTTXRETRANSMIT,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTTXSTATS,
	GlitchData    => EMAC0CLIENTTXSTATS_GlitchData,
	OutSignalName => "EMAC0CLIENTTXSTATS",
	OutTemp       => EMAC0CLIENTTXSTATS_OUT,
	Paths         => (0 => (CLIENTEMAC0TXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0TXCLIENTCLKIN_EMAC0CLIENTTXSTATS,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTTXSTATS,
	GlitchData    => EMAC0CLIENTTXSTATS_GlitchData,
	OutSignalName => "EMAC0CLIENTTXSTATS",
	OutTemp       => EMAC0CLIENTTXSTATS_OUT,
	Paths         => (0 => (CLIENTEMAC0TXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0TXCLIENTCLKIN_EMAC0CLIENTTXSTATS,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTTXSTATS,
	GlitchData    => EMAC0CLIENTTXSTATS_GlitchData,
	OutSignalName => "EMAC0CLIENTTXSTATS",
	OutTemp       => EMAC0CLIENTTXSTATS_OUT,
	Paths         => (0 => (PHYEMAC0TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0CLIENTTXSTATS,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTTXSTATSBYTEVLD,
	GlitchData    => EMAC0CLIENTTXSTATSBYTEVLD_GlitchData,
	OutSignalName => "EMAC0CLIENTTXSTATSBYTEVLD",
	OutTemp       => EMAC0CLIENTTXSTATSBYTEVLD_OUT,
	Paths         => (0 => (CLIENTEMAC0TXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0TXCLIENTCLKIN_EMAC0CLIENTTXSTATSBYTEVLD,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTTXSTATSBYTEVLD,
	GlitchData    => EMAC0CLIENTTXSTATSBYTEVLD_GlitchData,
	OutSignalName => "EMAC0CLIENTTXSTATSBYTEVLD",
	OutTemp       => EMAC0CLIENTTXSTATSBYTEVLD_OUT,
	Paths         => (0 => (CLIENTEMAC0TXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0TXCLIENTCLKIN_EMAC0CLIENTTXSTATSBYTEVLD,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTTXSTATSBYTEVLD,
	GlitchData    => EMAC0CLIENTTXSTATSBYTEVLD_GlitchData,
	OutSignalName => "EMAC0CLIENTTXSTATSBYTEVLD",
	OutTemp       => EMAC0CLIENTTXSTATSBYTEVLD_OUT,
	Paths         => (0 => (PHYEMAC0TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0CLIENTTXSTATSBYTEVLD,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTTXSTATSVLD,
	GlitchData    => EMAC0CLIENTTXSTATSVLD_GlitchData,
	OutSignalName => "EMAC0CLIENTTXSTATSVLD",
	OutTemp       => EMAC0CLIENTTXSTATSVLD_OUT,
	Paths         => (0 => (CLIENTEMAC0TXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0TXCLIENTCLKIN_EMAC0CLIENTTXSTATSVLD,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTTXSTATSVLD,
	GlitchData    => EMAC0CLIENTTXSTATSVLD_GlitchData,
	OutSignalName => "EMAC0CLIENTTXSTATSVLD",
	OutTemp       => EMAC0CLIENTTXSTATSVLD_OUT,
	Paths         => (0 => (CLIENTEMAC0TXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC0TXCLIENTCLKIN_EMAC0CLIENTTXSTATSVLD,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0CLIENTTXSTATSVLD,
	GlitchData    => EMAC0CLIENTTXSTATSVLD_GlitchData,
	OutSignalName => "EMAC0CLIENTTXSTATSVLD",
	OutTemp       => EMAC0CLIENTTXSTATSVLD_OUT,
	Paths         => (0 => (PHYEMAC0TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0CLIENTTXSTATSVLD,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYENCOMMAALIGN,
	GlitchData    => EMAC0PHYENCOMMAALIGN_GlitchData,
	OutSignalName => "EMAC0PHYENCOMMAALIGN",
	OutTemp       => EMAC0PHYENCOMMAALIGN_OUT,
	Paths         => (0 => (PHYEMAC0GTXCLK_dly'last_event, tpd_PHYEMAC0GTXCLK_EMAC0PHYENCOMMAALIGN,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYLOOPBACKMSB,
	GlitchData    => EMAC0PHYLOOPBACKMSB_GlitchData,
	OutSignalName => "EMAC0PHYLOOPBACKMSB",
	OutTemp       => EMAC0PHYLOOPBACKMSB_OUT,
	Paths         => (0 => (PHYEMAC0GTXCLK_dly'last_event, tpd_PHYEMAC0GTXCLK_EMAC0PHYLOOPBACKMSB,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYMCLKOUT,
	GlitchData    => EMAC0PHYMCLKOUT_GlitchData,
	OutSignalName => "EMAC0PHYMCLKOUT",
	OutTemp       => EMAC0PHYMCLKOUT_OUT,
	Paths         => (0 => (HOSTCLK_dly'last_event, tpd_HOSTCLK_EMAC0PHYMCLKOUT,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYMCLKOUT,
	GlitchData    => EMAC0PHYMCLKOUT_GlitchData,
	OutSignalName => "EMAC0PHYMCLKOUT",
	OutTemp       => EMAC0PHYMCLKOUT_OUT,
	Paths         => (0 => (PHYEMAC0MCLKIN_dly'last_event, tpd_PHYEMAC0MCLKIN_EMAC0PHYMCLKOUT,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYMDOUT,
	GlitchData    => EMAC0PHYMDOUT_GlitchData,
	OutSignalName => "EMAC0PHYMDOUT",
	OutTemp       => EMAC0PHYMDOUT_OUT,
	Paths         => (0 => (HOSTCLK_dly'last_event, tpd_HOSTCLK_EMAC0PHYMDOUT,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYMDOUT,
	GlitchData    => EMAC0PHYMDOUT_GlitchData,
	OutSignalName => "EMAC0PHYMDOUT",
	OutTemp       => EMAC0PHYMDOUT_OUT,
	Paths         => (0 => (PHYEMAC0MCLKIN_dly'last_event, tpd_PHYEMAC0MCLKIN_EMAC0PHYMDOUT,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYMDTRI,
	GlitchData    => EMAC0PHYMDTRI_GlitchData,
	OutSignalName => "EMAC0PHYMDTRI",
	OutTemp       => EMAC0PHYMDTRI_OUT,
	Paths         => (0 => (HOSTCLK_dly'last_event, tpd_HOSTCLK_EMAC0PHYMDTRI,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYMDTRI,
	GlitchData    => EMAC0PHYMDTRI_GlitchData,
	OutSignalName => "EMAC0PHYMDTRI",
	OutTemp       => EMAC0PHYMDTRI_OUT,
	Paths         => (0 => (PHYEMAC0MCLKIN_dly'last_event, tpd_PHYEMAC0MCLKIN_EMAC0PHYMDTRI,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYMGTRXRESET,
	GlitchData    => EMAC0PHYMGTRXRESET_GlitchData,
	OutSignalName => "EMAC0PHYMGTRXRESET",
	OutTemp       => EMAC0PHYMGTRXRESET_OUT,
	Paths         => (0 => (PHYEMAC0GTXCLK_dly'last_event, tpd_PHYEMAC0GTXCLK_EMAC0PHYMGTRXRESET,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYMGTTXRESET,
	GlitchData    => EMAC0PHYMGTTXRESET_GlitchData,
	OutSignalName => "EMAC0PHYMGTTXRESET",
	OutTemp       => EMAC0PHYMGTTXRESET_OUT,
	Paths         => (0 => (PHYEMAC0GTXCLK_dly'last_event, tpd_PHYEMAC0GTXCLK_EMAC0PHYMGTTXRESET,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYPOWERDOWN,
	GlitchData    => EMAC0PHYPOWERDOWN_GlitchData,
	OutSignalName => "EMAC0PHYPOWERDOWN",
	OutTemp       => EMAC0PHYPOWERDOWN_OUT,
	Paths         => (0 => (PHYEMAC0GTXCLK_dly'last_event, tpd_PHYEMAC0GTXCLK_EMAC0PHYPOWERDOWN,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYSYNCACQSTATUS,
	GlitchData    => EMAC0PHYSYNCACQSTATUS_GlitchData,
	OutSignalName => "EMAC0PHYSYNCACQSTATUS",
	OutTemp       => EMAC0PHYSYNCACQSTATUS_OUT,
	Paths         => (0 => (PHYEMAC0GTXCLK_dly'last_event, tpd_PHYEMAC0GTXCLK_EMAC0PHYSYNCACQSTATUS,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYSYNCACQSTATUS,
	GlitchData    => EMAC0PHYSYNCACQSTATUS_GlitchData,
	OutSignalName => "EMAC0PHYSYNCACQSTATUS",
	OutTemp       => EMAC0PHYSYNCACQSTATUS_OUT,
	Paths         => (0 => (PHYEMAC0TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYSYNCACQSTATUS,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYSYNCACQSTATUS,
	GlitchData    => EMAC0PHYSYNCACQSTATUS_GlitchData,
	OutSignalName => "EMAC0PHYSYNCACQSTATUS",
	OutTemp       => EMAC0PHYSYNCACQSTATUS_OUT,
	Paths         => (0 => (PHYEMAC0TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYSYNCACQSTATUS,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXCHARDISPMODE,
	GlitchData    => EMAC0PHYTXCHARDISPMODE_GlitchData,
	OutSignalName => "EMAC0PHYTXCHARDISPMODE",
	OutTemp       => EMAC0PHYTXCHARDISPMODE_OUT,
	Paths         => (0 => (PHYEMAC0GTXCLK_dly'last_event, tpd_PHYEMAC0GTXCLK_EMAC0PHYTXCHARDISPMODE,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXCHARDISPMODE,
	GlitchData    => EMAC0PHYTXCHARDISPMODE_GlitchData,
	OutSignalName => "EMAC0PHYTXCHARDISPMODE",
	OutTemp       => EMAC0PHYTXCHARDISPMODE_OUT,
	Paths         => (0 => (PHYEMAC0TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYTXCHARDISPMODE,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXCHARDISPMODE,
	GlitchData    => EMAC0PHYTXCHARDISPMODE_GlitchData,
	OutSignalName => "EMAC0PHYTXCHARDISPMODE",
	OutTemp       => EMAC0PHYTXCHARDISPMODE_OUT,
	Paths         => (0 => (PHYEMAC0TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYTXCHARDISPMODE,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXCHARDISPVAL,
	GlitchData    => EMAC0PHYTXCHARDISPVAL_GlitchData,
	OutSignalName => "EMAC0PHYTXCHARDISPVAL",
	OutTemp       => EMAC0PHYTXCHARDISPVAL_OUT,
	Paths         => (0 => (PHYEMAC0GTXCLK_dly'last_event, tpd_PHYEMAC0GTXCLK_EMAC0PHYTXCHARDISPVAL,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXCHARDISPVAL,
	GlitchData    => EMAC0PHYTXCHARDISPVAL_GlitchData,
	OutSignalName => "EMAC0PHYTXCHARDISPVAL",
	OutTemp       => EMAC0PHYTXCHARDISPVAL_OUT,
	Paths         => (0 => (PHYEMAC0TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYTXCHARDISPVAL,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXCHARDISPVAL,
	GlitchData    => EMAC0PHYTXCHARDISPVAL_GlitchData,
	OutSignalName => "EMAC0PHYTXCHARDISPVAL",
	OutTemp       => EMAC0PHYTXCHARDISPVAL_OUT,
	Paths         => (0 => (PHYEMAC0TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYTXCHARDISPVAL,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXCHARISK,
	GlitchData    => EMAC0PHYTXCHARISK_GlitchData,
	OutSignalName => "EMAC0PHYTXCHARISK",
	OutTemp       => EMAC0PHYTXCHARISK_OUT,
	Paths         => (0 => (PHYEMAC0GTXCLK_dly'last_event, tpd_PHYEMAC0GTXCLK_EMAC0PHYTXCHARISK,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXCHARISK,
	GlitchData    => EMAC0PHYTXCHARISK_GlitchData,
	OutSignalName => "EMAC0PHYTXCHARISK",
	OutTemp       => EMAC0PHYTXCHARISK_OUT,
	Paths         => (0 => (PHYEMAC0TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYTXCHARISK,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXCHARISK,
	GlitchData    => EMAC0PHYTXCHARISK_GlitchData,
	OutSignalName => "EMAC0PHYTXCHARISK",
	OutTemp       => EMAC0PHYTXCHARISK_OUT,
	Paths         => (0 => (PHYEMAC0TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYTXCHARISK,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXCLK,
	GlitchData    => EMAC0PHYTXCLK_GlitchData,
	OutSignalName => "EMAC0PHYTXCLK",
	OutTemp       => EMAC0PHYTXCLK_OUT,
	Paths         => (0 => (PHYEMAC0GTXCLK_dly'last_event, tpd_PHYEMAC0GTXCLK_EMAC0PHYTXCLK,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXCLK,
	GlitchData    => EMAC0PHYTXCLK_GlitchData,
	OutSignalName => "EMAC0PHYTXCLK",
	OutTemp       => EMAC0PHYTXCLK_OUT,
	Paths         => (0 => (PHYEMAC0TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYTXCLK,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXCLK,
	GlitchData    => EMAC0PHYTXCLK_GlitchData,
	OutSignalName => "EMAC0PHYTXCLK",
	OutTemp       => EMAC0PHYTXCLK_OUT,
	Paths         => (0 => (PHYEMAC0TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYTXCLK,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXD(0),
	GlitchData    => EMAC0PHYTXD0_GlitchData,
	OutSignalName => "EMAC0PHYTXD(0)",
	OutTemp       => EMAC0PHYTXD_OUT(0),
	Paths       => (0 => (PHYEMAC0GTXCLK_dly'last_event, tpd_PHYEMAC0GTXCLK_EMAC0PHYTXD(0),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXD(0),
	GlitchData    => EMAC0PHYTXD0_GlitchData,
	OutSignalName => "EMAC0PHYTXD(0)",
	OutTemp       => EMAC0PHYTXD_OUT(0),
	Paths       => (0 => (PHYEMAC0TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYTXD(0),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXD(0),
	GlitchData    => EMAC0PHYTXD0_GlitchData,
	OutSignalName => "EMAC0PHYTXD(0)",
	OutTemp       => EMAC0PHYTXD_OUT(0),
	Paths       => (0 => (PHYEMAC0TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYTXD(0),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXD(1),
	GlitchData    => EMAC0PHYTXD1_GlitchData,
	OutSignalName => "EMAC0PHYTXD(1)",
	OutTemp       => EMAC0PHYTXD_OUT(1),
	Paths       => (0 => (PHYEMAC0GTXCLK_dly'last_event, tpd_PHYEMAC0GTXCLK_EMAC0PHYTXD(1),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXD(1),
	GlitchData    => EMAC0PHYTXD1_GlitchData,
	OutSignalName => "EMAC0PHYTXD(1)",
	OutTemp       => EMAC0PHYTXD_OUT(1),
	Paths       => (0 => (PHYEMAC0TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYTXD(1),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXD(1),
	GlitchData    => EMAC0PHYTXD1_GlitchData,
	OutSignalName => "EMAC0PHYTXD(1)",
	OutTemp       => EMAC0PHYTXD_OUT(1),
	Paths       => (0 => (PHYEMAC0TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYTXD(1),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXD(2),
	GlitchData    => EMAC0PHYTXD2_GlitchData,
	OutSignalName => "EMAC0PHYTXD(2)",
	OutTemp       => EMAC0PHYTXD_OUT(2),
	Paths       => (0 => (PHYEMAC0GTXCLK_dly'last_event, tpd_PHYEMAC0GTXCLK_EMAC0PHYTXD(2),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXD(2),
	GlitchData    => EMAC0PHYTXD2_GlitchData,
	OutSignalName => "EMAC0PHYTXD(2)",
	OutTemp       => EMAC0PHYTXD_OUT(2),
	Paths       => (0 => (PHYEMAC0TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYTXD(2),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXD(2),
	GlitchData    => EMAC0PHYTXD2_GlitchData,
	OutSignalName => "EMAC0PHYTXD(2)",
	OutTemp       => EMAC0PHYTXD_OUT(2),
	Paths       => (0 => (PHYEMAC0TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYTXD(2),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXD(3),
	GlitchData    => EMAC0PHYTXD3_GlitchData,
	OutSignalName => "EMAC0PHYTXD(3)",
	OutTemp       => EMAC0PHYTXD_OUT(3),
	Paths       => (0 => (PHYEMAC0GTXCLK_dly'last_event, tpd_PHYEMAC0GTXCLK_EMAC0PHYTXD(3),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXD(3),
	GlitchData    => EMAC0PHYTXD3_GlitchData,
	OutSignalName => "EMAC0PHYTXD(3)",
	OutTemp       => EMAC0PHYTXD_OUT(3),
	Paths       => (0 => (PHYEMAC0TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYTXD(3),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXD(3),
	GlitchData    => EMAC0PHYTXD3_GlitchData,
	OutSignalName => "EMAC0PHYTXD(3)",
	OutTemp       => EMAC0PHYTXD_OUT(3),
	Paths       => (0 => (PHYEMAC0TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYTXD(3),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXD(4),
	GlitchData    => EMAC0PHYTXD4_GlitchData,
	OutSignalName => "EMAC0PHYTXD(4)",
	OutTemp       => EMAC0PHYTXD_OUT(4),
	Paths       => (0 => (PHYEMAC0GTXCLK_dly'last_event, tpd_PHYEMAC0GTXCLK_EMAC0PHYTXD(4),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXD(4),
	GlitchData    => EMAC0PHYTXD4_GlitchData,
	OutSignalName => "EMAC0PHYTXD(4)",
	OutTemp       => EMAC0PHYTXD_OUT(4),
	Paths       => (0 => (PHYEMAC0TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYTXD(4),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXD(4),
	GlitchData    => EMAC0PHYTXD4_GlitchData,
	OutSignalName => "EMAC0PHYTXD(4)",
	OutTemp       => EMAC0PHYTXD_OUT(4),
	Paths       => (0 => (PHYEMAC0TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYTXD(4),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXD(4),
	GlitchData    => EMAC0PHYTXD4_GlitchData,
	OutSignalName => "EMAC0PHYTXD(4)",
	OutTemp       => EMAC0PHYTXD_OUT(4),
	Paths       => (0 => (PHYEMAC0TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYTXD(4),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXD(5),
	GlitchData    => EMAC0PHYTXD5_GlitchData,
	OutSignalName => "EMAC0PHYTXD(5)",
	OutTemp       => EMAC0PHYTXD_OUT(5),
	Paths       => (0 => (PHYEMAC0GTXCLK_dly'last_event, tpd_PHYEMAC0GTXCLK_EMAC0PHYTXD(5),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXD(5),
	GlitchData    => EMAC0PHYTXD5_GlitchData,
	OutSignalName => "EMAC0PHYTXD(5)",
	OutTemp       => EMAC0PHYTXD_OUT(5),
	Paths       => (0 => (PHYEMAC0TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYTXD(5),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXD(5),
	GlitchData    => EMAC0PHYTXD5_GlitchData,
	OutSignalName => "EMAC0PHYTXD(5)",
	OutTemp       => EMAC0PHYTXD_OUT(5),
	Paths       => (0 => (PHYEMAC0TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYTXD(5),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXD(5),
	GlitchData    => EMAC0PHYTXD5_GlitchData,
	OutSignalName => "EMAC0PHYTXD(5)",
	OutTemp       => EMAC0PHYTXD_OUT(5),
	Paths       => (0 => (PHYEMAC0TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYTXD(5),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXD(6),
	GlitchData    => EMAC0PHYTXD6_GlitchData,
	OutSignalName => "EMAC0PHYTXD(6)",
	OutTemp       => EMAC0PHYTXD_OUT(6),
	Paths       => (0 => (PHYEMAC0GTXCLK_dly'last_event, tpd_PHYEMAC0GTXCLK_EMAC0PHYTXD(6),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXD(6),
	GlitchData    => EMAC0PHYTXD6_GlitchData,
	OutSignalName => "EMAC0PHYTXD(6)",
	OutTemp       => EMAC0PHYTXD_OUT(6),
	Paths       => (0 => (PHYEMAC0TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYTXD(6),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXD(6),
	GlitchData    => EMAC0PHYTXD6_GlitchData,
	OutSignalName => "EMAC0PHYTXD(6)",
	OutTemp       => EMAC0PHYTXD_OUT(6),
	Paths       => (0 => (PHYEMAC0TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYTXD(6),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXD(6),
	GlitchData    => EMAC0PHYTXD6_GlitchData,
	OutSignalName => "EMAC0PHYTXD(6)",
	OutTemp       => EMAC0PHYTXD_OUT(6),
	Paths       => (0 => (PHYEMAC0TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYTXD(6),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXD(7),
	GlitchData    => EMAC0PHYTXD7_GlitchData,
	OutSignalName => "EMAC0PHYTXD(7)",
	OutTemp       => EMAC0PHYTXD_OUT(7),
	Paths       => (0 => (PHYEMAC0GTXCLK_dly'last_event, tpd_PHYEMAC0GTXCLK_EMAC0PHYTXD(7),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXD(7),
	GlitchData    => EMAC0PHYTXD7_GlitchData,
	OutSignalName => "EMAC0PHYTXD(7)",
	OutTemp       => EMAC0PHYTXD_OUT(7),
	Paths       => (0 => (PHYEMAC0TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYTXD(7),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXD(7),
	GlitchData    => EMAC0PHYTXD7_GlitchData,
	OutSignalName => "EMAC0PHYTXD(7)",
	OutTemp       => EMAC0PHYTXD_OUT(7),
	Paths       => (0 => (PHYEMAC0TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYTXD(7),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXD(7),
	GlitchData    => EMAC0PHYTXD7_GlitchData,
	OutSignalName => "EMAC0PHYTXD(7)",
	OutTemp       => EMAC0PHYTXD_OUT(7),
	Paths       => (0 => (PHYEMAC0TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYTXD(7),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXEN,
	GlitchData    => EMAC0PHYTXEN_GlitchData,
	OutSignalName => "EMAC0PHYTXEN",
	OutTemp       => EMAC0PHYTXEN_OUT,
	Paths         => (0 => (PHYEMAC0GTXCLK_dly'last_event, tpd_PHYEMAC0GTXCLK_EMAC0PHYTXEN,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXEN,
	GlitchData    => EMAC0PHYTXEN_GlitchData,
	OutSignalName => "EMAC0PHYTXEN",
	OutTemp       => EMAC0PHYTXEN_OUT,
	Paths         => (0 => (PHYEMAC0TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYTXEN,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXEN,
	GlitchData    => EMAC0PHYTXEN_GlitchData,
	OutSignalName => "EMAC0PHYTXEN",
	OutTemp       => EMAC0PHYTXEN_OUT,
	Paths         => (0 => (PHYEMAC0TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYTXEN,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXER,
	GlitchData    => EMAC0PHYTXER_GlitchData,
	OutSignalName => "EMAC0PHYTXER",
	OutTemp       => EMAC0PHYTXER_OUT,
	Paths         => (0 => (PHYEMAC0GTXCLK_dly'last_event, tpd_PHYEMAC0GTXCLK_EMAC0PHYTXER,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXER,
	GlitchData    => EMAC0PHYTXER_GlitchData,
	OutSignalName => "EMAC0PHYTXER",
	OutTemp       => EMAC0PHYTXER_OUT,
	Paths         => (0 => (PHYEMAC0TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYTXER,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXER,
	GlitchData    => EMAC0PHYTXER_GlitchData,
	OutSignalName => "EMAC0PHYTXER",
	OutTemp       => EMAC0PHYTXER_OUT,
	Paths         => (0 => (PHYEMAC0TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYTXER,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0PHYTXER,
	GlitchData    => EMAC0PHYTXER_GlitchData,
	OutSignalName => "EMAC0PHYTXER",
	OutTemp       => EMAC0PHYTXER_OUT,
	Paths         => (0 => (PHYEMAC0TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC0TXGMIIMIICLKIN_EMAC0PHYTXER,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC0SPEEDIS10100,
	GlitchData    => EMAC0SPEEDIS10100_GlitchData,
	OutSignalName => "EMAC0SPEEDIS10100",
	OutTemp       => EMAC0SPEEDIS10100_OUT,
	Paths         => (0 => (HOSTCLK_dly'last_event, tpd_HOSTCLK_EMAC0SPEEDIS10100,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTANINTERRUPT,
	GlitchData    => EMAC1CLIENTANINTERRUPT_GlitchData,
	OutSignalName => "EMAC1CLIENTANINTERRUPT",
	OutTemp       => EMAC1CLIENTANINTERRUPT_OUT,
	Paths         => (0 => (PHYEMAC1GTXCLK_dly'last_event, tpd_PHYEMAC1GTXCLK_EMAC1CLIENTANINTERRUPT,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXBADFRAME,
	GlitchData    => EMAC1CLIENTRXBADFRAME_GlitchData,
	OutSignalName => "EMAC1CLIENTRXBADFRAME",
	OutTemp       => EMAC1CLIENTRXBADFRAME_OUT,
	Paths         => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXBADFRAME,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXBADFRAME,
	GlitchData    => EMAC1CLIENTRXBADFRAME_GlitchData,
	OutSignalName => "EMAC1CLIENTRXBADFRAME",
	OutTemp       => EMAC1CLIENTRXBADFRAME_OUT,
	Paths         => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXBADFRAME,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXBADFRAME,
	GlitchData    => EMAC1CLIENTRXBADFRAME_GlitchData,
	OutSignalName => "EMAC1CLIENTRXBADFRAME",
	OutTemp       => EMAC1CLIENTRXBADFRAME_OUT,
	Paths         => (0 => (PHYEMAC1RXCLK_dly'last_event, tpd_PHYEMAC1RXCLK_EMAC1CLIENTRXBADFRAME,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXCLIENTCLKOUT,
	GlitchData    => EMAC1CLIENTRXCLIENTCLKOUT_GlitchData,
	OutSignalName => "EMAC1CLIENTRXCLIENTCLKOUT",
	OutTemp       => EMAC1CLIENTRXCLIENTCLKOUT_OUT,
	Paths         => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXCLIENTCLKOUT,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXCLIENTCLKOUT,
	GlitchData    => EMAC1CLIENTRXCLIENTCLKOUT_GlitchData,
	OutSignalName => "EMAC1CLIENTRXCLIENTCLKOUT",
	OutTemp       => EMAC1CLIENTRXCLIENTCLKOUT_OUT,
	Paths         => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXCLIENTCLKOUT,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXCLIENTCLKOUT,
	GlitchData    => EMAC1CLIENTRXCLIENTCLKOUT_GlitchData,
	OutSignalName => "EMAC1CLIENTRXCLIENTCLKOUT",
	OutTemp       => EMAC1CLIENTRXCLIENTCLKOUT_OUT,
	Paths         => (0 => (PHYEMAC1RXCLK_dly'last_event, tpd_PHYEMAC1RXCLK_EMAC1CLIENTRXCLIENTCLKOUT,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXCLIENTCLKOUT,
	GlitchData    => EMAC1CLIENTRXCLIENTCLKOUT_GlitchData,
	OutSignalName => "EMAC1CLIENTRXCLIENTCLKOUT",
	OutTemp       => EMAC1CLIENTRXCLIENTCLKOUT_OUT,
	Paths         => (0 => (PHYEMAC1GTXCLK_dly'last_event, tpd_PHYEMAC1GTXCLK_EMAC1CLIENTRXCLIENTCLKOUT,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(0),
	GlitchData    => EMAC1CLIENTRXD0_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(0)",
	OutTemp       => EMAC1CLIENTRXD_OUT(0),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXD(0),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(0),
	GlitchData    => EMAC1CLIENTRXD0_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(0)",
	OutTemp       => EMAC1CLIENTRXD_OUT(0),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXD(0),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(0),
	GlitchData    => EMAC1CLIENTRXD0_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(0)",
	OutTemp       => EMAC1CLIENTRXD_OUT(0),
	Paths       => (0 => (PHYEMAC1RXCLK_dly'last_event, tpd_PHYEMAC1RXCLK_EMAC1CLIENTRXD(0),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(1),
	GlitchData    => EMAC1CLIENTRXD1_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(1)",
	OutTemp       => EMAC1CLIENTRXD_OUT(1),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXD(1),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(1),
	GlitchData    => EMAC1CLIENTRXD1_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(1)",
	OutTemp       => EMAC1CLIENTRXD_OUT(1),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXD(1),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(1),
	GlitchData    => EMAC1CLIENTRXD1_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(1)",
	OutTemp       => EMAC1CLIENTRXD_OUT(1),
	Paths       => (0 => (PHYEMAC1RXCLK_dly'last_event, tpd_PHYEMAC1RXCLK_EMAC1CLIENTRXD(1),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(2),
	GlitchData    => EMAC1CLIENTRXD2_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(2)",
	OutTemp       => EMAC1CLIENTRXD_OUT(2),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXD(2),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(2),
	GlitchData    => EMAC1CLIENTRXD2_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(2)",
	OutTemp       => EMAC1CLIENTRXD_OUT(2),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXD(2),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(2),
	GlitchData    => EMAC1CLIENTRXD2_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(2)",
	OutTemp       => EMAC1CLIENTRXD_OUT(2),
	Paths       => (0 => (PHYEMAC1RXCLK_dly'last_event, tpd_PHYEMAC1RXCLK_EMAC1CLIENTRXD(2),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(3),
	GlitchData    => EMAC1CLIENTRXD3_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(3)",
	OutTemp       => EMAC1CLIENTRXD_OUT(3),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXD(3),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(3),
	GlitchData    => EMAC1CLIENTRXD3_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(3)",
	OutTemp       => EMAC1CLIENTRXD_OUT(3),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXD(3),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(3),
	GlitchData    => EMAC1CLIENTRXD3_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(3)",
	OutTemp       => EMAC1CLIENTRXD_OUT(3),
	Paths       => (0 => (PHYEMAC1RXCLK_dly'last_event, tpd_PHYEMAC1RXCLK_EMAC1CLIENTRXD(3),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(4),
	GlitchData    => EMAC1CLIENTRXD4_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(4)",
	OutTemp       => EMAC1CLIENTRXD_OUT(4),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXD(4),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(4),
	GlitchData    => EMAC1CLIENTRXD4_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(4)",
	OutTemp       => EMAC1CLIENTRXD_OUT(4),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXD(4),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(4),
	GlitchData    => EMAC1CLIENTRXD4_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(4)",
	OutTemp       => EMAC1CLIENTRXD_OUT(4),
	Paths       => (0 => (PHYEMAC1RXCLK_dly'last_event, tpd_PHYEMAC1RXCLK_EMAC1CLIENTRXD(4),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(5),
	GlitchData    => EMAC1CLIENTRXD5_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(5)",
	OutTemp       => EMAC1CLIENTRXD_OUT(5),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXD(5),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(5),
	GlitchData    => EMAC1CLIENTRXD5_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(5)",
	OutTemp       => EMAC1CLIENTRXD_OUT(5),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXD(5),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(5),
	GlitchData    => EMAC1CLIENTRXD5_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(5)",
	OutTemp       => EMAC1CLIENTRXD_OUT(5),
	Paths       => (0 => (PHYEMAC1RXCLK_dly'last_event, tpd_PHYEMAC1RXCLK_EMAC1CLIENTRXD(5),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(6),
	GlitchData    => EMAC1CLIENTRXD6_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(6)",
	OutTemp       => EMAC1CLIENTRXD_OUT(6),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXD(6),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(6),
	GlitchData    => EMAC1CLIENTRXD6_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(6)",
	OutTemp       => EMAC1CLIENTRXD_OUT(6),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXD(6),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(6),
	GlitchData    => EMAC1CLIENTRXD6_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(6)",
	OutTemp       => EMAC1CLIENTRXD_OUT(6),
	Paths       => (0 => (PHYEMAC1RXCLK_dly'last_event, tpd_PHYEMAC1RXCLK_EMAC1CLIENTRXD(6),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(7),
	GlitchData    => EMAC1CLIENTRXD7_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(7)",
	OutTemp       => EMAC1CLIENTRXD_OUT(7),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXD(7),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(7),
	GlitchData    => EMAC1CLIENTRXD7_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(7)",
	OutTemp       => EMAC1CLIENTRXD_OUT(7),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXD(7),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(7),
	GlitchData    => EMAC1CLIENTRXD7_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(7)",
	OutTemp       => EMAC1CLIENTRXD_OUT(7),
	Paths       => (0 => (PHYEMAC1RXCLK_dly'last_event, tpd_PHYEMAC1RXCLK_EMAC1CLIENTRXD(7),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(8),
	GlitchData    => EMAC1CLIENTRXD8_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(8)",
	OutTemp       => EMAC1CLIENTRXD_OUT(8),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXD(8),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(8),
	GlitchData    => EMAC1CLIENTRXD8_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(8)",
	OutTemp       => EMAC1CLIENTRXD_OUT(8),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXD(8),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(8),
	GlitchData    => EMAC1CLIENTRXD8_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(8)",
	OutTemp       => EMAC1CLIENTRXD_OUT(8),
	Paths       => (0 => (PHYEMAC1RXCLK_dly'last_event, tpd_PHYEMAC1RXCLK_EMAC1CLIENTRXD(8),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(9),
	GlitchData    => EMAC1CLIENTRXD9_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(9)",
	OutTemp       => EMAC1CLIENTRXD_OUT(9),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXD(9),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(9),
	GlitchData    => EMAC1CLIENTRXD9_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(9)",
	OutTemp       => EMAC1CLIENTRXD_OUT(9),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXD(9),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(9),
	GlitchData    => EMAC1CLIENTRXD9_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(9)",
	OutTemp       => EMAC1CLIENTRXD_OUT(9),
	Paths       => (0 => (PHYEMAC1RXCLK_dly'last_event, tpd_PHYEMAC1RXCLK_EMAC1CLIENTRXD(9),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(10),
	GlitchData    => EMAC1CLIENTRXD10_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(10)",
	OutTemp       => EMAC1CLIENTRXD_OUT(10),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXD(10),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(10),
	GlitchData    => EMAC1CLIENTRXD10_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(10)",
	OutTemp       => EMAC1CLIENTRXD_OUT(10),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXD(10),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(10),
	GlitchData    => EMAC1CLIENTRXD10_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(10)",
	OutTemp       => EMAC1CLIENTRXD_OUT(10),
	Paths       => (0 => (PHYEMAC1RXCLK_dly'last_event, tpd_PHYEMAC1RXCLK_EMAC1CLIENTRXD(10),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(11),
	GlitchData    => EMAC1CLIENTRXD11_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(11)",
	OutTemp       => EMAC1CLIENTRXD_OUT(11),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXD(11),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(11),
	GlitchData    => EMAC1CLIENTRXD11_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(11)",
	OutTemp       => EMAC1CLIENTRXD_OUT(11),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXD(11),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(11),
	GlitchData    => EMAC1CLIENTRXD11_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(11)",
	OutTemp       => EMAC1CLIENTRXD_OUT(11),
	Paths       => (0 => (PHYEMAC1RXCLK_dly'last_event, tpd_PHYEMAC1RXCLK_EMAC1CLIENTRXD(11),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(12),
	GlitchData    => EMAC1CLIENTRXD12_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(12)",
	OutTemp       => EMAC1CLIENTRXD_OUT(12),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXD(12),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(12),
	GlitchData    => EMAC1CLIENTRXD12_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(12)",
	OutTemp       => EMAC1CLIENTRXD_OUT(12),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXD(12),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(12),
	GlitchData    => EMAC1CLIENTRXD12_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(12)",
	OutTemp       => EMAC1CLIENTRXD_OUT(12),
	Paths       => (0 => (PHYEMAC1RXCLK_dly'last_event, tpd_PHYEMAC1RXCLK_EMAC1CLIENTRXD(12),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(13),
	GlitchData    => EMAC1CLIENTRXD13_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(13)",
	OutTemp       => EMAC1CLIENTRXD_OUT(13),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXD(13),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(13),
	GlitchData    => EMAC1CLIENTRXD13_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(13)",
	OutTemp       => EMAC1CLIENTRXD_OUT(13),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXD(13),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(13),
	GlitchData    => EMAC1CLIENTRXD13_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(13)",
	OutTemp       => EMAC1CLIENTRXD_OUT(13),
	Paths       => (0 => (PHYEMAC1RXCLK_dly'last_event, tpd_PHYEMAC1RXCLK_EMAC1CLIENTRXD(13),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(14),
	GlitchData    => EMAC1CLIENTRXD14_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(14)",
	OutTemp       => EMAC1CLIENTRXD_OUT(14),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXD(14),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(14),
	GlitchData    => EMAC1CLIENTRXD14_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(14)",
	OutTemp       => EMAC1CLIENTRXD_OUT(14),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXD(14),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(14),
	GlitchData    => EMAC1CLIENTRXD14_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(14)",
	OutTemp       => EMAC1CLIENTRXD_OUT(14),
	Paths       => (0 => (PHYEMAC1RXCLK_dly'last_event, tpd_PHYEMAC1RXCLK_EMAC1CLIENTRXD(14),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(15),
	GlitchData    => EMAC1CLIENTRXD15_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(15)",
	OutTemp       => EMAC1CLIENTRXD_OUT(15),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXD(15),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(15),
	GlitchData    => EMAC1CLIENTRXD15_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(15)",
	OutTemp       => EMAC1CLIENTRXD_OUT(15),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXD(15),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXD(15),
	GlitchData    => EMAC1CLIENTRXD15_GlitchData,
	OutSignalName => "EMAC1CLIENTRXD(15)",
	OutTemp       => EMAC1CLIENTRXD_OUT(15),
	Paths       => (0 => (PHYEMAC1RXCLK_dly'last_event, tpd_PHYEMAC1RXCLK_EMAC1CLIENTRXD(15),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXDVLD,
	GlitchData    => EMAC1CLIENTRXDVLD_GlitchData,
	OutSignalName => "EMAC1CLIENTRXDVLD",
	OutTemp       => EMAC1CLIENTRXDVLD_OUT,
	Paths         => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXDVLD,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXDVLD,
	GlitchData    => EMAC1CLIENTRXDVLD_GlitchData,
	OutSignalName => "EMAC1CLIENTRXDVLD",
	OutTemp       => EMAC1CLIENTRXDVLD_OUT,
	Paths         => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXDVLD,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXDVLD,
	GlitchData    => EMAC1CLIENTRXDVLD_GlitchData,
	OutSignalName => "EMAC1CLIENTRXDVLD",
	OutTemp       => EMAC1CLIENTRXDVLD_OUT,
	Paths         => (0 => (PHYEMAC1RXCLK_dly'last_event, tpd_PHYEMAC1RXCLK_EMAC1CLIENTRXDVLD,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXDVLDMSW,
	GlitchData    => EMAC1CLIENTRXDVLDMSW_GlitchData,
	OutSignalName => "EMAC1CLIENTRXDVLDMSW",
	OutTemp       => EMAC1CLIENTRXDVLDMSW_OUT,
	Paths         => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXDVLDMSW,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXDVLDMSW,
	GlitchData    => EMAC1CLIENTRXDVLDMSW_GlitchData,
	OutSignalName => "EMAC1CLIENTRXDVLDMSW",
	OutTemp       => EMAC1CLIENTRXDVLDMSW_OUT,
	Paths         => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXDVLDMSW,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXDVLDMSW,
	GlitchData    => EMAC1CLIENTRXDVLDMSW_GlitchData,
	OutSignalName => "EMAC1CLIENTRXDVLDMSW",
	OutTemp       => EMAC1CLIENTRXDVLDMSW_OUT,
	Paths         => (0 => (PHYEMAC1RXCLK_dly'last_event, tpd_PHYEMAC1RXCLK_EMAC1CLIENTRXDVLDMSW,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXFRAMEDROP,
	GlitchData    => EMAC1CLIENTRXFRAMEDROP_GlitchData,
	OutSignalName => "EMAC1CLIENTRXFRAMEDROP",
	OutTemp       => EMAC1CLIENTRXFRAMEDROP_OUT,
	Paths         => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXFRAMEDROP,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXFRAMEDROP,
	GlitchData    => EMAC1CLIENTRXFRAMEDROP_GlitchData,
	OutSignalName => "EMAC1CLIENTRXFRAMEDROP",
	OutTemp       => EMAC1CLIENTRXFRAMEDROP_OUT,
	Paths         => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXFRAMEDROP,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXFRAMEDROP,
	GlitchData    => EMAC1CLIENTRXFRAMEDROP_GlitchData,
	OutSignalName => "EMAC1CLIENTRXFRAMEDROP",
	OutTemp       => EMAC1CLIENTRXFRAMEDROP_OUT,
	Paths         => (0 => (PHYEMAC1RXCLK_dly'last_event, tpd_PHYEMAC1RXCLK_EMAC1CLIENTRXFRAMEDROP,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXGOODFRAME,
	GlitchData    => EMAC1CLIENTRXGOODFRAME_GlitchData,
	OutSignalName => "EMAC1CLIENTRXGOODFRAME",
	OutTemp       => EMAC1CLIENTRXGOODFRAME_OUT,
	Paths         => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXGOODFRAME,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXGOODFRAME,
	GlitchData    => EMAC1CLIENTRXGOODFRAME_GlitchData,
	OutSignalName => "EMAC1CLIENTRXGOODFRAME",
	OutTemp       => EMAC1CLIENTRXGOODFRAME_OUT,
	Paths         => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXGOODFRAME,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXGOODFRAME,
	GlitchData    => EMAC1CLIENTRXGOODFRAME_GlitchData,
	OutSignalName => "EMAC1CLIENTRXGOODFRAME",
	OutTemp       => EMAC1CLIENTRXGOODFRAME_OUT,
	Paths         => (0 => (PHYEMAC1RXCLK_dly'last_event, tpd_PHYEMAC1RXCLK_EMAC1CLIENTRXGOODFRAME,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXSTATS(0),
	GlitchData    => EMAC1CLIENTRXSTATS0_GlitchData,
	OutSignalName => "EMAC1CLIENTRXSTATS(0)",
	OutTemp       => EMAC1CLIENTRXSTATS_OUT(0),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXSTATS(0),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXSTATS(0),
	GlitchData    => EMAC1CLIENTRXSTATS0_GlitchData,
	OutSignalName => "EMAC1CLIENTRXSTATS(0)",
	OutTemp       => EMAC1CLIENTRXSTATS_OUT(0),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXSTATS(0),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXSTATS(0),
	GlitchData    => EMAC1CLIENTRXSTATS0_GlitchData,
	OutSignalName => "EMAC1CLIENTRXSTATS(0)",
	OutTemp       => EMAC1CLIENTRXSTATS_OUT(0),
	Paths       => (0 => (PHYEMAC1RXCLK_dly'last_event, tpd_PHYEMAC1RXCLK_EMAC1CLIENTRXSTATS(0),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXSTATS(1),
	GlitchData    => EMAC1CLIENTRXSTATS1_GlitchData,
	OutSignalName => "EMAC1CLIENTRXSTATS(1)",
	OutTemp       => EMAC1CLIENTRXSTATS_OUT(1),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXSTATS(1),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXSTATS(1),
	GlitchData    => EMAC1CLIENTRXSTATS1_GlitchData,
	OutSignalName => "EMAC1CLIENTRXSTATS(1)",
	OutTemp       => EMAC1CLIENTRXSTATS_OUT(1),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXSTATS(1),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXSTATS(1),
	GlitchData    => EMAC1CLIENTRXSTATS1_GlitchData,
	OutSignalName => "EMAC1CLIENTRXSTATS(1)",
	OutTemp       => EMAC1CLIENTRXSTATS_OUT(1),
	Paths       => (0 => (PHYEMAC1RXCLK_dly'last_event, tpd_PHYEMAC1RXCLK_EMAC1CLIENTRXSTATS(1),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXSTATS(2),
	GlitchData    => EMAC1CLIENTRXSTATS2_GlitchData,
	OutSignalName => "EMAC1CLIENTRXSTATS(2)",
	OutTemp       => EMAC1CLIENTRXSTATS_OUT(2),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXSTATS(2),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXSTATS(2),
	GlitchData    => EMAC1CLIENTRXSTATS2_GlitchData,
	OutSignalName => "EMAC1CLIENTRXSTATS(2)",
	OutTemp       => EMAC1CLIENTRXSTATS_OUT(2),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXSTATS(2),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXSTATS(2),
	GlitchData    => EMAC1CLIENTRXSTATS2_GlitchData,
	OutSignalName => "EMAC1CLIENTRXSTATS(2)",
	OutTemp       => EMAC1CLIENTRXSTATS_OUT(2),
	Paths       => (0 => (PHYEMAC1RXCLK_dly'last_event, tpd_PHYEMAC1RXCLK_EMAC1CLIENTRXSTATS(2),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXSTATS(3),
	GlitchData    => EMAC1CLIENTRXSTATS3_GlitchData,
	OutSignalName => "EMAC1CLIENTRXSTATS(3)",
	OutTemp       => EMAC1CLIENTRXSTATS_OUT(3),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXSTATS(3),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXSTATS(3),
	GlitchData    => EMAC1CLIENTRXSTATS3_GlitchData,
	OutSignalName => "EMAC1CLIENTRXSTATS(3)",
	OutTemp       => EMAC1CLIENTRXSTATS_OUT(3),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXSTATS(3),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXSTATS(3),
	GlitchData    => EMAC1CLIENTRXSTATS3_GlitchData,
	OutSignalName => "EMAC1CLIENTRXSTATS(3)",
	OutTemp       => EMAC1CLIENTRXSTATS_OUT(3),
	Paths       => (0 => (PHYEMAC1RXCLK_dly'last_event, tpd_PHYEMAC1RXCLK_EMAC1CLIENTRXSTATS(3),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXSTATS(4),
	GlitchData    => EMAC1CLIENTRXSTATS4_GlitchData,
	OutSignalName => "EMAC1CLIENTRXSTATS(4)",
	OutTemp       => EMAC1CLIENTRXSTATS_OUT(4),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXSTATS(4),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXSTATS(4),
	GlitchData    => EMAC1CLIENTRXSTATS4_GlitchData,
	OutSignalName => "EMAC1CLIENTRXSTATS(4)",
	OutTemp       => EMAC1CLIENTRXSTATS_OUT(4),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXSTATS(4),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXSTATS(4),
	GlitchData    => EMAC1CLIENTRXSTATS4_GlitchData,
	OutSignalName => "EMAC1CLIENTRXSTATS(4)",
	OutTemp       => EMAC1CLIENTRXSTATS_OUT(4),
	Paths       => (0 => (PHYEMAC1RXCLK_dly'last_event, tpd_PHYEMAC1RXCLK_EMAC1CLIENTRXSTATS(4),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXSTATS(5),
	GlitchData    => EMAC1CLIENTRXSTATS5_GlitchData,
	OutSignalName => "EMAC1CLIENTRXSTATS(5)",
	OutTemp       => EMAC1CLIENTRXSTATS_OUT(5),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXSTATS(5),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXSTATS(5),
	GlitchData    => EMAC1CLIENTRXSTATS5_GlitchData,
	OutSignalName => "EMAC1CLIENTRXSTATS(5)",
	OutTemp       => EMAC1CLIENTRXSTATS_OUT(5),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXSTATS(5),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXSTATS(5),
	GlitchData    => EMAC1CLIENTRXSTATS5_GlitchData,
	OutSignalName => "EMAC1CLIENTRXSTATS(5)",
	OutTemp       => EMAC1CLIENTRXSTATS_OUT(5),
	Paths       => (0 => (PHYEMAC1RXCLK_dly'last_event, tpd_PHYEMAC1RXCLK_EMAC1CLIENTRXSTATS(5),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXSTATS(6),
	GlitchData    => EMAC1CLIENTRXSTATS6_GlitchData,
	OutSignalName => "EMAC1CLIENTRXSTATS(6)",
	OutTemp       => EMAC1CLIENTRXSTATS_OUT(6),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXSTATS(6),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXSTATS(6),
	GlitchData    => EMAC1CLIENTRXSTATS6_GlitchData,
	OutSignalName => "EMAC1CLIENTRXSTATS(6)",
	OutTemp       => EMAC1CLIENTRXSTATS_OUT(6),
	Paths       => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXSTATS(6),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXSTATS(6),
	GlitchData    => EMAC1CLIENTRXSTATS6_GlitchData,
	OutSignalName => "EMAC1CLIENTRXSTATS(6)",
	OutTemp       => EMAC1CLIENTRXSTATS_OUT(6),
	Paths       => (0 => (PHYEMAC1RXCLK_dly'last_event, tpd_PHYEMAC1RXCLK_EMAC1CLIENTRXSTATS(6),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXSTATSBYTEVLD,
	GlitchData    => EMAC1CLIENTRXSTATSBYTEVLD_GlitchData,
	OutSignalName => "EMAC1CLIENTRXSTATSBYTEVLD",
	OutTemp       => EMAC1CLIENTRXSTATSBYTEVLD_OUT,
	Paths         => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXSTATSBYTEVLD,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXSTATSBYTEVLD,
	GlitchData    => EMAC1CLIENTRXSTATSBYTEVLD_GlitchData,
	OutSignalName => "EMAC1CLIENTRXSTATSBYTEVLD",
	OutTemp       => EMAC1CLIENTRXSTATSBYTEVLD_OUT,
	Paths         => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXSTATSBYTEVLD,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXSTATSBYTEVLD,
	GlitchData    => EMAC1CLIENTRXSTATSBYTEVLD_GlitchData,
	OutSignalName => "EMAC1CLIENTRXSTATSBYTEVLD",
	OutTemp       => EMAC1CLIENTRXSTATSBYTEVLD_OUT,
	Paths         => (0 => (PHYEMAC1RXCLK_dly'last_event, tpd_PHYEMAC1RXCLK_EMAC1CLIENTRXSTATSBYTEVLD,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXSTATSVLD,
	GlitchData    => EMAC1CLIENTRXSTATSVLD_GlitchData,
	OutSignalName => "EMAC1CLIENTRXSTATSVLD",
	OutTemp       => EMAC1CLIENTRXSTATSVLD_OUT,
	Paths         => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXSTATSVLD,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXSTATSVLD,
	GlitchData    => EMAC1CLIENTRXSTATSVLD_GlitchData,
	OutSignalName => "EMAC1CLIENTRXSTATSVLD",
	OutTemp       => EMAC1CLIENTRXSTATSVLD_OUT,
	Paths         => (0 => (CLIENTEMAC1RXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1RXCLIENTCLKIN_EMAC1CLIENTRXSTATSVLD,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTRXSTATSVLD,
	GlitchData    => EMAC1CLIENTRXSTATSVLD_GlitchData,
	OutSignalName => "EMAC1CLIENTRXSTATSVLD",
	OutTemp       => EMAC1CLIENTRXSTATSVLD_OUT,
	Paths         => (0 => (PHYEMAC1RXCLK_dly'last_event, tpd_PHYEMAC1RXCLK_EMAC1CLIENTRXSTATSVLD,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTTXACK,
	GlitchData    => EMAC1CLIENTTXACK_GlitchData,
	OutSignalName => "EMAC1CLIENTTXACK",
	OutTemp       => EMAC1CLIENTTXACK_OUT,
	Paths         => (0 => (CLIENTEMAC1TXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1TXCLIENTCLKIN_EMAC1CLIENTTXACK,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTTXACK,
	GlitchData    => EMAC1CLIENTTXACK_GlitchData,
	OutSignalName => "EMAC1CLIENTTXACK",
	OutTemp       => EMAC1CLIENTTXACK_OUT,
	Paths         => (0 => (CLIENTEMAC1TXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1TXCLIENTCLKIN_EMAC1CLIENTTXACK,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTTXACK,
	GlitchData    => EMAC1CLIENTTXACK_GlitchData,
	OutSignalName => "EMAC1CLIENTTXACK",
	OutTemp       => EMAC1CLIENTTXACK_OUT,
	Paths         => (0 => (PHYEMAC1TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1CLIENTTXACK,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTTXCLIENTCLKOUT,
	GlitchData    => EMAC1CLIENTTXCLIENTCLKOUT_GlitchData,
	OutSignalName => "EMAC1CLIENTTXCLIENTCLKOUT",
	OutTemp       => EMAC1CLIENTTXCLIENTCLKOUT_OUT,
	Paths         => (0 => (PHYEMAC1TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1CLIENTTXCLIENTCLKOUT,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTTXCLIENTCLKOUT,
	GlitchData    => EMAC1CLIENTTXCLIENTCLKOUT_GlitchData,
	OutSignalName => "EMAC1CLIENTTXCLIENTCLKOUT",
	OutTemp       => EMAC1CLIENTTXCLIENTCLKOUT_OUT,
	Paths         => (0 => (PHYEMAC1MIITXCLK_dly'last_event, tpd_PHYEMAC1MIITXCLK_EMAC1CLIENTTXCLIENTCLKOUT,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTTXCLIENTCLKOUT,
	GlitchData    => EMAC1CLIENTTXCLIENTCLKOUT_GlitchData,
	OutSignalName => "EMAC1CLIENTTXCLIENTCLKOUT",
	OutTemp       => EMAC1CLIENTTXCLIENTCLKOUT_OUT,
	Paths         => (0 => (PHYEMAC1GTXCLK_dly'last_event, tpd_PHYEMAC1GTXCLK_EMAC1CLIENTTXCLIENTCLKOUT,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTTXCOLLISION,
	GlitchData    => EMAC1CLIENTTXCOLLISION_GlitchData,
	OutSignalName => "EMAC1CLIENTTXCOLLISION",
	OutTemp       => EMAC1CLIENTTXCOLLISION_OUT,
	Paths         => (0 => (CLIENTEMAC1TXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1TXCLIENTCLKIN_EMAC1CLIENTTXCOLLISION,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTTXCOLLISION,
	GlitchData    => EMAC1CLIENTTXCOLLISION_GlitchData,
	OutSignalName => "EMAC1CLIENTTXCOLLISION",
	OutTemp       => EMAC1CLIENTTXCOLLISION_OUT,
	Paths         => (0 => (CLIENTEMAC1TXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1TXCLIENTCLKIN_EMAC1CLIENTTXCOLLISION,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTTXCOLLISION,
	GlitchData    => EMAC1CLIENTTXCOLLISION_GlitchData,
	OutSignalName => "EMAC1CLIENTTXCOLLISION",
	OutTemp       => EMAC1CLIENTTXCOLLISION_OUT,
	Paths         => (0 => (PHYEMAC1TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1CLIENTTXCOLLISION,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXGMIIMIICLKOUT,
	GlitchData    => EMAC1PHYTXGMIIMIICLKOUT_GlitchData,
	OutSignalName => "EMAC1PHYTXGMIIMIICLKOUT",
	OutTemp       => EMAC1PHYTXGMIIMIICLKOUT_OUT,
	Paths         => (0 => (PHYEMAC1GTXCLK_dly'last_event, tpd_PHYEMAC1GTXCLK_EMAC1PHYTXGMIIMIICLKOUT,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXGMIIMIICLKOUT,
	GlitchData    => EMAC1PHYTXGMIIMIICLKOUT_GlitchData,
	OutSignalName => "EMAC1PHYTXGMIIMIICLKOUT",
	OutTemp       => EMAC1PHYTXGMIIMIICLKOUT_OUT,
	Paths         => (0 => (PHYEMAC1MIITXCLK_dly'last_event, tpd_PHYEMAC1MIITXCLK_EMAC1PHYTXGMIIMIICLKOUT,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTTXRETRANSMIT,
	GlitchData    => EMAC1CLIENTTXRETRANSMIT_GlitchData,
	OutSignalName => "EMAC1CLIENTTXRETRANSMIT",
	OutTemp       => EMAC1CLIENTTXRETRANSMIT_OUT,
	Paths         => (0 => (CLIENTEMAC1TXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1TXCLIENTCLKIN_EMAC1CLIENTTXRETRANSMIT,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTTXRETRANSMIT,
	GlitchData    => EMAC1CLIENTTXRETRANSMIT_GlitchData,
	OutSignalName => "EMAC1CLIENTTXRETRANSMIT",
	OutTemp       => EMAC1CLIENTTXRETRANSMIT_OUT,
	Paths         => (0 => (CLIENTEMAC1TXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1TXCLIENTCLKIN_EMAC1CLIENTTXRETRANSMIT,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTTXRETRANSMIT,
	GlitchData    => EMAC1CLIENTTXRETRANSMIT_GlitchData,
	OutSignalName => "EMAC1CLIENTTXRETRANSMIT",
	OutTemp       => EMAC1CLIENTTXRETRANSMIT_OUT,
	Paths         => (0 => (PHYEMAC1TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1CLIENTTXRETRANSMIT,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTTXSTATS,
	GlitchData    => EMAC1CLIENTTXSTATS_GlitchData,
	OutSignalName => "EMAC1CLIENTTXSTATS",
	OutTemp       => EMAC1CLIENTTXSTATS_OUT,
	Paths         => (0 => (CLIENTEMAC1TXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1TXCLIENTCLKIN_EMAC1CLIENTTXSTATS,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTTXSTATS,
	GlitchData    => EMAC1CLIENTTXSTATS_GlitchData,
	OutSignalName => "EMAC1CLIENTTXSTATS",
	OutTemp       => EMAC1CLIENTTXSTATS_OUT,
	Paths         => (0 => (CLIENTEMAC1TXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1TXCLIENTCLKIN_EMAC1CLIENTTXSTATS,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTTXSTATS,
	GlitchData    => EMAC1CLIENTTXSTATS_GlitchData,
	OutSignalName => "EMAC1CLIENTTXSTATS",
	OutTemp       => EMAC1CLIENTTXSTATS_OUT,
	Paths         => (0 => (PHYEMAC1TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1CLIENTTXSTATS,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTTXSTATSBYTEVLD,
	GlitchData    => EMAC1CLIENTTXSTATSBYTEVLD_GlitchData,
	OutSignalName => "EMAC1CLIENTTXSTATSBYTEVLD",
	OutTemp       => EMAC1CLIENTTXSTATSBYTEVLD_OUT,
	Paths         => (0 => (CLIENTEMAC1TXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1TXCLIENTCLKIN_EMAC1CLIENTTXSTATSBYTEVLD,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTTXSTATSBYTEVLD,
	GlitchData    => EMAC1CLIENTTXSTATSBYTEVLD_GlitchData,
	OutSignalName => "EMAC1CLIENTTXSTATSBYTEVLD",
	OutTemp       => EMAC1CLIENTTXSTATSBYTEVLD_OUT,
	Paths         => (0 => (CLIENTEMAC1TXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1TXCLIENTCLKIN_EMAC1CLIENTTXSTATSBYTEVLD,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTTXSTATSBYTEVLD,
	GlitchData    => EMAC1CLIENTTXSTATSBYTEVLD_GlitchData,
	OutSignalName => "EMAC1CLIENTTXSTATSBYTEVLD",
	OutTemp       => EMAC1CLIENTTXSTATSBYTEVLD_OUT,
	Paths         => (0 => (PHYEMAC1TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1CLIENTTXSTATSBYTEVLD,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTTXSTATSVLD,
	GlitchData    => EMAC1CLIENTTXSTATSVLD_GlitchData,
	OutSignalName => "EMAC1CLIENTTXSTATSVLD",
	OutTemp       => EMAC1CLIENTTXSTATSVLD_OUT,
	Paths         => (0 => (CLIENTEMAC1TXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1TXCLIENTCLKIN_EMAC1CLIENTTXSTATSVLD,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTTXSTATSVLD,
	GlitchData    => EMAC1CLIENTTXSTATSVLD_GlitchData,
	OutSignalName => "EMAC1CLIENTTXSTATSVLD",
	OutTemp       => EMAC1CLIENTTXSTATSVLD_OUT,
	Paths         => (0 => (CLIENTEMAC1TXCLIENTCLKIN_dly'last_event, tpd_CLIENTEMAC1TXCLIENTCLKIN_EMAC1CLIENTTXSTATSVLD,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1CLIENTTXSTATSVLD,
	GlitchData    => EMAC1CLIENTTXSTATSVLD_GlitchData,
	OutSignalName => "EMAC1CLIENTTXSTATSVLD",
	OutTemp       => EMAC1CLIENTTXSTATSVLD_OUT,
	Paths         => (0 => (PHYEMAC1TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1CLIENTTXSTATSVLD,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYENCOMMAALIGN,
	GlitchData    => EMAC1PHYENCOMMAALIGN_GlitchData,
	OutSignalName => "EMAC1PHYENCOMMAALIGN",
	OutTemp       => EMAC1PHYENCOMMAALIGN_OUT,
	Paths         => (0 => (PHYEMAC1GTXCLK_dly'last_event, tpd_PHYEMAC1GTXCLK_EMAC1PHYENCOMMAALIGN,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYLOOPBACKMSB,
	GlitchData    => EMAC1PHYLOOPBACKMSB_GlitchData,
	OutSignalName => "EMAC1PHYLOOPBACKMSB",
	OutTemp       => EMAC1PHYLOOPBACKMSB_OUT,
	Paths         => (0 => (PHYEMAC1GTXCLK_dly'last_event, tpd_PHYEMAC1GTXCLK_EMAC1PHYLOOPBACKMSB,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYMCLKOUT,
	GlitchData    => EMAC1PHYMCLKOUT_GlitchData,
	OutSignalName => "EMAC1PHYMCLKOUT",
	OutTemp       => EMAC1PHYMCLKOUT_OUT,
	Paths         => (0 => (HOSTCLK_dly'last_event, tpd_HOSTCLK_EMAC1PHYMCLKOUT,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYMCLKOUT,
	GlitchData    => EMAC1PHYMCLKOUT_GlitchData,
	OutSignalName => "EMAC1PHYMCLKOUT",
	OutTemp       => EMAC1PHYMCLKOUT_OUT,
	Paths         => (0 => (PHYEMAC1MCLKIN_dly'last_event, tpd_PHYEMAC1MCLKIN_EMAC1PHYMCLKOUT,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYMDOUT,
	GlitchData    => EMAC1PHYMDOUT_GlitchData,
	OutSignalName => "EMAC1PHYMDOUT",
	OutTemp       => EMAC1PHYMDOUT_OUT,
	Paths         => (0 => (HOSTCLK_dly'last_event, tpd_HOSTCLK_EMAC1PHYMDOUT,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYMDOUT,
	GlitchData    => EMAC1PHYMDOUT_GlitchData,
	OutSignalName => "EMAC1PHYMDOUT",
	OutTemp       => EMAC1PHYMDOUT_OUT,
	Paths         => (0 => (PHYEMAC1MCLKIN_dly'last_event, tpd_PHYEMAC1MCLKIN_EMAC1PHYMDOUT,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYMDTRI,
	GlitchData    => EMAC1PHYMDTRI_GlitchData,
	OutSignalName => "EMAC1PHYMDTRI",
	OutTemp       => EMAC1PHYMDTRI_OUT,
	Paths         => (0 => (HOSTCLK_dly'last_event, tpd_HOSTCLK_EMAC1PHYMDTRI,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYMDTRI,
	GlitchData    => EMAC1PHYMDTRI_GlitchData,
	OutSignalName => "EMAC1PHYMDTRI",
	OutTemp       => EMAC1PHYMDTRI_OUT,
	Paths         => (0 => (PHYEMAC1MCLKIN_dly'last_event, tpd_PHYEMAC1MCLKIN_EMAC1PHYMDTRI,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYMGTRXRESET,
	GlitchData    => EMAC1PHYMGTRXRESET_GlitchData,
	OutSignalName => "EMAC1PHYMGTRXRESET",
	OutTemp       => EMAC1PHYMGTRXRESET_OUT,
	Paths         => (0 => (PHYEMAC1GTXCLK_dly'last_event, tpd_PHYEMAC1GTXCLK_EMAC1PHYMGTRXRESET,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYMGTTXRESET,
	GlitchData    => EMAC1PHYMGTTXRESET_GlitchData,
	OutSignalName => "EMAC1PHYMGTTXRESET",
	OutTemp       => EMAC1PHYMGTTXRESET_OUT,
	Paths         => (0 => (PHYEMAC1GTXCLK_dly'last_event, tpd_PHYEMAC1GTXCLK_EMAC1PHYMGTTXRESET,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYPOWERDOWN,
	GlitchData    => EMAC1PHYPOWERDOWN_GlitchData,
	OutSignalName => "EMAC1PHYPOWERDOWN",
	OutTemp       => EMAC1PHYPOWERDOWN_OUT,
	Paths         => (0 => (PHYEMAC1GTXCLK_dly'last_event, tpd_PHYEMAC1GTXCLK_EMAC1PHYPOWERDOWN,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYSYNCACQSTATUS,
	GlitchData    => EMAC1PHYSYNCACQSTATUS_GlitchData,
	OutSignalName => "EMAC1PHYSYNCACQSTATUS",
	OutTemp       => EMAC1PHYSYNCACQSTATUS_OUT,
	Paths         => (0 => (PHYEMAC1GTXCLK_dly'last_event, tpd_PHYEMAC1GTXCLK_EMAC1PHYSYNCACQSTATUS,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYSYNCACQSTATUS,
	GlitchData    => EMAC1PHYSYNCACQSTATUS_GlitchData,
	OutSignalName => "EMAC1PHYSYNCACQSTATUS",
	OutTemp       => EMAC1PHYSYNCACQSTATUS_OUT,
	Paths         => (0 => (PHYEMAC1TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYSYNCACQSTATUS,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYSYNCACQSTATUS,
	GlitchData    => EMAC1PHYSYNCACQSTATUS_GlitchData,
	OutSignalName => "EMAC1PHYSYNCACQSTATUS",
	OutTemp       => EMAC1PHYSYNCACQSTATUS_OUT,
	Paths         => (0 => (PHYEMAC1TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYSYNCACQSTATUS,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXCHARDISPMODE,
	GlitchData    => EMAC1PHYTXCHARDISPMODE_GlitchData,
	OutSignalName => "EMAC1PHYTXCHARDISPMODE",
	OutTemp       => EMAC1PHYTXCHARDISPMODE_OUT,
	Paths         => (0 => (PHYEMAC1GTXCLK_dly'last_event, tpd_PHYEMAC1GTXCLK_EMAC1PHYTXCHARDISPMODE,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXCHARDISPMODE,
	GlitchData    => EMAC1PHYTXCHARDISPMODE_GlitchData,
	OutSignalName => "EMAC1PHYTXCHARDISPMODE",
	OutTemp       => EMAC1PHYTXCHARDISPMODE_OUT,
	Paths         => (0 => (PHYEMAC1TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYTXCHARDISPMODE,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXCHARDISPMODE,
	GlitchData    => EMAC1PHYTXCHARDISPMODE_GlitchData,
	OutSignalName => "EMAC1PHYTXCHARDISPMODE",
	OutTemp       => EMAC1PHYTXCHARDISPMODE_OUT,
	Paths         => (0 => (PHYEMAC1TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYTXCHARDISPMODE,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXCHARDISPVAL,
	GlitchData    => EMAC1PHYTXCHARDISPVAL_GlitchData,
	OutSignalName => "EMAC1PHYTXCHARDISPVAL",
	OutTemp       => EMAC1PHYTXCHARDISPVAL_OUT,
	Paths         => (0 => (PHYEMAC1GTXCLK_dly'last_event, tpd_PHYEMAC1GTXCLK_EMAC1PHYTXCHARDISPVAL,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXCHARDISPVAL,
	GlitchData    => EMAC1PHYTXCHARDISPVAL_GlitchData,
	OutSignalName => "EMAC1PHYTXCHARDISPVAL",
	OutTemp       => EMAC1PHYTXCHARDISPVAL_OUT,
	Paths         => (0 => (PHYEMAC1TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYTXCHARDISPVAL,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXCHARDISPVAL,
	GlitchData    => EMAC1PHYTXCHARDISPVAL_GlitchData,
	OutSignalName => "EMAC1PHYTXCHARDISPVAL",
	OutTemp       => EMAC1PHYTXCHARDISPVAL_OUT,
	Paths         => (0 => (PHYEMAC1TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYTXCHARDISPVAL,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXCHARISK,
	GlitchData    => EMAC1PHYTXCHARISK_GlitchData,
	OutSignalName => "EMAC1PHYTXCHARISK",
	OutTemp       => EMAC1PHYTXCHARISK_OUT,
	Paths         => (0 => (PHYEMAC1GTXCLK_dly'last_event, tpd_PHYEMAC1GTXCLK_EMAC1PHYTXCHARISK,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXCHARISK,
	GlitchData    => EMAC1PHYTXCHARISK_GlitchData,
	OutSignalName => "EMAC1PHYTXCHARISK",
	OutTemp       => EMAC1PHYTXCHARISK_OUT,
	Paths         => (0 => (PHYEMAC1TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYTXCHARISK,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXCHARISK,
	GlitchData    => EMAC1PHYTXCHARISK_GlitchData,
	OutSignalName => "EMAC1PHYTXCHARISK",
	OutTemp       => EMAC1PHYTXCHARISK_OUT,
	Paths         => (0 => (PHYEMAC1TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYTXCHARISK,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXCLK,
	GlitchData    => EMAC1PHYTXCLK_GlitchData,
	OutSignalName => "EMAC1PHYTXCLK",
	OutTemp       => EMAC1PHYTXCLK_OUT,
	Paths         => (0 => (PHYEMAC1GTXCLK_dly'last_event, tpd_PHYEMAC1GTXCLK_EMAC1PHYTXCLK,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXCLK,
	GlitchData    => EMAC1PHYTXCLK_GlitchData,
	OutSignalName => "EMAC1PHYTXCLK",
	OutTemp       => EMAC1PHYTXCLK_OUT,
	Paths         => (0 => (PHYEMAC1TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYTXCLK,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXCLK,
	GlitchData    => EMAC1PHYTXCLK_GlitchData,
	OutSignalName => "EMAC1PHYTXCLK",
	OutTemp       => EMAC1PHYTXCLK_OUT,
	Paths         => (0 => (PHYEMAC1TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYTXCLK,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXD(0),
	GlitchData    => EMAC1PHYTXD0_GlitchData,
	OutSignalName => "EMAC1PHYTXD(0)",
	OutTemp       => EMAC1PHYTXD_OUT(0),
	Paths       => (0 => (PHYEMAC1GTXCLK_dly'last_event, tpd_PHYEMAC1GTXCLK_EMAC1PHYTXD(0),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXD(0),
	GlitchData    => EMAC1PHYTXD0_GlitchData,
	OutSignalName => "EMAC1PHYTXD(0)",
	OutTemp       => EMAC1PHYTXD_OUT(0),
	Paths       => (0 => (PHYEMAC1TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYTXD(0),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXD(0),
	GlitchData    => EMAC1PHYTXD0_GlitchData,
	OutSignalName => "EMAC1PHYTXD(0)",
	OutTemp       => EMAC1PHYTXD_OUT(0),
	Paths       => (0 => (PHYEMAC1TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYTXD(0),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXD(1),
	GlitchData    => EMAC1PHYTXD1_GlitchData,
	OutSignalName => "EMAC1PHYTXD(1)",
	OutTemp       => EMAC1PHYTXD_OUT(1),
	Paths       => (0 => (PHYEMAC1GTXCLK_dly'last_event, tpd_PHYEMAC1GTXCLK_EMAC1PHYTXD(1),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXD(1),
	GlitchData    => EMAC1PHYTXD1_GlitchData,
	OutSignalName => "EMAC1PHYTXD(1)",
	OutTemp       => EMAC1PHYTXD_OUT(1),
	Paths       => (0 => (PHYEMAC1TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYTXD(1),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXD(1),
	GlitchData    => EMAC1PHYTXD1_GlitchData,
	OutSignalName => "EMAC1PHYTXD(1)",
	OutTemp       => EMAC1PHYTXD_OUT(1),
	Paths       => (0 => (PHYEMAC1TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYTXD(1),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXD(2),
	GlitchData    => EMAC1PHYTXD2_GlitchData,
	OutSignalName => "EMAC1PHYTXD(2)",
	OutTemp       => EMAC1PHYTXD_OUT(2),
	Paths       => (0 => (PHYEMAC1GTXCLK_dly'last_event, tpd_PHYEMAC1GTXCLK_EMAC1PHYTXD(2),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXD(2),
	GlitchData    => EMAC1PHYTXD2_GlitchData,
	OutSignalName => "EMAC1PHYTXD(2)",
	OutTemp       => EMAC1PHYTXD_OUT(2),
	Paths       => (0 => (PHYEMAC1TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYTXD(2),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXD(2),
	GlitchData    => EMAC1PHYTXD2_GlitchData,
	OutSignalName => "EMAC1PHYTXD(2)",
	OutTemp       => EMAC1PHYTXD_OUT(2),
	Paths       => (0 => (PHYEMAC1TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYTXD(2),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXD(3),
	GlitchData    => EMAC1PHYTXD3_GlitchData,
	OutSignalName => "EMAC1PHYTXD(3)",
	OutTemp       => EMAC1PHYTXD_OUT(3),
	Paths       => (0 => (PHYEMAC1GTXCLK_dly'last_event, tpd_PHYEMAC1GTXCLK_EMAC1PHYTXD(3),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXD(3),
	GlitchData    => EMAC1PHYTXD3_GlitchData,
	OutSignalName => "EMAC1PHYTXD(3)",
	OutTemp       => EMAC1PHYTXD_OUT(3),
	Paths       => (0 => (PHYEMAC1TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYTXD(3),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXD(3),
	GlitchData    => EMAC1PHYTXD3_GlitchData,
	OutSignalName => "EMAC1PHYTXD(3)",
	OutTemp       => EMAC1PHYTXD_OUT(3),
	Paths       => (0 => (PHYEMAC1TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYTXD(3),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXD(4),
	GlitchData    => EMAC1PHYTXD4_GlitchData,
	OutSignalName => "EMAC1PHYTXD(4)",
	OutTemp       => EMAC1PHYTXD_OUT(4),
	Paths       => (0 => (PHYEMAC1GTXCLK_dly'last_event, tpd_PHYEMAC1GTXCLK_EMAC1PHYTXD(4),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXD(4),
	GlitchData    => EMAC1PHYTXD4_GlitchData,
	OutSignalName => "EMAC1PHYTXD(4)",
	OutTemp       => EMAC1PHYTXD_OUT(4),
	Paths       => (0 => (PHYEMAC1TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYTXD(4),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXD(4),
	GlitchData    => EMAC1PHYTXD4_GlitchData,
	OutSignalName => "EMAC1PHYTXD(4)",
	OutTemp       => EMAC1PHYTXD_OUT(4),
	Paths       => (0 => (PHYEMAC1TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYTXD(4),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXD(4),
	GlitchData    => EMAC1PHYTXD4_GlitchData,
	OutSignalName => "EMAC1PHYTXD(4)",
	OutTemp       => EMAC1PHYTXD_OUT(4),
	Paths       => (0 => (PHYEMAC1TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYTXD(4),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXD(5),
	GlitchData    => EMAC1PHYTXD5_GlitchData,
	OutSignalName => "EMAC1PHYTXD(5)",
	OutTemp       => EMAC1PHYTXD_OUT(5),
	Paths       => (0 => (PHYEMAC1GTXCLK_dly'last_event, tpd_PHYEMAC1GTXCLK_EMAC1PHYTXD(5),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXD(5),
	GlitchData    => EMAC1PHYTXD5_GlitchData,
	OutSignalName => "EMAC1PHYTXD(5)",
	OutTemp       => EMAC1PHYTXD_OUT(5),
	Paths       => (0 => (PHYEMAC1TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYTXD(5),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXD(5),
	GlitchData    => EMAC1PHYTXD5_GlitchData,
	OutSignalName => "EMAC1PHYTXD(5)",
	OutTemp       => EMAC1PHYTXD_OUT(5),
	Paths       => (0 => (PHYEMAC1TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYTXD(5),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXD(5),
	GlitchData    => EMAC1PHYTXD5_GlitchData,
	OutSignalName => "EMAC1PHYTXD(5)",
	OutTemp       => EMAC1PHYTXD_OUT(5),
	Paths       => (0 => (PHYEMAC1TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYTXD(5),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXD(6),
	GlitchData    => EMAC1PHYTXD6_GlitchData,
	OutSignalName => "EMAC1PHYTXD(6)",
	OutTemp       => EMAC1PHYTXD_OUT(6),
	Paths       => (0 => (PHYEMAC1GTXCLK_dly'last_event, tpd_PHYEMAC1GTXCLK_EMAC1PHYTXD(6),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXD(6),
	GlitchData    => EMAC1PHYTXD6_GlitchData,
	OutSignalName => "EMAC1PHYTXD(6)",
	OutTemp       => EMAC1PHYTXD_OUT(6),
	Paths       => (0 => (PHYEMAC1TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYTXD(6),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXD(6),
	GlitchData    => EMAC1PHYTXD6_GlitchData,
	OutSignalName => "EMAC1PHYTXD(6)",
	OutTemp       => EMAC1PHYTXD_OUT(6),
	Paths       => (0 => (PHYEMAC1TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYTXD(6),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXD(6),
	GlitchData    => EMAC1PHYTXD6_GlitchData,
	OutSignalName => "EMAC1PHYTXD(6)",
	OutTemp       => EMAC1PHYTXD_OUT(6),
	Paths       => (0 => (PHYEMAC1TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYTXD(6),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXD(7),
	GlitchData    => EMAC1PHYTXD7_GlitchData,
	OutSignalName => "EMAC1PHYTXD(7)",
	OutTemp       => EMAC1PHYTXD_OUT(7),
	Paths       => (0 => (PHYEMAC1GTXCLK_dly'last_event, tpd_PHYEMAC1GTXCLK_EMAC1PHYTXD(7),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXD(7),
	GlitchData    => EMAC1PHYTXD7_GlitchData,
	OutSignalName => "EMAC1PHYTXD(7)",
	OutTemp       => EMAC1PHYTXD_OUT(7),
	Paths       => (0 => (PHYEMAC1TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYTXD(7),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXD(7),
	GlitchData    => EMAC1PHYTXD7_GlitchData,
	OutSignalName => "EMAC1PHYTXD(7)",
	OutTemp       => EMAC1PHYTXD_OUT(7),
	Paths       => (0 => (PHYEMAC1TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYTXD(7),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXD(7),
	GlitchData    => EMAC1PHYTXD7_GlitchData,
	OutSignalName => "EMAC1PHYTXD(7)",
	OutTemp       => EMAC1PHYTXD_OUT(7),
	Paths       => (0 => (PHYEMAC1TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYTXD(7),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXEN,
	GlitchData    => EMAC1PHYTXEN_GlitchData,
	OutSignalName => "EMAC1PHYTXEN",
	OutTemp       => EMAC1PHYTXEN_OUT,
	Paths         => (0 => (PHYEMAC1GTXCLK_dly'last_event, tpd_PHYEMAC1GTXCLK_EMAC1PHYTXEN,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXEN,
	GlitchData    => EMAC1PHYTXEN_GlitchData,
	OutSignalName => "EMAC1PHYTXEN",
	OutTemp       => EMAC1PHYTXEN_OUT,
	Paths         => (0 => (PHYEMAC1TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYTXEN,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXEN,
	GlitchData    => EMAC1PHYTXEN_GlitchData,
	OutSignalName => "EMAC1PHYTXEN",
	OutTemp       => EMAC1PHYTXEN_OUT,
	Paths         => (0 => (PHYEMAC1TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYTXEN,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXER,
	GlitchData    => EMAC1PHYTXER_GlitchData,
	OutSignalName => "EMAC1PHYTXER",
	OutTemp       => EMAC1PHYTXER_OUT,
	Paths         => (0 => (PHYEMAC1GTXCLK_dly'last_event, tpd_PHYEMAC1GTXCLK_EMAC1PHYTXER,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXER,
	GlitchData    => EMAC1PHYTXER_GlitchData,
	OutSignalName => "EMAC1PHYTXER",
	OutTemp       => EMAC1PHYTXER_OUT,
	Paths         => (0 => (PHYEMAC1TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYTXER,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXER,
	GlitchData    => EMAC1PHYTXER_GlitchData,
	OutSignalName => "EMAC1PHYTXER",
	OutTemp       => EMAC1PHYTXER_OUT,
	Paths         => (0 => (PHYEMAC1TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYTXER,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1PHYTXER,
	GlitchData    => EMAC1PHYTXER_GlitchData,
	OutSignalName => "EMAC1PHYTXER",
	OutTemp       => EMAC1PHYTXER_OUT,
	Paths         => (0 => (PHYEMAC1TXGMIIMIICLKIN_dly'last_event, tpd_PHYEMAC1TXGMIIMIICLKIN_EMAC1PHYTXER,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMAC1SPEEDIS10100,
	GlitchData    => EMAC1SPEEDIS10100_GlitchData,
	OutSignalName => "EMAC1SPEEDIS10100",
	OutTemp       => EMAC1SPEEDIS10100_OUT,
	Paths         => (0 => (HOSTCLK_dly'last_event, tpd_HOSTCLK_EMAC1SPEEDIS10100,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMACDCRACK,
	GlitchData    => EMACDCRACK_GlitchData,
	OutSignalName => "EMACDCRACK",
	OutTemp       => EMACDCRACK_OUT,
	Paths         => (0 => (DCREMACCLK_dly'last_event, tpd_DCREMACCLK_EMACDCRACK,TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMACDCRDBUS(0),
	GlitchData    => EMACDCRDBUS0_GlitchData,
	OutSignalName => "EMACDCRDBUS(0)",
	OutTemp       => EMACDCRDBUS_OUT(0),
	Paths       => (0 => (DCREMACCLK_dly'last_event, tpd_DCREMACCLK_EMACDCRDBUS(0),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMACDCRDBUS(1),
	GlitchData    => EMACDCRDBUS1_GlitchData,
	OutSignalName => "EMACDCRDBUS(1)",
	OutTemp       => EMACDCRDBUS_OUT(1),
	Paths       => (0 => (DCREMACCLK_dly'last_event, tpd_DCREMACCLK_EMACDCRDBUS(1),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMACDCRDBUS(2),
	GlitchData    => EMACDCRDBUS2_GlitchData,
	OutSignalName => "EMACDCRDBUS(2)",
	OutTemp       => EMACDCRDBUS_OUT(2),
	Paths       => (0 => (DCREMACCLK_dly'last_event, tpd_DCREMACCLK_EMACDCRDBUS(2),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMACDCRDBUS(3),
	GlitchData    => EMACDCRDBUS3_GlitchData,
	OutSignalName => "EMACDCRDBUS(3)",
	OutTemp       => EMACDCRDBUS_OUT(3),
	Paths       => (0 => (DCREMACCLK_dly'last_event, tpd_DCREMACCLK_EMACDCRDBUS(3),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMACDCRDBUS(4),
	GlitchData    => EMACDCRDBUS4_GlitchData,
	OutSignalName => "EMACDCRDBUS(4)",
	OutTemp       => EMACDCRDBUS_OUT(4),
	Paths       => (0 => (DCREMACCLK_dly'last_event, tpd_DCREMACCLK_EMACDCRDBUS(4),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMACDCRDBUS(5),
	GlitchData    => EMACDCRDBUS5_GlitchData,
	OutSignalName => "EMACDCRDBUS(5)",
	OutTemp       => EMACDCRDBUS_OUT(5),
	Paths       => (0 => (DCREMACCLK_dly'last_event, tpd_DCREMACCLK_EMACDCRDBUS(5),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMACDCRDBUS(6),
	GlitchData    => EMACDCRDBUS6_GlitchData,
	OutSignalName => "EMACDCRDBUS(6)",
	OutTemp       => EMACDCRDBUS_OUT(6),
	Paths       => (0 => (DCREMACCLK_dly'last_event, tpd_DCREMACCLK_EMACDCRDBUS(6),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMACDCRDBUS(7),
	GlitchData    => EMACDCRDBUS7_GlitchData,
	OutSignalName => "EMACDCRDBUS(7)",
	OutTemp       => EMACDCRDBUS_OUT(7),
	Paths       => (0 => (DCREMACCLK_dly'last_event, tpd_DCREMACCLK_EMACDCRDBUS(7),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMACDCRDBUS(8),
	GlitchData    => EMACDCRDBUS8_GlitchData,
	OutSignalName => "EMACDCRDBUS(8)",
	OutTemp       => EMACDCRDBUS_OUT(8),
	Paths       => (0 => (DCREMACCLK_dly'last_event, tpd_DCREMACCLK_EMACDCRDBUS(8),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMACDCRDBUS(9),
	GlitchData    => EMACDCRDBUS9_GlitchData,
	OutSignalName => "EMACDCRDBUS(9)",
	OutTemp       => EMACDCRDBUS_OUT(9),
	Paths       => (0 => (DCREMACCLK_dly'last_event, tpd_DCREMACCLK_EMACDCRDBUS(9),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMACDCRDBUS(10),
	GlitchData    => EMACDCRDBUS10_GlitchData,
	OutSignalName => "EMACDCRDBUS(10)",
	OutTemp       => EMACDCRDBUS_OUT(10),
	Paths       => (0 => (DCREMACCLK_dly'last_event, tpd_DCREMACCLK_EMACDCRDBUS(10),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMACDCRDBUS(11),
	GlitchData    => EMACDCRDBUS11_GlitchData,
	OutSignalName => "EMACDCRDBUS(11)",
	OutTemp       => EMACDCRDBUS_OUT(11),
	Paths       => (0 => (DCREMACCLK_dly'last_event, tpd_DCREMACCLK_EMACDCRDBUS(11),TRUE)),
	Mode          => VitalTransport,
	Xon           => false,
	MsgOn         => false,
	MsgSeverity   => WARNING
	);
	VitalPathDelay01
	(
	OutSignal     => EMACDCRDBUS(12),
	GlitchData    => EMACDCRDBUS12_GlitchData,
	OutSignalName => "